package com.ubsidi.epos_2021.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.DialogFragment;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.PaymentIntentResult;
import com.stripe.android.Stripe;
import com.stripe.android.model.CardParams;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.Token;
import com.ubsidi.BuildConfig;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.ccwatchers.CreditCardEditText;
import com.ubsidi.epos_2021.comman.ccwatchers.OtherCardTextWatcher;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public class PaymentViaMotoDialogFragment extends DialogFragment {

    private MaterialButton btnPay;
    private Float payment_amount;
    private EditText etExpDate, etCvv, etHolderName;
    private CreditCardEditText etCardNumber;
    private Stripe stripe;
    private String description;
    private String descriptor;
    private String stripe_secret_key;
    long lastClickTime = 0;
    final long MIN_CLICK_INTERVAL = 5000; //in millis
    private AlertDialog progressBarDialog;
    private Business selectedBusiness;
    private MyApp myApp = MyApp.getInstance();
    private MyPreferences myPreferences = MyApp.getInstance().myPreferences;
    private DialogDismissListener dialogDismissListener;
    private Chip chipBack;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Override
    public int getTheme() {
        return R.style.MyRightDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        try {
            getDialog().setCancelable(false);
            getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.MATCH_PARENT);
            getDialog().getWindow().setGravity(Gravity.END);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_place_order_moto_payment, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (getArguments() != null) {
                payment_amount = getArguments().getFloat("payment_amount");
            }
            initViews(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {

        try {
            selectedBusiness = myPreferences.getLoggedInAdmin().selected_business;
            String stripeMode = selectedBusiness.stripe_mode;
            progressBarDialog = CommonFunctions.customProgressDialog(getActivity());

            description = selectedBusiness.statement_description;
            descriptor = selectedBusiness.statement_descriptor;

            String stripe_public_key;
            if (!Validators.isNullOrEmpty(selectedBusiness.s_account_id) && selectedBusiness.connect_service && !Validators.isNullOrEmpty(BuildConfig.connect_stripe_public_key)) {
                stripe = new Stripe(getActivity(), BuildConfig.connect_stripe_public_key);
                stripe_public_key = BuildConfig.connect_stripe_public_key;
                stripe_secret_key = BuildConfig.connect_stripe_private_key;
                descriptor = selectedBusiness.statement_descriptor;
            } else {
                if (stripeMode.equalsIgnoreCase("live")) {
                    stripe = new Stripe(getActivity(), selectedBusiness.stripe_public_key_live);
                    stripe_public_key = selectedBusiness.stripe_public_key_live;
                    stripe_secret_key = selectedBusiness.stripe_private_key_live;
                } else {
                    stripe = new Stripe(getActivity(), selectedBusiness.stripe_public_key_test);
                    stripe_secret_key = selectedBusiness.stripe_private_key_test;
                    stripe_public_key = selectedBusiness.stripe_public_key_test;
                }
            }
            PaymentConfiguration.init(getActivity(), stripe_public_key);

            etExpDate = view.findViewById(R.id.etExpDate);
            etCardNumber = view.findViewById(R.id.etCardNumber);
            etCvv = view.findViewById(R.id.etCvv);
            etHolderName = view.findViewById(R.id.etCardHolderName);
            MaterialButton btnAmount = view.findViewById(R.id.btnTotalAmount);
            btnPay = view.findViewById(R.id.btnPay);
            chipBack = view.findViewById(R.id.chipBack);

            btnAmount.setText("Amount: " + MyApp.currencySymbol + MyApp.df.format(payment_amount));

            btnPay.setEnabled(false);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            chipBack.setOnClickListener(v -> {
                dismiss();
            });
            etCardNumber.addTextChangedListener(new OtherCardTextWatcher(etCardNumber, null));
            etCardNumber.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence s, int start, int count, int after) {

                }

                @Override
                public void onTextChanged(CharSequence s, int start, int before, int count) {

                }

                @Override
                public void afterTextChanged(Editable s) {
                    btnPay.setEnabled(isFilled());
                }
            });
            etExpDate.addTextChangedListener(new TextWatcher() {
                int previousLength = 0;
                String previousText = "";

                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    previousLength = etExpDate.getText().toString().length();
                    previousText = charSequence.toString();
                }

                @Override
                public void onTextChanged(CharSequence charSequence, int start, int before, int i2) {
                    String current = charSequence.toString();
                    if (charSequence.length() == 1) {
                        int n = Integer.parseInt(current);
                        if (n > 1) {
                            etExpDate.setText("0" + current + "/");
                            etExpDate.setSelection(current.length() + 2);
                        } else {
                            if (current.length() == 2 && start == 1) {
                                etExpDate.setText(current + "/");
                                etExpDate.setSelection(current.length() + 1);
                            } else if (current.length() == 2 && before == 1) {
                                current = current.substring(0, 1);
                                etExpDate.setText(current);
                                etExpDate.setSelection(current.length());
                            }
                        }
                    } else {
                        if (charSequence.length() == 2) {
                            int n = Integer.parseInt(current);
                            if (n > 12) {
                                etExpDate.setText(previousText);
                                etExpDate.setSelection(etExpDate.getText().toString().length());
                                return;
                            }
                        }
                        if (current.length() == 2 && start == 1) {
                            etExpDate.setText(current + "/");
                            etExpDate.setSelection(current.length() + 1);
                        } else if (current.length() == 2 && before == 1) {
                            current = current.substring(0, 1);
                            etExpDate.setText(current);
                            etExpDate.setSelection(current.length());
                        }
                    }
                    if (etExpDate.getText().toString().length() == 5) {
                        etCvv.requestFocus();
                    }
                }

                @Override
                public void afterTextChanged(Editable editable) {
                    btnPay.setEnabled(isFilled());
                }
            });

            etCvv.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence s, int start, int count, int after) {

                }

                @Override
                public void onTextChanged(CharSequence s, int start, int before, int count) {

                }

                @Override
                public void afterTextChanged(Editable s) {
                    btnPay.setEnabled(isFilled());
                }
            });

            btnPay.setOnClickListener(view -> {
                if (isValid()) {
                    long currentTime = SystemClock.elapsedRealtime();
                    if (currentTime - lastClickTime > MIN_CLICK_INTERVAL) {
                        lastClickTime = currentTime;
                        createStripeCall();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isFilled() {
        return (!Validators.isNullOrEmpty(etCardNumber.getText().toString())) && (!Validators.isNullOrEmpty(etExpDate.getText().toString())) && (!Validators.isNullOrEmpty(etCvv.getText().toString()));
    }


    CardParams cardParams;

    private boolean isValid() {

        String exp = etExpDate.getText().toString();
        String[] data = exp.split("/");
        if (!isNumberChar(data[0])) {
            ToastUtils.makeSnackToast(getActivity(), "Invalid expiry month");
            return false;
        }
        if (data.length == 1) {
            ToastUtils.makeSnackToast(getActivity(), "Please enter expiry year");
            return false;
        }
        if (data.length > 1 && !isNumberChar(data[1])) {
            ToastUtils.makeSnackToast(getActivity(), "Invalid expiry year");
            return false;
        }
        if (Validators.isNullOrEmpty(etCvv.getText().toString())) {
            ToastUtils.makeSnackToast(getActivity(), "Please enter card cvv");
            return false;
        }
        String address = "";

        cardParams = new CardParams(etCardNumber.getText().toString().replace(" ", ""), Integer.parseInt(data[0]), Integer.parseInt(data[1]), etCvv.getText().toString());

        return true;
    }

    private boolean isNumberChar(String string) {
        return string.matches(".*\\d.*");
    }

    float totalAmount = 0;

    private void createStripeCall() {
        try {
            totalAmount = payment_amount;
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    progressBarDialog.show();
                });
            }

            PaymentMethodCreateParams params = PaymentMethodCreateParams.createCard(cardParams);
            if (cardParams == null) {
                ToastUtils.makeSnackToast(getActivity(), "Invalid Details");
                return;
            }
            // Configure the SDK with your Stripe publishable key so that it can make requests to the Stripe API
            if (selectedBusiness.s_account_id != null && selectedBusiness.connect_service) {
                createPaymentMethod(params);
            } else {
                createCardToken(cardParams);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    String paymentMethodId;

    private void createPaymentMethod(PaymentMethodCreateParams params) {
        try {
            stripe.createPaymentMethod(params, new ApiResultCallback<PaymentMethod>() {
                @Override
                public void onSuccess(@NonNull PaymentMethod result) {
                    try {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> progressBarDialog.dismiss());
                        }
                        paymentMethodId = result.id;
                        createPaymentIntent();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onError(@NonNull Exception e) {
                    // Display the error to the user
                    try {
                        e.printStackTrace();
                        LogUtils.e(e.getMessage());

                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                progressBarDialog.dismiss();
                                ToastUtils.makeToast(getActivity(), e.getMessage());
                            });
                        }
                    } catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createCardToken(CardParams cardParams) {
        // Configure the SDK with your Stripe publishable key so that it can make requests to the Stripe API
        /*stripe.createCardToken(cardParams, new ApiResultCallback<Token>() {
            @Override
            public void onSuccess(@NotNull Token token) {

                com.stripe.Stripe.apiKey = "" + stripe_secret_key;
                Map<String, Object> params = new HashMap<String, Object>();
                Map<String, Object> params1 = new HashMap<String, Object>();
                DecimalFormat doubleFormat = new DecimalFormat("#.##");
                doubleFormat.setMinimumFractionDigits(0);
                String price = doubleFormat.format((totalAmount) * 100);
                params.put("amount", "" + price);
                params.put("currency", "gbp");
                params.put("capture", true);
                params.put("source", token.getId());
                params.put("description", description);
                params.put("statement_descriptor", Validators.isNullOrEmpty(descriptor) ? "UBSIDI" : descriptor);
                params1.put("limit", "3");
                new Thread(() -> {
                    try {
                        Charge charge = Charge.create(params);
                        Charge.list(params1);
                        manageChargeResponse(charge);
                    } catch (StripeException e) {
                        e.printStackTrace();
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                progressBarDialog.dismiss();
                                myApp.startPaymentFailedSound();
                                if (dialogDismissListener != null)
                                    dialogDismissListener.onDialogDismiss(null);
                                dismiss();
                            });
                        }
                    }

                }).start();
            }

            @Override
            public void onError(@NotNull Exception e) {
                e.printStackTrace();
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        progressBarDialog.dismiss();
                        etCardNumber.setText(null);
                        etCvv.setText(null);
                        etExpDate.setText(null);
                        AnimatedConfirmationDialogFragment confirmationDialogFragment = getInstanceAnimatedConfirmation("Error", "Payment declined", 2, "Okay", null);
                        confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    });
                }
            }
        });*/

    }

    public AnimatedConfirmationDialogFragment getInstanceAnimatedConfirmation(String title, String info, int type, String positiveButton, String negativeButton) {
        AnimatedConfirmationDialogFragment rejectReasonDialog = new AnimatedConfirmationDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("title", title);
        bundle.putString("info", info);
        bundle.putString("positive_button", positiveButton);
        bundle.putString("negative_button", negativeButton);
        bundle.putInt("type", type);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    boolean autoConfirm = false;

    private HashMap<String, String> generatePaymentIntentParams() {
        HashMap<String, String> params = new HashMap<>();

        params.put("amount", MyApp.df.format(totalAmount * 100));
        params.put("currency", "GBP");
        params.put("transaction_type", !selectedBusiness.connect_service ? "merchant" : "connect");
        params.put("stripe_secrete_key", stripe_secret_key);
        params.put("business_id", selectedBusiness.id);
        params.put("payment_method_id", paymentMethodId);
        params.put("auto_confirm", autoConfirm ? "1" : "0");

        return params;
    }

    private void createPaymentIntent() {
        if (getActivity() != null) {
            getActivity().runOnUiThread(() -> {
                progressBarDialog.show();

                etCardNumber.setText(null);
                etExpDate.setText(null);
                etCvv.setText(null);
                etHolderName.setText(null);
            });
        }
        AndroidNetworking.post(ApiEndPoints.PAYMENT_INTENT)
                .addBodyParameter(generatePaymentIntentParams())
                .build()
                .getAsJSONObject(new JSONObjectRequestListener() {
                    @Override
                    public void onResponse(JSONObject response) {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> progressBarDialog.dismiss());
                        }
                        try {
                            if (response.has("payment_intent")) {
                                JSONObject paymentIntent = response.getJSONObject("payment_intent");
                                String paymentSecret = paymentIntent.getString("client_secret");
                                if (!autoConfirm)
                                    performStripePayment(paymentSecret);
                                else {
                                    if (getActivity() != null) {
                                        getActivity().runOnUiThread(() -> progressBarDialog.show());
                                    }
                                    stripe.retrievePaymentIntent(paymentSecret, new ApiResultCallback<PaymentIntent>() {
                                        @Override
                                        public void onSuccess(@NotNull PaymentIntent paymentIntent) {
                                            if (getActivity() != null) {
                                                getActivity().runOnUiThread(() -> progressBarDialog.dismiss());
                                            }
                                            managePaymentResponse(paymentIntent);
                                        }

                                        @Override
                                        public void onError(@NotNull Exception e) {

                                        }
                                    });
                                }
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                            ToastUtils.makeToast(getActivity(), "Something went wrong!");
                        }

                    }

                    @Override
                    public void onError(ANError anError) {
                        anError.printStackTrace();
                        LogUtils.e("MOTO PAYMENT ERROR");

                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> progressBarDialog.dismiss());
                        }
                        if (anError.getErrorCode() == 400) {
                            ApiError apiError = anError.getErrorAsObject(ApiError.class);
                            ToastUtils.makeToast(getActivity(), apiError.getMessage());
                        } else {
                            ToastUtils.makeToast(getActivity(), "Unknown Error");
                        }


                        if (!CommonFunctions.isConnected(getActivity()))
                            myApp.noInternet(getActivity());
                    }
                });
    }

    private void performStripePayment(String paymentIntentSecret) {
        if (getActivity() != null) {
            getActivity().runOnUiThread(() -> progressBarDialog.show());
        }
        ConfirmPaymentIntentParams confirmParams = ConfirmPaymentIntentParams
                .createWithPaymentMethodId(paymentMethodId, paymentIntentSecret);
//        stripe = new Stripe(getContext(), stripe_public_key);
        stripe.confirmPayment(this, confirmParams);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (data != null) {
            stripe.onPaymentResult(requestCode, data, new PaymentResultCallback(this));
        }
    }

    private final class PaymentResultCallback
            implements ApiResultCallback<PaymentIntentResult> {

        @NonNull
        private final WeakReference<PaymentViaMotoDialogFragment> activityRef;

        PaymentResultCallback(PaymentViaMotoDialogFragment activity) {
            activityRef = new WeakReference<>(activity);
            final PaymentViaMotoDialogFragment a = activityRef.get();
            if (activity.getActivity() != null && !activity.getActivity().isFinishing())
                a.progressBarDialog.show();
        }


        @Override
        public void onSuccess(@NonNull PaymentIntentResult result) {
            final PaymentViaMotoDialogFragment activity = activityRef.get();
            if (activity == null) {
                return;
            }
            PaymentIntent paymentIntent = result.getIntent();
            activity.managePaymentResponse(paymentIntent);
            activity.myApp.startPaymentSuccessSound();
        }

        @Override
        public void onError(@NonNull Exception e) {
            final PaymentViaMotoDialogFragment activity = activityRef.get();
            if (activity == null) {
                return;
            }
            e.printStackTrace();
            if (activity.getActivity() != null && !activity.getActivity().isFinishing())
                activity.progressBarDialog.dismiss();
            // Payment request failed – allow retrying using the same payment method
            activity.myApp.startPaymentFailedSound();
            ToastUtils.makeToast(activity.getActivity(), "Payment request failed");
        }
    }

    /*private void manageChargeResponse(Charge charge) {
        if (getActivity() != null) {
            getActivity().runOnUiThread(() -> {
                progressBarDialog.dismiss();
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss(charge);
                dismiss();
            });
        }

    }*/

    private void managePaymentResponse(PaymentIntent paymentIntent) {
        if (getActivity() != null) {
            getActivity().runOnUiThread(() -> {
                progressBarDialog.dismiss();
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss(paymentIntent);
                dismiss();
            });
        }

    }

}