package com.ubsidi.epos_2021.fragment;

import android.os.AsyncTask;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;

import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.Voucher;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.Calendar;
import java.util.Date;

public class PaymentViaVoucherFragment extends BaseFragment {
    private EditText etVoucherNo, etVoucherValue;
    private MaterialButton btnApply, btnCancel;
    private Float orderTotal, paidAmount, orderSubTotal;
    private String order_id, order_split_id, order_type_id;
    private int _order_id, _order_split_id;
    private AlertDialog progressBarDialog;
    MyApp myApp = MyApp.getInstance();
    MyPreferences myPreferences = myApp.myPreferences;
    AppDatabase appDatabase = myApp.appDatabase;
    private Order order;

    private DialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_payment_via_voucher, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (getArguments() != null) {
                order_id = getArguments().getString("order_id");
                order_split_id = getArguments().getString("order_split_id");
                order_type_id = getArguments().getString("order_type_id");
                _order_id = getArguments().getInt("_order_id");
                _order_split_id = getArguments().getInt("_order_split_id");
                orderTotal = getArguments().getFloat("order_total");
                paidAmount = getArguments().getFloat("paid_amount");
                orderSubTotal = getArguments().getFloat("order_sub_total");
            }
            initViews(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            btnCancel.setOnClickListener(v -> getActivity().onBackPressed());

            btnApply.setOnClickListener(v -> {
                CommonFunctions.hideKeyboard(getActivity(), etVoucherNo);
                if (isValid()) {
                    if (myApp.isConnected(getActivity()))
                        fetchVoucher();
                    else ToastUtils.makeSnackToast(getActivity(), "No internet connectivity");
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isValid() {
        if (Validators.isNullOrEmpty(etVoucherNo.getText().toString())) {
            etVoucherNo.setError("Please enter voucher code");
            etVoucherNo.requestFocus();
            return false;
        }

        return true;
    }

    private void initViews(View view) {
        try {
            progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
            etVoucherNo = view.findViewById(R.id.etVoucherNo);
            etVoucherValue = view.findViewById(R.id.etVoucherValue);
            btnCancel = view.findViewById(R.id.btnCancel);
            btnApply = view.findViewById(R.id.btnApply);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchVoucher() {
        try {
            progressBarDialog.show();
            new ValidateVoucherAsync(etVoucherNo.getText().toString()).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void payAmount(Voucher appliedVoucher) {
        try {
            if (getActivity() != null)
                progressBarDialog.show();
            OrderPayment orderPayment = new OrderPayment();
            String paymentMethodId = "5";
            orderPayment.payment_method_id = paymentMethodId;
            orderPayment.payment_method_name = "Voucher";
            orderPayment.updater_id = myPreferences.getLoggedInUser().id;
            orderPayment.amount = Float.parseFloat(MyApp.df.format(Float.parseFloat(etVoucherValue.getText().toString().replace(",", ""))));
            orderPayment.voucher_id = appliedVoucher.id;
            orderPayment.order_id = order_id;
            orderPayment.order_split_id = order_split_id;
            orderPayment._order_split_id = _order_split_id;
            orderPayment._order_id = _order_id;
            new Thread(() -> {
                float paidAmount;
                if (_order_split_id > 0) {
                    paidAmount = Float.parseFloat(MyApp.df.format(appDatabase.orderPaymentDao().getSplitTotalPaidAmount(_order_id, _order_split_id)));
                } else {
                    paidAmount = Float.parseFloat(MyApp.df.format(appDatabase.orderPaymentDao().getTotalPaidAmount(_order_id)));
                }
                if (Float.parseFloat(MyApp.df.format(paidAmount + orderPayment.amount)) > Float.parseFloat(MyApp.df.format(orderTotal))) {
                    ToastUtils.makeLongToast(getActivity(), "You cannot pay more than total");
                } else {
                    appDatabase.orderPaymentDao().insert(orderPayment);
                    order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                    appDatabase.orderDao().update(order);
                    if (getActivity() != null) {
                        getActivity().runOnUiThread(() -> {
                            //                        myApp.needToPrint = true;
                            myApp.isCashDrawerOpen = false;
                            progressBarDialog.dismiss();
                            if (dialogDismissListener != null) {
                                dialogDismissListener.onDialogDismiss("confirm");
                                getActivity().onBackPressed();
                            }
                        });
                    } else {
                        getActivity().onBackPressed();
                    }
                }
                if (getActivity() != null)
                    progressBarDialog.dismiss();
            }).start();
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private class ValidateVoucherAsync extends AsyncTask<String, String, String> {
        String voucherNo;
        Voucher fetchedVoucher;

        public ValidateVoucherAsync(String fetchedVoucher) {
            this.voucherNo = fetchedVoucher;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            if (getActivity() != null)
                progressBarDialog.show();
        }

        @Override
        protected String doInBackground(String... strings) {
            try {
                order = appDatabase.orderDao().view(_order_id);
                fetchedVoucher = appDatabase.voucherDao().find(voucherNo);
                if (fetchedVoucher == null) {
                    return "Invalid voucher code!";
                }
                Date startDate = CommonFunctions.convertToDate(fetchedVoucher.start_date, Constants.PHP_DATE_TIME_FORMAT);
                Date endDate = null;
                long now = System.currentTimeMillis();
                Calendar c = Calendar.getInstance();
                int dayIndex = c.get(Calendar.DAY_OF_WEEK) - 1;// Because sunday starts with 1, And we need with 0
                if (!Validators.isNullOrEmpty(fetchedVoucher.end_date)) {
                    endDate = CommonFunctions.convertToDate(fetchedVoucher.end_date, Constants.PHP_DATE_TIME_FORMAT);
                }

                if (endDate != null) {
                    if (startDate.getTime() > now) {
                        return "Voucher is not applicable yet";
                    }
                    if (endDate.getTime() < now) {
                        return "Voucher is already expired";
                    }
                    if (startDate.getTime() > now && endDate.getTime() < now) {
                        return "Voucher expired";
                    }
                } else {
                    if (startDate.getTime() > now) {
                        return "Voucher is not applicable yet.";
                    }
                }
                if (!Validators.isNullOrEmpty(fetchedVoucher.week_day) && fetchedVoucher.week_day.contains(dayIndex + "")) {
                    return "Voucher is not applicable for today";
                }
                if (!Validators.isNullOrEmpty(fetchedVoucher.order_type_id) && fetchedVoucher.order_type_id.contains(order_type_id)) {
                    return "Voucher is not valid for this order type";
                }
                if (fetchedVoucher.minimum_order_value > 0 && fetchedVoucher.minimum_order_value > orderSubTotal) {
                    return "Minimum order value not matched";
                }
               /* if (fetchedVoucher._customer_id != _customer_id) {
                    return "Invalid customer";
                }*/

                OrderPayment alreadyRedeemedVoucher = appDatabase.orderPaymentDao().findVoucher(fetchedVoucher.id, "5");
                if (alreadyRedeemedVoucher != null) {
                    return "Voucher already redeemed";
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                if (getActivity() != null)
                    progressBarDialog.dismiss();
                if (s != null) {
                    ToastUtils.makeSnackToast(getActivity(), s);
                } else {
                    float remainingAmount = Float.parseFloat(MyApp.df.format(orderTotal - paidAmount));
                    if (Float.parseFloat(MyApp.df.format(fetchedVoucher.voucher_amount)) > remainingAmount) {
                        etVoucherValue.setText(String.valueOf(remainingAmount));
                    } else {
                        etVoucherValue.setText(String.valueOf(fetchedVoucher.voucher_amount));
                    }
                    payAmount(fetchedVoucher);
                }
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }
}