package com.ubsidi.epos_2021.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;

import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.SiteSetting;

/**
 * Created by Amrish on 31-05-2021.
 */
public class PrintOptionsDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private MaterialButton btnPrintAll, btnPrintBill;
    private DialogDismissListener dialogDismissListener;
    private Chip chipBack;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    public static PrintOptionsDialogFragment getInstance(SiteSetting printBillMainSetting, SiteSetting printAllMainSetting) {
        PrintOptionsDialogFragment fragment = new PrintOptionsDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("printBillSetting", new Gson().toJson(printBillMainSetting));
        bundle.putString("printAllSetting", new Gson().toJson(printAllMainSetting));
        fragment.setArguments(bundle);
        return fragment;
    }

    private SiteSetting printBillMainSetting, printAllMainSetting;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_print_options_fragment, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (getArguments() != null) {
                printBillMainSetting = new Gson().fromJson(getArguments().getString("printBillSetting"), SiteSetting.class);
                printAllMainSetting = new Gson().fromJson(getArguments().getString("printAllSetting"), SiteSetting.class);
            }
            initViews(view);
            setListeners();
        } catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            btnPrintAll = view.findViewById(R.id.btnPrintAll);
            btnPrintBill = view.findViewById(R.id.btnPrintBill);
            chipBack = view.findViewById(R.id.chipBack);

            if (MyApp.userPermission.print_all.actions.list && printAllMainSetting != null && (printAllMainSetting.value.equalsIgnoreCase("true") || printAllMainSetting.value.equalsIgnoreCase("1"))) {
                btnPrintAll.setVisibility(View.VISIBLE);
            } else {
                btnPrintAll.setVisibility(View.GONE);
            }
            if (MyApp.userPermission.print_bill.actions.list && printBillMainSetting != null && (printBillMainSetting.value.equalsIgnoreCase("true") || printBillMainSetting.value.equalsIgnoreCase("1"))) {
                btnPrintBill.setVisibility(View.VISIBLE);
            } else {
                btnPrintBill.setVisibility(View.GONE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            btnPrintBill.setOnClickListener(view -> {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss("print_bill");
                    dismiss();
                }
            });
            btnPrintAll.setOnClickListener(view -> {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss("print_all");
                    dismiss();
                }
            });
            chipBack.setOnClickListener(view -> {
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
