package com.ubsidi.epos_2021.fragment;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.ubsidi.R;
import com.ubsidi.epos_2021.activities.NewOrderActivity;
import com.ubsidi.epos_2021.adapters.CategoryAdapter;
import com.ubsidi.epos_2021.adapters.SubCategoryAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.Category;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.utils.WrapContentGridLayoutManager;

import java.util.ArrayList;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;

public class ProductAreaFragment extends BaseFragment {

    private RecyclerView rvCategories, rvSubCategory;
    private ProductsFragment productsFragment;
    private CategoryAdapter categoryAdapter;
    private SubCategoryAdapter subCategoryAdapter;

    private ArrayList<Category> filteredItems = new ArrayList<>();
    private ArrayList<Category> categories = new ArrayList<>();
    private ArrayList<Category> subCategories = new ArrayList<>();

    private Order order;
    private int _order_id;
    private String order_id;
    private String selectedCategoryId;
    private Category saveSelectedCategory;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_product_area, container, false);
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (getArguments() != null) {
                order = new Gson().fromJson(getArguments().getString("order"), Order.class);
                _order_id = getArguments().getInt("_order_id");
                order_id = getArguments().getString("order_id");
            }
        } catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            fetchProductCategory();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void initViews(View view) {
        try {
            rvCategories = view.findViewById(R.id.rvCategories);
            rvSubCategory = view.findViewById(R.id.rvSubCategory);

            setAdapters();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void setAdapters() {
        //top category

        try {
            categoryAdapter = new CategoryAdapter(filteredItems, (position, data) -> {
                try {
                    Category selectedCategory = (Category) data;
                    subCategories.clear();
                    if (selectedCategory.children != null && selectedCategory.children.size() > 0) {
                        subCategories.addAll(selectedCategory.children);
                    }
                    subCategoryAdapter.selectedSubCategoryId = null;
                    rvSubCategory.post(() -> subCategoryAdapter.notifyDataSetChanged());

                    productsFragment = getInstanceProducts(_order_id, order_id, selectedCategory.id, order.order_type_id);
                    changeFragment(productsFragment);
                    productsFragment.setNoDataFoundListener(o -> {
                        try {
                            if (o instanceof Integer) {
                                if ((int) o == 0) {
                                    if (subCategories.size() > 0) {
                                        Category sc = subCategories.get(0);
                                        subCategoryAdapter.selectedSubCategoryId = sc.id;
                                        rvSubCategory.post(() -> subCategoryAdapter.notifyDataSetChanged());
                                        changeFragment(getInstanceProducts(_order_id, order_id, sc.id, order.order_type_id));
                                    }
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                } catch (Exception e) {
                    e.printStackTrace();
                }

            });

            subCategoryAdapter = new SubCategoryAdapter(subCategories, (position, data) -> {
                try {
                    Category selectedCategory = (Category) data;
                    rvSubCategory.post(() -> subCategoryAdapter.notifyDataSetChanged());

                    changeFragment(getInstanceProducts(_order_id, order_id, selectedCategory.id, order.order_type_id));

                    if (getActivity() != null) {
                        ((NewOrderActivity) getActivity()).clearEditText();
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            int spanCount = getResources().getInteger(R.integer.order_products_span);
            rvCategories.setLayoutManager(new WrapContentGridLayoutManager(getActivity(), spanCount));
            rvCategories.setAdapter(categoryAdapter);
            int itemWidth = 0;
            subCategoryAdapter.itemWidth = itemWidth;
            rvSubCategory.setAdapter(subCategoryAdapter);
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }


    }

    private void changeFragment(Fragment fragment) {
        try {
            FragmentManager manager = getChildFragmentManager();
            FragmentTransaction transaction = manager.beginTransaction();
            transaction.replace(R.id.fragment_products, fragment);
            transaction.commitAllowingStateLoss();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchProductCategory() {
        try {
            Observable.fromCallable(() -> {
                        try {
                            order = appDatabase.orderDao().view(_order_id);
                            categories.clear();
                            if (saveSelectedCategory == null) {
                                Log.e("saveSelectedCategory ", " " + (myApp.categories.size()));
                                categories.addAll(myApp.categories);
                            } else {
                                categories.add(saveSelectedCategory);
                            }

                            filteredItems.clear();
                            filteredItems.addAll(categories);
                            subCategories.clear();
                            // Set first floor item selected;
                            if (categories.size() > 0) {
                                // Log.e("Category Name"," "+filteredItems.get(0).name);
                                Category selectedCategory = categories.get(0);
                                if (selectedCategory.children != null && selectedCategory.children.size() > 0) {
                                    subCategories.addAll(selectedCategory.children);
                                }
                                if (subCategoryAdapter != null) {
                                    rvSubCategory.post(() -> subCategoryAdapter.notifyDataSetChanged());
                                    ;
                                }
                                if (Validators.isNullOrEmpty(selectedCategoryId)) {
                                    selectedCategoryId = selectedCategory.id;
                                }
                                productsFragment = getInstanceProducts(_order_id, order_id, selectedCategoryId, order.order_type_id);
                                changeFragment(productsFragment);
                                productsFragment.setNoDataFoundListener(o -> {
                                    try {
                                        if (o instanceof Integer) {
                                            if ((int) o == 0) {
                                                if (subCategories.size() > 0) {
                                                    try {
                                                        Category sc = subCategories.get(0);
                                                        subCategoryAdapter.selectedSubCategoryId = sc.id;
                                                        rvSubCategory.post(() -> subCategoryAdapter.notifyDataSetChanged());
                                                        ;
                                                        changeFragment(getInstanceProducts(_order_id, order_id, sc.id, order.order_type_id));
                                                    } catch (Exception e) {
                                                        e.printStackTrace();
                                                    }
                                                }
                                            }
                                        }
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                });
                            }
                            if (categoryAdapter != null) {
                                rvCategories.post(() -> categoryAdapter.notifyDataSetChanged());
                            }
                        } catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                        return true;
                    }) // Execute in IO thread, i.e. background thread.
                    .subscribeOn(Schedulers.io())
                    // report or post the result to main thread.
                    .observeOn(AndroidSchedulers.mainThread())
                    // execute this RxJava
                    .subscribe(new Observer<Boolean>() {
                        @Override
                        public void onSubscribe(Disposable d) {

                        }

                        @Override
                        public void onNext(Boolean success) {
                            // on success. Called on main thread, as defined in .observeOn(AndroidSchedulers.mainThread())
                            try {

                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(Throwable e) {

                        }

                        @Override
                        public void onComplete() {

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    BroadcastReceiver selectedCategoryReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                String categoryItem = intent.getStringExtra("category_data");
                saveSelectedCategory = new Gson().fromJson(categoryItem, Category.class);
                subCategories.clear();
                if (saveSelectedCategory.children != null && saveSelectedCategory.children.size() > 0) {
                    subCategories.addAll(saveSelectedCategory.children);
                }
                subCategoryAdapter.selectedSubCategoryId = null;
                rvSubCategory.post(() -> subCategoryAdapter.notifyDataSetChanged());
                ;
                selectedCategoryId = saveSelectedCategory.id;
                productsFragment = getInstanceProducts(_order_id, order_id, saveSelectedCategory.id, order == null ? "" : order.order_type_id);
                changeFragment(productsFragment);
                productsFragment.setNoDataFoundListener(o -> {
                    try {
                        if (o instanceof Integer) {
                            if ((int) o == 0) {
                                if (subCategories.size() > 0) {
                                    Category sc = subCategories.get(0);
                                    subCategoryAdapter.selectedSubCategoryId = sc.id;
                                    rvSubCategory.post(() -> subCategoryAdapter.notifyDataSetChanged());
                                    changeFragment(getInstanceProducts(_order_id, order_id, sc.id, order.order_type_id));
                                }
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            } catch (JsonSyntaxException e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    public void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance(getActivity()).registerReceiver(selectedCategoryReceiver, new IntentFilter("search_receiver"));
    }


    @Override
    public void onDestroy() {
        super.onDestroy();
        LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(selectedCategoryReceiver);
    }

    public ProductsFragment getInstanceProducts(int _order_id, String order_id, String categoryId, String orderTypeId) {
        Bundle bundle = new Bundle();
        ProductsFragment fragment = new ProductsFragment();
        bundle.putString("category_id", categoryId);
        bundle.putString("order_type_id", orderTypeId);
        bundle.putString("order_id", order_id);
        bundle.putInt("_order_id", _order_id);
        fragment.setArguments(bundle);
        return fragment;
    }
}
