package com.ubsidi.epos_2021.fragment;


import android.bluetooth.BluetoothDevice;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.button.MaterialButtonToggleGroup;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.chip.Chip;
import com.ubsidi.R;
import com.ubsidi.epos_2021.adapters.SalesReportAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.DaoReportNameTotalValue;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.SalesReport;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.ToastUtils;
import com.wdullaer.materialdatetimepicker.date.DatePickerDialog;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ProductSalesReportFragment extends BaseFragment {

    private Chip chipBack;
    private LinearLayout llItemTitle;
    private LinearLayout llToDate, llFromDate;
    private String fromDateString, toDateString;
    private Calendar today = Calendar.getInstance();
    int fromYear, fromMonth, fromDay, toYear, toMonth, toDay;
    private Calendar fromCalender = Calendar.getInstance();
    private Calendar toCalender = Calendar.getInstance();
    private TextView tvFromDate, tvToDate;
    private MaterialCardView cvCustom;
    private RecyclerView rvReports;
    private MaterialButton btnBack, btnPrint;
    private ArrayList<Object> reports = new ArrayList<>();
    private SalesReportAdapter reportAdapter;
    private LinearLayout llProgress, llData;
    private TextView tvSelectedDate;

    private Date startDate, endDate;
    Calendar c = Calendar.getInstance();
    int year = c.get(Calendar.YEAR);
    int month = c.get(Calendar.MONTH);
    int day = 1;
    int selectedButton = 0;
    private SiteSetting ticketHeaderSetting;
    private SiteSetting footerASetting;
    private SiteSetting footerBSetting;
    private int headerAlignment = 0;

    private ZoneRichPrinter zoneRichPrinter;
    private SunmiPrinter sunmiPrinter;
    private WifiPrinter wifiPrinter;
    public BluetoothPrinter bluetoothPrinter;
    private Printer defaultPrinter;
    private LinearLayout llToday, llThisWeek, llThisMonth, llCustom;
    private TextView tvToday, tvThisWeek, tvThisMonth, tvCustom;
    private View vToday, vThisWeek, vThisMonth, vCustom;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_sales_report, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            setListeners();
            getToday();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean moveNext = false;
    int customeButton = 0;

    private void setListeners() {

        try {
            chipBack.setOnClickListener(v -> getActivity().onBackPressed());
            llToday.setOnClickListener(v -> {
                selectedButton = llToday.getId();
                cvCustom.setVisibility(View.GONE);
                chekedBtn(llToday);
                getToday();
            });
            llThisWeek.setOnClickListener(v -> {
                selectedButton = llThisWeek.getId();
                cvCustom.setVisibility(View.GONE);
                chekedBtn(llThisWeek);
                getWeek();
            });
            llThisMonth.setOnClickListener(v -> {
                selectedButton = llThisMonth.getId();
                cvCustom.setVisibility(View.GONE);
                chekedBtn(llThisMonth);
                getCurrentMonth();
            });
            llCustom.setOnClickListener(v -> {
                selectedButton = llCustom.getId();
                cvCustom.setVisibility(View.VISIBLE);
                chekedBtn(llCustom);
            });
            llFromDate.setOnClickListener(view -> {
                try {
                    DatePickerDialog datePickerDialog = DatePickerDialog.newInstance(new DatePickerDialog.OnDateSetListener() {
                        @Override
                        public void onDateSet(DatePickerDialog view, int y, int m, int d) {
                            fromDay = d;
                            fromMonth = m;
                            fromYear = y;
                            fromDateString = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                            fromCalender.set(y, m, d);
                            tvFromDate.setText(CommonFunctions.formatMiliToDesireFormat(fromCalender.getTimeInMillis(), "dd/MM/yyyy"));

                            setDateText();
                            fetchReport();
                        }
                    }, fromCalender.get(Calendar.YEAR), fromCalender.get(Calendar.MONTH), fromCalender.get(Calendar.DAY_OF_MONTH));
                    datePickerDialog.setThemeDark(false);
                    datePickerDialog.showYearPickerFirst(false);
                    datePickerDialog.show(getActivity().getFragmentManager(), "FromPickerDialog");
                    if (!Validators.isNullOrEmpty(toDateString)) {
                        datePickerDialog.setMaxDate(toCalender);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });

            llToDate.setOnClickListener(view -> {
                try {
                    DatePickerDialog datePickerDialog = DatePickerDialog.newInstance((view1, y, m, d) -> {
                        toDay = d;
                        toMonth = m;
                        toYear = y;
                        toDateString = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                        toCalender.set(y, m, d);
                        tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalender.getTimeInMillis(), "dd/MM/yyyy"));

                        setDateText();
                        fetchReport();
                    }, toCalender.get(Calendar.YEAR), toCalender.get(Calendar.MONTH), toCalender.get(Calendar.DAY_OF_MONTH));
                    datePickerDialog.setThemeDark(false);
                    datePickerDialog.showYearPickerFirst(false);
                    datePickerDialog.show(getActivity().getFragmentManager(), "ToPickerDialog");
                    if (!Validators.isNullOrEmpty(fromDateString)) {
                        datePickerDialog.setMinDate(fromCalender);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            btnBack.setOnClickListener(view -> {
                getActivity().onBackPressed();
            });
            btnPrint.setOnClickListener(view -> {
                createPrint();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void chekedBtn(View v) {
        try {
            vToday.setBackgroundResource(R.color.light_gray);
            tvToday.setAlpha(0.5f);

            vThisWeek.setBackgroundResource(R.color.light_gray);
            tvThisWeek.setAlpha(0.5f);

            vThisMonth.setBackgroundResource(R.color.light_gray);
            tvThisMonth.setAlpha(0.5f);

            vCustom.setBackgroundResource(R.color.light_gray);
            tvCustom.setAlpha(0.5f);

            if (v == llToday) {
                vToday.setBackgroundResource(R.color.persian_green);
                tvToday.setAlpha(1f);
            }
            if (v == llThisWeek) {
                vThisWeek.setBackgroundResource(R.color.persian_green);
                tvThisWeek.setAlpha(1f);
            }
            if (v == llThisMonth) {
                vThisMonth.setBackgroundResource(R.color.persian_green);
                tvThisMonth.setAlpha(1f);
            }
            if (v == llCustom) {
                vCustom.setBackgroundResource(R.color.persian_green);
                tvCustom.setAlpha(1f);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void getCurrentMonth() {
        try {
            c.set(year, month, day);
            startDate = c.getTime();


            int numOfDaysInMonth = c.getActualMaximum(Calendar.DAY_OF_MONTH);
            c.add(Calendar.DAY_OF_MONTH, numOfDaysInMonth - 1);

            endDate = c.getTime();

            fromDateString = CommonFunctions.formatMiliToDesireFormat(startDate.getTime(), "yyyy-MM-dd");
            toDateString = CommonFunctions.formatMiliToDesireFormat(endDate.getTime(), "yyyy-MM-dd");

            setDateText();
            fetchReport();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void getWeek() {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setFirstDayOfWeek(Calendar.MONDAY);
            cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
            startDate = cal.getTime();

            cal.add(Calendar.DATE, 6);
            endDate = cal.getTime();

            fromDateString = CommonFunctions.formatMiliToDesireFormat(startDate.getTime(), "yyyy-MM-dd");
            toDateString = CommonFunctions.formatMiliToDesireFormat(endDate.getTime(), "yyyy-MM-dd");

            setDateText();
            fetchReport();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getToday() {
        try {
            fromDateString = CommonFunctions.formatMiliToDesireFormat(System.currentTimeMillis(), "yyyy-MM-dd");
            toDateString = CommonFunctions.formatMiliToDesireFormat(System.currentTimeMillis(), "yyyy-MM-dd");

            setDateText();
            fetchReport();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setDateText() {
        try {
            if (fromDateString.equalsIgnoreCase(toDateString)) {
                tvSelectedDate.setText(CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd MMM yyyy"));
            } else {
                tvSelectedDate.setText(CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd MMM yyyy") + " to " + CommonFunctions.formatUnknownDateTime(toDateString, "yyyy-MM-dd", "dd MMM yyyy"));
            }

            tvFromDate.setText("From: " + CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd/MM/yyyy"));
            tvToDate.setText("To: " + CommonFunctions.formatUnknownDateTime(toDateString, "yyyy-MM-dd", "dd/MM/yyyy"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            loadSettings();
            zoneRichPrinter = new ZoneRichPrinter(getActivity());
            defaultPrinter = myPreferences.getDefaultPrinter();
            zoneRichPrinter = myApp.connectZonerich(zoneRichPrinter, defaultPrinter);
            sunmiPrinter = new SunmiPrinter(getActivity());
            wifiPrinter = WifiPrinter.getInstance();
            bluetoothPrinter = new BluetoothPrinter(getActivity());
            chipBack = view.findViewById(R.id.chipBack);
            cvCustom = view.findViewById(R.id.cvCustom);
            rvReports = view.findViewById(R.id.rvReports);
            btnBack = view.findViewById(R.id.btnBack);
            btnPrint = view.findViewById(R.id.btnPrint);
            llToDate = view.findViewById(R.id.llToDate);
            llFromDate = view.findViewById(R.id.llFromDate);
            tvToDate = view.findViewById(R.id.tvToDate);
            tvFromDate = view.findViewById(R.id.tvFromDate);
            llProgress = view.findViewById(R.id.llProgress);
            llData = view.findViewById(R.id.llData);
            tvSelectedDate = view.findViewById(R.id.tvSelectedDate);
            llItemTitle = view.findViewById(R.id.llItemTitle);
            fromMonth = today.get(Calendar.MONTH);
            fromDay = today.get(Calendar.DAY_OF_MONTH);
            fromYear = today.get(Calendar.YEAR);

            toMonth = today.get(Calendar.MONTH);
            toDay = today.get(Calendar.DAY_OF_MONTH);
            toYear = today.get(Calendar.YEAR);

            llToday = view.findViewById(R.id.llToday);
            llThisWeek = view.findViewById(R.id.llThisWeek);
            llThisMonth = view.findViewById(R.id.llThisMonth);
            llCustom = view.findViewById(R.id.llCustom);

            tvToday = view.findViewById(R.id.tvToday);
            tvThisWeek = view.findViewById(R.id.tvThisWeek);
            tvThisMonth = view.findViewById(R.id.tvThisMonth);
            tvCustom = view.findViewById(R.id.tvCustom);

            vToday = view.findViewById(R.id.vToday);
            vThisWeek = view.findViewById(R.id.vThisWeek);
            vThisMonth = view.findViewById(R.id.vThisMonth);
            vCustom = view.findViewById(R.id.vCustom);

            chekedBtn(llToday);
            cvCustom.setVisibility(View.GONE);
            reportAdapter = new SalesReportAdapter(reports, (position, data) -> {

            });
            rvReports.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            rvReports.setAdapter(reportAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void loadSettings() {
        try {
            SiteSetting ticketHeaderTypeSetting = myApp.findSetting("ticket_header_type");
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("right")) {
                headerAlignment = 2;
            }
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("center")) {
                headerAlignment = 1;
            }
            ticketHeaderSetting = myApp.findSetting("ticket_header");

            footerASetting = myApp.findSetting("footer_a");
            footerBSetting = myApp.findSetting("footer_b");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ReportAsync extends AsyncTask<String, String, String> {

        @Override
        protected String doInBackground(String... strings) {
            try {
                StringBuffer stringCategoriesQuery = new StringBuffer();
                ArrayList<String> categoriesParams = new ArrayList<>();

                stringCategoriesQuery.append("SELECT SUM(OrderItem.quantity) as total, SUM(OrderItem.total) as value, OrderItem.product_name as name FROM OrderItem LEFT JOIN 'Order' ON 'Order'._id= OrderItem._order_id LEFT JOIN Product ON Product.id= OrderItem.product_id WHERE date('Order'.created_at) >= ?  AND date('Order'.created_at) <= ? AND is_delete=0");


                categoriesParams.add(fromDateString);
                categoriesParams.add(toDateString);

                stringCategoriesQuery.append(" GROUP BY OrderItem.product_id");
                SupportSQLiteQuery categoryQuery = new SimpleSQLiteQuery(stringCategoriesQuery.toString(), categoriesParams.toArray());

                List<DaoReportNameTotalValue> categories = appDatabase.reportDao().getOrderStatusReport(categoryQuery);

                reports.clear();
                for (DaoReportNameTotalValue d : categories) {
                    SalesReport salesReport = new SalesReport();
                    salesReport.category_name = d.name;
                    salesReport.count = d.total;
                    salesReport.total = d.value;
                    reports.add(salesReport);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                llProgress.setVisibility(View.GONE);
                llData.setVisibility(View.VISIBLE);
                if (reports.size() > 0) {
                    llItemTitle.setVisibility(View.VISIBLE);
                } else
                    llItemTitle.setVisibility(View.GONE);
                reportAdapter.notifyDataSetChanged();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void fetchReport() {
        try {
            if ("manual".equalsIgnoreCase(myPreferences.getOrderSyncMode())) {
                new ReportAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                return;
            }
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    llProgress.setVisibility(View.VISIBLE);
                    llData.setVisibility(View.GONE);
                });
            }
            AndroidNetworking.get(ApiEndPoints.sales_report)
                    .addQueryParameter("shift_status", "both")
                    .addQueryParameter("from_date", fromDateString)
                    .addQueryParameter("to_date", toDateString)
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(SalesReport.class, new ParsedRequestListener<List<SalesReport>>() {

                        @Override
                        public void onResponse(List<SalesReport> response) {
                            try {
                                reports.clear();
                                reports.addAll(response);

                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llProgress.setVisibility(View.GONE);
                                        llData.setVisibility(View.VISIBLE);
                                        if (reports.size() > 0) {
                                            llItemTitle.setVisibility(View.VISIBLE);
                                        } else
                                            llItemTitle.setVisibility(View.GONE);
                                        reportAdapter.notifyDataSetChanged();
                                    });
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llProgress.setVisibility(View.GONE);
                                        llData.setVisibility(View.GONE);
                                    });
                                }

                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    private void createPrint() {
        try {
            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                    zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                    zoneRichPrinter.printFullReport(myApp.businessLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, "Product Sale Report", tvSelectedDate.getText().toString(), null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myApp.myPreferences);
                    getActivity().onBackPressed();
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("sunmi") || defaultPrinter.printer_model_name.toLowerCase().contains("t2")) {
                    sunmiPrinter.printFullReport(myApp.businessLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, "Product Category Sale Report", tvSelectedDate.getText().toString(), null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                    getActivity().onBackPressed();
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                        wifiPrinter.connect(defaultPrinter.ip);
                        wifiPrinter.printFullReport(myApp.businessLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, "Product Category Sale Report", tvSelectedDate.getText().toString(), null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                        getActivity().onBackPressed();
                    } else {
                        try {
                            if (bluetoothPrinter != null) {
                                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                if (device != null) {
                                    bluetoothPrinter.printFullReport(myApp.businessLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, "Product Category Sale Report", tvSelectedDate.getText().toString(), null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "");
                                    getActivity().onBackPressed();
                                } else {
                                    ToastUtils.makeSnackToast(getActivity(), "No bluetooth device found.");
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                ToastUtils.makeSnackToast(getActivity(), "No printer model found");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
