package com.ubsidi.epos_2021.fragment;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.activities.NewOrderActivity;
import com.ubsidi.epos_2021.adapters.AddonAdapter;
import com.ubsidi.epos_2021.adapters.ProductsAdapter;
import com.ubsidi.epos_2021.adapters.SubAddonAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.Addon;
import com.ubsidi.epos_2021.models.Category;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderType;
import com.ubsidi.epos_2021.models.Product;
import com.ubsidi.epos_2021.models.ProductAddon;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.utils.ToastUtils;
import com.ubsidi.epos_2021.utils.WrapContentGridLayoutManager;

import java.util.ArrayList;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;

public class ProductsFragment extends BaseFragment {
    private RecyclerView rvItems;
    private ArrayList<Product> products = new ArrayList<>();
    private ArrayList<Product> allProducts = new ArrayList<>();
    private ArrayList<Product> filteredItems = new ArrayList<>();
    public ProductsAdapter productsAdapter;
    public EditText etSearchItem;
    private TextView tvSearch, tvErrorMessage;
    private String categoryId;
    private OrderType orderType;
    private int _order_id;
    private String order_id;
    private SiteSetting addonThemeSetting;
    DialogDismissListener errorListener;

    public void setNoDataFoundListener(DialogDismissListener errorListener) {
        this.errorListener = errorListener;
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (getArguments() != null) {
                categoryId = getArguments().getString("category_id");
                String orderTypeId = getArguments().getString("order_type_id");
                _order_id = getArguments().getInt("_order_id");
                order_id = getArguments().getString("order_id");
                orderType = new Gson().fromJson(getArguments().getString("order_type"), OrderType.class);
                if (!Validators.isNullOrEmpty(orderTypeId) && orderType == null) {
                    orderType = new OrderType(orderTypeId, "");
                }
            }
        } catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_products, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            addonThemeSetting = myApp.findSetting("addon_theme");
            iniViews(view);
            setListeners();
            fetchProducts();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void iniViews(View view) {

        try {
            rvItems = view.findViewById(R.id.rvItems);
            etSearchItem = view.findViewById(R.id.etSearch);
            tvSearch = view.findViewById(R.id.tvSearch);
            tvErrorMessage = view.findViewById(R.id.tvErrorMessage);
            productsAdapter = new ProductsAdapter(filteredItems, (position, data) -> {
                Product product = (Product) data;
                getActivity().runOnUiThread(new Runnable() {
                    @Override
                    public void run() {

                        new Handler().postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                try {
                                    getOrderItemFromProduct(product);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }, 500);
                    }
                });
            });
            int spanCount = getResources().getInteger(R.integer.order_products_span);
            rvItems.setLayoutManager(new WrapContentGridLayoutManager(getActivity(), spanCount));
            rvItems.setAdapter(productsAdapter);
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }

    }

    private void getOrderItemFromProduct(Product product) {
        try {
            OrderItem orderItem = new OrderItem();
            orderItem._order_id = _order_id;
            orderItem.order_id = order_id;
            orderItem.product_name = product.name;
            orderItem.product_short_name = product.short_name;
            orderItem.product_id = product.id;
            orderItem.quantity = 1;
            orderItem.price = product.selected_price;
            orderItem.sub_total = (orderItem.quantity * orderItem.price);
            orderItem.total = orderItem.sub_total + orderItem.addons_price + orderItem.ingredients_price;
            orderItem.updater_id = myPreferences.getLoggedInUser().id;
            openProductEdit(product, orderItem);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            NewOrderActivity orderActivity = (NewOrderActivity) getActivity();
            orderActivity.setSearchListener(o -> {
                String searchText = (String) o;
                etSearchItem.setText(searchText);
            });
            etSearchItem.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void afterTextChanged(Editable editable) {
                    try {
                        filteredItems.clear();
                        filteredItems.addAll(searchItems());
                        rvItems.post(() -> productsAdapter.notifyDataSetChanged());

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });

            etSearchItem.setOnKeyListener((textView, i, keyEvent) -> {
                if (keyEvent.getKeyCode() == KeyEvent.KEYCODE_BACK) {
                    getActivity().onBackPressed();
                } else if ((keyEvent.getKeyCode() == KeyEvent.KEYCODE_ENTER)) {
                    filteredItems.clear();
                    filteredItems.addAll(searchItems());
                    rvItems.post(() -> productsAdapter.notifyDataSetChanged());
                    if (getActivity() != null) {
                        CommonFunctions.hideKeyboard(getActivity(), etSearchItem);
                    }
                }
                return false;
            });

            tvSearch.setOnClickListener(v -> {
                try {
                    if (!Validators.isNullOrEmpty(etSearchItem.getText().toString())) {
                        filteredItems.clear();
                        filteredItems.addAll(searchItems());
                        rvItems.post(() -> productsAdapter.notifyDataSetChanged());
                    } else {
                        ToastUtils.makeToast(getActivity(), "please enter item name or number");
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });

            //Listen Cart item
            LocalBroadcastManager.getInstance(getActivity()).registerReceiver(cart_update, new IntentFilter("cart_update"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final BroadcastReceiver cart_update = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                boolean notifyAdapter = intent.getBooleanExtra("notify_products", false);
                if (notifyAdapter) {
                    rvItems.post(() -> productsAdapter.notifyDataSetChanged());
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    public void onDestroy() {
        super.onDestroy();
        if(getActivity()!=null){
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(cart_update);
        }
    }

    private void fetchProducts() {
        try {
            tvErrorMessage.setVisibility(View.GONE);
            //new ProductAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, categoryId);
            fetchProduct();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void openProductEdit(Product product, OrderItem orderItem) {
        try {
            if ((product.auto_addon && product.total_addons > 0 && (MyApp.userPermission != null && MyApp.userPermission.addons.actions.list)) || (product.auto_modify && MyApp.userPermission != null && MyApp.userPermission.modify.actions.list && product.product_ingredients.size() > 0)) {
                // old and new theme same like food hub condition
                if (addonThemeSetting != null && !Validators.isNullOrEmpty(addonThemeSetting.value) && (addonThemeSetting.value.equalsIgnoreCase("theme1"))) {
                    CartProductEditDialogFragmentOldDesign cartProductEditDialogFragmentOldDesign = getInstanceCartProductEditDialogOldDesign(orderType.id, orderItem);
                    cartProductEditDialogFragmentOldDesign.show(getChildFragmentManager(), "product_view");
                } else {
                    CartProductEditDialogFragment cartProductEditDialogFragment = getInstanceCartProductEditDialog(orderType.id, orderItem);
                    cartProductEditDialogFragment.show(getChildFragmentManager(), "product_view");
                }
            } else {
                myApp.notifyCart(getContext(), new Intent("cart_update").putExtra("order_item", new Gson().toJson(orderItem)));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CartProductEditDialogFragmentOldDesign getInstanceCartProductEditDialogOldDesign(String orderTypeId, OrderItem orderItem) {
        CartProductEditDialogFragmentOldDesign fragment = new CartProductEditDialogFragmentOldDesign();
        Bundle bundle = new Bundle();
        bundle.putString("order_item", new Gson().toJson(orderItem));
        bundle.putString("order_type_id", orderTypeId);
        fragment.setArguments(bundle);
        return fragment;
    }

    public CartProductEditDialogFragment getInstanceCartProductEditDialog(String orderTypeId, OrderItem orderItem) {
        CartProductEditDialogFragment fragment = new CartProductEditDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("order_item", new Gson().toJson(orderItem));
        bundle.putString("order_type_id", orderTypeId);
        fragment.setArguments(bundle);
        return fragment;
    }


    private ArrayList<Product> searchItems() {
        if (etSearchItem.getText().toString().isEmpty()) {
            return products;
        }

        ArrayList<Product> searchedRest = new ArrayList<>();

        for (Product s : allProducts) {
            if (s.name != null && s.name.toLowerCase().trim().contains(etSearchItem.getText().toString().toLowerCase().trim())) {
                searchedRest.add(s);
            }
        }
        getActivity().runOnUiThread(() -> {
            if (searchedRest.size() == 0) {
                tvErrorMessage.setVisibility(View.VISIBLE);
            } else {
                tvErrorMessage.setVisibility(View.GONE);
            }
        });
        return searchedRest;
    }

    private void fetchProduct() {
        try {
            Observable.fromCallable(() -> {
                        try {
                            Thread.currentThread().setPriority(Thread.MAX_PRIORITY);
                            products.clear();
                            allProducts.clear();
                            if (myApp.showBanquetPorducts) {
                                switch (orderType.id) {
                                    case "1":
                                        products.addAll(appDatabase.productDao().listDineinProductByCategory(categoryId, 1));
                                        allProducts.addAll(appDatabase.productDao().listDineinProductByCategory(1));
                                        break;
                                    case "2": //Collection & Waiting
                                    case "5": //Collection & Waiting
                                    case "4":
                                        products.addAll(appDatabase.productDao().listCollectionProductByCategory(categoryId, 1));
                                        allProducts.addAll(appDatabase.productDao().listCollectionProductByCategory(1));
                                        break;
                                    case "3":
                                        products.addAll(appDatabase.productDao().listDeliveryProductByCategory(categoryId, 1));
                                        allProducts.addAll(appDatabase.productDao().listDeliveryProductByCategory(1));
                                        break;
                                    default:
                                        products.addAll(appDatabase.productDao().listByCategory(categoryId, 1));
                                        allProducts.addAll(appDatabase.productDao().listBanquetProductByCategory(1));
                                        break;
                                }
                            } else {
                                switch (orderType.id) {
                                    case "1":
                                        products.addAll(appDatabase.productDao().listDineinProductByCategory(categoryId));
                                        allProducts.addAll(appDatabase.productDao().listDineinProductByCategory());
                                        break;
                                    case "2": //Collection & Waiting
                                    case "5": //Collection & Waiting
                                    case "4":
                                        products.addAll(appDatabase.productDao().listCollectionProductByCategory(categoryId));
                                        allProducts.addAll(appDatabase.productDao().listCollectionProductByCategory());
                                        break;
                                    case "3":
                                        products.addAll(appDatabase.productDao().listDeliveryProductByCategory(categoryId));
                                        allProducts.addAll(appDatabase.productDao().listDeliveryProductByCategory());
                                        break;
                                    default:
                                        products.addAll(appDatabase.productDao().listByCategory(categoryId));
                                        allProducts.addAll(appDatabase.productDao().list());
                                        break;
                                }
                            }
                            for (Product p : products) {
                                p.selected_price = MyApp.calculatedProductPrice(orderType.id, p);
                            }
                            for (Product p : allProducts) {
                                p.selected_price = MyApp.calculatedProductPrice(orderType.id, p);
                            }

                            filteredItems.clear();
                            filteredItems.addAll(products);

                            if (getActivity() != null) {
                                rvItems.post(() -> productsAdapter.notifyDataSetChanged());
                                if (products.size() == 0) {
                                    tvErrorMessage.post(() -> {
                                        tvErrorMessage.setVisibility(View.VISIBLE);
                                        tvErrorMessage.setText("No products found");
                                    });
                                    if (errorListener != null)
                                        errorListener.onDialogDismiss(0);
                                } else {
                                    tvErrorMessage.post(() -> {
                                        tvErrorMessage.setVisibility(View.GONE);
                                    });
                                    if (errorListener != null)
                                        errorListener.onDialogDismiss(1);
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        return true;
                    }) // Execute in IO thread, i.e. background thread.
                    .subscribeOn(Schedulers.io())
                    // report or post the result to main thread.
                    .observeOn(AndroidSchedulers.mainThread())
                    // execute this RxJava
                    .subscribe(new Observer<Boolean>() {
                        @Override
                        public void onSubscribe(Disposable d) {

                        }

                        @Override
                        public void onNext(Boolean success) {
                            // on success. Called on main thread, as defined in .observeOn(AndroidSchedulers.mainThread())
                            try {

                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(Throwable e) {

                        }

                        @Override
                        public void onComplete() {

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
