package com.ubsidi.epos_2021.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.DialogFragment;

import com.ubsidi.R;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;

public class PushDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private AppCompatImageView ivClose;
    private CardView cvCard;
    private DialogDismissListener dialogDismissListener;
    String title, subTitle;
    String orderId, paymentStatus, orderType;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_push_fragment, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (getArguments() != null) {
                title = getArguments().getString("title");
                subTitle = getArguments().getString("sub_title");
                orderId = getArguments().getString("order_type");
                orderType = getArguments().getString("order_type");
                paymentStatus = getArguments().getString("payment_status");
            }
            initViews(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            ivClose = view.findViewById(R.id.ivClose);
            TextView tvSubTitle = view.findViewById(R.id.tvSubTitle);
            TextView tvTitle = view.findViewById(R.id.tvTitle);
            cvCard = view.findViewById(R.id.cvCardBg);
            tvTitle.setText(title);
            tvSubTitle.setText(subTitle);
            if (!Validators.isNullOrEmpty(orderType)) {
                String title = orderType + " - " + paymentStatus;
                String subTitle = "New online order";

                tvTitle.setText(title);
                tvSubTitle.setText(subTitle);
                if (orderType.equalsIgnoreCase("delivery")) {
                    cvCard.setCardBackgroundColor(ContextCompat.getColor(getActivity(), R.color.orders_card_bg_green));
                } else if (orderType.equalsIgnoreCase("collection") || orderType.equalsIgnoreCase("pickup")) {
                    cvCard.setCardBackgroundColor(ContextCompat.getColor(getActivity(), R.color.orders_card_bg_indigo));
                } else if (orderType.equalsIgnoreCase("dinein")) {
                    cvCard.setCardBackgroundColor(ContextCompat.getColor(getActivity(), R.color.orders_card_bg_amber));
                } else {
                    cvCard.setCardBackgroundColor(ContextCompat.getColor(getActivity(), R.color.orders_card_bg_orange));
                }
            } else {
                String title = "Reservation";
                String subTitle = "New online order";
                cvCard.setCardBackgroundColor(ContextCompat.getColor(getActivity(), R.color.orders_card_bg_orange));
                tvTitle.setText(title);
                tvSubTitle.setText(subTitle);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            cvCard.setOnClickListener(view -> {
                if (!Validators.isNullOrEmpty(orderId)) {
                    if (dialogDismissListener != null)
                        dialogDismissListener.onDialogDismiss(orderId);
                } else {
                    if (dialogDismissListener != null)
                        dialogDismissListener.onDialogDismiss("booking");
                }
                dismiss();
            });
            ivClose.setOnClickListener(view -> {
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}