package com.ubsidi.epos_2021.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.MenuAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.models.ExclusionModel;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;

public class ReportListFragment extends BaseFragment {
    private ArrayList<ExclusionModel> paymentList = new ArrayList<>();

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_report_list, container, false);
    }

    @Override
    public void onViewCreated(@NonNull @NotNull View view, @Nullable @org.jetbrains.annotations.Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initView(view);
            setUpPayments();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initView(View view) {

        try {
            RecyclerView rvReports = view.findViewById(R.id.rvReports);

            MenuAdapter menuAdapter = new MenuAdapter(paymentList, (position, data) -> {
                try {
                    ExclusionModel exclusionModel = (ExclusionModel) data;
                    if (exclusionModel.id.equalsIgnoreCase("full_report")) {
                        changeFragment(getInstance("Full Report", false));
                    }
                    if (exclusionModel.id.equalsIgnoreCase("full_archived_report")) {
                        changeFragment(getInstance("Full Archived Report", true));
                    }
                    if (exclusionModel.id.equalsIgnoreCase("online_order_report")) {
                        changeFragment(getInstance("Online Order Report", false, true));
                    }
                    if (exclusionModel.id.equalsIgnoreCase("selected_user_report")) {
                        changeFragment(getInstance(true));
                    }
                    if (exclusionModel.id.equalsIgnoreCase("product_sales_report")) {
                        changeFragment(new ProductSalesReportFragment());
                    }

                    if (exclusionModel.id.equalsIgnoreCase("product_category_sales_report")) {
                        changeFragment(new CategorySalesReportFragment());
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });

            rvReports.setLayoutManager(new LinearLayoutManager(getActivity(), LinearLayoutManager.VERTICAL, false));
            rvReports.setAdapter(menuAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public FullReportFragment getInstance(String title, boolean isUserReport, boolean isOnlineReport) {
        FullReportFragment fullReportFragment = new FullReportFragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean("user_report", isUserReport);
        bundle.putBoolean("online_report", isOnlineReport);
        bundle.putString("title", title);
        fullReportFragment.setArguments(bundle);
        return fullReportFragment;
    }

    public FullReportFragment getInstance(String title, boolean isArchived) {
        FullReportFragment fullReportFragment = new FullReportFragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean("is_archived", isArchived);
        bundle.putString("title", title);
        fullReportFragment.setArguments(bundle);
        return fullReportFragment;
    }

    public FullReportFragment getInstance(boolean isUserReport) {
        FullReportFragment fullReportFragment = new FullReportFragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean("user_report", isUserReport);
        fullReportFragment.setArguments(bundle);
        return fullReportFragment;
    }


    private void setUpPayments() {
        try {
            paymentList.clear();

            ExclusionModel exclusionModel = new ExclusionModel();
            exclusionModel.id = "full_report";
            exclusionModel.name = "Full Report";
            paymentList.add(exclusionModel);
            if (MyApp.userPermission != null && MyApp.userPermission.archive_order.actions.list) {
                exclusionModel = new ExclusionModel();
                exclusionModel.id = "full_archived_report";
                exclusionModel.name = "Full Archived Report";
                paymentList.add(exclusionModel);
            }
            if (MyApp.userPermission != null && MyApp.userPermission.product_wise.actions.list) {
                exclusionModel = new ExclusionModel();
                exclusionModel.id = "product_sales_report";
                exclusionModel.name = "Product Sales Report";
                paymentList.add(exclusionModel);
            }
            if (MyApp.userPermission != null && MyApp.userPermission.product_category_wise.actions.list) {
                exclusionModel = new ExclusionModel();
                exclusionModel.id = "product_category_sales_report";
                exclusionModel.name = "Product Category Report";
                paymentList.add(exclusionModel);
            }


            exclusionModel = new ExclusionModel();
            exclusionModel.id = "selected_user_report";
            exclusionModel.name = "Selected User Report";
            paymentList.add(exclusionModel);

            exclusionModel = new ExclusionModel();
            exclusionModel.id = "online_order_report";
            exclusionModel.name = "Online Order Report";
            paymentList.add(exclusionModel);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeFragment(Fragment fragment) {
        try {
            FragmentManager manager = getActivity().getSupportFragmentManager();
            FragmentTransaction transaction = manager.beginTransaction();
            transaction.replace(R.id.nav_payment_fragment, fragment);
            transaction.addToBackStack("can_go_back");
            transaction.commit();
            getActivity().invalidateOptionsMenu();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}