package com.ubsidi.epos_2021.fragment;


import android.bluetooth.BluetoothDevice;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONArrayRequestListener;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.activities.NewOrderActivity;
import com.ubsidi.epos_2021.adapters.ReservationListAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinterV3Mix;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.daos.relations.ReservationWithCustomer;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.Reservation;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.Table;
import com.ubsidi.epos_2021.models.TableStatus;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.online.fragments.RejectReasonDialogFragment;
import com.ubsidi.epos_2021.online.models.OnlineReservation;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;
import com.wdullaer.materialdatetimepicker.date.DatePickerDialog;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class ReservationListFragment extends BaseFragment {

    private Chip chipBack;
    private SwipeRefreshLayout swipeRefreshLayout;
    private TextView tvDate, tvTotalCustomer, tvErrorMessage;
    private MaterialCardView btnPrintList, btnNew, btnDeleteAll;
    private MaterialButton btnCustom;
    private ArrayList<Object> objects = new ArrayList<>();
    private ArrayList<Reservation> reservationList = new ArrayList<>();
    private ArrayList<OnlineReservation> onlineReservations = new ArrayList<>();
    private ReservationListAdapter reservationListAdapter;
    private AlertDialog progressBarDialog;
    private ZoneRichPrinter zoneRichPrinter;
    private SunmiPrinter sunmiPrinter;
    private SunmiPrinterV3Mix sunmiPrinterV3Mix;
    private WifiPrinter wifiPrinter;
    public BluetoothPrinter bluetoothPrinter;
    private Printer defaultPrinter;
    private int headerAlignment = 0;
    private SiteSetting ticketHeaderSetting;
    private SiteSetting footerASetting;
    private SiteSetting footerBSetting;
    int selectedButton = 0;
    private Date startDate, endDate;
    Calendar c = Calendar.getInstance();
    private String fromDateString = "0", toDateString = "0";
    private Calendar myCalendar = Calendar.getInstance();
    private Date fromDate, toDate;
    private boolean pendingSelected = false;
    private CheckBox cvDeleteAll;
    private LinearLayout llPending, llToday, llThisWeek, llThisMonth, llCustom, llCustomOri, linearFromTo;
    private TextView tvPending, tvToday, tvThisWeek, tvThisMonth, tvCustom, tvCustomOri;
    private View vPending, vToday, vThisWeek, vThisMonth, vCustom, vCustomOri;
    public TableStatus vacantStatus = myApp.findStatus("Vacant");
    public TableStatus takingOrderStatus = myApp.findStatus("Taking Order");
    private EditText etValidFrom, etValidTo;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_reservationlist, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initView(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initView(View view) {
        try {
            loadSettings();
            defaultPrinter = myPreferences.getDefaultPrinter();
            zoneRichPrinter = new ZoneRichPrinter(getActivity());
            zoneRichPrinter = myApp.connectZonerich(zoneRichPrinter, defaultPrinter);
            sunmiPrinter = new SunmiPrinter(getActivity());
            if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                sunmiPrinterV3Mix = new SunmiPrinterV3Mix(requireActivity());
            }
            wifiPrinter = WifiPrinter.getInstance();
            bluetoothPrinter = new BluetoothPrinter(getActivity());
            progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
            btnNew = view.findViewById(R.id.btnNew);
            btnPrintList = view.findViewById(R.id.btnPrintList);
            tvTotalCustomer = view.findViewById(R.id.tvTotalCustomer);
            tvDate = view.findViewById(R.id.tvDate);
            chipBack = view.findViewById(R.id.chipBack);
            btnCustom = view.findViewById(R.id.btnCustomSingleDate);
            btnDeleteAll = view.findViewById(R.id.btnDeleteAll);
            RecyclerView rvReservation = view.findViewById(R.id.rvReservation);
            swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
            tvErrorMessage = view.findViewById(R.id.tvErrorMessage);

            llPending = view.findViewById(R.id.llPending);
            llToday = view.findViewById(R.id.llToday);
            llThisWeek = view.findViewById(R.id.llThisWeek);
            llThisMonth = view.findViewById(R.id.llThisMonth);
            llCustom = view.findViewById(R.id.llCustom);
            llCustomOri = view.findViewById(R.id.llCustomOri);
            linearFromTo = view.findViewById(R.id.linearFromTo);

            tvPending = view.findViewById(R.id.tvPending);
            tvToday = view.findViewById(R.id.tvToday);
            cvDeleteAll = view.findViewById(R.id.cvDeleteAll);
            tvThisWeek = view.findViewById(R.id.tvThisWeek);
            tvThisMonth = view.findViewById(R.id.tvThisMonth);
            tvCustom = view.findViewById(R.id.tvCustom);
            tvCustomOri = view.findViewById(R.id.tvCustomOri);
            etValidFrom = view.findViewById(R.id.etValidFrom);
            etValidTo = view.findViewById(R.id.etValidTo);

            vPending = view.findViewById(R.id.vPending);
            vToday = view.findViewById(R.id.vToday);
            vThisWeek = view.findViewById(R.id.vThisWeek);
            vThisMonth = view.findViewById(R.id.vThisMonth);
            vCustom = view.findViewById(R.id.vCustom);
            vCustomOri = view.findViewById(R.id.vCustomOri);

            chekedBtn(llPending);
            tvThisWeek.setText("Tomorrow");
            tvThisMonth.setText("D-A Tomorrow");
            tvCustom.setText("Show All");

            etValidFrom.setOnClickListener(v -> {
                try {
                    if (fromDate != null)
                        myCalendar.setTime(fromDate);
                    DatePickerDialog datePickerDialog = DatePickerDialog.newInstance(datePickerFromDate, myCalendar
                                    .get(Calendar.YEAR), myCalendar.get(Calendar.MONTH),
                            myCalendar.get(Calendar.DAY_OF_MONTH));
                    datePickerDialog.setThemeDark(false);
                    datePickerDialog.showYearPickerFirst(false);
                    datePickerDialog.show(getActivity().getFragmentManager(), "FromDatePickerDialog");
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            etValidTo.setOnClickListener(v -> {
                try {
                    if (Validators.isNullOrEmpty(fromDateString)) {
                        etValidFrom.performClick();
                    } else {
                        if (toDate != null)
                            myCalendar.setTime(toDate);
                        DatePickerDialog datePickerDialog = DatePickerDialog.newInstance(datePickerToDate, myCalendar
                                        .get(Calendar.YEAR), myCalendar.get(Calendar.MONTH),
                                myCalendar.get(Calendar.DAY_OF_MONTH));
                        datePickerDialog.setThemeDark(false);
                        datePickerDialog.showYearPickerFirst(false);
                        datePickerDialog.show(getActivity().getFragmentManager(), "FromDatePickerDialog");
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            cvDeleteAll.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                @Override
                public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                    if (compoundButton.isPressed()) {
                        for (int i = 0; i < reservationListAdapter.objects.size(); i++) {
                            Object reservaction = reservationListAdapter.objects.get(i);
                            if (reservaction instanceof OnlineReservation) {
                                if (((OnlineReservation) reservaction).past_days >= 7) {
                                    ((OnlineReservation) reservaction).isDeleteSelected = b;
                                }
                            }
                        }
                        if (b) {
                            btnDeleteAll.setVisibility(View.VISIBLE);
                        } else {
                            btnDeleteAll.setVisibility(View.GONE);
                        }
                        reservationListAdapter.notifyDataSetChanged();
                    }
                }
            });
            reservationListAdapter = new ReservationListAdapter(objects, (position, tag, data) -> {
                try {
                    if ("delete".equals(tag)) {
                        if (data instanceof OnlineReservation) {
                            btnDeleteAll.setVisibility(View.VISIBLE);
                        }
                    }
                    if ("print".equals(tag)) {
                        Reservation reservation = new Reservation();
                        if (data instanceof Reservation) {
                            reservation = (Reservation) data;
                        }
                        if (data instanceof OnlineReservation) {
                            OnlineReservation onlineReservation = (OnlineReservation) data;
                            reservation.id = String.valueOf(onlineReservation.id);
                            reservation.customer = new Customer();
                            reservation.customer.name = onlineReservation.customer_name;
                            reservation.customer.mobile = onlineReservation.booking_phone;
                            reservation.customer_name = onlineReservation.customer_name;
                            reservation.telephone = onlineReservation.booking_phone;
                            reservation.reservation_status = onlineReservation.status;
                            if (onlineReservation.booking_time != null && (onlineReservation.booking_time.toLowerCase().contains("mon") || onlineReservation.booking_time.toLowerCase().contains("tue") || onlineReservation.booking_time.toLowerCase().contains("wed") || onlineReservation.booking_time.toLowerCase().contains("thu") || onlineReservation.booking_time.toLowerCase().contains("fri") || onlineReservation.booking_time.toLowerCase().contains("sat") || onlineReservation.booking_time.toLowerCase().contains("sun"))) {
                                reservation.reservation_date_time = onlineReservation.booking_date + " " + CommonFunctions.formatUnknownDateTime(onlineReservation.booking_time, "EEE hh:mm a", "HH:mm") + ":00";
                            } else {
                                reservation.reservation_date_time = onlineReservation.booking_date + " " + CommonFunctions.formatUnknownDateTime(onlineReservation.booking_time, "hh:mm a", "HH:mm") + ":00";
                            }
                            reservation.diners = Integer.parseInt(onlineReservation.guest_count);
                            reservation.online_reservation = true;
                            reservation.special_instruction = onlineReservation.booking_instruction;
                        }
                        if (getActivity() != null && reservation != null) {
                            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                                    zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                                    zoneRichPrinter.printReservation(myApp.businessLogo, data instanceof OnlineReservation ? "Reservation-" + ((OnlineReservation) data).id : "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("sunmi") || defaultPrinter.printer_model_name.toLowerCase().contains("t2")) {
                                    if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                                        sunmiPrinterV3Mix.printReservation(myApp.businessLogo, data instanceof OnlineReservation ? "Reservation-" + ((OnlineReservation) data).id : "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                    }else {
                                        sunmiPrinter.printReservation(myApp.businessLogo, data instanceof OnlineReservation ? "Reservation-" + ((OnlineReservation) data).id : "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                    }
                                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                                        myApp.iMinPrinterUtils.printReservation(reservation, data instanceof OnlineReservation ? "Reservation-" + ((OnlineReservation) data).id : "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", myApp.tiffintomLogoSmall);
                                    } else {
                                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                                            wifiPrinter.connect(defaultPrinter.ip);
                                            CommonFunctions.functionThatDelay(200);
                                            wifiPrinter.printReservation(myApp.businessLogo, data instanceof OnlineReservation ? "Reservation-" + ((OnlineReservation) data).id : "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                        } else {
                                            try {
                                                if (bluetoothPrinter != null) {
                                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                                    if (device != null) {
                                                        bluetoothPrinter.printReservation(myApp.businessLogo, data instanceof OnlineReservation ? "Reservation-" + ((OnlineReservation) data).id : "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "");
                                                    } else {
                                                        ToastUtils.makeSnackToast(getActivity(), "No bluetooth device found.");
                                                    }
                                                }
                                            } catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    }
                                }
                            } else {
                                ToastUtils.makeLongToast(getActivity(), "No printer model found");
                            }
                        }
                    }
                    if ("cancel".equals(tag)) {
                        if (data instanceof Reservation) {
                            Reservation reservation = (Reservation) data;
                            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "Are you sure you want to cancel this reservation?", 0, "Confirm", "Cancel");
                            confirmationDialogFragment.show(getChildFragmentManager(), "confirmation");
                            confirmationDialogFragment.setDialogDismissListener(o -> {
                                if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                                    cancelEposReservation(position, reservation);
                                }
                            });

                        }
                        if (data instanceof OnlineReservation) {
                            OnlineReservation onlineReservation = (OnlineReservation) data;
                            onlineReservation.status = "Cancel";//Approved
                            RejectReasonDialogFragment rejectReasonDialogFragment = getInstanceejectReason("Customer cancelled,Fully booked,Customer error,Other");
                            rejectReasonDialogFragment.show(getChildFragmentManager(), "reject_reservation");
                            rejectReasonDialogFragment.setDialogDismissListener(o -> {
                                onlineReservation.cancel_reason = (String) o;
                                changeStatusOnlineReservation(onlineReservation);
                            });
                        }
                    }
                    if ("accept".equals(tag)) {

                        if (data instanceof OnlineReservation) {
                            OnlineReservation onlineReservation = (OnlineReservation) data;
                            onlineReservation.status = "Approved";//Approved
                            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "Are you sure you want to approve this reservation?", 0, "Confirm", "Cancel");
                            confirmationDialogFragment.show(getChildFragmentManager(), "confirmation");
                            confirmationDialogFragment.setDialogDismissListener(o -> {
                                if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                                    changeStatusOnlineReservation(onlineReservation);
                                }
                            });

                        }
                    }
                    if ("view".equalsIgnoreCase(tag)) {
                        boolean isOnlineReservation = false;
                        Reservation reservation = new Reservation();
                        OnlineReservation onlineReservation = null;
                        if (data instanceof Reservation) {
                            reservation = (Reservation) data;
                            isOnlineReservation = false;
                        }
                        if (data instanceof OnlineReservation) {
                            isOnlineReservation = true;
                            onlineReservation = (OnlineReservation) data;
                            reservation.id = String.valueOf(onlineReservation.id);
                            reservation.customer = new Customer();
                            reservation.customer.name = onlineReservation.customer_name;
                            reservation.customer.mobile = onlineReservation.booking_phone;
                            reservation.customer_name = onlineReservation.customer_name;
                            reservation.telephone = onlineReservation.booking_phone;
                            reservation.created_at = onlineReservation.created;
                            reservation.reservation_status = onlineReservation.status;
                            if (onlineReservation.booking_time != null && (onlineReservation.booking_time.toLowerCase().contains("mon") || onlineReservation.booking_time.toLowerCase().contains("tue") || onlineReservation.booking_time.toLowerCase().contains("wed") || onlineReservation.booking_time.toLowerCase().contains("thu") || onlineReservation.booking_time.toLowerCase().contains("fri") || onlineReservation.booking_time.toLowerCase().contains("sat") || onlineReservation.booking_time.toLowerCase().contains("sun"))) {
                                reservation.reservation_date_time = onlineReservation.booking_date + " " + CommonFunctions.formatUnknownDateTime(onlineReservation.booking_time, "EEE hh:mm a", "HH:mm") + ":00";
                            } else {
                                reservation.reservation_date_time = onlineReservation.booking_date + " " + CommonFunctions.formatUnknownDateTime(onlineReservation.booking_time, "hh:mm a", "HH:mm") + ":00";
                            }
                            reservation.diners = Integer.parseInt(onlineReservation.guest_count);
                            reservation.special_instruction = onlineReservation.booking_instruction;
                            reservation.online_reservation = true;
                            reservation.cancel_reason = onlineReservation.cancel_reason;
                        }
                        if (isOnlineReservation || reservation.reservation_status_id.equalsIgnoreCase("2")) {

                            ReservationViewBottomSheetFragment reservationViewBottomSheetFragment = getInstanceReservationView(reservation);
                            reservationViewBottomSheetFragment.show(getChildFragmentManager(), "reservation");
                            OnlineReservation finalOnlineReservation = onlineReservation;
                            boolean finalIsOnlineReservation = isOnlineReservation;
                            Reservation finalReservation = reservation;
                            reservationViewBottomSheetFragment.setDialogDismissListener(o -> {
                                if (o instanceof String) {
                                    String action = (String) o;
                                    if (action.equalsIgnoreCase("accept")) {
                                        if (finalIsOnlineReservation && finalOnlineReservation != null) {
                                            finalOnlineReservation.status = "Approved";
                                            changeStatusOnlineReservation(finalOnlineReservation);
                                        }
                                    } else if (action.equalsIgnoreCase("reject")) {
                                        if (!finalIsOnlineReservation) {
                                            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "Are you sure you want to cancel this reservation?", 0, "Confirm", "Cancel");
                                            confirmationDialogFragment.show(getChildFragmentManager(), "confirmation");
                                            confirmationDialogFragment.setDialogDismissListener(o1 -> {
                                                if (o1 instanceof String && ((String) o1).equalsIgnoreCase("confirm")) {
                                                    cancelEposReservation(position, finalReservation);
                                                }
                                            });
                                        } else {
                                            finalOnlineReservation.status = "Cancel";//Approved
                                            RejectReasonDialogFragment rejectReasonDialogFragment = getInstanceejectReason("Customer cancelled,Fully booked,Customer error,Other");
                                            rejectReasonDialogFragment.show(getChildFragmentManager(), "reject_reservation");
                                            rejectReasonDialogFragment.setDialogDismissListener(o1 -> {
                                                finalOnlineReservation.cancel_reason = (String) o1;
                                                changeStatusOnlineReservation(finalOnlineReservation);
                                            });
                                        }
                                    } else if (action.equalsIgnoreCase("print")) {
                                        if (getActivity() != null && finalReservation != null) {
                                            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                                                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                                                    zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                                                    zoneRichPrinter.printReservation(myApp.businessLogo, "Reservation-" + finalReservation.id, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, finalReservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("sunmi") || defaultPrinter.printer_model_name.toLowerCase().contains("t2")) {
                                                    if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                                                        sunmiPrinterV3Mix.printReservation(myApp.businessLogo, "Reservation-" + finalReservation.id, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, finalReservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                                    }else {
                                                        sunmiPrinter.printReservation(myApp.businessLogo, "Reservation-" + finalReservation.id, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, finalReservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                                    }
                                                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                                                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                                                        myApp.iMinPrinterUtils.printReservation(finalReservation, "Reservation-" + finalReservation.id, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", myApp.tiffintomLogoSmall);
                                                    } else {
                                                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                                                            wifiPrinter.connect(defaultPrinter.ip);
                                                            CommonFunctions.functionThatDelay(200);
                                                            wifiPrinter.printReservation(myApp.businessLogo, "Reservation-" + finalReservation.id, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, finalReservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                                        } else {
                                                            try {
                                                                if (bluetoothPrinter != null) {
                                                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                                                    if (device != null) {
                                                                        bluetoothPrinter.printReservation(myApp.businessLogo, "Reservation-" + finalReservation.id, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, finalReservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "");
                                                                    } else {
                                                                        ToastUtils.makeSnackToast(getActivity(), "No bluetooth device found.");
                                                                    }
                                                                }
                                                            } catch (Exception e) {
                                                                e.printStackTrace();
                                                            }
                                                        }
                                                    }
                                                }
                                            } else {
                                                ToastUtils.makeLongToast(getActivity(), "No printer model found");
                                            }
                                        }
                                    }
                                }
                            });
                        } else {
                            FragmentManager manager = getActivity().getSupportFragmentManager();
                            FragmentTransaction transaction = manager.beginTransaction();
                            transaction.replace(R.id.nav_host_fragment, getInstance(reservation));
                            transaction.addToBackStack("can_go_back");
                            transaction.commitAllowingStateLoss();
                        }
                    }
                    if ("sit_on_table".equalsIgnoreCase(tag)) {
                        Reservation reservation = (Reservation) data;
                        if (Validators.isNullOrEmpty(reservation.table_id)) {
                            openAssignTableFragment(reservation);
                        } else {
                            new FetchTableStatus(reservation).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, String.valueOf(reservation.table_id));
                        }
                    }
                } catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            });
            rvReservation.setLayoutManager(new LinearLayoutManager(getActivity(), LinearLayoutManager.VERTICAL, false));
            rvReservation.setAdapter(reservationListAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ReservationViewBottomSheetFragment getInstanceReservationView(Reservation reservation) {
        ReservationViewBottomSheetFragment orderViewBottomSheetFragment = new ReservationViewBottomSheetFragment();
        Bundle bundle = new Bundle();
        bundle.putString("reservation", new Gson().toJson(reservation));
        orderViewBottomSheetFragment.setArguments(bundle);
        return orderViewBottomSheetFragment;
    }

    public NewReservationFragment getInstance(Reservation reservation) {
        Bundle bundle = new Bundle();
        NewReservationFragment fragment = new NewReservationFragment();
        bundle.putString("reservation", new Gson().toJson(reservation));
        fragment.setArguments(bundle);
        return fragment;
    }

    private void chekedBtn(View v) {
        try {
            vPending.setBackgroundResource(R.color.light_gray);
            tvPending.setAlpha(0.5f);

            vToday.setBackgroundResource(R.color.light_gray);
            tvToday.setAlpha(0.5f);

            vThisWeek.setBackgroundResource(R.color.light_gray);
            tvThisWeek.setAlpha(0.5f);

            vThisMonth.setBackgroundResource(R.color.light_gray);
            tvThisMonth.setAlpha(0.5f);

            vCustom.setBackgroundResource(R.color.light_gray);
            tvCustom.setAlpha(0.5f);

            vCustomOri.setBackgroundResource(R.color.light_gray);
            tvCustomOri.setAlpha(0.5f);
            linearFromTo.setVisibility(View.GONE);
            if (v == llPending) {
                vPending.setBackgroundResource(R.color.persian_green);
                tvPending.setAlpha(1f);
                pendingSelected = true;
            }

            if (v == llToday) {
                vToday.setBackgroundResource(R.color.persian_green);
                tvToday.setAlpha(1f);
                pendingSelected = false;
            }
            if (v == llThisWeek) {
                vThisWeek.setBackgroundResource(R.color.persian_green);
                tvThisWeek.setAlpha(1f);
                pendingSelected = false;
            }
            if (v == llThisMonth) {
                vThisMonth.setBackgroundResource(R.color.persian_green);
                tvThisMonth.setAlpha(1f);
                pendingSelected = false;
            }
            if (v == llCustom) {
                vCustom.setBackgroundResource(R.color.persian_green);
                tvCustom.setAlpha(1f);
                pendingSelected = false;
            }
            if (v == llCustomOri) {
                etValidTo.setText("");
                etValidFrom.setText("");
                linearFromTo.setVisibility(View.VISIBLE);
                vCustomOri.setBackgroundResource(R.color.persian_green);
                tvCustomOri.setAlpha(1f);
                pendingSelected = false;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openAssignTableFragment(Reservation reservation) {
        try {
            AssignTableDialogFragment assignTableDialogFragment = getInstanceAssignTableDialog(true);
            assignTableDialogFragment.show(getChildFragmentManager(), "assign_table");
            assignTableDialogFragment.setDialogDismissListener(o -> {
                try {
                    if (o instanceof Table) {
                        Table table = (Table) o;
                        reservation.table_id = table.id;
                        reservation.table_number = table.number;
                        createOrderOffline(reservation);
                        //openNewDineinFragment(reservation, table);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AssignTableDialogFragment getInstanceAssignTableDialog(boolean showOnlyFree) {
        AssignTableDialogFragment fragment = new AssignTableDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean("show_only_free", showOnlyFree);
        fragment.setArguments(bundle);
        return fragment;
    }

    private void openNewDineinFragment(Reservation reservation, Table table) {
        try {
            reservation.table_number = table.number;
            reservation.table_id = table.id;
            createOrderOffline(reservation);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createOrderOffline(Reservation reservation) {
        try {
            Order order = new Order();
            Customer customer = reservation.customer;

            order.customer_id = customer.id;

            order.table_id = reservation.table_id;
            order.table_number = reservation.table_number;
            order.no_guest = String.valueOf(reservation.diners);
            order.customer = customer;
            order.customer_name = customer.name;
            order.updater_id = MyApp.getInstance().myPreferences.getLoggedInUser().id;
            order.order_status_id = "1";
            order.order_status = "Taking Order";
            order.order_type_id = "1";
            order.order_items = new ArrayList<>();
            order.device_id = MyApp.getInstance().myPreferences.getRegisteredDevice().id;
            order.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
            order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
            order.delivery_date = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
            new Thread(() -> {
                // Update Customer
                try {
                    order._customer_id = customer._id;
                    order.customer_name = customer.name;
                    // Save Order
                    order._id = (int) MyApp.getInstance().appDatabase.orderDao().insert(order);
                    Table table = appDatabase.tableDao().view(reservation.table_id);
                    table._last_order_id = order._id;
                    table.last_order_id = null;
                    appDatabase.tableDao().insert(table);
                    deleteReservation(reservation);
                    if (MyApp.getInstance().isConnected(getActivity()) && "auto".equalsIgnoreCase(MyApp.getInstance().myPreferences.getOrderSyncMode())) {
                        createOrderOnline(order);
                    } else {
                        changeTableStatus(order, takingOrderStatus.id, takingOrderStatus.status);
                        //open new Order activity
                        getActivity().runOnUiThread(() -> {
                            startActivityForResult(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(order)), Constants.CODE_REFRESH);
                        });
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteReservation(Reservation reservation) {
        try {
            LogUtils.e("DELETING RESERVATION");
            new Thread(() -> {
                try {
                    appDatabase.reservationDao().delete(reservation);
                    if (!Validators.isNullOrEmpty(reservation.id)) {
                        AndroidNetworking.delete(ApiEndPoints.reservations + reservation.id)
                                .build()
                                .getAsJSONObject(new JSONObjectRequestListener() {
                                    @Override
                                    public void onResponse(JSONObject response) {
                                        getActivity().runOnUiThread(() -> {
                                            fetchReservation();
                                        });
                                    }

                                    @Override
                                    public void onError(ANError anError) {
                                        LogUtils.e("ERROR WHILE DELETING ONLINE RESERVATION");
                                        if (anError.getErrorCode() == 400)
                                            LogUtils.e(anError.getErrorAsObject(ApiError.class).getMessage());
                                    }
                                });
                    } else {
                        getActivity().runOnUiThread(() -> {
                            fetchReservation();
                        });
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteOnlineReservation(String deleteReservactionId) {
        try {
            LogUtils.e("DELETING RESERVATION");
            new Thread(() -> {
                try {
                    Log.e("deleteReservactionId", "deleteReservactionId " + deleteReservactionId);
                    //appDatabase.reservationDao().delete(reservation);
                    AndroidNetworking.post(ApiEndPoints.online_reservations_delete)
                            .addQueryParameter("ids", deleteReservactionId)
                            .build()
                            .getAsJSONObject(new JSONObjectRequestListener() {
                                @Override
                                public void onResponse(JSONObject response) {
                                    getActivity().runOnUiThread(() -> {
                                        fetchReservation();
                                    });
                                }

                                @Override
                                public void onError(ANError anError) {
                                    LogUtils.e("ERROR WHILE DELETING ONLINE RESERVATION " + anError.getMessage());
                                    if (anError.getErrorCode() == 400) {
                                        ToastUtils.makeSnackToast(requireContext(), anError.getErrorAsObject(ApiError.class).getMessage());
                                        LogUtils.e(anError.getErrorAsObject(ApiError.class).getMessage());
                                    } else {
                                        ToastUtils.makeToast(requireContext(), anError.getMessage());
                                    }
                                }
                            });
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createOrderOnline(Order order) {

        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    progressBarDialog.show();
                });
            }
            myApp.shallWeRefreshOrders = false;
            AndroidNetworking.post(ApiEndPoints.orders)
                    .addApplicationJsonBody(order)
                    .build()
                    .getAsObject(Order.class, new ParsedRequestListener<Order>() {
                        @Override
                        public void onResponse(Order response) {
                            try {
                                if (response != null) {
                                    response.customer._id = order._customer_id;
                                    response._id = order._id;
                                    response._customer_id = order._customer_id;
                                    new Thread(() -> {
                                        // Update Table
                                        changeTableStatus(order, takingOrderStatus.id, takingOrderStatus.status);
                                    }).start();
                                    new UpdateOrderWithOnline(response).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        progressBarDialog.show();
                                    });
                                }
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void changeTableStatus(Order order, String table_status_id, String status) {
        try {
            if (!order.order_type_id.equals("1")) {
                return;
            }

            new Thread(() -> {
                try {
                    Table table = appDatabase.tableDao().view(order.table_id);
                    table.last_order_id = order.id;
                    table.table_status_id = table_status_id;
                    table.status = status;
                    appDatabase.tableDao().insert(table);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class UpdateOrderWithOnline extends AsyncTask<String, String, String> {
        Order onlineorder;

        public UpdateOrderWithOnline(Order onlineorder) {
            this.onlineorder = onlineorder;
        }

        @Override
        protected String doInBackground(String... strings) {
            try {
                appDatabase.customerDao().update(onlineorder.customer);
                appDatabase.orderDao().insert(onlineorder);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                myApp.shallWeRefreshOrders = true;

                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        progressBarDialog.dismiss();
                        startActivityForResult(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(onlineorder)), Constants.CODE_REFRESH);
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void changeStatusOnlineReservation(OnlineReservation reservation) {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    swipeRefreshLayout.setRefreshing(true);
                });
            }
            Log.e("reservation", "" + reservation.status);

            ANRequest.PostRequestBuilder anRequest;
            anRequest = AndroidNetworking.post(ApiEndPoints.online_reservations_status_change)
                    .addPathParameter("id", String.valueOf(reservation.id))
                    .addBodyParameter("status", reservation.status);
            if (reservation.status.equalsIgnoreCase("cancel"))
                anRequest.addBodyParameter("cancel_reason", reservation.cancel_reason);
            anRequest.build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        swipeRefreshLayout.setRefreshing(false);
                                    });
                                }
                                if (reservation.status.equalsIgnoreCase("approved")) {
                                    printReservation(reservation);
                                }
                                fetchReservation();
                                ToastUtils.makeToast(getActivity(), response.getString("message"));

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        swipeRefreshLayout.setRefreshing(false);
                                    });
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printReservation(OnlineReservation reservation) {
        try {
            Reservation eposReservation = new Reservation();
            eposReservation.customer = new Customer();
            eposReservation.id = String.valueOf(reservation.id);
            eposReservation.customer.name = reservation.customer_name;
            eposReservation.customer.mobile = reservation.booking_phone;
            eposReservation.customer_name = reservation.customer_name;
            eposReservation.telephone = reservation.booking_phone;
            eposReservation.reservation_status = reservation.status;
            eposReservation.reservation_date_time = reservation.booking_date + " " + CommonFunctions.formatUnknownDateTime(reservation.booking_time, "EEE hh:mm a", "HH:mm") + ":00";
            eposReservation.online_reservation = true;
            eposReservation.diners = Integer.parseInt(reservation.guest_count);
            eposReservation.special_instruction = reservation.booking_instruction;
            if (getActivity() != null) {
                if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                        zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                        zoneRichPrinter.printReservation(myApp.businessLogo, "Reservation-" + reservation.id, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, eposReservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                    } else if (defaultPrinter.printer_model_name.toLowerCase().contains("sunmi") || defaultPrinter.printer_model_name.toLowerCase().contains("t2")) {
                        if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                            sunmiPrinterV3Mix.printReservation(myApp.businessLogo, "Reservation-" + reservation.id, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, eposReservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                        }else {
                            sunmiPrinter.printReservation(myApp.businessLogo, "Reservation-" + reservation.id, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, eposReservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                        }
                    } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                        if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                            myApp.iMinPrinterUtils.printReservation(eposReservation, "Reservation-" + reservation.id, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", myApp.tiffintomLogoSmall);
                        } else {
                            if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                                wifiPrinter.connect(defaultPrinter.ip);
                                CommonFunctions.functionThatDelay(200);
                                wifiPrinter.printReservation(myApp.businessLogo, "Reservation-" + reservation.id, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, eposReservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                            } else {
                                try {
                                    if (bluetoothPrinter != null) {
                                        BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                        if (device != null) {
                                            bluetoothPrinter.printReservation(myApp.businessLogo, "Reservation-" + reservation.id, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, eposReservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "");
                                        } else {
                                            ToastUtils.makeSnackToast(getActivity(), "No bluetooth device found.");
                                        }
                                    }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                } else {
                    ToastUtils.makeLongToast(getActivity(), "No printer model found");
                }
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private void cancelEposReservation(int position, Reservation reservation) {
        try {
            myApp.isReservationOpen = true;

            new Thread(() -> {
                reservation.reservation_status_id = "2";
                reservation.uploadable = false;
                reservation.updater_id = myPreferences.getLoggedInUser().id;
                appDatabase.reservationDao().insert(reservation);
                if (reservation.id != null) {

                    AndroidNetworking.post(ApiEndPoints.reservations + reservation.id)
                            .addApplicationJsonBody(reservation)
                            .build()
                            .getAsJSONObject(new JSONObjectRequestListener() {
                                @Override
                                public void onResponse(JSONObject response) {
                                    try {
                                        getActivity().runOnUiThread(() -> {
                                            progressBarDialog.dismiss();
                                            fetchReservation();
                                        });
                                        myApp.isReservationOpen = false;
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }

                                @Override
                                public void onError(ANError anError) {
                                    try {
                                        LogUtils.e("ERROR WHILE DELETING ONLINE RESERVATION");
                                        reservation.uploadable = true;
                                        appDatabase.reservationDao().insert(reservation);
                                        myApp.isReservationOpen = false;
                                        getActivity().runOnUiThread(() -> {
                                            progressBarDialog.dismiss();
                                            fetchReservation();
                                        });
                                        if (anError.getErrorCode() == 400)
                                            LogUtils.e(anError.getErrorAsObject(ApiError.class).getMessage());
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                } else {
                    getActivity().runOnUiThread(() -> {
                        progressBarDialog.dismiss();
                        fetchReservation();
                    });
                }
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        ToastUtils.makeSnackToast(getActivity(), "Reservation cancelled");
                        objects.remove(position);
                        reservationListAdapter.notifyDataSetChanged();
                    });
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {

        try {
            swipeRefreshLayout.setOnRefreshListener(this::fetchReservation);

            chipBack.setOnClickListener(v -> getActivity().onBackPressed());

            btnPrintList.setOnClickListener(v -> {
                getActivity().runOnUiThread(() -> {
                    try {
                        if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                            if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                                zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                                zoneRichPrinter.printReservationList(myApp.businessLogo, "Reservation List", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, objects, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", fromDateString, toDateString, myPreferences);
                            } else if (defaultPrinter.printer_model_name.toLowerCase().contains("sunmi") || defaultPrinter.printer_model_name.toLowerCase().contains("t2")) {
                                if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                                    sunmiPrinterV3Mix.printReservationList(myApp.businessLogo, "Reservation List", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, objects, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", fromDateString, toDateString, myPreferences);
                                }else {
                                    sunmiPrinter.printReservationList(myApp.businessLogo, "Reservation List", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, objects, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", fromDateString, toDateString, myPreferences);
                                }
                            } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                                if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                                    wifiPrinter.connect(defaultPrinter.ip);
                                    CommonFunctions.functionThatDelay(200);
                                    wifiPrinter.printReservationList(myApp.businessLogo, "Reservation List", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, objects, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", fromDateString, toDateString, myPreferences);
                                } else {
                                    try {
                                        if (bluetoothPrinter != null) {
                                            BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                            if (device != null) {
                                                bluetoothPrinter.printReservationList(myApp.businessLogo, "Reservation List", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, objects, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", fromDateString, toDateString);
                                            } else {
                                                ToastUtils.makeSnackToast(getActivity(), "No bluetooth device found.");
                                            }
                                        }
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        } else {
                            ToastUtils.makeLongToast(getActivity(), "No printer model found");
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            });

            btnNew.setOnClickListener(v -> {
                try {
                    FragmentManager manager = getActivity().getSupportFragmentManager();
                    FragmentTransaction transaction = manager.beginTransaction();
                    transaction.replace(R.id.nav_host_fragment, new NewReservationFragment());
                    transaction.addToBackStack("can_go_back");
                    transaction.commitAllowingStateLoss();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            llPending.setOnClickListener(v -> {
                selectedButton = llPending.getId();
                chekedBtn(llPending);
                tvDate.setVisibility(View.VISIBLE);
                fromDateString = null;
                toDateString = null;
                fetchReservation();
            });

            llToday.setOnClickListener(v -> {
                selectedButton = llToday.getId();
                chekedBtn(llToday);
                tvDate.setVisibility(View.VISIBLE);
                getToday();
            });
            llThisWeek.setOnClickListener(v -> {
                selectedButton = llThisWeek.getId();
                chekedBtn(llThisWeek);
                tvDate.setVisibility(View.VISIBLE);
                getWeek();
            });
            llThisMonth.setOnClickListener(v -> {
                selectedButton = llThisMonth.getId();
                chekedBtn(llThisMonth);
                tvDate.setVisibility(View.VISIBLE);
                getCurrentMonth();
            });
            llCustom.setOnClickListener(v -> {
                selectedButton = llCustom.getId();
                chekedBtn(llCustom);
            });
            llCustomOri.setOnClickListener(v -> {
                fromDateString = null;
                toDateString = null;
                selectedButton = llCustomOri.getId();
                tvDate.setVisibility(View.INVISIBLE);
                chekedBtn(llCustomOri);
            });
            llCustom.setOnClickListener(v -> {
                selectedButton = llCustom.getId();
                chekedBtn(llCustom);
                fromDateString = null;
                toDateString = null;
                tvDate.setVisibility(View.INVISIBLE);
                fetchReservation();
            });
            btnDeleteAll.setOnClickListener(v -> {
                JSONArray jsonArray = new JSONArray();
                for (int i = 0; i < reservationListAdapter.objects.size(); i++) {
                    Object reservaction = reservationListAdapter.objects.get(i);
                    if (reservaction instanceof OnlineReservation) {
                        if (((OnlineReservation) reservaction).isDeleteSelected) {
                            if (((OnlineReservation) reservaction).past_days >= 7) {
                                jsonArray.put(((OnlineReservation) reservaction).id);
                            }
                        }
                    }
                }
                if (jsonArray.length() == 0) {
                    ToastUtils.makeToast(requireContext(), "Please select reservation to delete");
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Confirmation", "Are you sure you want to delete this reservation?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.show(getChildFragmentManager(), "confirmation");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                            deleteOnlineReservation(jsonArray.toString());
                        }
                    });
                }
            });
            btnCustom.setOnClickListener(v -> {
                tvDate.setVisibility(View.VISIBLE);
                fetchReservation();
            });

            tvDate.setOnClickListener(v -> {
                try {
                    DatePickerDialog datePickerDialog = DatePickerDialog.newInstance(datePicker, myCalendar
                                    .get(Calendar.YEAR), myCalendar.get(Calendar.MONTH),
                            myCalendar.get(Calendar.DAY_OF_MONTH));
                    datePickerDialog.setThemeDark(false);
                    datePickerDialog.showYearPickerFirst(false);
                    datePickerDialog.show(getActivity().getFragmentManager(), "DatePickerDialog");
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    DatePickerDialog.OnDateSetListener datePickerFromDate = new DatePickerDialog.OnDateSetListener() {
        @Override
        public void onDateSet(DatePickerDialog view, int year, int month, int dayOfMonth) {
            try {
                myCalendar.set(Calendar.YEAR, year);
                myCalendar.set(Calendar.MONTH, month);
                myCalendar.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                fromDate = myCalendar.getTime();
                fromDateString = CommonFunctions.formatMiliToDesireFormat(fromDate.getTime(), "yyyy-MM-dd");
                etValidFrom.setText(fromDateString);
                setDateText();
                btnCustom.setVisibility(View.VISIBLE);
                //fetchReservation();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    DatePickerDialog.OnDateSetListener datePickerToDate = (view, year, month, dayOfMonth) -> {
        try {
            if (Validators.isNullOrEmpty(fromDateString)) {
                etValidFrom.performClick();
            } else {
                myCalendar.set(Calendar.YEAR, year);
                myCalendar.set(Calendar.MONTH, month);
                myCalendar.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                toDate = myCalendar.getTime();
                toDateString = CommonFunctions.formatMiliToDesireFormat(toDate.getTime(), "yyyy-MM-dd");
                etValidTo.setText(toDateString);
                setDateText();
                btnCustom.setVisibility(View.VISIBLE);
                fetchReservation();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    };

    DatePickerDialog.OnDateSetListener datePicker = new DatePickerDialog.OnDateSetListener() {
        @Override
        public void onDateSet(DatePickerDialog view, int year, int month, int dayOfMonth) {
            try {
                myCalendar.set(Calendar.YEAR, year);
                myCalendar.set(Calendar.MONTH, month);
                myCalendar.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                fromDate = myCalendar.getTime();
                fromDateString = CommonFunctions.formatMiliToDesireFormat(fromDate.getTime(), "yyyy-MM-dd");
                toDateString = fromDateString;
                setDateText();
                btnCustom.setVisibility(View.VISIBLE);
                fetchReservation();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };


    private void loadSettings() {
        try {
            SiteSetting ticketHeaderTypeSetting = myApp.findSetting("ticket_header_type");
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("right")) {
                headerAlignment = 2;
            }
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("center")) {
                headerAlignment = 1;
            }
            ticketHeaderSetting = myApp.findSetting("ticket_header");

            footerASetting = myApp.findSetting("footer_a");
            footerBSetting = myApp.findSetting("footer_b");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getCurrentMonth() {
        try {
            // Day After tomorrow
            Calendar cal = Calendar.getInstance();
            cal.add(Calendar.DATE, 2);
            startDate = cal.getTime();
            endDate = cal.getTime();

            fromDateString = CommonFunctions.formatMiliToDesireFormat(startDate.getTime(), "yyyy-MM-dd");
            toDateString = CommonFunctions.formatMiliToDesireFormat(endDate.getTime(), "yyyy-MM-dd");

            setDateText();
            fetchReservation();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getWeek() {
        try {
            // Tomorrow

            Calendar cal = Calendar.getInstance();
            cal.add(Calendar.DATE, 1);
            startDate = cal.getTime();
            endDate = cal.getTime();

            fromDateString = CommonFunctions.formatMiliToDesireFormat(startDate.getTime(), "yyyy-MM-dd");
            toDateString = CommonFunctions.formatMiliToDesireFormat(endDate.getTime(), "yyyy-MM-dd");

            setDateText();
            fetchReservation();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getToday() {
        try {
            Calendar cal = Calendar.getInstance();
            startDate = cal.getTime();
            endDate = cal.getTime();

            fromDateString = CommonFunctions.formatMiliToDesireFormat(startDate.getTime(), "yyyy-MM-dd");
            toDateString = CommonFunctions.formatMiliToDesireFormat(endDate.getTime(), "yyyy-MM-dd");

            setDateText();
            fetchReservation();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setDateText() {
        try {
            if (fromDateString.equalsIgnoreCase(toDateString)) {
                tvDate.setText(CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd MMM yyyy"));
            } else {
                tvDate.setText(CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd MMM yyyy") + " - " + CommonFunctions.formatUnknownDateTime(toDateString, "yyyy-MM-dd", "dd MMM yyyy"));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchReservation() {
        try {
            setButtonsEnable(!swipeRefreshLayout.isRefreshing());
            if (!myApp.isConnected(getActivity())) {
                new ReservationsSaveAndGet().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                return;
            }
            swipeRefreshLayout.setRefreshing(true);
            ANRequest.GetRequestBuilder getRequestBuilder = AndroidNetworking.get(ApiEndPoints.reservations)
                    .addQueryParameter("nopaginate", "1")
                    .addQueryParameter("reservation_status_id", "1");
            if (!Validators.isNullOrEmpty(fromDateString)) {
                getRequestBuilder.addQueryParameter("from_date", fromDateString);
            }
            if (!Validators.isNullOrEmpty(toDateString)) {
                getRequestBuilder.addQueryParameter("to_date", toDateString);
            }
            getRequestBuilder.build()
                    .getAsObjectList(Reservation.class, new ParsedRequestListener<List<Reservation>>() {
                        @Override
                        public void onResponse(List<Reservation> response) {
                            try {
                                new ReservationsSaveAndGet().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, response);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                swipeRefreshLayout.setRefreshing(false);
                                new ReservationsSaveAndGet().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    private class FetchTableStatus extends AsyncTask<String, String, String> {
        Reservation reservation;
        Table table;

        public FetchTableStatus(Reservation reservation) {
            this.reservation = reservation;
        }

        @Override
        protected String doInBackground(String... strings) {
            try {
                String table_id = strings[0];
                table = appDatabase.tableDao().view(table_id);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                if (table != null && table.table_status_id.equalsIgnoreCase(vacantStatus.id)) {
                    openNewDineinFragment(reservation, table);
                } else {
                    openAssignTableFragment(reservation);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

    }

    private class ReservationsSaveAndGet extends AsyncTask<List<Reservation>, String, String> {
        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            try {
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        swipeRefreshLayout.setRefreshing(true);
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        protected String doInBackground(List<Reservation>... lists) {
            try {
                if (lists.length > 0) {
                    ArrayList<Reservation> cloudReservations = (ArrayList<Reservation>) lists[0];
                    for (Reservation reservation : cloudReservations) {
                        Customer dbCustomer = appDatabase.customerDao().view(reservation.customer_id);
                        int _customer_id;
                        if (dbCustomer != null) {
                            _customer_id = dbCustomer._id;
                            dbCustomer = reservation.customer;
                            dbCustomer._id = _customer_id;
                            appDatabase.customerDao().update(dbCustomer);
                        } else {
                            _customer_id = (int) appDatabase.customerDao().insert(reservation.customer);
                        }
                        reservation._customer_id = _customer_id;
                        Reservation dbReservation = appDatabase.reservationDao().view(reservation.id);
                        int _reservation_id;
                        if (dbReservation != null) {
                            _reservation_id = dbReservation._id;
                            dbReservation = reservation;
                            dbReservation._id = _reservation_id;
                            dbReservation._customer_id = _customer_id;
                            appDatabase.reservationDao().update(dbReservation);
                        } else {
                            reservation.uploadable = false;
                            _reservation_id = (int) appDatabase.reservationDao().insert(reservation);
                            reservation._id = _reservation_id;
                            appDatabase.reservationDao().insert(reservation);
                        }
                    }
                }
                ArrayList<ReservationWithCustomer> reservationWithCustomers = new ArrayList<>();
                if (Validators.isNullOrEmpty(fromDateString)) {
                    reservationWithCustomers.addAll(appDatabase.reservationDao().listWithCustomer());
                } else {
                    reservationWithCustomers.addAll(appDatabase.reservationDao().historyListWithCustomer(fromDateString, toDateString));
                }
                reservationList.clear();
                for (ReservationWithCustomer reservationWithCustomer : reservationWithCustomers) {
                    Reservation reservation = reservationWithCustomer.reservation;
                    reservation.customer = reservationWithCustomer.customer;
                    reservationList.add(reservation);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        setButtonsEnable(true);
                        swipeRefreshLayout.setRefreshing(false);
                        if (myApp.isConnected(getActivity()))
                            fetchOnlineReservations();
                        else {
                            sortReservations();
                        }
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setButtonsEnable(boolean b) {
        btnCustom.setEnabled(b);
    }

    private void fetchOnlineReservations() {
        try {
            swipeRefreshLayout.setRefreshing(true);
            //'ThisWeek','ThisMonth','ThisYear','Today', 'Yesterday'
            Log.e("restaurant_id", "" + myApp.restaurant_id);
            if (!myApp.restaurant_id.isEmpty()) {
                ANRequest.GetRequestBuilder requestBuilder = AndroidNetworking.get(ApiEndPoints.online_reservations)
                        .addQueryParameter("action", "ReservationListFillter")
                        .addQueryParameter("restaurant_id", myApp.restaurant_id)
                        .addQueryParameter("nopaginate", "1");
                if (!Validators.isNullOrEmpty(fromDateString)) {
                    requestBuilder.addQueryParameter("from_date", fromDateString);
                }
                if (!Validators.isNullOrEmpty(toDateString)) {
                    requestBuilder.addQueryParameter("to_date", toDateString);
                }
                requestBuilder.build()
                        .getAsJSONArray(new JSONArrayRequestListener() {
                            @Override
                            public void onResponse(JSONArray response) {
                                swipeRefreshLayout.setRefreshing(false);

                                Type reservationTypeToken = new TypeToken<List<OnlineReservation>>() {
                                }.getType();

                                ArrayList<OnlineReservation> reservations = new ArrayList<>();
                                reservations.addAll(new Gson().fromJson(response.toString(), reservationTypeToken));
                                onlineReservations.clear();
                                if (pendingSelected) {
                                    for (OnlineReservation res : reservations) {
                                        if (res.status.equalsIgnoreCase("pending")) {
                                            onlineReservations.add(res);
                                        }
                                    }
                                } else
                                    onlineReservations.addAll(reservations);
                                sortReservations();
                            }

                            @Override
                            public void onError(ANError anError) {
                                anError.printStackTrace();
                                onlineReservations.clear();
                                swipeRefreshLayout.setRefreshing(false);
                                sortReservations();
                            }
                        });
            } else {
                onlineReservations.clear();
                swipeRefreshLayout.setRefreshing(false);
                sortReservations();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void sortReservations() {
        try {
            objects.clear();
            if (!pendingSelected) {
                objects.addAll(reservationList);
            }
            objects.addAll(onlineReservations);
            Collections.sort(objects, new Comparator<Object>() {
                public int compare(Object o1, Object o2) {
                    Long d1 = 0L;
                    Long d2 = 0L;
                    if (o1 instanceof Reservation) {
                        d1 = CommonFunctions.convertStringDateToDate(((Reservation) o1).reservation_date_time, "yyyy-MM-dd HH:mm:ss").getTime();
                    }
                    if (o2 instanceof OnlineReservation) {
                        OnlineReservation onlineReservation = (OnlineReservation) o2;
                        if (onlineReservation.booking_time != null &&
                                (onlineReservation.booking_time.toLowerCase().contains("mon") || onlineReservation.booking_time.toLowerCase().contains("tue") ||
                                        onlineReservation.booking_time.toLowerCase().contains("wed") || onlineReservation.booking_time.toLowerCase().contains("thu") ||
                                        onlineReservation.booking_time.toLowerCase().contains("fri") || onlineReservation.booking_time.toLowerCase().contains("sat") || onlineReservation.booking_time.toLowerCase().contains("sun"))) {
                            d2 = CommonFunctions.convertStringDateToDate(onlineReservation.booking_date + " " + onlineReservation.booking_time, "yyyy-MM-dd EEE hh:mm a").getTime();
                        } else {
                            d2 = CommonFunctions.convertStringDateToDate(onlineReservation.booking_date + " " + onlineReservation.booking_time, "yyyy-MM-dd hh:mm a").getTime();
                        }

                    }
                    if (o1 instanceof OnlineReservation) {
                        OnlineReservation onlineReservation = (OnlineReservation) o1;
                        if (onlineReservation.booking_time != null &&
                                (onlineReservation.booking_time.toLowerCase().contains("mon") || onlineReservation.booking_time.toLowerCase().contains("tue") ||
                                        onlineReservation.booking_time.toLowerCase().contains("wed") || onlineReservation.booking_time.toLowerCase().contains("thu") ||
                                        onlineReservation.booking_time.toLowerCase().contains("fri") || onlineReservation.booking_time.toLowerCase().contains("sat") || onlineReservation.booking_time.toLowerCase().contains("sun"))) {
                            d1 = CommonFunctions.convertStringDateToDate(onlineReservation.booking_date + " " + onlineReservation.booking_time, "yyyy-MM-dd EEE hh:mm a").getTime();
                        } else {
                            d1 = CommonFunctions.convertStringDateToDate(onlineReservation.booking_date + " " + onlineReservation.booking_time, "yyyy-MM-dd hh:mm a").getTime();
                        }
                    }
                    if (o2 instanceof Reservation) {
                        d2 = CommonFunctions.convertStringDateToDate(((Reservation) o2).reservation_date_time, "yyyy-MM-dd HH:mm:ss").getTime();
                    }
                    return d2.compareTo(d1);
                }
            });
            Collections.reverse(objects);
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    reservationListAdapter.notifyDataSetChanged();
                    if (objects.size() == 0) {
                        cvDeleteAll.setVisibility(View.GONE);
                        tvErrorMessage.setVisibility(View.VISIBLE);
                    } else {
                        cvDeleteAll.setChecked(false);
                        boolean isPast7DaysAvailable = false;
                        for (int i = 0; i < objects.size(); i++) {
                            Object reservaction = objects.get(i);
                            if (reservaction instanceof OnlineReservation) {
                                if (((OnlineReservation) reservaction).past_days >= 7) {
                                    isPast7DaysAvailable = true;
                                }
                            }
                        }
                        if (isPast7DaysAvailable) {
                            cvDeleteAll.setVisibility(View.VISIBLE);
                        }
                        tvErrorMessage.setVisibility(View.GONE);
                    }
                    tvTotalCustomer.setText("Total bookings: " + objects.size());
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        try {
            if (selectedButton == llPending.getId()) {
                llPending.performClick();
            } else if (selectedButton == llToday.getId()) {
                llToday.performClick();
            } else if (selectedButton == llThisWeek.getId()) {
                llThisWeek.performClick();
            } else if (selectedButton == llThisMonth.getId()) {
                llThisMonth.performClick();
            } else if (selectedButton == llCustom.getId()) {
                llCustom.performClick();
            } else if (selectedButton == llCustomOri.getId()) {
                llCustomOri.performClick();
            } else {
                llPending.performClick();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RejectReasonDialogFragment getInstanceejectReason(String reasons) {
        RejectReasonDialogFragment rejectReasonDialogFragment = new RejectReasonDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("reasons", reasons);
        rejectReasonDialogFragment.setArguments(bundle);
        return rejectReasonDialogFragment;
    }
}