package com.ubsidi.epos_2021.fragment;

import android.app.TimePickerDialog;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.TimePicker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.online.adapters.TimeslotsSelectionAdapter;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class ReservationTimeSelectionFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private DialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    private ArrayList<String> timeSlotsString = new ArrayList<>();
    private TimeslotsSelectionAdapter adapter;
    private String selectedTimeSlot = "";
    private Button btnConfirm, btnCancel;
    private TextView tvSelectedTime;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_reservation_timeslot, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (getArguments() != null) {
                selectedTimeSlot = getArguments().getString("selected_time");
            }
            initViews(view);
            setListeners();
            fetchSlots();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchSlots() {
        try {
            SiteSetting reservationOpening = MyApp.getInstance().findSetting("reservation_start_time");
            SiteSetting reservationClosing = MyApp.getInstance().findSetting("reservation_end_time");
            SiteSetting reservationSlotGap = MyApp.getInstance().findSetting("reservation_slot_gap");
            if (reservationOpening != null && reservationClosing != null && !Validators.isNullOrEmpty(reservationClosing.value) && !Validators.isNullOrEmpty(reservationOpening.value)) {
                Date startTime = CommonFunctions.convertStringDateToDate(reservationOpening.value, "HH:mm");
                Date endTime = CommonFunctions.convertStringDateToDate(reservationClosing.value, "HH:mm");
                timeSlotsString.clear();
                while (startTime.getTime() <= endTime.getTime()) {
                    timeSlotsString.add(CommonFunctions.formatMiliToDesireFormat(startTime.getTime(), "HH:mm"));
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(startTime);
                    if(reservationSlotGap!=null){
                        calendar.add(Calendar.MINUTE, Integer.parseInt(reservationSlotGap.value));
                    }else {
                        calendar.add(Calendar.MINUTE, 15);
                    }
                    startTime = calendar.getTime();
                }
                timeSlotsString.add("Custom");
                if (!Validators.isNullOrEmpty(selectedTimeSlot)) {
                    adapter.selectedTimeslot = selectedTimeSlot;
                }
                adapter.notifyDataSetChanged();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            RecyclerView rvSlots = view.findViewById(R.id.rvTimeSlots);
            tvSelectedTime = view.findViewById(R.id.tvSelectedTime);
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnCancel = view.findViewById(R.id.btnCancel);
            adapter = new TimeslotsSelectionAdapter(timeSlotsString, (position, data) -> {
                try {
                    adapter.notifyDataSetChanged();
                    if (position < timeSlotsString.size() - 1) {
                        selectedTimeSlot = (String) data;
                        if (Validators.isNullOrEmpty(selectedTimeSlot)) {
                            tvSelectedTime.setVisibility(View.GONE);
                        } else {
                            tvSelectedTime.setVisibility(View.VISIBLE);
                            tvSelectedTime.setText(selectedTimeSlot + " selected");
                        }
                    }
                    if (position == timeSlotsString.size() - 1) {
                        Calendar calendar = Calendar.getInstance();

                        TimePickerDialog timePickerDialog = new TimePickerDialog(getActivity(), timeSetListener, calendar.get(Calendar.HOUR_OF_DAY), calendar.get(Calendar.MINUTE), true);
                        timePickerDialog.show();
                        timePickerDialog.setOnCancelListener(dialogInterface -> {
                            adapter.selectedTimeslot = selectedTimeSlot;
                            timeSlotsString.set(timeSlotsString.size() - 1, "Custom");
                            adapter.notifyDataSetChanged();

                            if (Validators.isNullOrEmpty(selectedTimeSlot)) {
                                tvSelectedTime.setVisibility(View.GONE);
                            } else {
                                tvSelectedTime.setVisibility(View.VISIBLE);
                                tvSelectedTime.setText(selectedTimeSlot + " selected");
                            }
                        });


                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            rvSlots.setAdapter(adapter);
            rvSlots.setLayoutManager(new GridLayoutManager(getActivity(), 8));
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void setListeners() {
        try {
            btnCancel.setOnClickListener(v -> {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss(null);
                }
                dismiss();
            });
            btnConfirm.setOnClickListener(v -> {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss(selectedTimeSlot);
                }
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void selectOldTimeSlot() {
        try {
            adapter.selectedTimeslot = selectedTimeSlot;
            timeSlotsString.set(timeSlotsString.size() - 1, "Custom");
            adapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    TimePickerDialog.OnTimeSetListener timeSetListener = new TimePickerDialog.OnTimeSetListener() {
        @Override
        public void onTimeSet(TimePicker timePicker, int hour, int minutes) {
            try {
                Calendar calendar = Calendar.getInstance();
                int currentHour = calendar.get(Calendar.HOUR_OF_DAY);
                int currentMinute = calendar.get(Calendar.MINUTE);
                boolean valid = false;
                String pickedTime = hour + ":" + minutes;
                String current = currentHour + ":" + currentMinute;
                if (hour == currentHour) {
                    valid = minutes >= currentMinute;
                } else valid = hour > currentHour;
                if (valid) {

                    String min = "";
                    if (minutes < 10)
                        min = "0" + minutes;
                    else
                        min = String.valueOf(minutes);
                    selectedTimeSlot = String.valueOf(hour) + ':' + min;
                    adapter.selectedTimeslot = selectedTimeSlot;
                    timeSlotsString.set(timeSlotsString.size() - 1, selectedTimeSlot);
                    adapter.notifyDataSetChanged();
                } else {
                    selectedTimeSlot = "";
                    ToastUtils.makeToast(getActivity(), "Invalid timeslot");
                    selectOldTimeSlot();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

}
