package com.ubsidi.epos_2021.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.google.android.material.button.MaterialButton;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.ubsidi.R;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.Reservation;
import com.ubsidi.epos_2021.online.base.BaseBottomSheet;
import com.ubsidi.epos_2021.utils.Constants;

import java.util.Calendar;

/**
 * Created by Amrish on 11-11-2020.
 */
public class ReservationViewBottomSheetFragment extends BaseBottomSheet {

    private Reservation reservation;
    private DialogDismissListener dialogDismissListener;
    private TextView tvPersonalDetails, tvNoOfGuests;
    private LinearLayout llInstructions, llCancelReason;
    private TextView tvInstructions, tvInstructionTitle, tvCancelReasonTitle, tvCancelReason;
    private MaterialButton btnAccept, btnReject;
    Calendar todayCalendar = Calendar.getInstance();
    private ImageView ivPrint;
    private TextView tvReservationNumber;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_reservationview_bottomsheet, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            todayCalendar.add(Calendar.DAY_OF_MONTH, -1);
            updateViews();
            setListners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListners() {
        super.setListeners();
        try {
            btnAccept.setOnClickListener(v -> {
                if (dialogDismissListener != null) dialogDismissListener.onDialogDismiss("accept");
                dismiss();
            });
            btnReject.setOnClickListener(v -> {
                if (dialogDismissListener != null) dialogDismissListener.onDialogDismiss("reject");
                dismiss();
            });
            ivPrint.setOnClickListener(view -> {
                if (dialogDismissListener != null) dialogDismissListener.onDialogDismiss("print");
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (intentExtrasData.containsKey("reservation")) {
                reservation = new Gson().fromJson(String.valueOf(intentExtrasData.get("reservation")), Reservation.class);
            }
        } catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);

        try {
            ivClose = view.findViewById(R.id.ivClose);
            ivPrint = view.findViewById(R.id.ivPrint);

            tvReservationNumber = view.findViewById(R.id.tvBookingNumber);
            tvPersonalDetails = view.findViewById(R.id.tvPersonalDetails);
            tvInstructions = view.findViewById(R.id.tvInstructions);
            tvInstructionTitle = view.findViewById(R.id.tvInstructionsTitle);
            llInstructions = view.findViewById(R.id.cvInstruction);
            btnAccept = view.findViewById(R.id.btnAccept);
            btnReject = view.findViewById(R.id.btnReject);
            tvNoOfGuests = view.findViewById(R.id.tvNoOfGuests);
            llCancelReason = view.findViewById(R.id.llCancelReason);
            tvCancelReasonTitle = view.findViewById(R.id.tvCancelReasionTitle);
            tvCancelReason = view.findViewById(R.id.tvCancelReason);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateViews() {

        try {
            if (reservation != null) {
                StringBuilder personalDetailsBuilder = new StringBuilder();
                personalDetailsBuilder.append("Name: ");
                personalDetailsBuilder.append(reservation.customer_name);
                personalDetailsBuilder.append("\n");
                personalDetailsBuilder.append("Contact number: ");
                personalDetailsBuilder.append(reservation.telephone);
                personalDetailsBuilder.append("\n");
                personalDetailsBuilder.append("Reservation on: ");
                if (reservation.reservation_date_time.toLowerCase().contains("z")) {
                    personalDetailsBuilder.append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd MMM yyyy ' at ' hh:mm a"));
                } else {
                    personalDetailsBuilder.append(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT, "dd MMM yyyy ' at ' hh:mm a"));
                }
                tvPersonalDetails.setText(personalDetailsBuilder);
                tvReservationNumber.setText(reservation.id);
                tvReservationNumber.setVisibility(View.GONE);
                tvInstructions.setText(reservation.special_instruction);
                tvNoOfGuests.setText(reservation.diners + " guests");

                if (!Validators.isNullOrEmpty(reservation.special_instruction)) {
                    tvInstructionTitle.setVisibility(View.VISIBLE);
                    llInstructions.setVisibility(View.VISIBLE);
                } else {
                    tvInstructionTitle.setVisibility(View.GONE);
                    llInstructions.setVisibility(View.GONE);
                }

                if (!Validators.isNullOrEmpty(reservation.cancel_reason)) {
                    tvCancelReasonTitle.setVisibility(View.VISIBLE);
                    llCancelReason.setVisibility(View.VISIBLE);
                } else {
                    tvCancelReasonTitle.setVisibility(View.GONE);
                    llCancelReason.setVisibility(View.GONE);
                }

                String orderStatus = "View";

                if (reservation.reservation_status.equalsIgnoreCase("pending")) {
                    orderStatus = "Accept";
                } else if (reservation.reservation_status.equalsIgnoreCase("cancelled") || reservation.reservation_status.equalsIgnoreCase("cancel") || (reservation.reservation_status_id != null && reservation.reservation_status_id.equalsIgnoreCase("2"))) {
                    orderStatus = "Cancelled";
                } else if (reservation.reservation_status.equalsIgnoreCase("approved")) {
                    orderStatus = "Completed";
                } else if (reservation.reservation_status.equalsIgnoreCase("confirm")) {
                    orderStatus = "Cancel";
                }
                if (orderStatus.equalsIgnoreCase("accept")) {
                    btnReject.setText("Cancel");
                } else if (orderStatus.equalsIgnoreCase("cancelled")) {
                    btnAccept.setVisibility(View.GONE);
                    btnReject.setVisibility(View.GONE);
                    if (!Validators.isNullOrEmpty(reservation.cancel_reason)) {
                        tvCancelReasonTitle.setVisibility(View.VISIBLE);
                        llCancelReason.setVisibility(View.VISIBLE);
                        tvCancelReason.setText(reservation.cancel_reason);
                    }
                } else if (orderStatus.equalsIgnoreCase("completed")) {
                    btnAccept.setVisibility(View.GONE);
                    btnReject.setVisibility(View.GONE);

                } else if (orderStatus.equalsIgnoreCase("cancel")) {
                    btnReject.setText("Cancel");
                    btnAccept.setVisibility(View.GONE);
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
