package com.ubsidi.epos_2021.fragment

import android.content.ContentUris
import android.net.Uri
import android.os.Build
import android.os.Bundle
import android.provider.MediaStore
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.google.android.material.button.MaterialButton
import com.ubsidi.R
import com.ubsidi.epos_2021.adapters.AudioFileListAdapter
import com.ubsidi.epos_2021.base.BaseFragment
import com.ubsidi.epos_2021.comman.Validators
import com.ubsidi.epos_2021.utils.ToastUtils
import java.util.concurrent.TimeUnit

class ReservationsSetting : BaseFragment() {
    private lateinit var audioFileListAdapter: AudioFileListAdapter
    private var selectedAudioFilesModel: AudioFilesModel? = null
    private val rvAudioList by lazy {
        requireActivity().findViewById<RecyclerView>(R.id.rvAudioList)
    }
    private val btnConfirm by lazy {
        requireActivity().findViewById<MaterialButton>(R.id.btnConfirm)
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_reservaction_setting, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        initAdapter()
        getAudioList()
    }

    private fun initAdapter() {
        btnConfirm.isEnabled = false
        audioFileListAdapter = AudioFileListAdapter(
            arrayListOf(),
            if (Validators.isNullOrEmpty(myPreferences.selectedReservationFileName)) "" else myPreferences.selectedReservationFileName
        ) { position, data ->
            btnConfirm.isEnabled = true
            selectedAudioFilesModel = (data as AudioFilesModel)
            myPreferences.saveSelectedReservationFileName((data as AudioFilesModel).name)
            myPreferences.saveSelectedReservationFileUri((data as AudioFilesModel).uri.toString())
        }
        rvAudioList.adapter = audioFileListAdapter

        btnConfirm.setOnClickListener {
            if (selectedAudioFilesModel != null) {
                ToastUtils.makeToast(requireContext(), "Ringtone set successfully")
                myApp.resetReservationsSound()
            }
        }
    }

    private fun getAudioList() {
        val audioFilesModelList = arrayListOf<AudioFilesModel>()

        val collection =
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
                MediaStore.Audio.Media.getContentUri(
                    MediaStore.VOLUME_EXTERNAL
                )
            } else {
                MediaStore.Audio.Media.EXTERNAL_CONTENT_URI
            }

        val projection = arrayOf(
            MediaStore.Audio.Media._ID,
            MediaStore.Audio.Media.DISPLAY_NAME,
            MediaStore.Audio.Media.DURATION,
            MediaStore.Audio.Media.SIZE
        )

        // Show only videos that are at least 5 minutes in duration.
        val selection = "${MediaStore.Audio.Media.DURATION} >= ?"
        val selectionArgs = arrayOf(
            TimeUnit.MILLISECONDS.convert(1, TimeUnit.SECONDS).toString()
        )

        // Display videos in alphabetical order based on their display name.
        val sortOrder = "${MediaStore.Audio.Media.DISPLAY_NAME} ASC"
        val query = requireActivity().applicationContext.contentResolver.query(
            collection,
            projection,
            selection,
            selectionArgs,
            sortOrder
        )
        query?.use { cursor ->
            // Cache column indices.
            val idColumn = cursor.getColumnIndexOrThrow(MediaStore.Audio.Media._ID)
            val nameColumn =
                cursor.getColumnIndexOrThrow(MediaStore.Audio.Media.DISPLAY_NAME)
            val durationColumn =
                cursor.getColumnIndexOrThrow(MediaStore.Audio.Media.DURATION)
            val sizeColumn = cursor.getColumnIndexOrThrow(MediaStore.Audio.Media.SIZE)

            while (cursor.moveToNext()) {
                // Get values of columns for a given video.
                val id = cursor.getLong(idColumn)
                val name = cursor.getString(nameColumn)
                val duration = cursor.getInt(durationColumn)
                val size = cursor.getInt(sizeColumn)

                val contentUri: Uri = ContentUris.withAppendedId(
                    MediaStore.Audio.Media.EXTERNAL_CONTENT_URI,
                    id
                )

                // Stores column values and the contentUri in a local object
                // that represents the media file.
                audioFilesModelList += AudioFilesModel(contentUri, name, duration, size)
            }
        }
        Log.e("videoListvideoList", "videoList $audioFilesModelList")
        audioFileListAdapter.updateList(audioFilesModelList)
    }
}

data class AudioFilesModel(
    val uri: Uri,
    val name: String,
    val duration: Int,
    val size: Int,
    var isPlaying: Boolean = false
)