package com.ubsidi.epos_2021.fragment;

import static com.ubsidi.epos_2021.utils.Constants.YYYY_MM_DD;

import android.bluetooth.BluetoothDevice;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.androidnetworking.interfaces.StringRequestListener;
import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.activities.HomeActivity;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.DaoReportNameTotalValue;
import com.ubsidi.epos_2021.models.FullReport;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.ReportOrderPaymentMethod;
import com.ubsidi.epos_2021.models.ReportOrderStatus;
import com.ubsidi.epos_2021.models.ReportOrderType;
import com.ubsidi.epos_2021.models.ReportTextModel;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.User;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

public class ResetDeviceDialogFragment extends DialogFragment {

    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private String fromDateString, toDateString;
    boolean isArchived = false;
    private AppDatabase appDatabase = MyApp.getInstance().appDatabase;
    private ArrayList<Object> reports = new ArrayList<>();
    Printer defaultPrinter;
    private SiteSetting ticketHeaderSetting;
    private SiteSetting footerASetting;
    private SiteSetting footerBSetting;
    private int headerAlignment = 0;
    private ZoneRichPrinter zoneRichPrinter;
    private SunmiPrinter sunmiPrinter;
    private WifiPrinter wifiPrinter;
    public BluetoothPrinter bluetoothPrinter;
    MyApp myApp;
    MyPreferences myPreferences;
    private User selectedUser;
    String currentDate = "";
    private MaterialButton btnConfirm, btnCancel, btPrintReport;
    private ProgressBar progressDevice;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_reset_device_dialog, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        loadSettings();
        setListeners();
        Calendar currentCalender = Calendar.getInstance(Locale.getDefault());
        currentDate = CommonFunctions.formatMiliToDesireFormat(currentCalender.getTimeInMillis(), YYYY_MM_DD);
        toDateString = currentDate;
        currentCalender.add(Calendar.DATE, -1);
        fromDateString = CommonFunctions.formatMiliToDesireFormat(currentCalender.getTimeInMillis(), YYYY_MM_DD);
        fetchReport();
    }

    private void loadSettings() {
        try {
            SiteSetting ticketHeaderTypeSetting = myApp.findSetting("ticket_header_type");
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("right")) {
                headerAlignment = 2;
            }
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("center")) {
                headerAlignment = 1;
            }
            ticketHeaderSetting = myApp.findSetting("ticket_header");

            footerASetting = myApp.findSetting("footer_a");
            footerBSetting = myApp.findSetting("footer_b");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        btnConfirm = view.findViewById(R.id.btnConfirm);
        progressDevice = view.findViewById(R.id.progress_device);
        btnCancel = view.findViewById(R.id.btnCancel);
        btPrintReport = view.findViewById(R.id.btPrintReport);
        myApp = MyApp.getInstance();
        myPreferences = myApp.myPreferences;
        zoneRichPrinter = new ZoneRichPrinter(getActivity());
        sunmiPrinter = new SunmiPrinter(getActivity());
        defaultPrinter = myApp.myPreferences.getDefaultPrinter();
        //zoneRichPrinter = myApp.connectZonerich(zoneRichPrinter, defaultPrinter);
        wifiPrinter = WifiPrinter.getInstance();
        bluetoothPrinter = new BluetoothPrinter(getActivity());
    }

    private void setListeners() {
        btPrintReport.setOnClickListener(view -> {
            progressDevice.setVisibility(View.VISIBLE);
            createPrint();
            eraseData();
        });
        btnConfirm.setOnClickListener(view -> {
            progressDevice.setVisibility(View.VISIBLE);
            eraseData();
            //dialogDismissListener.onDialogDismiss("confirm");
            //dismiss();
        });

        btnCancel.setOnClickListener(view -> {
            dismiss();
        });
    }

    public void eraseData() {
        try {
            String url = ApiEndPoints.delete_orders;
            AndroidNetworking.delete(url)
                    .addQueryParameter("device_id", myPreferences.getRegisteredDevice().device_id)
                    .build()
                    .getAsString(new StringRequestListener() {
                        @Override
                        public void onResponse(String response) {
                            String message = "Factory Reset settings done";
                            ToastUtils.makeToast(requireActivity(), message);
                            new Thread(() -> {
                                appDatabase.emptyPulledDao().nukeOrderItemIngredient();
                                appDatabase.emptyPulledDao().nukeOrderItemAddon();
                                appDatabase.emptyPulledDao().nukeOrderPayment();
                                appDatabase.emptyPulledDao().nukeOrderSplit();
                                appDatabase.emptyPulledDao().nukeOrder();
                                appDatabase.orderDao().resetOrderRelatedPrimaryKey();
                                appDatabase.tableDao().freeAllTables();
                            }).start();
                            requireActivity().runOnUiThread(() -> {
                                progressDevice.setVisibility(View.GONE);
                                Intent mIntent = new Intent(getActivity(), HomeActivity.class);
                                getActivity().finishAffinity();
                                startActivity(mIntent);
                                //dismiss();
                            });
                        }

                        @Override
                        public void onError(ANError anError) {
                            progressDevice.setVisibility(View.GONE);
                            if (anError.getErrorCode() == 400) {

                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void fetchReport() {
        try {
            new ReportAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            String url = ApiEndPoints.full_report;
            Log.e("onErroronError", "fetchReport " + MyApp.getInstance().restaurant_id);
            ANRequest.GetRequestBuilder requestBuilder = AndroidNetworking.get(url)
                    .addQueryParameter("shift_status", "both")
                    .addQueryParameter("from_date", fromDateString)
                    .addQueryParameter("restaurant_id", MyApp.getInstance().restaurant_id)
                    .addQueryParameter("to_date", toDateString);
            requestBuilder.addQueryParameter("archived", isArchived ? "1" : "0");
            requestBuilder.build()
                    .getAsObject(FullReport.class, new ParsedRequestListener<FullReport>() {
                        @Override
                        public void onResponse(FullReport response) {
                            try {
                                reports.clear();
                                if (MyApp.userPermission.order_count.actions.list)
                                    reports.add(new ReportTextModel("Total Orders", response.order_count, false));
                                if (MyApp.userPermission.orders_total_product.actions.list)
                                    reports.add(new ReportTextModel("Total Product Sale", response.orders_total_product, false));
                                if (MyApp.userPermission.orders_amount_product.actions.list)
                                    reports.add(new ReportTextModel("Value Product Sale", MyApp.currencySymbol + MyApp.df.format(response.orders_amount_product), false));
                                if (MyApp.userPermission.total_discount.actions.list)
                                    reports.add(new ReportTextModel("Total Discounts", MyApp.currencySymbol + MyApp.df.format(response.total_discount), false));
                                if (MyApp.userPermission.total_no_guest.actions.list)
                                    reports.add(new ReportTextModel("Total Dinners", response.total_no_guest, false));
                                if (MyApp.userPermission.total_no_table.actions.list)
                                    reports.add(new ReportTextModel("Total Tables", response.total_no_table, false));

                                if (response.allocated_voucher != 0) {
                                    reports.add(new ReportTextModel("Total Voucher", String.valueOf(response.allocated_voucher), false));
                                }
                                if (response.allocated_voucher_value != 0) {
                                    reports.add(new ReportTextModel("Total Voucher value", String.valueOf(response.allocated_voucher_value), false));
                                }
                                if (!Validators.isNullOrEmpty(response.total_gratuity)) {
                                    reports.add(new ReportTextModel("Total gratuity", response.total_gratuity, false));
                                }
                                if (!Validators.isNullOrEmpty(response.total_service_charge)) {
                                    reports.add(new ReportTextModel("Total service charge", String.valueOf(response.total_service_charge), false));
                                }
                                if (response.order_type_wise != null && response.order_type_wise.size() > 0 && MyApp.userPermission.order_type_wise.actions.list) {
                                    reports.add(new ReportTextModel("Order type", "", true));
                                    for (ReportOrderType something : response.order_type_wise) {
                                        reports.add(new ReportTextModel("Total " + something.type + " orders", String.valueOf(something.count), false));
                                        reports.add(new ReportTextModel("Value " + something.type + " orders", MyApp.currencySymbol + MyApp.df.format(something.total), false));
                                    }
                                }
                                if (response.order_status_wise != null && response.order_status_wise.size() > 0 && MyApp.userPermission.order_status_wise.actions.list) {
                                    reports.add(new ReportTextModel("Order status", "", true));
                                    for (ReportOrderStatus something : response.order_status_wise) {
                                        reports.add(new ReportTextModel("Total " + something.status, String.valueOf(something.count), false));
                                        reports.add(new ReportTextModel("Value " + something.status, MyApp.currencySymbol + MyApp.df.format(something.total), false));
                                    }
                                }
                                if (response.order_payment_wise != null && response.order_payment_wise.size() > 0 && MyApp.userPermission.order_payment_wise.actions.list) {
                                    reports.add(new ReportTextModel("Order payment", "", true));
                                    for (ReportOrderPaymentMethod something : response.order_payment_wise) {
                                        reports.add(new ReportTextModel("Total " + something.name + " Payment", String.valueOf(something.count), false));
                                        reports.add(new ReportTextModel("Value " + something.name + " Payment", MyApp.currencySymbol + MyApp.df.format(something.total), false));
                                    }
                                }
                                if (getActivity() != null)
                                    btPrintReport.post(() -> {
                                        btPrintReport.setVisibility(View.VISIBLE);
                                    });
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                Log.e("onErroronError", "onError " + anError.getErrorBody());
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onErroronError", "onError " + apiError.getMessage());
                                    ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                    if (getActivity() != null) {
                                        getActivity().runOnUiThread(() -> {
                                            btPrintReport.setVisibility(View.VISIBLE);
                                        });
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ReportAsync extends AsyncTask<String, String, String> {

        @Override
        protected String doInBackground(String... strings) {
            try {
                StringBuffer stringTotalOrdersQuery = new StringBuffer();
                StringBuffer stringTotalProductSaleQuery = new StringBuffer();
                StringBuffer stringTotalProductSaleAmountQuery = new StringBuffer();
                StringBuffer stringTotalDiscountQuery = new StringBuffer();
                StringBuffer stringTotalGratuityQuery = new StringBuffer();
                StringBuffer stringTotalServiceChargeQuery = new StringBuffer();
                StringBuffer stringTotalDinersQuery = new StringBuffer();
                StringBuffer stringTotalTablesQuery = new StringBuffer();
                StringBuffer stringOrderTypeQuery = new StringBuffer();
                StringBuffer stringPaymentTypeQuery = new StringBuffer();
                StringBuffer stringOrderStatusQuery = new StringBuffer();
                StringBuffer stringRejectQuery = new StringBuffer();

                ArrayList<String> totalOrdersParams = new ArrayList<>();
                ArrayList<String> totalProductsSaleParams = new ArrayList<>();
                ArrayList<String> totalProductsSaleAmountParams = new ArrayList<>();
                ArrayList<String> totalDiscountsParams = new ArrayList<>();
                ArrayList<String> totalGratuityParams = new ArrayList<>();
                ArrayList<String> totalServiceChargeParams = new ArrayList<>();
                ArrayList<String> totalDinersParams = new ArrayList<>();
                ArrayList<String> totalTablesParams = new ArrayList<>();
                ArrayList<String> orderTypeParams = new ArrayList<>();
                ArrayList<String> paymentTypeParams = new ArrayList<>();
                ArrayList<String> orderStatusParams = new ArrayList<>();
                ArrayList<String> orderRejectParams = new ArrayList<>();

                stringTotalOrdersQuery.append("SELECT COUNT(*) from 'Order' WHERE date(created_at) >= ?  AND date(created_at) <= ?");
                stringOrderStatusQuery.append("SELECT COUNT(*) as total, SUM(total) as value, order_status as name from 'Order' WHERE date(created_at) >= ?  AND date(created_at) <= ? ");
                stringOrderTypeQuery.append("SELECT COUNT(*) as total, SUM(total) as value, order_type as name from 'Order' WHERE date(created_at) >= ?  AND date(created_at) <= ? ");
                stringPaymentTypeQuery.append("SELECT COUNT(*) as total, SUM(amount) as value, payment_method_name as name from OrderPayment LEFT JOIN 'Order' ON 'Order'._id = OrderPayment._order_id  WHERE date('Order'.created_at) >= ?  AND date('Order'.created_at) <= ? ");
                stringRejectQuery.append("SELECT COUNT(*) as total, SUM(amount) as value, payment_method_name as name from OrderPayment LEFT JOIN 'Order' ON 'Order'._id = OrderPayment._order_id  WHERE date('Order'.created_at) >= ?  AND date('Order'.created_at) <= ? AND 'Order'.order_status_id = 10 ");
                stringTotalDinersQuery.append("SELECT SUM(no_guest) from 'Order' WHERE date(created_at) >= ?  AND date(created_at) <= ? AND order_type_id = 1");
                stringTotalTablesQuery.append("SELECT COUNT(*) from 'Order' WHERE date(created_at) >= ?  AND date(created_at) <= ? AND order_type_id = 1");
                stringTotalDiscountQuery.append("SELECT SUM(discount) from 'Order' WHERE date(created_at) >= ?  AND date(created_at) <= ?");
                stringTotalGratuityQuery.append("SELECT SUM(gratuity) from 'Order' WHERE date(created_at) >= ?  AND date(created_at) <= ?");
                stringTotalServiceChargeQuery.append("SELECT SUM(service_charge) from 'Order' WHERE date(created_at) >= ?  AND date(created_at) <= ?");
                stringTotalProductSaleQuery.append("SELECT COUNT(*) from OrderItem LEFT JOIN 'Order' ON 'Order'._id = OrderItem._order_id WHERE date('Order'.created_at) >= ?  AND date('Order'.created_at) <= ? ");
                stringTotalProductSaleAmountQuery.append("SELECT SUM(OrderItem.total) from OrderItem LEFT JOIN 'Order' ON 'Order'._id = OrderItem._order_id WHERE date('Order'.created_at) >= ?  AND date('Order'.created_at) <= ?");

                totalOrdersParams.add(fromDateString);
                totalOrdersParams.add(toDateString);

                orderStatusParams.add(fromDateString);
                orderStatusParams.add(toDateString);

                orderTypeParams.add(fromDateString);
                orderTypeParams.add(toDateString);

                totalProductsSaleParams.add(fromDateString);
                totalProductsSaleParams.add(toDateString);

                totalProductsSaleAmountParams.add(fromDateString);
                totalProductsSaleAmountParams.add(toDateString);

                totalDiscountsParams.add(fromDateString);
                totalDiscountsParams.add(toDateString);

                totalGratuityParams.add(fromDateString);
                totalGratuityParams.add(toDateString);

                totalServiceChargeParams.add(fromDateString);
                totalServiceChargeParams.add(toDateString);

                totalDinersParams.add(fromDateString);
                totalDinersParams.add(toDateString);

                totalTablesParams.add(fromDateString);
                totalTablesParams.add(toDateString);

                paymentTypeParams.add(fromDateString);
                paymentTypeParams.add(toDateString);

                orderRejectParams.add(fromDateString);
                orderRejectParams.add(toDateString);

                if (selectedUser != null) {
                    stringTotalOrdersQuery.append(" AND updater_id = ?");
                    stringOrderTypeQuery.append(" AND updater_id = ?");
                    stringOrderStatusQuery.append(" AND updater_id = ?");
                    stringTotalDiscountQuery.append(" AND updater_id = ?");
                    stringTotalDinersQuery.append(" AND updater_id = ?");
                    stringTotalTablesQuery.append(" AND updater_id = ?");
                    stringTotalGratuityQuery.append(" AND updater_id = ?");
                    stringTotalServiceChargeQuery.append(" AND updater_id = ?");
                    stringTotalProductSaleQuery.append(" AND OrderItem.updater_id = ?");
                    stringTotalProductSaleAmountQuery.append(" AND OrderItem.updater_id = ?");
                    stringPaymentTypeQuery.append(" AND OrderPayment.updater_id = ?");
                    stringRejectQuery.append(" AND OrderPayment.updater_id = ?");

                    totalTablesParams.add(selectedUser.id);
                    orderTypeParams.add(selectedUser.id);
                    orderStatusParams.add(selectedUser.id);
                    totalDinersParams.add(selectedUser.id);
                    totalOrdersParams.add(selectedUser.id);
                    totalDiscountsParams.add(selectedUser.id);
                    totalGratuityParams.add(selectedUser.id);
                    totalServiceChargeParams.add(selectedUser.id);
                    totalProductsSaleParams.add(selectedUser.id);
                    totalProductsSaleAmountParams.add(selectedUser.id);
                    paymentTypeParams.add(selectedUser.id);
                    orderRejectParams.add(selectedUser.id);
                } else {
                    stringTotalOrdersQuery.append(" AND 'Order'.is_archived = ?");
                    stringOrderTypeQuery.append(" AND 'Order'.is_archived = ?");
                    stringOrderStatusQuery.append(" AND 'Order'.is_archived = ?");
                    stringTotalDiscountQuery.append(" AND 'Order'.is_archived = ?");
                    stringTotalDinersQuery.append(" AND 'Order'.is_archived = ?");
                    stringTotalTablesQuery.append(" AND 'Order'.is_archived = ?");
                    stringTotalGratuityQuery.append(" AND 'Order'.is_archived = ?");
                    stringTotalServiceChargeQuery.append(" AND 'Order'.is_archived = ?");
                    stringTotalProductSaleQuery.append(" AND 'Order'.is_archived = ?");
                    stringTotalProductSaleAmountQuery.append(" AND 'Order'.is_archived = ?");
                    stringPaymentTypeQuery.append(" AND 'Order'.is_archived = ?");
                    stringRejectQuery.append(" AND 'Order'.is_archived = ?");


                    totalTablesParams.add(isArchived ? "1" : "0");
                    orderTypeParams.add(isArchived ? "1" : "0");
                    orderStatusParams.add(isArchived ? "1" : "0");
                    totalDinersParams.add(isArchived ? "1" : "0");
                    totalOrdersParams.add(isArchived ? "1" : "0");
                    totalDiscountsParams.add(isArchived ? "1" : "0");
                    totalGratuityParams.add(isArchived ? "1" : "0");
                    totalServiceChargeParams.add(isArchived ? "1" : "0");
                    totalProductsSaleParams.add(isArchived ? "1" : "0");
                    totalProductsSaleAmountParams.add(isArchived ? "1" : "0");
                    paymentTypeParams.add(isArchived ? "1" : "0");
                    orderRejectParams.add(isArchived ? "1" : "0");
                }

                stringOrderStatusQuery.append(" Group By 'Order'.order_status_id");
                stringOrderTypeQuery.append(" Group By 'Order'.order_type_id");
                stringPaymentTypeQuery.append(" Group By OrderPayment.payment_method_id");
                stringRejectQuery.append(" Group By OrderPayment.payment_method_id");

                SupportSQLiteQuery totalOrdersQuery = new SimpleSQLiteQuery(stringTotalOrdersQuery.toString(), totalOrdersParams.toArray());
                SupportSQLiteQuery totalProductsSaleQuery = new SimpleSQLiteQuery(stringTotalProductSaleQuery.toString(), totalProductsSaleParams.toArray());
                SupportSQLiteQuery totalProductsSaleAmountQuery = new SimpleSQLiteQuery(stringTotalProductSaleAmountQuery.toString(), totalProductsSaleAmountParams.toArray());
                SupportSQLiteQuery totalDiscountQuery = new SimpleSQLiteQuery(stringTotalDiscountQuery.toString(), totalDiscountsParams.toArray());
                SupportSQLiteQuery totalGratuityQuery = new SimpleSQLiteQuery(stringTotalGratuityQuery.toString(), totalGratuityParams.toArray());
                SupportSQLiteQuery totalServiceChargeQuery = new SimpleSQLiteQuery(stringTotalServiceChargeQuery.toString(), totalServiceChargeParams.toArray());
                SupportSQLiteQuery totalDinersQuery = new SimpleSQLiteQuery(stringTotalDinersQuery.toString(), totalDinersParams.toArray());
                SupportSQLiteQuery totalTablesQuery = new SimpleSQLiteQuery(stringTotalTablesQuery.toString(), totalTablesParams.toArray());
                SupportSQLiteQuery orderStatusQuery = new SimpleSQLiteQuery(stringOrderStatusQuery.toString(), orderStatusParams.toArray());
                SupportSQLiteQuery orderTypeQuery = new SimpleSQLiteQuery(stringOrderTypeQuery.toString(), orderTypeParams.toArray());
                SupportSQLiteQuery paymentTypeQuery = new SimpleSQLiteQuery(stringPaymentTypeQuery.toString(), paymentTypeParams.toArray());
                SupportSQLiteQuery rejectQuery = new SimpleSQLiteQuery(stringRejectQuery.toString(), orderRejectParams.toArray());

                int totalOrders = appDatabase.reportDao().totalOrders(totalOrdersQuery);
                int totalProducts = appDatabase.reportDao().totalProducts(totalProductsSaleQuery);
                float totalProductSaleAmount = appDatabase.reportDao().totalProductsAmount(totalProductsSaleAmountQuery);
                float totalDiscounts = appDatabase.reportDao().totalDiscount(totalDiscountQuery);
                float totalGratuity = appDatabase.reportDao().totalGratuity(totalGratuityQuery);
                float totalServiceCharge = appDatabase.reportDao().totalServiceCharge(totalServiceChargeQuery);
                int totalDiners = appDatabase.reportDao().totalDiners(totalDinersQuery);
                int totalTables = appDatabase.reportDao().totalTables(totalTablesQuery);
                List<DaoReportNameTotalValue> orderStatus = appDatabase.reportDao().getOrderStatusReport(orderStatusQuery);
                List<DaoReportNameTotalValue> orderTypes = appDatabase.reportDao().getOrderStatusReport(orderTypeQuery);
                List<DaoReportNameTotalValue> orderPayments = appDatabase.reportDao().getOrderStatusReport(paymentTypeQuery);
                List<DaoReportNameTotalValue> reject = appDatabase.reportDao().getOrderStatusReport(rejectQuery);

                reports.clear();
                if (MyApp.userPermission.order_count.actions.list)
                    reports.add(new ReportTextModel("Total Orders", String.valueOf(totalOrders), false));
                if (MyApp.userPermission.orders_total_product.actions.list)
                    reports.add(new ReportTextModel("Total Product Sale", String.valueOf(totalProducts), false));
                if (MyApp.userPermission.orders_amount_product.actions.list)
                    reports.add(new ReportTextModel("Value Product Sale", MyApp.currencySymbol + MyApp.df.format(totalProductSaleAmount), false));
                if (MyApp.userPermission.total_discount.actions.list)
                    reports.add(new ReportTextModel("Total Discounts", MyApp.currencySymbol + MyApp.df.format(totalDiscounts), false));
                if (MyApp.userPermission.total_no_guest.actions.list)
                    reports.add(new ReportTextModel("Total Dinners", String.valueOf(totalDiners), false));
                if (MyApp.userPermission.total_no_table.actions.list)
                    reports.add(new ReportTextModel("Total Tables", String.valueOf(totalTables), false));


                if (totalGratuity > 0) {
                    reports.add(new ReportTextModel("Total gratuity", MyApp.df.format(totalGratuity), false));
                }
                if (totalServiceCharge > 0) {
                    reports.add(new ReportTextModel("Total service charge", MyApp.df.format(totalServiceCharge), false));
                }
                if (orderTypes != null && orderTypes.size() > 0 && MyApp.userPermission.order_type_wise.actions.list) {
                    reports.add(new ReportTextModel("Order type", "", true));
                    for (DaoReportNameTotalValue something : orderTypes) {
                        reports.add(new ReportTextModel("Total " + something.name + " orders", String.valueOf(something.total), false));
                        reports.add(new ReportTextModel("Value " + something.name + " orders", MyApp.currencySymbol + MyApp.df.format(Float.parseFloat(something.value)), false));
                    }
                }

                if (orderStatus != null && orderStatus.size() > 0 && MyApp.userPermission.order_type_wise.actions.list) {
                    reports.add(new ReportTextModel("Order Status", "", true));
                    for (DaoReportNameTotalValue something : orderStatus) {
                        Log.d("Full Report Status", "name: " + something.name + " , " + "value: " + something.value);
                        reports.add(new ReportTextModel("Total " + something.name + " orders", String.valueOf(something.total), false));
                        reports.add(new ReportTextModel("Value " + something.name + " orders", MyApp.currencySymbol + MyApp.df.format(Float.parseFloat(something.value)), false));
                    }
                }
                float cashTotal = 0, cardTotal = 0;
                if (orderPayments != null && orderPayments.size() > 0 && MyApp.userPermission.order_type_wise.actions.list) {
                    reports.add(new ReportTextModel("Payment Type", "", true));
                    for (DaoReportNameTotalValue something : orderPayments) {
                        Log.d("Full Report Payment", "name: " + something.name + " , " + "value: " + something.value);
                        reports.add(new ReportTextModel("Total " + something.name + " orders", String.valueOf(something.total), false));
                        reports.add(new ReportTextModel("Value " + something.name + " orders", MyApp.currencySymbol + MyApp.df.format(Float.parseFloat(something.value)), false));
                        if (something.name.toLowerCase().contains("cash")) {
                            cashTotal = cashTotal + Float.parseFloat(something.value);
                        }
                        if (something.name.toLowerCase().contains("card") || something.name.toLowerCase().contains("link")) {
                            cardTotal = cardTotal + Float.parseFloat(something.value);
                        }

                    }

                    for (DaoReportNameTotalValue something : reject) {
                        Log.d("Reject", "name: " + something.name + " , " + "value: " + something.value);
                        if (something.name.toLowerCase().contains("cash")) {
                            cashTotal = cashTotal - Float.parseFloat(something.value);
                        }
                        if (something.name.toLowerCase().contains("card") || something.name.toLowerCase().contains("link")) {
                            cardTotal = cardTotal - Float.parseFloat(something.value);
                        }
                    }
                    reports.add(new ReportTextModel("Grand Total", "", true));
                    reports.add(new ReportTextModel("Total Cash", MyApp.currencySymbol + MyApp.df.format(cashTotal), false));
                    reports.add(new ReportTextModel("Total Card", MyApp.currencySymbol + MyApp.df.format(cardTotal), false));
                    reports.add(new ReportTextModel("Total", MyApp.currencySymbol + MyApp.df.format(cardTotal + cashTotal), false));
                }
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }

            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {

            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createPrint() {
        try {
            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                String title = "Full report";
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                    zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                    zoneRichPrinter.printFullReport(myApp.businessLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, title, currentDate, selectedUser != null ? selectedUser.username : null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myApp.myPreferences);
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("sunmi") || defaultPrinter.printer_model_name.toLowerCase().contains("t2")) {
                    sunmiPrinter.printFullReport(myApp.businessLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, title, currentDate, selectedUser != null ? selectedUser.username : null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                        wifiPrinter.connect(defaultPrinter.ip);
                        CommonFunctions.functionThatDelay(200);
                        wifiPrinter.printFullReport(myApp.businessLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, title, currentDate, selectedUser != null ? selectedUser.username : null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                    } else {
                        try {
                            if (bluetoothPrinter != null) {
                                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                if (device != null) {
                                    CommonFunctions.functionThatDelay(100);
                                    bluetoothPrinter.printFullReport(myApp.businessLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, title, currentDate, selectedUser != null ? selectedUser.username : null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "");
                                } else {
                                    ToastUtils.makeSnackToast(getActivity(), "No bluetooth device found.");
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                }
            } else {
                ToastUtils.makeSnackToast(getActivity(), "No printer model found");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}