package com.ubsidi.epos_2021.fragment;

import static android.Manifest.permission.RECORD_AUDIO;
import static android.Manifest.permission.WRITE_EXTERNAL_STORAGE;
import static com.ubsidi.epos_2021.utils.Constants.CODE_IMAGE_PICKER;

import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.media.MediaRecorder;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.SystemClock;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.LinearInterpolator;
import android.widget.Chronometer;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONArrayRequestListener;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.bumptech.glide.Glide;
import com.devlomi.record_view.OnRecordListener;
import com.devlomi.record_view.RecordButton;
import com.devlomi.record_view.RecordView;
import com.github.dhaval2404.imagepicker.ImagePicker;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.mikhaellopez.circularimageview.CircularImageView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.adapters.ChatAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.StickHeaderItemDecoration;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.Chat;
import com.ubsidi.epos_2021.models.Dategroup;
import com.ubsidi.epos_2021.models.Message;
import com.ubsidi.epos_2021.models.OrderHistory;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

/**
 * Created by Amrish on 12-09-2020.
 */
public class RestaurantChatWindowFragment extends BaseFragment {
    private CircularImageView ivLogo;
    private LinearLayoutManager linearLayoutManager;
    private RecyclerView rvMessages;
    private EditText etMessage;
    private ImageView ivCamera, ivSend;
    private ArrayList<Object> feed = new ArrayList<>();
    private ArrayList<Message> allMessages = new ArrayList<>();
    private ArrayList<Message> oldMessages = new ArrayList<>();
    private ChatAdapter chatAdapter;
    private String customer_id, customer_name, customer_phone, intentOrderId, chat_id;
    private ImageView ivRecord;
    private TextView tvRecordingTime;
    private ImageView ivRecordingStatus;
    private LinearLayout llRecordingView, llInputMain;
    private Chronometer chronometer;
    private RecordButton recordButton;
    private RecordView recordView;
    private TextView tvTitle;
    private ImageView ivBack;
    private ImageView ivCall;
    private ImageView ivInfo;
    private ImageView ivDelete;
    private RelativeLayout rlCall;
    boolean isRequestOnGoing;
    private AlertDialog progressDialog;
    private String customer_logo;
    private DialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_restaurant_chat_window, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            setListeners();
            updateViews();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (getArguments() != null) {
                customer_id = getArguments().getString("customer_id");
                customer_name = getArguments().getString("customer_name");
                customer_phone = getArguments().getString("customer_phone");
                intentOrderId = getArguments().getString("order_id");
                customer_logo = getArguments().getString("customer_logo");
                chat_id = getArguments().getString("chat_id");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initViews(View view) {
        try {
            progressDialog = CommonFunctions.customProgressDialog(getActivity());
            rvMessages = view.findViewById(R.id.rvMessages);
            etMessage = view.findViewById(R.id.etMessage);
            ivCamera = view.findViewById(R.id.ivCamera);
            ivSend = view.findViewById(R.id.ivSend);
            ivRecord = view.findViewById(R.id.ivRecord);
            ivBack = view.findViewById(R.id.ivBack);
            ivCall = view.findViewById(R.id.ivCall);
            ImageView ivAttech = view.findViewById(R.id.ivAttech);
            ivInfo = view.findViewById(R.id.ivInfo);
            ivDelete = view.findViewById(R.id.ivDelete);

            rlCall = view.findViewById(R.id.rlCall);
            RelativeLayout rlDelete = view.findViewById(R.id.rlDelete);

            tvTitle = view.findViewById(R.id.tvTitle);
            recordButton = view.findViewById(R.id.record_button);
            recordView = view.findViewById(R.id.record_view);
            ((ImageView) recordView.findViewById(R.id.basket_img)).setColorFilter(Color.WHITE);
            llInputMain = view.findViewById(R.id.llInputMain);
            llRecordingView = view.findViewById(R.id.llRecordingView);
            tvRecordingTime = view.findViewById(R.id.tvRecordingTime);
            ivRecordingStatus = view.findViewById(R.id.ivRecordingStatus);
            chronometer = view.findViewById(R.id.chronometer);
            ivLogo = view.findViewById(R.id.ivLogo);

            rlDelete.setVisibility(View.GONE);
            ivAttech.setVisibility(View.GONE);

            chatAdapter = new ChatAdapter(feed, (position, data) -> {

            });
            linearLayoutManager = new LinearLayoutManager(getContext(), RecyclerView.VERTICAL, false);
            rvMessages.setLayoutManager(linearLayoutManager);
            rvMessages.setAdapter(chatAdapter);
            rvMessages.addItemDecoration(new StickHeaderItemDecoration(chatAdapter));
            ivSend.setAlpha(0.4f);
            ivSend.setEnabled(false);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateViews() {
        try {
            if (!Validators.isNullOrEmpty(customer_phone)) {
                rlCall.setVisibility(View.VISIBLE);
            } else {
                rlCall.setVisibility(View.GONE);
            }
            tvTitle.setText(customer_name);

            if (!Validators.isNullOrEmpty(customer_logo)) {
                Glide.with(getActivity())
                        .load(customer_logo)
                        .placeholder(R.drawable.avatar_logo_placeholder)
                        .error(R.drawable.avatar_logo_placeholder)
                        .into(ivLogo);
            } else {
                ivLogo.setImageResource(R.drawable.avatar_logo_placeholder);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static UserDetailsDialogFragment getInstanceUserDetailsDialog(String logo, String name, String phone) {
        UserDetailsDialogFragment detailsDialogFragment = new UserDetailsDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("customer_logo", logo);
        bundle.putString("customer_name", name);
        bundle.putString("customer_phone", phone);
        detailsDialogFragment.setArguments(bundle);
        return detailsDialogFragment;
    }

    private void setListeners() {
        try {
            ivInfo.setOnClickListener(v -> {
                UserDetailsDialogFragment dialogFragment = getInstanceUserDetailsDialog(customer_logo, customer_name, customer_phone);
                dialogFragment.show(getActivity().getSupportFragmentManager(), "details");
                dialogFragment.setDialogDismissListener(o -> {
                    try {
                        if (o.equals("compose")) {
                            SelectChatCustomerDialogFragment selectChatCustomerDialogFragment = new SelectChatCustomerDialogFragment();
                            selectChatCustomerDialogFragment.show(getChildFragmentManager(), "customers");
                            selectChatCustomerDialogFragment.setDialogDismissListener(o1 -> {
                                if (o1 instanceof OrderHistory) {
                                    OrderHistory orderHistory = (OrderHistory) o1;
                                    Chat chat = new Chat();
                                    chat.customer_id = orderHistory.customer_id;
                                    chat.order_id = orderHistory.id;
                                    chat.customer_name = orderHistory.customer_name;
                                    chat.phone_number = orderHistory.phone_number;
                                    changeFragment(chat);
                                }
                            });
                        } else {
                            Intent intent = new Intent();
                            intent.setAction(Intent.ACTION_DIAL);
                            intent.setData(Uri.parse("tel: " + customer_phone));
                            startActivity(intent);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            });
            blinkRecording();
            ivSend.setOnClickListener(view -> {
                if (!Validators.isNullOrEmpty(etMessage.getText().toString()) && etMessage.getText().toString().trim().length() > 0) {
                    sendMessage(etMessage.getText().toString().trim(), null, "0");
                    etMessage.setText("");
                    CommonFunctions.hideKeyboard(getActivity(), etMessage);
                }
            });
            ivCamera.setOnClickListener(view -> pickImage());
            ivBack.setOnClickListener((view) -> getActivity().onBackPressed());
            ivCall.setOnClickListener((view) -> {
                Intent intent = new Intent();
                intent.setAction(Intent.ACTION_DIAL);
                intent.setData(Uri.parse("tel: " + customer_phone));
                startActivity(intent);
            });

            ivDelete.setOnClickListener(view -> deleteChat());
            recordButton.setRecordView(recordView);
            recordView.setOnRecordListener(new OnRecordListener() {
                @Override
                public void onStart() {
                    startRecording();
                    //Start Recording..
                    llInputMain.setVisibility(View.INVISIBLE);
                }

                @Override
                public void onCancel() {
                    //On Swipe To Cancel
                    cancelRecording();

                }

                @Override
                public void onFinish(long recordTime) {
                    //Stop Recording..
                    stopRecording();
                    llInputMain.setVisibility(View.VISIBLE);
                }

                @Override
                public void onLessThanSecond() {
                    //When the record time is less than One Second
                    llInputMain.setVisibility(View.VISIBLE);
                    cancelRecording();
                }
            });
            recordView.setOnBasketAnimationEndListener(() -> llInputMain.setVisibility(View.VISIBLE));
            ivRecord.setOnClickListener(view -> {
            });
            ivRecord.setOnTouchListener((view, event) -> {
                switch (event.getAction()) {
                    case MotionEvent.ACTION_DOWN:
                        startRecording();
                        startRecordingTimer();
                        //This is where my code for movement is initialized to get original location.
                        break;
                    case MotionEvent.ACTION_UP:
                        stopRecordingTimer();
                        if (mediaRecorder != null) {
                            stopRecording();
                        }
                        return false;
                    case MotionEvent.ACTION_MOVE:
                        //Code for movement here. This may include using a window manager to update the view
                        break;
                }
                return true;
            });

            etMessage.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    try {
                        if (etMessage.getText().toString().trim().length() == 0) {
                            ivSend.setAlpha(0.4f);
                            ivSend.setEnabled(false);
                        } else {
                            ivSend.setAlpha(1f);
                            ivSend.setEnabled(true);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void afterTextChanged(Editable editable) {

                }
            });

            rvMessages.addOnLayoutChangeListener((view, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> {
                try {
                    if (bottom < oldBottom) {
                        rvMessages.postDelayed(() -> rvMessages.scrollToPosition(
                                rvMessages.getAdapter().getItemCount() - 1), 100);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteChat() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            AndroidNetworking.delete(ApiEndPoints.order_help_list + chat_id)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                LogUtils.e("delete chat responce:: " + new Gson().toJson(response));
                                getActivity().getSupportFragmentManager().beginTransaction().detach(new RestaurantChatWindowFragment()).commit();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        progressDialog.dismiss();
                                    });
                                }
                                getAllMessages(null, false);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                }
                                if (!CommonFunctions.isConnected(getActivity()))
                                    myApp.noInternet(getActivity());
                                getAllMessages(null, false);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeFragment(Chat chat) {
        try {
            customer_id = chat.customer_id;
            customer_name = chat.customer_name;
            customer_phone = chat.phone_number;
            intentOrderId = chat.order_id;
            customer_logo = chat.customer_logo;
            //    updateViews();
            if (dialogDismissListener != null)
                dialogDismissListener.onDialogDismiss(chat);
            //  getAllMessages(null, false);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void cancelRecording() {
        try {
            if (mediaRecorder != null) {
                try {
                    mediaRecorder.stop();
                    mediaRecorder.release();
                    mediaRecorder = null;
                    if (audioFile.exists()) {
                        audioFile.delete();
                    }
                } catch (Exception e) {
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startRecordingTimer() {
        try {
            llInputMain.setVisibility(View.GONE);
            llRecordingView.setVisibility(View.VISIBLE);
            tvRecordingTime.setText("Recording ");
            chronometer.setBase(SystemClock.elapsedRealtime());
            chronometer.start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stopRecordingTimer() {
        try {
            llInputMain.setVisibility(View.VISIBLE);
            llRecordingView.setVisibility(View.GONE);
            chronometer.stop();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void blinkRecording() {
        Animation animation = new AlphaAnimation(1, 0); //to change visibility from visible to invisible
        animation.setDuration(500); //1 second duration for each animation cycle
        animation.setInterpolator(new LinearInterpolator());
        animation.setRepeatCount(Animation.INFINITE); //repeating indefinitely
        animation.setRepeatMode(Animation.REVERSE); //animation will start from end point once ended.
        ivRecordingStatus.startAnimation(animation); //to start animation
    }

    private void startRecording() {
        try {
            random = new Random();
            if (checkPermission()) {

                String root = Environment.getExternalStorageDirectory().getAbsolutePath();
                File directory = new File(root + "/TiffinTom/Chat/Audio/");
                String audioFileName = CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd HH:mm:ss") + " Recording.mp3";
                if (!directory.exists()) directory.mkdirs();
                audioFile = new File(directory, audioFileName);

                mediaRecorder = new MediaRecorder();
                mediaRecorder.setAudioSource(MediaRecorder.AudioSource.MIC);
                mediaRecorder.setOutputFormat(MediaRecorder.OutputFormat.THREE_GPP);
                mediaRecorder.setAudioEncoder(MediaRecorder.OutputFormat.AMR_NB);
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                    mediaRecorder.setOutputFile(audioFile);
                } else {
                    mediaRecorder.setOutputFile(audioFile.getAbsolutePath());
                }

                try {
                    mediaRecorder.prepare();
                    mediaRecorder.start();
                } catch (IllegalStateException | IOException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }

            } else {
                requestPermission();
            }
        } catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }


    private void stopRecording() {
        try {
            mediaRecorder.stop();
            mediaRecorder.release();
            sendMessage(null, audioFile, "2");
            mediaRecorder = null;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean newMessage = false;

    private void getAllMessages(String lastMsgId, boolean autoRefresh) {
        try {
            HashMap<String, String> hashMap = new HashMap<>();
            hashMap.put("user_id", customer_id);
            hashMap.put("restaurant_id", myApp.restaurant_id);
            hashMap.put("order_id", intentOrderId);
            hashMap.put("admin", "0");
            hashMap.put("nopaginate", "1");
            if (lastMsgId != null) {
                hashMap.put("last_id", lastMsgId);
            }
            isRequestOnGoing = true;
            AndroidNetworking.get(ApiEndPoints.order_help_list)
                    .addQueryParameter(hashMap)
                    .build()
                    .getAsJSONArray(new JSONArrayRequestListener() {
                        @Override
                        public void onResponse(JSONArray response) {
                            try {
                                isRequestOnGoing = false;
                                Type type = new TypeToken<List<Message>>() {
                                }.getType();
                                feed.clear();
                                if (!autoRefresh) {
                                    allMessages.clear();
                                }
                                oldMessages.clear();
                                oldMessages.addAll(new Gson().fromJson(response.toString(), type));
                                allMessages.addAll(oldMessages);
                                newMessage = true;
                                setupAdapter();
                                if (!autoRefresh) {
                                    rvMessages.scrollToPosition(feed.size() - 1);
                                } else {
                                    if (newMessage && linearLayoutManager.findLastCompletelyVisibleItemPosition() + 1 != feed.size()) {
                                        rvMessages.scrollToPosition(feed.size() - 1);
                                    }
                                }
                                if (!autoRefresh) setAutoFetch();
                            } catch (JsonSyntaxException e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            isRequestOnGoing = false;
                            anError.printStackTrace();
                            newMessage = false;
                            if (!autoRefresh && !CommonFunctions.isConnected(getActivity()))
                                myApp.noInternet(getActivity());
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setupAdapter() {
        try {
            feed.clear();
            ArrayList<String> dates = new ArrayList<>();

            for (Message message : allMessages) {
                //chatAdapter.image_path = message.image_url;
                String messageDate = CommonFunctions.formatUnknownDateTime(message.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "EEE dd MMM, yyyy");
                int datesIndex = -1;
                if (!dates.contains(messageDate)) {
                    dates.add(messageDate);
                }
            }
            for (String date : dates) {
                feed.add(new Dategroup(date));
                for (Message message : allMessages) {

                    String messageDate = CommonFunctions.formatUnknownDateTime(message.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "EEE dd MMM, yyyy");
                    if (messageDate.equals(date))
                        feed.add(message);

                }
            }
            chatAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //0 msg,1 img 2 audio
    private void sendMessage(String message, File file, String type) {

        try {
            if (type.equals("2")) {
                if (getActivity() != null && progressDialog != null)
                    getActivity().runOnUiThread(() -> progressDialog.show());
            }
            HashMap<String, String> params = new HashMap<>();

            if (type.equalsIgnoreCase("0"))
                params.put("message", message);
            else params.put("message", "");
            params.put("customer_id", customer_id);
            params.put("order_id", intentOrderId);
            params.put("restaurant_id", myApp.restaurant_id);
            params.put("admin", "1");
            params.put("status", "1");
            //0 msg,1 img 2 audio
            if (type.equals("1") || type.equals("2"))
                params.put("is_attach", "1");
            else {
                params.put("is_attach", "0");
            }
            ANRequest.MultiPartBuilder androidNetworking = AndroidNetworking.upload(ApiEndPoints.order_help_list)
                    .addMultipartParameter(params);
            if (!type.equalsIgnoreCase("0")) {
                androidNetworking.addMultipartFile("attach", file);
            }

            androidNetworking
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                Message m = new Gson().fromJson(response.toString(), Message.class);
                                allMessages.add(m);
                                setupAdapter();
                                rvMessages.scrollToPosition(feed.size() - 1);
                                if (file != null && file.exists()) {
                                    file.delete();
                                }
                                if (getActivity() != null && progressDialog != null)
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            } catch (JsonSyntaxException e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null && progressDialog != null)
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                if (!CommonFunctions.isConnected(getActivity()))
                                    myApp.noInternet(getActivity());
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void pickImage() {
        ImagePicker.Companion.with(this)
                //Crop image(Optional), Check Customization for more option
                .compress(1024)            //Final image size will be less than 1 MB(Optional)
                .maxResultSize(1080, 1080)    //Final image resolution will be less than 1080 x 1080(Optional)
                .start(CODE_IMAGE_PICKER);
    }

    File audioFile;
    MediaRecorder mediaRecorder;
    Random random;
    public final int RequestPermissionCode = 1;

    private void requestPermission() {
        ActivityCompat.requestPermissions(getActivity(), new
                String[]{WRITE_EXTERNAL_STORAGE, RECORD_AUDIO}, RequestPermissionCode);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode,
                                           String permissions[], int[] grantResults) {
        if (requestCode == RequestPermissionCode) {
            try {
                if (grantResults.length > 0) {
                    boolean StoragePermission = grantResults[0] ==
                            PackageManager.PERMISSION_GRANTED;
                    boolean RecordPermission = grantResults[1] ==
                            PackageManager.PERMISSION_GRANTED;

                    if (!StoragePermission || !RecordPermission) {
                        ToastUtils.makeToast(getActivity(), "Permissions denied");
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean checkPermission() {
        int result = ContextCompat.checkSelfPermission(getActivity(),
                WRITE_EXTERNAL_STORAGE);
        int result1 = ContextCompat.checkSelfPermission(getActivity(),
                RECORD_AUDIO);
        return result == PackageManager.PERMISSION_GRANTED &&
                result1 == PackageManager.PERMISSION_GRANTED;
    }

    Handler handler = new Handler();
    Runnable runnable = new Runnable() {
        @Override
        public void run() {
            try {
                String lastMsgId = null;
                for (Object o : feed) {
                    if (o instanceof Message) {
                        if (((Message) o).id != 0) {
                            lastMsgId = String.valueOf(((Message) o).id);
                        }
                    }
                }
                getAllMessages(lastMsgId, true);
                handler.postDelayed(runnable, 5 * 1000);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private void setAutoFetch() {
        handler.postDelayed(runnable, 5 * 1000);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == CODE_IMAGE_PICKER) {
            try {
                if (data != null) {
                    Uri uri = data.getData();
                    File userImageFile = new File(uri.getPath());
                    if (userImageFile != null && userImageFile.exists())
                        sendMessage(null, userImageFile, "1");
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    }

    @Override
    public void onResume() {
        super.onResume();
        getAllMessages(null, false);
    }

    @Override
    public void onStop() {
        try {
            handler.removeCallbacks(runnable);
            if (mediaRecorder != null) mediaRecorder.stop();
        } catch (IllegalStateException e) {
            e.printStackTrace();
        }
        super.onStop();
    }
}
