package com.ubsidi.epos_2021.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.button.MaterialButton;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.stripe.stripeterminal.external.models.Reader;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.CardReaderAdapter;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.BusinessCardReader;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Amrish on 07-12-2020.
 */
public class SelectCardReaderDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private DialogDismissListener dialogDismissListener;
    private MaterialButton btnConfirm, btnCancel;
    private BusinessCardReader selectedCardReader;
    private ArrayList<Object> cardReaders = new ArrayList<>();
    private boolean stripe = false;
    private Reader stripeReader;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_select_cardreader, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            selectedCardReader = MyApp.getInstance().myPreferences.getDefaultCardReader();
            if (getArguments() != null) {
                ArrayList<Object> cr = new Gson().fromJson(getArguments().getString("readers"), new TypeToken<List<Reader>>() {
                }.getType());
                if (cr != null && cr.size() > 0) cardReaders.addAll(cr);
                stripe = getArguments().getBoolean("stripe");
            }
            initViews(view);
            setListeners();
        } catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnCancel = view.findViewById(R.id.btnCancel);
            RecyclerView rvReaders = view.findViewById(R.id.rvCardReaders);

            cardReaders.addAll(MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.card_readers);
            CardReaderAdapter cardReaderAdapter = new CardReaderAdapter(cardReaders, (position, data) -> {
                try {
                    if (data instanceof BusinessCardReader) {
                        selectedCardReader = (BusinessCardReader) data;
                        btnConfirm.setEnabled(true);
                    } else if (data instanceof Reader) {
                        stripeReader = (Reader) data;
                        btnConfirm.setEnabled(true);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            rvReaders.setAdapter(cardReaderAdapter);
            rvReaders.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));

            if (selectedCardReader != null) {
                cardReaderAdapter.selectedId = selectedCardReader.id;
                cardReaderAdapter.notifyDataSetChanged();
                btnConfirm.setEnabled(true);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            btnConfirm.setOnClickListener(view -> {
                try {
                    if (stripe && stripeReader == null) {
                        ToastUtils.makeSnackToast(getActivity(), "Please select card reader");
                        return;
                    }
                    if (!stripe && selectedCardReader == null) {
                        ToastUtils.makeSnackToast(getActivity(), "Please select card reader");
                        return;
                    }
                    if (dialogDismissListener != null) {
                        if (stripe) dialogDismissListener.onDialogDismiss(stripeReader);
                        else dialogDismissListener.onDialogDismiss(selectedCardReader);
                    }
                    dismiss();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            btnCancel.setOnClickListener(view -> {
                try {
                    if (dialogDismissListener != null)
                        dialogDismissListener.onDialogDismiss(null);
                    dismiss();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
