package com.ubsidi.epos_2021.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.CardReaderAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.BusinessCardReader;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;

public class SelectCardReaderFragment extends BaseFragment {
    private DialogDismissListener dialogDismissListener;
    private MaterialButton btnConfirm, btnCancel;
    private BusinessCardReader selectedCardReader;
    private ArrayList<Object> cardReaders = new ArrayList<>();

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_select_cardreader, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            selectedCardReader = MyApp.getInstance().myPreferences.getDefaultCardReader();
            initViews(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnCancel = view.findViewById(R.id.btnCancel);
            RecyclerView rvReaders = view.findViewById(R.id.rvCardReaders);

            btnConfirm.setVisibility(View.GONE);
            btnCancel.setVisibility(View.GONE);
            cardReaders.addAll(MyApp.getInstance().myPreferences.getLoggedInAdmin().selected_business.card_readers);
            CardReaderAdapter cardReaderAdapter = new CardReaderAdapter(cardReaders, (position, data) -> {
                if (data instanceof BusinessCardReader) {
                    selectedCardReader = (BusinessCardReader) data;
                    if (dialogDismissListener != null)
                        dialogDismissListener.onDialogDismiss(selectedCardReader);

                }
            });
            rvReaders.setAdapter(cardReaderAdapter);
            rvReaders.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));

            if (selectedCardReader != null) {
                cardReaderAdapter.selectedId = selectedCardReader.id;
                cardReaderAdapter.notifyDataSetChanged();
                btnConfirm.setEnabled(true);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            btnConfirm.setOnClickListener(view -> {
                if (selectedCardReader == null) {
                    ToastUtils.makeSnackToast(getActivity(), "Please select card reader");
                } else {
                    if (dialogDismissListener != null)
                        dialogDismissListener.onDialogDismiss(selectedCardReader);

                }
            });
            btnCancel.setOnClickListener(view -> {
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss(null);

            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
