package com.ubsidi.epos_2021.fragment;

import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.fragment.app.DialogFragment;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.airbnb.lottie.LottieAnimationView;
import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONArrayRequestListener;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.RecentOrdersAdapter;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.OrderHistory;
import com.ubsidi.epos_2021.network.ApiEndPoints;

import org.json.JSONArray;

import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;


/**
 * Created by Amrish on 13-11-2020.
 */
public class SelectChatCustomerDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private DialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }


    private AppCompatEditText etSearch;

    private RecentOrdersAdapter orderHistoryAdapter;
    private ArrayList<OrderHistory> orders = new ArrayList<>();
    private ArrayList<OrderHistory> searchedOrders = new ArrayList<>();
    private LottieAnimationView loadingView;
    private Chip chipBack;
    private String fromDateStr, toDateStr;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_select_chat_customer, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            setListener();
            fetchData();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initViews(View view) {
        try {
            chipBack = view.findViewById(R.id.chipBack);
            RecyclerView rvCustomers = view.findViewById(R.id.rvCustomers);
            etSearch = view.findViewById(R.id.etSearch);
            loadingView = view.findViewById(R.id.lodingView);
            orderHistoryAdapter = new RecentOrdersAdapter(searchedOrders, (position, data) -> {
                if (data instanceof OrderHistory) {
                    OrderHistory orderHistory = (OrderHistory) data;
                    if (dialogDismissListener != null)
                        dialogDismissListener.onDialogDismiss(orderHistory);
                    dismiss();
                }
            });
            rvCustomers.setLayoutManager(new GridLayoutManager(getActivity(), 3));
            rvCustomers.setAdapter(orderHistoryAdapter);

            getRecentDate();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getRecentDate() {
        try {
            Calendar cal = Calendar.getInstance();
            Date toDate = new Date();
            cal.setTime(toDate);
            cal.add(Calendar.DAY_OF_YEAR, -3);
            Date fromDate = cal.getTime();

            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            fromDateStr = sdf.format(fromDate);
            toDateStr = sdf.format(toDate);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListener() {
        try {
            chipBack.setOnClickListener(view -> dismiss());
            etSearch.setOnKeyListener((textView, i, keyEvent) -> {
                if (keyEvent.getAction() != KeyEvent.ACTION_DOWN)
                    return true;
                if (keyEvent.getKeyCode() == KeyEvent.KEYCODE_BACK) {
                    getActivity().onBackPressed();
                } else if ((keyEvent.getKeyCode() == KeyEvent.KEYCODE_ENTER)) {
                    searchedOrders.clear();
                    searchedOrders.addAll(searchChat());
                    orderHistoryAdapter.notifyDataSetChanged();
                    CommonFunctions.hideKeyboard(getActivity(), etSearch);
                }
                return false;
            });
            etSearch.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void afterTextChanged(Editable editable) {
                    searchedOrders.clear();
                    searchedOrders.addAll(searchChat());
                    orderHistoryAdapter.notifyDataSetChanged();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchData() {
        try {
            new Thread(this::getRecentCustomerOrders).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getRecentCustomerOrders() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> loadingView.setVisibility(View.VISIBLE));
            }
            AndroidNetworking.get(ApiEndPoints.online_orders)
                    .addQueryParameter("from_date", fromDateStr)
                    .addQueryParameter("to_date", toDateStr)
                    .addQueryParameter("restaurant_id", MyApp.getInstance().restaurant_id)
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsJSONArray(new JSONArrayRequestListener() {
                        @Override
                        public void onResponse(JSONArray response) {
                            try {
                                Type type = new TypeToken<List<OrderHistory>>() {
                                }.getType();
                                orders.clear();
                                orders.addAll(new Gson().fromJson(response.toString(), type));
                                searchedOrders.clear();
                                searchedOrders.addAll(orders);
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        loadingView.setVisibility(View.GONE);
                                        orderHistoryAdapter.notifyDataSetChanged();
                                    });
                                }
                            } catch (JsonSyntaxException e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> loadingView.setVisibility(View.GONE));
                                }
                                if (!CommonFunctions.isConnected(getActivity()))
                                    MyApp.getInstance().noInternet(getActivity());
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<OrderHistory> searchChat() {
        if (etSearch.getText().toString().isEmpty()) {
            return orders;
        }
        ArrayList<OrderHistory> searchedRest = new ArrayList<>();
        for (OrderHistory r : orders) {
            if (r.customer_name != null && r.customer_name.toLowerCase().contains(etSearch.getText().toString().toLowerCase())) {
                searchedRest.add(r);
            }
        }
        return searchedRest;

    }

    @Override
    public void onStop() {
        CommonFunctions.hideKeyboard(getActivity(), etSearch);
        super.onStop();
    }
}
