package com.ubsidi.epos_2021.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;

import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.SiteSetting;

/**
 * Created by Amrish on 31-05-2021.
 */
public class SendOrderDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private MaterialButton btnSendOrder, btnSendDupOrder, btnSendOrderUpdate, btnSendDupOrderUpdate;
    private DialogDismissListener dialogDismissListener;
    private Chip chipBack;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    private SiteSetting sendOrderMainSetting, sendOrderUpdateMainSetting, sendDupOrderMainSetting, sendDupOrderUpdateMainSetting;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_send_order_fragment, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (getArguments() != null) {
                sendOrderMainSetting = new Gson().fromJson(getArguments().getString("sendOrderMainSetting"), SiteSetting.class);
                sendOrderUpdateMainSetting = new Gson().fromJson(getArguments().getString("sendOrderUpdateMainSetting"), SiteSetting.class);
                sendDupOrderMainSetting = new Gson().fromJson(getArguments().getString("sendDupOrderMainSetting"), SiteSetting.class);
                sendDupOrderUpdateMainSetting = new Gson().fromJson(getArguments().getString("sendDupOrderUpdateMainSetting"), SiteSetting.class);
            }
            initViews(view);
            setListeners();
        } catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            btnSendDupOrder = view.findViewById(R.id.btnSendDuplicateFullOrder);
            btnSendOrder = view.findViewById(R.id.btnSendFullOrder);
            btnSendOrderUpdate = view.findViewById(R.id.btnSendOrderUpdate);
            btnSendDupOrderUpdate = view.findViewById(R.id.btnSendDuplicateOrderUpdate);
            chipBack = view.findViewById(R.id.chipBack);

            if (sendOrderMainSetting != null && (sendOrderMainSetting.value.equalsIgnoreCase("true") || sendOrderMainSetting.value.equalsIgnoreCase("1"))) {
                btnSendOrder.setVisibility(View.VISIBLE);
            } else {
                btnSendOrder.setVisibility(View.GONE);
            }
            if (sendOrderUpdateMainSetting != null && (sendOrderUpdateMainSetting.value.equalsIgnoreCase("true") || sendOrderUpdateMainSetting.value.equalsIgnoreCase("1"))) {
                btnSendOrderUpdate.setVisibility(View.VISIBLE);
            } else {
                btnSendOrderUpdate.setVisibility(View.GONE);
            }
            if (sendDupOrderMainSetting != null && (sendDupOrderMainSetting.value.equalsIgnoreCase("true") || sendDupOrderMainSetting.value.equalsIgnoreCase("1"))) {
                btnSendDupOrder.setVisibility(View.VISIBLE);
            } else {
                btnSendDupOrder.setVisibility(View.GONE);
            }
            if (sendDupOrderUpdateMainSetting != null && (sendDupOrderUpdateMainSetting.value.equalsIgnoreCase("true") || sendDupOrderUpdateMainSetting.value.equalsIgnoreCase("1"))) {
                btnSendDupOrderUpdate.setVisibility(View.VISIBLE);
            } else {
                btnSendDupOrderUpdate.setVisibility(View.GONE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            btnSendDupOrderUpdate.setOnClickListener(view -> {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss("4");
                    dismiss();
                }
            });
            btnSendDupOrder.setOnClickListener(view -> {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss("2");
                    dismiss();
                }
            });
            btnSendOrderUpdate.setOnClickListener(view -> {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss("3");
                    dismiss();
                }
            });
            btnSendOrder.setOnClickListener(view -> {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss("1");
                    dismiss();
                }
            });
            chipBack.setOnClickListener(view -> dismiss());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
