package com.ubsidi.epos_2021.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;

import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.utils.ToastUtils;

public class SunmiIpAddressFragment extends DialogFragment {

    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private EditText etIpAddress;
    private MaterialButton btnCancel, btnConfirm;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.dialog_enter_sunmi_ip_address, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            setListeners();
            etIpAddress.setText(MyApp.getInstance().myPreferences.getWifiConnectionId());
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    private void initViews(View view) {

        try {
            btnCancel = view.findViewById(R.id.btnCancel);
            etIpAddress = view.findViewById(R.id.etIpAddress);
            btnConfirm = view.findViewById(R.id.btnConfirm);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    void setListeners() {
        try {
            btnCancel.setOnClickListener(view -> dismiss());
            btnConfirm.setOnClickListener(view -> {
                if (!etIpAddress.getText().toString().isEmpty()) {
                    MyApp.getInstance().myPreferences.saveWifiConnectionId(etIpAddress.getText().toString());
                    ToastUtils.makeToast(requireContext(), "Ip address save successfully");
                    dismiss();
                } else {
                    ToastUtils.makeToast(requireContext(), "Please enter Ip address");
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


}