package com.ubsidi.epos_2021.fragment;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.imin.library.IminSDKManager;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.activities.NewOrderActivity;
import com.ubsidi.epos_2021.adapters.TablesAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.daos.relations.OrderItemWithAddonsIngredients;
import com.ubsidi.epos_2021.daos.relations.OrderWithItems;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.Floor;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.OrderSplit;
import com.ubsidi.epos_2021.models.PrepLocation;
import com.ubsidi.epos_2021.models.PrintSetting;
import com.ubsidi.epos_2021.models.PrintStructure;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.Table;
import com.ubsidi.epos_2021.models.TableStatus;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.services.SingleOrderUploaderService;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class TablesFragment extends BaseFragment {
    private final ArrayList<Table> tables = new ArrayList<>();
    public WifiPrinter wifiPrinter;
    public BluetoothPrinter bluetoothPrinter;
    public Business selectedBusiness;
    TableStatus vacantStatus = myApp.findStatus("Vacant");
    TableStatus servedStatus = myApp.findStatus("Served");

    public TableStatus mergedStatus = myApp.findStatus("Merged");
    boolean orderCompleteAuto = false;
    boolean splitByPersonPrint = false;
    float printableTotal = 0;
    private TablesAdapter tablesAdapter;
    private String floorId;
    private Floor floor;
    private Order order;
    private String assignTable;
    private SwipeRefreshLayout swipeRefreshLayout;
    /**
     * All Broadcast receivers starts
     */
    BroadcastReceiver orderUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getBooleanExtra("result", false)) {
                if (!swipeRefreshLayout.isRefreshing()) {
                    swipeRefreshLayout.setRefreshing(true);
                    fetchFloorDetails();
                }
            }
        }
    };
    private ZoneRichPrinter zoneRichPrinter;
    private SunmiPrinter sunmiPrinter;
    private Printer defaultPrinter;
    private Printer forceFullyDefaultPrinter;
    private ArrayList<Printer> printers = new ArrayList<>();
    private SiteSetting buzzerSetting;
    private SiteSetting ticketHeaderSetting;
    private SiteSetting footerOrderTypeSetting;
    private SiteSetting tableOrOrderIdSetting;
    private SiteSetting paidPaymentSetting;
    private SiteSetting unpaidPaymentSetting;
    private SiteSetting partialPaymentSetting;
    private SiteSetting cardPaymentSetting;
    private SiteSetting cashPaymentSetting;
    private int headerAlignment = 0;
    private boolean printTotalInPrint = true;
    private String footerA, footerB, footerHeading;
    private String dateTimeModeInPrint;
    private AlertDialog progressBarDialog;
    private HashMap<String, String> settingsMap = new HashMap<>();
    private List<PrintSetting> printSettings = myApp.myPreferences.getPrintSetting();
    private PrintStructure printStructure;


    BroadcastReceiver newOrderReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("refresh", false)) {
                    if (!myApp.myPreferences.getRemoteDeviceEnableStatus() && (intent.hasExtra("notification_section") && intent.getStringExtra("notification_section").equalsIgnoreCase("orders")) && (intent.hasExtra("print") && intent.getBooleanExtra("print", false) && "auto".equalsIgnoreCase(myPreferences.getOrderSyncMode()))) {
                        if (!swipeRefreshLayout.isRefreshing()) {
                            swipeRefreshLayout.setRefreshing(true);
                        }
                        fetchFloorDetails();
                        int orderId = intent.getIntExtra("order_id_", 0);
                        if (intent.hasExtra("print") && intent.getBooleanExtra("print", false) && "auto".equalsIgnoreCase(myPreferences.getOrderSyncMode())) {
                            fetchOrderUpdate(String.valueOf(orderId), "update");
                        }
                    } else {
                        if (!swipeRefreshLayout.isRefreshing()) {
                            if (intent.hasExtra("notification_section") && intent.getStringExtra("notification_section").equalsIgnoreCase("tables")) {
                                if (!swipeRefreshLayout.isRefreshing()) {
                                    swipeRefreshLayout.setRefreshing(true);
                                }
                                fetchFloorDetails();
                            } else if (intent.hasExtra("     ") && intent.getStringExtra("notification_section").equalsIgnoreCase("orders")) {
                                if (!swipeRefreshLayout.isRefreshing()) {
                                    swipeRefreshLayout.setRefreshing(true);
                                }
                                fetchFloorDetails();
                                int orderId = intent.getIntExtra("order_id_", 0);
                                if (intent.hasExtra("print") && intent.getBooleanExtra("print", false) && "auto".equalsIgnoreCase(myPreferences.getOrderSyncMode())) {
                                    fetchOrderUpdate(String.valueOf(orderId), "update");
                                }
                            }
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private boolean fromTheme2;
    private boolean refreshOnResume = true;

    private void loadSettings() {
        try {
            buzzerSetting = myApp.findSetting("open_cash_drawer_after_send_to_kitchen");
            SiteSetting totalVisibilitySetting = myApp.findSetting("kitchen_total_visible");
            SiteSetting footerASetting = myApp.findSetting("footer_a");
            SiteSetting footerBSetting = myApp.findSetting("footer_b");
            SiteSetting orderDateTimeSetting = myApp.findSetting("date_time_in_receipt_printing");
            tableOrOrderIdSetting = myApp.findSetting("use_table_number_or_order_number");
            SiteSetting ticketHeaderTypeSetting = myApp.findSetting("ticket_header_type");
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("right")) {
                headerAlignment = 2;
            }
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("center")) {
                headerAlignment = 1;
            }
            ticketHeaderSetting = myApp.findSetting("ticket_header");

            if (footerASetting != null) {
                footerA = footerASetting.value;
            }
            if (footerBSetting != null) {
                footerB = footerBSetting.value;
            }

            if (order != null) {
                if (!Validators.isNullOrEmpty(order.order_type_id) && order.order_type_id.equalsIgnoreCase("2")) {
                    footerOrderTypeSetting = myApp.findSetting("footer_takeaway");
                } else if (!Validators.isNullOrEmpty(order.order_type_id) && order.order_type_id.equalsIgnoreCase("3")) {
                    footerOrderTypeSetting = myApp.findSetting("footer_delivery");
                } else if (!Validators.isNullOrEmpty(order.order_type_id) && order.order_type_id.equalsIgnoreCase("5")) {
                    footerOrderTypeSetting = myApp.findSetting("footer_waiting");
                } else {
                    if (!Validators.isNullOrEmpty(order.order_type_id) && order.order_type_id.equalsIgnoreCase("1")) {
                        footerOrderTypeSetting = myApp.findSetting("footer_dinein");
                    }
                }
            }
            if (footerOrderTypeSetting != null) {
                footerHeading = footerOrderTypeSetting.value;
            }
            if (orderDateTimeSetting != null) {
                dateTimeModeInPrint = orderDateTimeSetting.value;
            }
            if (totalVisibilitySetting != null && (totalVisibilitySetting.value.equalsIgnoreCase("no") || totalVisibilitySetting.value.equalsIgnoreCase("false") || totalVisibilitySetting.value.equalsIgnoreCase("0"))) {
                printTotalInPrint = false;
            }
            SiteSetting orderCompleteMode = myApp.findSetting("order_complete_mode");
            if (orderCompleteMode != null && !Validators.isNullOrEmpty(orderCompleteMode.value) && (orderCompleteMode.value.equalsIgnoreCase("auto") || orderCompleteMode.value.equalsIgnoreCase("1") || orderCompleteMode.value.equalsIgnoreCase("yes"))) {
                orderCompleteAuto = true;
            }
            paidPaymentSetting = myApp.findSetting("paid_payment_title");
            unpaidPaymentSetting = myApp.findSetting("unpaid_payment_title");
            partialPaymentSetting = myApp.findSetting("partial_payment_title");
            cardPaymentSetting = myApp.findSetting("card_payment_type");
            cashPaymentSetting = myApp.findSetting("cash_payment_type");

            settingsMap.put("paid_payment_title", paidPaymentSetting.value);
            settingsMap.put("unpaid_payment_title", unpaidPaymentSetting.value);
            settingsMap.put("partial_payment_title", partialPaymentSetting.value);
            settingsMap.put("card_payment_type", cardPaymentSetting.value);
            settingsMap.put("cash_payment_type", cashPaymentSetting.value);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createBillPrint(String title, boolean kitchenCopy, boolean goBack, boolean updateOrder, int orderId) {
        try {
            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                if (kitchenCopy) {
                    new PrepLocationSenderAsync(title, orderId, updateOrder, () -> null).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                } else {
                    new OrderItemsPrintBlockAsync(null, orderId, () -> {
                        //LogUtils.e("TABLE Can we go back? " + (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1 || !Validators.isNullOrEmpty(title)) + " OrderTotal:" + order.total + " Paid: " + order.total_paid + " Title is nullorempty?" + Validators.isNullOrEmpty(title));
                        return null;
                    }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                }
            } else {
                //LogUtils.e("TABLE Can we go if no printer back? " + (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1 || !Validators.isNullOrEmpty(title)) + " OrderTotal:" + order.total + " Paid: " + order.total_paid + " Title is nullorempty?" + Validators.isNullOrEmpty(title));
                ToastUtils.makeLongToast(getActivity(), "No printer model found");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (getArguments() != null) {
                floorId = getArguments().getString("floor_id");
                assignTable = getArguments().getString("assignTable");
                order = new Gson().fromJson(getArguments().getString("order"), Order.class);
                fromTheme2 = getArguments().getBoolean("from_theme2", false);
            }
        } catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_tables, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        try {
            initViews(view);
            fetchFloorDetails();
            setListener();

            if (defaultPrinter != null && (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80))) {
                wifiPrinter.connect(defaultPrinter.ip);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    int _last_order_id = 0;

    private void initViews(View view) {
        try {
            SiteSetting homeTheme = myApp.findSetting("home_theme");
            defaultPrinter = myPreferences.getDefaultPrinter();
            forceFullyDefaultPrinter = myPreferences.getDefaultPrinter(true);
            zoneRichPrinter = new ZoneRichPrinter(getActivity());
            sunmiPrinter = new SunmiPrinter(getActivity());
            wifiPrinter = WifiPrinter.getInstance();
            bluetoothPrinter = new BluetoothPrinter(getActivity());

            if (myPreferences.getLoggedInAdmin() != null)
                selectedBusiness = myPreferences.getLoggedInAdmin().selected_business;

            printers = selectedBusiness.printers;

            progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
            swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayoutTables);
            RecyclerView rvTables = view.findViewById(R.id.rvItemsTables);
            boolean isTheme3;
            isTheme3 = (homeTheme != null && !Validators.isNullOrEmpty(homeTheme.value) && homeTheme.value.equalsIgnoreCase("theme3"));
            tablesAdapter = new TablesAdapter(tables, fromTheme2,isTheme3, (position, data) -> {
                try {
                    Table table = (Table) data;
                    if (table.status.equalsIgnoreCase(mergedStatus.status) && !Validators.isNullOrEmpty(table.merge_table_id)) {
                        Table table1 = appDatabase.tableDao().view(table.merge_table_id);
                        String message = table.number + " " + table.status + " With " + table1.number;
                        MergeInfoDialogFragment mergeInfoDialogFragment = getInstance(mergedStatus.status, message, 2, "Vacant", "Okay", table.id);
                        mergeInfoDialogFragment.setDialogDismissListener(o -> {
                            if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                                fetchFloorDetails();
                            }
                        });
                        mergeInfoDialogFragment.show(getChildFragmentManager(), "confirm");
                    } else {
                        if (order != null) {
                            // Handle cases when order updating from Multiple devices
                            if (order.table_id != null && order.table_id.equalsIgnoreCase(table.id) && !table.status.equalsIgnoreCase("Vacant") && !table.locked) {
                                order.table_id = table.id;
                                order.table_number = table.number;
                                startActivityForResult(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(order)), Constants.CODE_REFRESH);
                            } else if (table.locked && !table.status.equalsIgnoreCase("Vacant")) {
                                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Busy", table.number + " is Busy right now", 2, "Okay", null);
                                confirmationDialogFragment.show(getChildFragmentManager(), "confirm");
                            } else if (table.status.equalsIgnoreCase("Vacant")) {
                                NewDineinOrderDialogFragment newDineinOrderDialogFragment = getInstanceNewDineinOrder(table);
                                newDineinOrderDialogFragment.show(getChildFragmentManager(), "new_order");
                                newDineinOrderDialogFragment.setDialogDismissListener(o -> {
                                    if (o instanceof Order) {
                                        startActivityForResult(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(o)), Constants.CODE_REFRESH);
                                    }
                                });
                            } else if (!Validators.isNullOrEmpty(table.last_order_id)) {
                                fetchOrder(table.last_order_id, "open");
                            }
                        } else {
                            if (assignTable != null && assignTable.equalsIgnoreCase("assignTable")) {
                                myApp.notifyCart(getActivity(), new Intent("assign_Table").putExtra("assignTable", new Gson().toJson(table)));
                            } else {
                                if (table.status.equalsIgnoreCase(vacantStatus.status)) {
                                    NewDineinOrderDialogFragment newDineinOrderDialogFragment = getInstanceNewDineinOrder(table);
                                    newDineinOrderDialogFragment.show(getChildFragmentManager(), "new_order");
                                    newDineinOrderDialogFragment.setDialogDismissListener(o -> {
                                        if (o instanceof Order) {
                                            ToastUtils.makeSnackToast(getActivity(), "Order Taken Successfully");
                                            startActivityForResult(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(o)), Constants.CODE_REFRESH);
                                        }
                                    });
                                } else {
                                    if (!table.locked) {
                                        if (!Validators.isNullOrEmpty(table.last_order_id)) {
                                            _last_order_id = table._last_order_id;
                                            fetchOrder(table.last_order_id, "open");
                                        } else if (table._last_order_id > 0) {
                                            Order order = new Order();
                                            order._id = table._last_order_id;
                                            order.order_type_id = "1";
                                            startActivityForResult(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(order)), Constants.CODE_REFRESH);
                                        } else {
                                            NewDineinOrderDialogFragment newDineinOrderDialogFragment = getInstanceNewDineinOrder(table);
                                            newDineinOrderDialogFragment.show(getChildFragmentManager(), "new_order");
                                            newDineinOrderDialogFragment.setDialogDismissListener(o -> {
                                                if (o instanceof Order) {
                                                    startActivityForResult(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(o)), Constants.CODE_REFRESH);
                                                }
                                            });
                                        }
                                    } else {
                                        ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Busy", table.number + " is Busy right now", 2, "Okay", null);
                                        confirmationDialogFragment.show(getChildFragmentManager(), "confirm");
                                    }
                                }
                            }
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }, (position, action, data) -> {
                //Action click event
                try {
                    Table table = (Table) data;
                    String last_order_id = table.last_order_id;
                    int _last_order_id = table._last_order_id;

                    if (table.locked) {
                        ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Busy", table.number + " is Busy right now", 2, "Okay", null);
                        confirmationDialogFragment.show(getChildFragmentManager(), "confirm");
                        return;
                    }
                    switch (action) {
                        case "cancel_order":
                            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Cancel order", "Are you sure you want to cancel this order?", 2, "Confim", "Cancel");
                            confirmationDialogFragment.show(getChildFragmentManager(), "cancel_order_menu");
                            confirmationDialogFragment.setDialogDismissListener(o -> {
                                if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                                    table.table_status_id = vacantStatus.id;
                                    table.status = vacantStatus.status;
                                    table.last_order_created_at = null;
                                    table.last_order_id = null;
                                    table._last_order_id = 0;
                                    table.table_status = vacantStatus;
                                    if (!Validators.isNullOrEmpty(last_order_id)) {
                                        fetchOrder(last_order_id, action);
                                    } else if (_last_order_id > 0) {
                                        fetchOfflineOrderAndAction(_last_order_id, action);
                                    } else {
                                        freeOldTable(table.id);
                                    }
                                    tablesAdapter.notifyItemChanged(position);

                                    // check and change merged table status as vacant
                                    changeMergedTableStatus(table.id);
                                }
                            });

                            break;
                        case "pay_order":
                            if (!Validators.isNullOrEmpty(last_order_id)) {
                                fetchOrder(last_order_id, action);
                            } else if (_last_order_id > 0) {
                                fetchOfflineOrderAndAction(_last_order_id, action);
                            } else {
                                ToastUtils.makeSnackToast(getActivity(), "No order found");
                            }
                            break;
                        case "serve_order":

                            table.table_status_id = servedStatus.id;
                            table.status = servedStatus.status;
                            table.table_status = servedStatus;
                            table.locked = false;
                            tablesAdapter.notifyItemChanged(position);
                            if (!Validators.isNullOrEmpty(last_order_id)) {
                                fetchOrder(last_order_id, action);
                            } else if (_last_order_id > 0) {
                                fetchOfflineOrderAndAction(_last_order_id, action);
                            } else {
                                ToastUtils.makeSnackToast(getActivity(), "No order found");
                            }
                            break;
                        case "complete_order":
                            //Completing order or mark as vacant
                            table.table_status_id = vacantStatus.id;
                            table.status = vacantStatus.status;
                            table.last_order_created_at = null;
                            table.locked = false;
                            table.last_order_id = null;
                            table._last_order_id = 0;
                            table.table_status = vacantStatus;
                            if (!Validators.isNullOrEmpty(last_order_id)) {
                                fetchOrder(last_order_id, action);
                            } else if (_last_order_id > 0) {
                                fetchOfflineOrderAndAction(_last_order_id, action);
                            } else {
                                freeOldTable(table.id);
                            }
                            tablesAdapter.notifyItemChanged(position);
                            // check and change merged table status as vacant
                            changeMergedTableStatus(table.id);
                            break;
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            int spanCount = 4;
            if (homeTheme != null && !Validators.isNullOrEmpty(homeTheme.value) && homeTheme.value.equalsIgnoreCase("theme3")) {
                if (myApp.screenWidth > 2000) {
                    spanCount = 7;
                } else if (myApp.screenWidth > 1200) {
                    spanCount = 6;
                }
                // if imin device make span count to 4
                if (myApp.isAddIMinDevice) {
                    //spanCount = 4;
                }
            } else {
                if (myApp.screenWidth > 2000) {
                    spanCount = 6;
                } else if (myApp.screenWidth > 1600) {
                    spanCount = 5;
                }
                // if imin device make span count to 4
                if (myApp.isAddIMinDevice) {
                    spanCount = 4;
                }
            }
            rvTables.setLayoutManager(new GridLayoutManager(getActivity(), spanCount));
            rvTables.setAdapter(tablesAdapter);
            loadSettings();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void changeMergedTableStatus(String tableId) {
        new Thread(() -> {
            List<Table> tables = appDatabase.tableDao().viewByMergedTableId(tableId);
            for (Table table : tables) {
                table.status = vacantStatus.status;
                table.table_status_id = vacantStatus.id;
                table.locked = false;
                table.merge_table_id = "";
                table.updater_id = myPreferences.getLoggedInUser().id;
                appDatabase.tableDao().insert(table);
            }
            if (!tables.isEmpty()) {
                AndroidNetworking.post(ApiEndPoints.tables_status_bulk)
                        .addBodyParameter("tables", new Gson().toJson(tables))
                        .build()
                        .getAsObject(Table.class, new ParsedRequestListener() {
                            @Override
                            public void onResponse(Object response) {
                            }

                            @Override
                            public void onError(ANError anError) {
                                anError.printStackTrace();
                                if (anError.getErrorCode() == 400) {
                                    LogUtils.e("TABLE::", anError.getErrorAsObject(ApiError.class).getMessage());
                                }
                            }
                        });
            }
        }).start();
    }

    private void setListener() {
        swipeRefreshLayout.setOnRefreshListener(this::fetchFloorDetails);
    }

    public void fetchFloorDetails() {
        try {
            swipeRefreshLayout.setRefreshing(true);
            new Thread(() -> {
                if (!myApp.isConnected(getActivity())) {
                    new TablesAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                    return;
                }
                if ("manual".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) {
                    new TablesAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                    return;
                }
                AndroidNetworking.get(ApiEndPoints.floors + floorId)
                        .build()
                        .getAsObject(Floor.class, new ParsedRequestListener<Floor>() {
                            @Override
                            public void onResponse(Floor response) {
                                Log.e("Response", ":" + new Gson().toJson(response));
                                try {
                                    new TablesAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, response);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }

                            }

                            @Override
                            public void onError(ANError anError) {
                                try {
                                    new TablesAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchOfflineOrderAndAction(int _last_order_id, String action) {
        try {
            new Thread(() -> {
                try {
                    Order order = appDatabase.orderDao().view(_last_order_id);
                    if (order == null) return;
                    if (order.table_id == null || !order.order_type_id.equalsIgnoreCase("1"))
                        return;
                    Table table = appDatabase.tableDao().view(order.table_id);
                    table.updater_id = myPreferences.getLoggedInUser().id;
                    boolean orderUpdated = false;
                    if (action != null) {
                        if (action.equalsIgnoreCase("complete_order")) {
                            order.order_status_id = "5";
                            order.order_status = "Order Completed";
                            order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                            orderUpdated = true;

                            table.table_status_id = vacantStatus.id;
                            table.status = vacantStatus.status;
                            table.last_order_created_at = null;
                            table._last_order_id = 0;
                            table.last_order_id = null;

                            // check and change merged table status as vacant
                            changeMergedTableStatus(table.id);
                        } else if (action.equalsIgnoreCase("pay_order")) {
                            orderUpdated = false;
                            startActivityForResult(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(order)).putExtra("destination", "pay_bill"), Constants.CODE_REFRESH);
                        } else if (action.equalsIgnoreCase("cancel_order")) {
                            order.order_status_id = "10";
                            order.order_status = "Order Rejected";
                            order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                            orderUpdated = true;

                            table.table_status_id = vacantStatus.id;
                            table.status = vacantStatus.status;
                            table.last_order_created_at = null;
                            table._last_order_id = 0;
                            table.last_order_id = null;

                            // check and change merged table status as vacant
                            changeMergedTableStatus(table.id);
                        } else if (action.equalsIgnoreCase("serve_order")) {
                            order.order_action_id = "1";
                            order.order_status_id = "3";
                            order.order_status = "Order Served";
                            order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                            orderUpdated = true;

                            table.table_status_id = servedStatus.id;
                            table.status = servedStatus.status;

                        } else {
                            orderUpdated = false;
                            startActivityForResult(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(order)), Constants.CODE_REFRESH);
                        }
                    }
                    if (orderUpdated) {
                        appDatabase.orderDao().update(order);
                        Intent intent = new Intent(getActivity(), SingleOrderUploaderService.class);
                        intent.putExtra("_order_id", order._id);
                        getActivity().startService(intent);
                        changeTableStatus(order, table.table_status_id, table.status);
                    }
                    appDatabase.tableDao().insert(table);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchOrder(String order_id, String action) {
        try {
            progressBarDialog.show();
            new Thread(() -> {
                AndroidNetworking.get(ApiEndPoints.orders + order_id)
                        .build()
                        .getAsObject(Order.class, new ParsedRequestListener<Order>() {
                            @Override
                            public void onResponse(Order response) {
                                try {
                                    if (action != null) {
                                        if (action.equalsIgnoreCase("complete_order")) {
                                            response.order_status_id = "5";
                                            response.order_status = "Order Completed";
                                        } else if (action.equalsIgnoreCase("pay_order")) {

                                        } else if (action.equalsIgnoreCase("cancel_order")) {
                                            response.order_status_id = "10";
                                            response.order_status = "Order Rejected";
                                        } else if (action.equalsIgnoreCase("serve_order")) {
                                            response.order_action_id = "1";
                                            response.order_status_id = "3";
                                            response.order_status = "Order Served";
                                        } else {

                                        }
                                    }
                                    new OrderSaveAsyncTask(action).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, response);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }

                            @Override
                            public void onError(ANError anError) {
                                try {
                                    anError.printStackTrace();
                                    progressBarDialog.dismiss();
                                    if (_last_order_id > 0 && "manual".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) {
                                        Order order = new Order();
                                        order._id = _last_order_id;
                                        order.order_type_id = "1";
                                        startActivityForResult(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(order)), Constants.CODE_REFRESH);
                                    }

                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeTableStatus(Order order, String table_status_id, String status) {
        try {
            if (!order.order_type_id.equals("1")) {
                return;
            }

            new Thread(() -> {
                Table table = appDatabase.tableDao().view(order.table_id);
                if (table == null) return;

                table.locked = false;
                table.status = status;
                table.table_status_id = table_status_id;
                if (table.status.equalsIgnoreCase(vacantStatus.status)) {
                    table.last_order_id = null;
                    table._last_order_id = 0;
                    table.last_order_created_at = null;
                }
                table.updater_id = myPreferences.getLoggedInUser().id;
                LogUtils.e("Updating table to " + table.status + " Table: " + new Gson().toJson(table));
                appDatabase.tableDao().insert(table);
                AndroidNetworking.post(ApiEndPoints.tables + table.id)
                        .addApplicationJsonBody(table)
                        .build()
                        .getAsObject(Table.class, new ParsedRequestListener() {
                            @Override
                            public void onResponse(Object response) {
                                fetchFloorDetails();
                            }

                            @Override
                            public void onError(ANError anError) {
                                fetchFloorDetails();
                            }
                        });
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void freeOldTable(String oldTableId) {
        try {
            LogUtils.e("TABLE::Freeing old table start");
            new Thread(() -> {
                Table table = appDatabase.tableDao().view(oldTableId);
                table.locked = false;
                table.table_status_id = vacantStatus.id;
                table.status = vacantStatus.status;
                table.last_order_id = null;
                table._last_order_id = 0;
                table.last_order_created_at = null;
                table.updater_id = myPreferences.getLoggedInUser().id;
                appDatabase.tableDao().insert(table);
                AndroidNetworking.post(ApiEndPoints.tables + table.id)
                        .addApplicationJsonBody(table)
                        .build()
                        .getAsObject(Table.class, new ParsedRequestListener() {
                            @Override
                            public void onResponse(Object response) {
                            }

                            @Override
                            public void onError(ANError anError) {
                                if (anError.getErrorCode() == 400) {
                                    LogUtils.e("TABLE FREEING OLD TABLE ERROR IN TABLE STATUS CHANGE: ", anError.getErrorAsObject(ApiError.class).getMessage());
                                }
                            }
                        });
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /**
     * Activity Lifecycle related methods
     */
    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode != 5) {
            // refreshOnResume = false;
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (refreshOnResume) {
            new TablesAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        }
        registerBroadcast();
    }

    private void registerBroadcast() {
        if (getActivity() != null && newOrderReceiver != null) {
            LocalBroadcastManager.getInstance(getActivity()).registerReceiver(newOrderReceiver, new IntentFilter(Constants.EPOS_NEW_ORDER));
        }
        if (getActivity() != null && orderUpdateReceiver != null)
            LocalBroadcastManager.getInstance(getActivity()).registerReceiver(orderUpdateReceiver, new IntentFilter(
                    Constants.EPOS_ORDER_UPDATE));
    }

    private void unregisterBroadcast() {
        if (getActivity() != null && orderUpdateReceiver != null) {
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(orderUpdateReceiver);
        }
        if (getActivity() != null && newOrderReceiver != null) {
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(newOrderReceiver);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        try {
            if (defaultPrinter != null && (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80))) {
                if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                    wifiPrinter.disconnect();
                } else {
                    disconnectBTPrinter();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @Override
    public void onDestroyView() {
        super.onDestroyView();
        clearAdapter();
    }

    private void disconnectBTPrinter() {
        try {
            if (bluetoothPrinter != null) {
                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                if (device != null) {
                    bluetoothPrinter.closeBTPrinter();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        unregisterBroadcast();
    }

    private void fetchOrderUpdate(String order_id, String action) {
        try {
            if (progressBarDialog != null && !progressBarDialog.isShowing()) {
                progressBarDialog.show();
            }
            new Thread(() -> {
                AndroidNetworking.get(ApiEndPoints.orders + order_id)
                        .build()
                        .getAsObject(Order.class, new ParsedRequestListener<Order>() {
                            @Override
                            public void onResponse(Order response) {
                                try {
                                    if (action != null) {
                                        if (action.equalsIgnoreCase("complete_order")) {
                                            response.order_status_id = "5";
                                            response.order_status = "Order Completed";
                                        } else if (action.equalsIgnoreCase("pay_order")) {

                                        } else if (action.equalsIgnoreCase("cancel_order")) {
                                            response.order_status_id = "10";
                                            response.order_status = "Order Rejected";
                                        } else if (action.equalsIgnoreCase("serve_order")) {
                                            response.order_action_id = "1";
                                            response.order_status_id = "3";
                                            response.order_status = "Order Served";
                                        } else {

                                        }
                                    }
                                    new OrderSaveAsyncTask_(action, order_id).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, response);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }

                            @Override
                            public void onError(ANError anError) {
                                anError.printStackTrace();
                                try {
                                    progressBarDialog.dismiss();
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    class PrepLocationSenderAsync extends AsyncTask<String, String, String> {
        HashMap<PrepLocation, List<OrderItem>> prepOrderItems = new HashMap<>();
        String title;
        int orderId;
        boolean updatedOrder;
        Callable<Void> nextMethod;

        public PrepLocationSenderAsync(String title, int orderId, boolean updatedOrder, Callable<Void> nextMethod) {
            this.title = title;
            this.updatedOrder = updatedOrder;
            this.nextMethod = nextMethod;
            this.orderId = orderId;
        }

        @Override
        protected String doInBackground(String... strings) {

            ArrayList<PrepLocation> prepLocations = (ArrayList<PrepLocation>) appDatabase.prepLocationDao().list();
            for (PrepLocation prepLocation : prepLocations) {
                List<OrderItem> miscPrepOits = new ArrayList<>();
                List<OrderItem> prepOits = new ArrayList<>();
                List<OrderItem> allOits = new ArrayList<>();

                if (updatedOrder) {
                    //miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocations(order._id, prepLocation.id, false);
                    miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocationsKitchen(order._id, prepLocation.id);
                    prepOits = appDatabase.orderItemDao().orderItemProductForPrepLocationsKitchen(order._id, prepLocation.id);
                } else {
                    miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocations(order._id, prepLocation.id);
                    prepOits = appDatabase.orderItemDao().orderItemProductForPrepLocations(order._id, prepLocation.id);
                }

                if (miscPrepOits != null && miscPrepOits.size() > 0) {
                    allOits.addAll(miscPrepOits);
                }

                if (prepOits != null && prepOits.size() > 0) {
                    allOits.addAll(prepOits);
                }
                if (allOits.size() > 0) {
                    prepOrderItems.put(prepLocation, allOits);
                    for (OrderItem oit : allOits) {
                        oit.sent_to_kitchen = true;
                        appDatabase.orderItemDao().update(oit);
                    }
                }
                for (Map.Entry<PrepLocation, List<OrderItem>> entry : prepOrderItems.entrySet()) {
                    for (OrderItem orderItem : (ArrayList<OrderItem>) entry.getValue()) {
                        orderItem.order_item_ingredients = (ArrayList<OrderItemIngredient>) appDatabase.orderItemIngredientDao().list(orderItem._id);
                        orderItem.order_item_addons = (ArrayList<OrderItemAddon>) appDatabase.orderItemAddonDao().list(orderItem._id);
                    }
                }
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            int position = 0;
            for (Map.Entry<PrepLocation, List<OrderItem>> entry : prepOrderItems.entrySet()) {
                position++;
                PrepLocation prepLocation = entry.getKey();
                if (printers == null) {
                    ToastUtils.makeToast(getActivity(), "Business printers are null");
                    continue;
                }
                Printer prepPrinter = null;
                for (Printer pp : printers) {
                    if (prepLocation.printer_id.equalsIgnoreCase(pp.id)) {
                        prepPrinter = pp;
                    }
                }
                if (prepPrinter == null) {
                    ToastUtils.makeToast(getActivity(), "Preplocation printer not found,: " + prepLocation.printer_name);
                    continue;
                }
                if (defaultPrinter == null && forceFullyDefaultPrinter != null && prepPrinter.ip.equalsIgnoreCase(forceFullyDefaultPrinter.ip)) {
                    ToastUtils.makeToast(getActivity(), "Preplocation printer also same as default and its not connected");
                    continue;
                }

                Order tempOrder = new Gson().fromJson(new Gson().toJson(order), Order.class);
                tempOrder.order_items = (ArrayList<OrderItem>) entry.getValue();
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Prep Ticket")) {
                        printStructure = printSettings.get(i).print_structure;
                        break;
                    }
                }

                if (tempOrder.order_items.size() > 0) {
                    if (prepPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                        zoneRichPrinter.connectPrinter(prepPrinter.ip);
                        CommonFunctions.functionThatDelay(250);
                        zoneRichPrinter.printOrderEposNew(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, printTotalInPrint, footerA, footerB, footerHeading, settingsMap, true, false, myApp.myPreferences);
                        if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && prepLocation.cash_draw) {
                            zoneRichPrinter.connectPrinter(prepPrinter.ip);
                            CommonFunctions.functionThatDelay(250);
                            zoneRichPrinter.openCashDrawer();
                        }
                    } else if (prepPrinter.printer_model_name.toLowerCase().contains("t2") || prepPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                        sunmiPrinter.printOrderEposNew(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, printTotalInPrint, footerA, footerB, footerHeading, settingsMap, true, false, myPreferences);
                        if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && prepLocation.cash_draw) {
                            sunmiPrinter.openCashDrawer();
                        }
                    } else if (prepPrinter.printer_model_name.toLowerCase().contains("pos-80") || prepPrinter.printer_model_name.toLowerCase().contains("pos 80") || prepPrinter.printer_model_name.toLowerCase().contains("yoke4") || prepPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || prepPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                        if (prepPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                            myApp.iMinPrinterUtils.printOrderEposNew(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, printTotalInPrint, footerA, footerB, footerHeading, settingsMap, true, false, myApp.myPreferences);
                            if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && prepLocation.cash_draw) {
                                IminSDKManager.opencashBox();
                            }
                        } else {
                            if (prepPrinter.ip != null && !prepPrinter.ip.equalsIgnoreCase("")) {
                                wifiPrinter.disconnect();
                                CommonFunctions.functionThatDelay(200);
                                wifiPrinter.connect(prepPrinter.ip);
                                CommonFunctions.functionThatDelay(200);
                                if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && prepLocation.cash_draw) {
                                    wifiPrinter.openCashDrawer(false);
                                }
                                wifiPrinter.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printTotalInPrint, footerA, footerB, footerHeading, settingsMap, true, false, myPreferences);
                            } else {
                                try {
                                    if (bluetoothPrinter != null) {
                                        BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                        if (device != null) {
                                            CommonFunctions.functionThatDelay(200);
                                            if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && prepLocation.cash_draw) {
                                                bluetoothPrinter.openCashDrawer(false);
                                                CommonFunctions.functionThatDelay(200);
                                            }
                                            bluetoothPrinter.printEposOrder(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printTotalInPrint, footerA, footerB, footerHeading, true, false);
                                        } else {
                                            // ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                                        }
                                    }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                }
            }
            if (position >= prepOrderItems.size()) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ToastUtils.makeToast(getActivity(), "Kitchen copy true");
            myApp.isCashDrawerOpen = false;
        }
    }
    //Activity Lifecycle related methods ends

    class OrderItemsPrintBlockAsync extends AsyncTask<Integer, Integer, Integer> {
        String title;
        int orderId;
        ArrayList<OrderItem> groupedOrderItems = new ArrayList<>();
        Callable<Void> nextMethod;


        public OrderItemsPrintBlockAsync(String title, int orderId, Callable<Void> nextMethod) {
            this.title = title;
            this.nextMethod = nextMethod;
            this.orderId = orderId;
        }

        @Override
        protected Integer doInBackground(Integer... integers) {
            List<OrderItem> miscOrderItems;
            List<OrderItem> productOrderItems;

            int _split_id = 0;
            if (integers.length > 0) {
                _split_id = integers[0];
                miscOrderItems = appDatabase.orderItemDao().orderItemsMiscForPrint(order._id, _split_id);
                productOrderItems = appDatabase.orderItemDao().orderItemProductForPrint(order._id, _split_id);
            } else {
                miscOrderItems = appDatabase.orderItemDao().orderItemsMiscForPrint(order._id);
                productOrderItems = appDatabase.orderItemDao().orderItemProductForPrint(order._id);
            }

            if (miscOrderItems != null && miscOrderItems.size() > 0) {
                groupedOrderItems.addAll(miscOrderItems);
            }

            if (productOrderItems != null && productOrderItems.size() > 0) {
                groupedOrderItems.addAll(productOrderItems);
            }

            for (int i = 0; i < groupedOrderItems.size(); i++) {
                OrderItem orderItems_object = groupedOrderItems.get(i);
                orderItems_object.order_item_ingredients = (ArrayList<OrderItemIngredient>) appDatabase.orderItemIngredientDao().list(orderItems_object._id);
                orderItems_object.order_item_addons = (ArrayList<OrderItemAddon>) appDatabase.orderItemAddonDao().list(orderItems_object._id);
                groupedOrderItems.set(i, orderItems_object);
            }

            if (_split_id > 0) {
                OrderSplit orderSplit = appDatabase.orderSplitDao().view(_split_id);
                order.total = orderSplit.total;
            }

            return 0;
        }

        @Override
        protected void onPostExecute(Integer integer) {
            super.onPostExecute(integer);
            Order tempOrder = new Gson().fromJson(new Gson().toJson(order), Order.class);
            if (splitByPersonPrint) {
                tempOrder.total = printableTotal;
            }
            tempOrder.order_items = groupedOrderItems;
            for (int i = 0; i < printSettings.size(); i++) {
                if (printSettings.get(i).name.equalsIgnoreCase("Bill")) {
                    printStructure = printSettings.get(i).print_structure;
                    break;
                }
            }

            if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                CommonFunctions.functionThatDelay(250);
                zoneRichPrinter.printOrderEposNew(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, true, footerA, footerB, footerHeading, settingsMap, false, false, myPreferences);
            } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                sunmiPrinter.printOrderEposNew(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, true, footerA, footerB, footerHeading, settingsMap, false, false, myPreferences);
            } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                    myApp.iMinPrinterUtils.printOrderEposNew(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, true, footerA, footerB, footerHeading, settingsMap, false, false, myPreferences);
                } else {
                    if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                        CommonFunctions.functionThatDelay(200);
                        wifiPrinter.connect(defaultPrinter.ip);
                        CommonFunctions.functionThatDelay(200);
                        wifiPrinter.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printTotalInPrint, footerA, footerB, footerHeading, settingsMap, false, false, myPreferences);
                    } else {
                        try {
                            if (bluetoothPrinter != null) {
                                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                if (device != null) {
                                    CommonFunctions.functionThatDelay(200);
                                    bluetoothPrinter.printEposOrder(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printTotalInPrint, footerA, footerB, footerHeading, false, false);
                                } else {
                                    //ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }

            }
            myApp.isCashDrawerOpen = false;
            ToastUtils.makeToast(getActivity(), "Kitchen copy false");
            try {
                nextMethod.call();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class TablesAsyncTask extends AsyncTask<Floor, String, String> {
        boolean autoMode = false;

        @Override
        protected String doInBackground(Floor... strings) {
            try {
                autoMode = myPreferences.getOrderSyncMode().equalsIgnoreCase("auto");
                if (strings.length > 0) {
                    Floor fl = strings[0];
                    if (fl != null) {
                        appDatabase.tableDao().insertMultiple(fl.tables);
                    }

                }
                floor = appDatabase.floorDao().view(floorId);
                if (floor == null) return null;
                floor.tables = (ArrayList<Table>) appDatabase.tableDao().list(floorId);
                if (floor.tables != null) {
                    for (Table table : floor.tables) {
                        Order dbOrder = appDatabase.orderDao().findLastOrderOfTable(table.id);
                        if (dbOrder != null) {
                            table._last_order_id = dbOrder._id;
                            if (!autoMode) {
                                table.last_order_total = dbOrder.total;
                                table.last_order_created_at = dbOrder.created_at;
                            }
                        }
                        if (!Validators.isNullOrEmpty(table.table_status_id))
                            table.table_status = appDatabase.tableStatusDao().view(table.table_status_id);
                        else {
                            LogUtils.e("Tabe status id null che");
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            refreshOnResume = true;
            if (swipeRefreshLayout != null) {
                swipeRefreshLayout.setRefreshing(false);
            }
            if (tables != null) {
                tables.clear();
            }
            if (floor != null && floor.tables != null) {
                if (tables != null) {
                    tables.addAll(floor.tables);
                }
            }
            if (tablesAdapter != null) {
                tablesAdapter.notifyDataSetChanged();
            }
        }

    }

    private class OrderSaveAsyncTask extends AsyncTask<Order, Order, Order> {
        String action;

        public OrderSaveAsyncTask(String action) {
            this.action = action;
        }

        @Override
        protected Order doInBackground(Order... orders) {
            Order order = orders[0];
            Order dbOrder = appDatabase.orderDao().view(order.id);
            if (dbOrder == null) {
                dbOrder = appDatabase.orderDao().viewByUniqueId(order.unique_id);
            }
            if (isCancelled()) return null;
            if (order.order_items != null && order.order_items.size() != 0) {
                Customer dbCustomer = appDatabase.customerDao().view(order.customer_id);
                int _customer_id;
                if (dbCustomer == null) {
                    dbCustomer = order.customer;
                    _customer_id = (int) appDatabase.customerDao().insert(order.customer);
                } else {
                    appDatabase.customerDao().update(dbCustomer);
                    _customer_id = dbCustomer._id;
                }
                order._customer_id = _customer_id;
                order.customer._id = _customer_id;

                int _order_id;
                order.customer_name = dbCustomer.name;
                if (dbOrder == null) {
                    _order_id = (int) appDatabase.orderDao().insert(order);
                } else {
                    order._id = dbOrder._id;
                    appDatabase.orderDao().update(order);
                    _order_id = dbOrder._id;
                }
                order._id = _order_id;

                ArrayList<String> shouldNotDeleteThisIds = new ArrayList<>();
                if (order.order_splits != null) {
                    for (OrderSplit split : order.order_splits) {
                        shouldNotDeleteThisIds.add(split.id);
                        split._order_id = _order_id;
                        OrderSplit dbSplit = appDatabase.orderSplitDao().view(split.id);
                        if (dbSplit == null) {
                            split._id = (int) appDatabase.orderSplitDao().insert(split);
                        } else {
                            split._id = dbSplit._id;
                            appDatabase.orderSplitDao().update(split);
                        }
                    }
                }
                appDatabase.orderSplitDao().deleteOtherIdsButNotThis(_order_id, shouldNotDeleteThisIds);

                shouldNotDeleteThisIds = new ArrayList<>();
                if (order.order_payments != null) {
                    for (OrderPayment payment : order.order_payments) {
                        shouldNotDeleteThisIds.add(payment.id);
                        payment._order_id = _order_id;
                        OrderPayment dbPayment = appDatabase.orderPaymentDao().view(payment.id);
                        if (dbPayment == null) {
                            payment._id = (int) appDatabase.orderPaymentDao().insert(payment);
                        } else {
                            payment._id = dbPayment._id;
                        }
                        if (!Validators.isNullOrEmpty(payment.order_split_id)) {
                            OrderSplit dbOrderSplit = appDatabase.orderSplitDao().view(payment.order_split_id);
                            if (dbOrderSplit != null)
                                payment._order_split_id = dbOrderSplit._id;
                        }
                        appDatabase.orderPaymentDao().update(payment);
                    }
                }

                appDatabase.orderPaymentDao().deleteOtherIdsButNotThis(_order_id, shouldNotDeleteThisIds);
                if (order.order_items != null) {
                    appDatabase.orderItemDao().deleteAll(_order_id);
                    for (OrderItem orderItem : order.order_items) {
                        orderItem._order_id = _order_id;
                        OrderItem dbOrderItem = myApp.appDatabase.orderItemDao().view(orderItem.id);

                        if (!Validators.isNullOrEmpty(orderItem.order_split_id)) {
                            OrderSplit orderSplit = appDatabase.orderSplitDao().view(orderItem.order_split_id);
                            if (orderSplit != null) orderItem._order_split_id = orderSplit._id;
                        }

                        int _order_item_id;
                        if (dbOrderItem == null) {
                            _order_item_id = (int) appDatabase.orderItemDao().insert(orderItem);
                        } else {
                            _order_item_id = dbOrderItem._id;
                            appDatabase.orderItemDao().update(dbOrderItem);
                        }

                        float addonTotal = 0;
                        shouldNotDeleteThisIds = new ArrayList<>();
                        if (orderItem.order_item_addons != null) {
                            for (OrderItemAddon itemAddon : orderItem.order_item_addons) {
                                shouldNotDeleteThisIds.add(itemAddon.id);
                                itemAddon._order_item_id = _order_item_id;
                                itemAddon.total = itemAddon.quantity * itemAddon.price;
                                addonTotal = addonTotal + itemAddon.total;
                                OrderItemAddon dbAddon = appDatabase.orderItemAddonDao().view(itemAddon.id);
                                if (dbAddon == null) {
                                    itemAddon._id = (int) appDatabase.orderItemAddonDao().insert(itemAddon);
                                } else {
                                    itemAddon._id = dbAddon._id;
                                    appDatabase.orderItemAddonDao().update(itemAddon);
                                }
                            }
                        }
                        appDatabase.orderItemAddonDao().deleteOtherIdsButNotThis(_order_item_id, shouldNotDeleteThisIds);

                        float ingredientTotal = 0;
                        if (orderItem.order_item_ingredients != null) {
                            appDatabase.orderItemIngredientDao().deleteAll(_order_item_id);
                            for (OrderItemIngredient itemIngredient : orderItem.order_item_ingredients) {
                                itemIngredient._order_item_id = _order_item_id;
                                itemIngredient.total = itemIngredient.quantity * itemIngredient.price;
                                ingredientTotal = ingredientTotal + itemIngredient.total;
                                OrderItemIngredient dbAddon = appDatabase.orderItemIngredientDao().view(itemIngredient.id);
                                if (dbAddon == null) {
                                    itemIngredient._id = (int) appDatabase.orderItemIngredientDao().insert(itemIngredient);
                                } else {
                                    itemIngredient._id = dbAddon._id;
                                    appDatabase.orderItemIngredientDao().update(itemIngredient);
                                }
                            }
                        }

                        ingredientTotal = ingredientTotal * orderItem.quantity;
                        addonTotal = addonTotal * orderItem.quantity;
                        myApp.appDatabase.orderItemDao().updateOrderItemTotal(_order_item_id, addonTotal, ingredientTotal);
                    }
                }

                OrderWithItems orderWithItems = myApp.appDatabase.orderDao().orderWithItems(order._id);

                order = orderWithItems.order;
                order.order_payments = (ArrayList<OrderPayment>) orderWithItems.orderPayments;
                order.order_splits = (ArrayList<OrderSplit>) orderWithItems.orderSplits;
                order.order_items = new ArrayList<>();
                order.customer = myApp.appDatabase.customerDao().view(order._customer_id);
                for (OrderItemWithAddonsIngredients item : orderWithItems.orderItems) {
                    OrderItem orderItem = item.orderItem;
                    orderItem.order_item_addons = (ArrayList<OrderItemAddon>) item.orderItemAddons;
                    orderItem.order_item_ingredients = (ArrayList<OrderItemIngredient>) item.orderItemIngredients;
                    order.order_items.add(orderItem);
                }
            } else {
                if (action != null && action.equalsIgnoreCase("open")) {
                    // updating value of the uploading on server boolean
                    if (dbOrder != null && dbOrder._id != 0) {
                        dbOrder.is_uploaded_on_server = false;
                        appDatabase.orderDao().update(dbOrder);
                    }
                    return dbOrder;
                } else {
                    if (dbOrder != null && dbOrder._id != 0) {
                        order._id = dbOrder._id;
                        appDatabase.orderDao().update(order);
                    }
                    return order;
                }
            }
            return order;
        }

        @Override
        protected void onPostExecute(Order order) {
            super.onPostExecute(order);
            progressBarDialog.dismiss();
            refreshOnResume = true;
            if (action != null && !action.equalsIgnoreCase("update")) {
                if (action.equalsIgnoreCase("cancel_order") || action.equalsIgnoreCase("complete_order")) {
                    changeTableStatus(order, vacantStatus.id, vacantStatus.status);
                    Intent intent = new Intent(getActivity(), SingleOrderUploaderService.class);
                    intent.putExtra("_order_id", order._id);
                    getActivity().startService(intent);
                } else if (action.equalsIgnoreCase("serve_order")) {
                    changeTableStatus(order, servedStatus.id, servedStatus.status);
                    Intent intent = new Intent(getActivity(), SingleOrderUploaderService.class);
                    intent.putExtra("_order_id", order._id);
                    getActivity().startService(intent);
                } else if (action.equalsIgnoreCase("pay_order")) {
                    startActivityForResult(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(order)).putExtra("destination", "pay_bill"), Constants.CODE_REFRESH);
                } else {
                    startActivityForResult(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(order)), Constants.CODE_REFRESH);
                }
            } else {
                startActivityForResult(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(order)), Constants.CODE_REFRESH);
            }
        }
    }

    private class OrderSaveAsyncTask_ extends AsyncTask<Order, Order, Order> {
        String action;
        int orderId;

        public OrderSaveAsyncTask_(String action, String orderId) {
            this.action = action;
            this.orderId = Integer.parseInt(orderId);
        }

        @Override
        protected Order doInBackground(Order... orders) {
            Order order = orders[0];
            Order dbOrder = appDatabase.orderDao().view(order.id);
            if (dbOrder == null) {
                dbOrder = appDatabase.orderDao().viewByUniqueId(order.unique_id);
            }
            if (isCancelled()) return null;
            Customer dbCustomer = appDatabase.customerDao().view(order.customer_id);
            int _customer_id;
            if (dbCustomer == null) {
                dbCustomer = order.customer;
                _customer_id = (int) appDatabase.customerDao().insert(order.customer);
            } else {
                appDatabase.customerDao().update(dbCustomer);
                _customer_id = dbCustomer._id;
            }
            order._customer_id = _customer_id;
            order.customer._id = _customer_id;

            int _order_id;
            order.customer_name = dbCustomer.name;
            if (dbOrder == null) {
                _order_id = (int) appDatabase.orderDao().insert(order);
            } else {
                order._id = dbOrder._id;
                appDatabase.orderDao().update(order);
                _order_id = dbOrder._id;
            }
            order._id = _order_id;

            ArrayList<String> shouldNotDeleteThisIds = new ArrayList<>();
            if (order.order_splits != null) {
                for (OrderSplit split : order.order_splits) {
                    shouldNotDeleteThisIds.add(split.id);
                    split._order_id = _order_id;
                    OrderSplit dbSplit = appDatabase.orderSplitDao().view(split.id);
                    if (dbSplit == null) {
                        split._id = (int) appDatabase.orderSplitDao().insert(split);
                    } else {
                        split._id = dbSplit._id;
                        appDatabase.orderSplitDao().update(split);
                    }
                }
            }
            appDatabase.orderSplitDao().deleteOtherIdsButNotThis(_order_id, shouldNotDeleteThisIds);

            shouldNotDeleteThisIds = new ArrayList<>();
            if (order.order_payments != null) {
                for (OrderPayment payment : order.order_payments) {
                    shouldNotDeleteThisIds.add(payment.id);
                    payment._order_id = _order_id;
                    OrderPayment dbPayment = appDatabase.orderPaymentDao().view(payment.id);
                    if (dbPayment == null) {
                        payment._id = (int) appDatabase.orderPaymentDao().insert(payment);
                    } else {
                        payment._id = dbPayment._id;
                    }
                    if (!Validators.isNullOrEmpty(payment.order_split_id)) {
                        OrderSplit dbOrderSplit = appDatabase.orderSplitDao().view(payment.order_split_id);
                        if (dbOrderSplit != null)
                            payment._order_split_id = dbOrderSplit._id;
                    }
                    appDatabase.orderPaymentDao().update(payment);
                }
            }

            appDatabase.orderPaymentDao().deleteOtherIdsButNotThis(_order_id, shouldNotDeleteThisIds);
            if (order.order_items != null) {
                appDatabase.orderItemDao().deleteAll(_order_id);
                for (OrderItem orderItem : order.order_items) {
                    orderItem._order_id = _order_id;
                    OrderItem dbOrderItem = myApp.appDatabase.orderItemDao().view(orderItem.id);

                    if (!Validators.isNullOrEmpty(orderItem.order_split_id)) {
                        OrderSplit orderSplit = appDatabase.orderSplitDao().view(orderItem.order_split_id);
                        if (orderSplit != null) orderItem._order_split_id = orderSplit._id;
                    }

                    int _order_item_id;
                    if (dbOrderItem == null) {
                        _order_item_id = (int) appDatabase.orderItemDao().insert(orderItem);
                    } else {
                        _order_item_id = dbOrderItem._id;
                        appDatabase.orderItemDao().update(dbOrderItem);
                    }

                    float addonTotal = 0;
                    shouldNotDeleteThisIds = new ArrayList<>();
                    if (orderItem.order_item_addons != null) {
                        for (OrderItemAddon itemAddon : orderItem.order_item_addons) {
                            shouldNotDeleteThisIds.add(itemAddon.id);
                            itemAddon._order_item_id = _order_item_id;
                            itemAddon.total = itemAddon.quantity * itemAddon.price;
                            addonTotal = addonTotal + itemAddon.total;
                            OrderItemAddon dbAddon = appDatabase.orderItemAddonDao().view(itemAddon.id);
                            if (dbAddon == null) {
                                itemAddon._id = (int) appDatabase.orderItemAddonDao().insert(itemAddon);
                            } else {
                                itemAddon._id = dbAddon._id;
                                appDatabase.orderItemAddonDao().update(itemAddon);
                            }
                        }
                    }
                    appDatabase.orderItemAddonDao().deleteOtherIdsButNotThis(_order_item_id, shouldNotDeleteThisIds);

                    float ingredientTotal = 0;
                    if (orderItem.order_item_ingredients != null) {
                        appDatabase.orderItemIngredientDao().deleteAll(_order_item_id);
                        for (OrderItemIngredient itemIngredient : orderItem.order_item_ingredients) {
                            itemIngredient._order_item_id = _order_item_id;
                            itemIngredient.total = itemIngredient.quantity * itemIngredient.price;
                            ingredientTotal = ingredientTotal + itemIngredient.total;
                            OrderItemIngredient dbAddon = appDatabase.orderItemIngredientDao().view(itemIngredient.id);
                            if (dbAddon == null) {
                                itemIngredient._id = (int) appDatabase.orderItemIngredientDao().insert(itemIngredient);
                            } else {
                                itemIngredient._id = dbAddon._id;
                                appDatabase.orderItemIngredientDao().update(itemIngredient);
                            }
                        }
                    }

                    ingredientTotal = ingredientTotal * orderItem.quantity;
                    addonTotal = addonTotal * orderItem.quantity;
                    myApp.appDatabase.orderItemDao().updateOrderItemTotal(_order_item_id, addonTotal, ingredientTotal);
                }
            }

            OrderWithItems orderWithItems = myApp.appDatabase.orderDao().orderWithItems(order._id);

            order = orderWithItems.order;
            order.order_payments = (ArrayList<OrderPayment>) orderWithItems.orderPayments;
            order.order_splits = (ArrayList<OrderSplit>) orderWithItems.orderSplits;
            order.order_items = new ArrayList<>();
            order.customer = myApp.appDatabase.customerDao().view(order._customer_id);
            for (OrderItemWithAddonsIngredients item : orderWithItems.orderItems) {
                OrderItem orderItem = item.orderItem;
                orderItem.order_item_addons = (ArrayList<OrderItemAddon>) item.orderItemAddons;
                orderItem.order_item_ingredients = (ArrayList<OrderItemIngredient>) item.orderItemIngredients;
                order.order_items.add(orderItem);
            }

            return order;
        }

        @Override
        protected void onPostExecute(Order order_) {
            super.onPostExecute(order);
            progressBarDialog.dismiss();
            refreshOnResume = true;

            order = order_;

            if (!myApp.myPreferences.getRemoteDeviceEnableStatus()) {
                // print order by default if device is in local mode
                createBillPrint("", true, false, false, orderId);
                createBillPrint("", false, true, false, orderId);
            }
        }
    }
    // All Broadcast receivers Ends

    public MergeInfoDialogFragment getInstance(String title, String info, int type, String positiveButton, String negativeButton, String tableId) {
        MergeInfoDialogFragment rejectReasonDialog = new MergeInfoDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("title", title);
        bundle.putString("info", info);
        bundle.putString("positive_button", positiveButton);
        bundle.putString("negative_button", negativeButton);
        bundle.putInt("type", type);
        bundle.putString("tableId", tableId);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    public NewDineinOrderDialogFragment getInstanceNewDineinOrder(Table table) {
        Bundle bundle = new Bundle();
        NewDineinOrderDialogFragment fragment = new NewDineinOrderDialogFragment();
        bundle.putString("table", new Gson().toJson(table));
        fragment.setArguments(bundle);
        return fragment;
    }

    private void clearAdapter() {
        if (tablesAdapter != null) {
            tablesAdapter.itemClickListener = null;
            tablesAdapter.homeActionClickListener = null;
            tablesAdapter.tmr.cancel();
            tablesAdapter.tmr = null;
            tablesAdapter.handler.removeCallbacks(tablesAdapter.updateTime);
            tablesAdapter.handler.removeCallbacks(null);
            tablesAdapter.handler = null;
            tablesAdapter.myApp = null;
        }
        tablesAdapter = null;
    }

}
