package com.ubsidi.epos_2021.fragment;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.chip.Chip;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.TableLockingAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.Table;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.services.SingleOrderUploaderService;
import com.ubsidi.epos_2021.utils.Constants;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Amrish on 18-06-2021.
 */
public class TablesLockingStatusFragment extends BaseFragment {
    private SwipeRefreshLayout swipeRefreshLayout;
    private TableLockingAdapter tableLockingAdapter;
    private ArrayList<Object> objects = new ArrayList<>();
    private ArrayList<Table> tables = new ArrayList<>();
    private AlertDialog progressBarDialog;

    @Nullable
    @Override
    public View onCreateView(@NonNull @NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_tables_locking_status, container, false);
    }

    @Override
    public void onViewCreated(@NonNull @NotNull View view, @Nullable @org.jetbrains.annotations.Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            fetchTables();
            swipeRefreshLayout.setOnRefreshListener(this::fetchTables);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            progressBarDialog = CommonFunctions.customProgressDialog(getActivity(), "");
            Chip chipBack = view.findViewById(R.id.chipBack);
            swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
            RecyclerView rvTables = view.findViewById(R.id.rvTables);
            int spanCount = 4;
            if (myApp.screenWidth > 2000) {
                spanCount = 6;
            } else if (myApp.screenWidth > 1600) {
                spanCount = 5;
            }
            GridLayoutManager gridLayoutManager = new GridLayoutManager(getActivity(), spanCount);
            rvTables.setLayoutManager(gridLayoutManager);
            tableLockingAdapter = new TableLockingAdapter(objects, (position, data) -> {
                changeTableStatus((Table) data);
            });
            rvTables.setAdapter(tableLockingAdapter);

            chipBack.setOnClickListener(view1 -> getActivity().onBackPressed());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeTableStatus(Table table) {
        try {
            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Successful", "Table status changed successfully", 1, "Okay", null);
            confirmationDialogFragment.show(getChildFragmentManager(), "status");
            confirmationDialogFragment.setDialogDismissListener(o -> {
                try {
                    uploadOrder(table._last_order_id);
                    unlockableTable = table;
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    Table unlockableTable;

    private void uploadOrder(int orderId) {
        try {
            progressBarDialog.show();
            Intent intent = new Intent(getActivity(), SingleOrderUploaderService.class);
            intent.putExtra("_order_id", orderId);
            getActivity().startService(intent);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void unlockTable(Table table) {
        try {
            new Thread(() -> {
                table.locked = false;
                appDatabase.tableDao().insert(table);
                if (getActivity() != null) getActivity().runOnUiThread(() -> {
                    tableLockingAdapter.notifyDataSetChanged();
                });
                AndroidNetworking.post(ApiEndPoints.tables + table.id)
                        .addApplicationJsonBody(table)
                        .build()
                        .getAsObject(Table.class, new ParsedRequestListener() {
                            @Override
                            public void onResponse(Object response) {
                                try {
                                    unlockableTable = null;
                                    fetchTables();
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }

                            @Override
                            public void onError(ANError anError) {

                            }
                        });
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchTables() {
        try {
            if (!myApp.isConnected(getActivity())) {
                new TablesAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                return;
            }
            swipeRefreshLayout.setRefreshing(true);
            AndroidNetworking.get(ApiEndPoints.tables)
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(Table.class, new ParsedRequestListener<List<Table>>() {
                        @Override
                        public void onResponse(List<Table> response) {
                            try {
                                new TablesAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, response);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            new TablesAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class TablesAsyncTask extends AsyncTask<List<Table>, String, String> {

        @Override
        protected String doInBackground(List<Table>... tablesParam) {
            try {
                if (tablesParam.length > 0) {
                    List<Table> tabs = tablesParam[0];

                    for (Table table : tabs) {
                        if (!Validators.isNullOrEmpty(table.table_status_id))
                            table.table_status = appDatabase.tableStatusDao().view(table.table_status_id);
                        Order dbOrder = appDatabase.orderDao().findLastOrderOfTable(table.id);
                        if (dbOrder != null) {
                            table._last_order_id = dbOrder._id;
                            table.last_order_total = dbOrder.total;
                            table.last_order_created_at = dbOrder.created_at;
                        }
                    }
                    tables.clear();
                    tables.addAll(tabs);
                    objects.clear();
                    objects.addAll(tables);
                } else {
                    tables.clear();
                    tables.addAll(appDatabase.tableDao().list());
                    objects.clear();
                    objects.addAll(tables);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                swipeRefreshLayout.setRefreshing(false);
                tableLockingAdapter.notifyDataSetChanged();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onResume() {
        super.onResume();

        try {
            if (getActivity() != null && orderUpdateReceiver != null)
                LocalBroadcastManager.getInstance(getActivity()).registerReceiver(orderUpdateReceiver, new IntentFilter(
                        Constants.EPOS_ORDER_UPDATE));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        try {
            if (getActivity() != null && orderUpdateReceiver != null) {
                LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(orderUpdateReceiver);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    BroadcastReceiver orderUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("result", false)) {
                    progressBarDialog.dismiss();
                    if (unlockableTable != null)
                        unlockTable(unlockableTable);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
}
