package com.ubsidi.epos_2021.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;

import com.bumptech.glide.Glide;
import com.google.android.material.chip.Chip;
import com.mikhaellopez.circularimageview.CircularImageView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;

public class UserDetailsDialogFragment extends DialogFragment {

    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private DialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    private Chip chipBack;
    private ImageView ivCall, ivMessage;

    private String customer_logo, customer_name, customer_phone;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (getArguments() != null) {
            customer_name = getArguments().getString("customer_name");
            customer_phone = getArguments().getString("customer_phone");
            customer_logo = getArguments().getString("customer_logo");
        }
        return inflater.inflate(R.layout.dialog_user_info, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            chipBack.setOnClickListener(v -> dismiss());

            ivCall.setOnClickListener(v -> {
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss(customer_phone);
                dismiss();
            });
            ivMessage.setOnClickListener(v -> {
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss("compose");
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initViews(View view) {
        try {
            chipBack = view.findViewById(R.id.chipBack);
            CircularImageView ivLogo = view.findViewById(R.id.ivLogo);
            TextView tvCustomerName = view.findViewById(R.id.tvCustomerName);
            ivCall = view.findViewById(R.id.ivCall);
            ivMessage = view.findViewById(R.id.ivChat);
            RelativeLayout rlCall = view.findViewById(R.id.rlCall);
            RelativeLayout rlDelete = view.findViewById(R.id.rlDelete);
            LinearLayout llContact = view.findViewById(R.id.llContact);
            LinearLayout llEmail = view.findViewById(R.id.llEmail);
            LinearLayout llAddress = view.findViewById(R.id.llAddress);
            TextView tvMobile = view.findViewById(R.id.tvContactNumber);

            rlDelete.setVisibility(View.GONE);
            llEmail.setVisibility(View.GONE);
            llAddress.setVisibility(View.GONE);

            if (!Validators.isNullOrEmpty(customer_logo)) {
                Glide.with(getActivity())
                        .load(customer_logo)
                        .placeholder(R.drawable.avatar_logo_placeholder)
                        .error(R.drawable.avatar_logo_placeholder)
                        .into(ivLogo);
            } else {
                ivLogo.setImageResource(R.drawable.avatar_logo_placeholder);
            }

            if (!Validators.isNullOrEmpty(customer_phone)) {
                tvMobile.setText(customer_phone);
                llContact.setVisibility(View.VISIBLE);
                rlCall.setVisibility(View.VISIBLE);
            } else {
                llContact.setVisibility(View.GONE);
                rlCall.setVisibility(View.GONE);
            }

            if (!Validators.isNullOrEmpty(customer_name)) {
                tvCustomerName.setText(customer_name);
                tvCustomerName.setVisibility(View.VISIBLE);
            } else {
                tvCustomerName.setVisibility(View.GONE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
