package com.ubsidi.epos_2021.fragment;


import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.google.android.material.textfield.MaterialAutoCompleteTextView;
import com.google.gson.Gson;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.CustomerAutoSuggestAdapter;
import com.ubsidi.epos_2021.adapters.DateAdapter;
import com.ubsidi.epos_2021.adapters.MinimumOrderAdapter;
import com.ubsidi.epos_2021.adapters.VoucherOrderType;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.MoneyTextWatcher;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinterV3Mix;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.ExclusionModel;
import com.ubsidi.epos_2021.models.OrderType;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.Voucher;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.services.SingleVoucherUploadService;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;
import com.wdullaer.materialdatetimepicker.date.DatePickerDialog;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;

public class VoucherFragment extends BaseFragment {
    private EditText etName, etContectNumber, etMinimumAmount, etEmailAddress, etValidFrom, etVoucherAmount,etMinimumOrderAmount;
    private MaterialAutoCompleteTextView etSearchCustomer;
    private CheckBox chkNoExpiry;
    private TextView tvValidUntil, tvVoucherCode, tvVoucherHistory, tvMinimumAmount,txtMinimumOrderAmount;
    private LinearLayout llCustomMinimumAmount;
    private MaterialButton btnUpdate, btnCancel;
    private ArrayList<ExclusionModel> daysList = new ArrayList<>();
    private ArrayList<OrderType> orderTypeList = new ArrayList<>();
    private ArrayList<ExclusionModel> minimumOrderList = new ArrayList<>();
    private ArrayList<Customer> customers = new ArrayList<>();
    private DateAdapter dateAdapter;
    private MinimumOrderAdapter minimumOrderAdapter;
    private VoucherOrderType voucherOrderType;
    private AlertDialog progressBarDialog;
    private Voucher voucher;
    private int _voucher_id;
    private OrderType orderType;
    private boolean fromPicker;
    private Customer selectedCustomer;
    private ExclusionModel minimumOrder;
    private ExclusionModel daySelected;
    private Calendar myCalendar = Calendar.getInstance();
    private CustomerAutoSuggestAdapter customerAutoSuggestAdapter;
    private ZoneRichPrinter zoneRichPrinter;
    private WifiPrinter wifiPrinter;
    public BluetoothPrinter bluetoothPrinter;
    private SunmiPrinter sunmiPrinter;
    private SunmiPrinterV3Mix sunmiPrinterV3Mix;
    private Printer defaultPrinter;
    private int headerAlignment = 0;
    private SiteSetting ticketHeaderSetting;
    private SiteSetting footerASetting;
    private SiteSetting footerBSetting;
    private Date fromDate, toDate;
    private Chip chipBack;
    private String voucher_amount = "0", minimum_amount = "0";

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getArguments() != null) {
            voucher = new Gson().fromJson(getArguments().getString("voucher"), Voucher.class);
            _voucher_id = getArguments().getInt("_voucher_id", 0);
            if (voucher != null && _voucher_id == 0) {
                _voucher_id = voucher._id;
            }
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_voucher, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initView(view);
            setListener();
            fetchCustomers();
            setUpDate();
            setUpMinimumOrder();
            fetchOrderType();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void initView(View view) {
        try {
            loadSettings();
            defaultPrinter = myPreferences.getDefaultPrinter();
            zoneRichPrinter = new ZoneRichPrinter(getActivity());
            zoneRichPrinter = myApp.connectZonerich(zoneRichPrinter, defaultPrinter);
            wifiPrinter = WifiPrinter.getInstance();
            bluetoothPrinter = new BluetoothPrinter(getActivity());
            sunmiPrinter = new SunmiPrinter(getActivity());
            if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                sunmiPrinterV3Mix = new SunmiPrinterV3Mix(requireActivity());
            }
            progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
            etSearchCustomer = view.findViewById(R.id.etSearchCustomer);
            etValidFrom = view.findViewById(R.id.etValidFrom);
            tvVoucherHistory = view.findViewById(R.id.tvVoucherHistory);
            tvVoucherCode = view.findViewById(R.id.tvVoucherCode);
            tvValidUntil = view.findViewById(R.id.tvValidUntil);
            btnUpdate = view.findViewById(R.id.btnUpdate);
            btnCancel = view.findViewById(R.id.btnCancel);
            etVoucherAmount = view.findViewById(R.id.etVoucherAmount);
            etMinimumOrderAmount = view.findViewById(R.id.etMinimumOrderAmount);
            chkNoExpiry = view.findViewById(R.id.chkNoExpiry);
            //RecyclerView rvMinimumOrder = view.findViewById(R.id.rvMinimumOrder);
            RecyclerView rvOrderType = view.findViewById(R.id.rvOrderType);
            RecyclerView rvDays = view.findViewById(R.id.rvDays);
            etName = view.findViewById(R.id.etName);
            etContectNumber = view.findViewById(R.id.etContectNumber);
            etEmailAddress = view.findViewById(R.id.etEmailAddress);
            etMinimumAmount = view.findViewById(R.id.etMinimumAmount);
            llCustomMinimumAmount = view.findViewById(R.id.llCustomMinimumAmount);
            txtMinimumOrderAmount = view.findViewById(R.id.txtMinimumOrderAmount);
            tvMinimumAmount = view.findViewById(R.id.tvMinimumAmount);
            chipBack = view.findViewById(R.id.chipBack);
            etSearchCustomer.setThreshold(3);
            customerAutoSuggestAdapter = new CustomerAutoSuggestAdapter(getActivity(), customers);
            etSearchCustomer.setAdapter(customerAutoSuggestAdapter);

            dateAdapter = new DateAdapter(daysList, (position, data) -> {
                try {
                    daySelected = (ExclusionModel) data;
                    daySelected.isChecked = !daySelected.isChecked;
                    dateAdapter.notifyDataSetChanged();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });

            /*minimumOrderAdapter = new MinimumOrderAdapter(minimumOrderList, (position, data) -> {
                minimumOrder = (ExclusionModel) data;
                if (minimumOrder.name.equalsIgnoreCase("Custom")) {
                    EnterVoucherAmountDialogFragment dialogFragment = getInstanceEnterVoucherAmount("voucher_amount", "Minimum voucher amount", "Please enter minimum voucher amount", Float.parseFloat(minimum_amount));
                    dialogFragment.show(getChildFragmentManager(), "voucer_amount");
                    dialogFragment.setDialogDismissListener(o -> {
                        try {
                            if (o instanceof String) {
                                String amount = (String) o;
                                minimum_amount = amount;
                                tvMinimumAmount.setVisibility(View.VISIBLE);
                                tvMinimumAmount.setText("Minimum Order: " + myApp.currencySymbol + amount);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                    dialogFragment.setCancelable(false);
                } else {
                    tvMinimumAmount.setVisibility(View.GONE);
                }
                minimumOrderAdapter.notifyDataSetChanged();
            });*/

            voucherOrderType = new VoucherOrderType(orderTypeList, (position, data) -> {
                try {
                    orderType = (OrderType) data;
                    orderType.isChecked = !orderType.isChecked;
                    voucherOrderType.notifyDataSetChanged();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });

            rvOrderType.setLayoutManager(new LinearLayoutManager(getActivity(), LinearLayoutManager.VERTICAL, false));
            rvOrderType.setAdapter(voucherOrderType);

            rvDays.setLayoutManager(new LinearLayoutManager(getActivity(), LinearLayoutManager.VERTICAL, false));
            rvDays.setAdapter(dateAdapter);

            //rvMinimumOrder.setLayoutManager(new LinearLayoutManager(getActivity(), LinearLayoutManager.VERTICAL, false));
            //rvMinimumOrder.setAdapter(minimumOrderAdapter);

            tvVoucherCode.setText(getSaltString());
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void setListener() {

        try {
            chipBack.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    getActivity().onBackPressed();
                }
            });
            //etVoucherAmount.addTextChangedListener(new MoneyTextWatcher(etVoucherAmount));
            etMinimumAmount.addTextChangedListener(new MoneyTextWatcher(etMinimumAmount));
            etMinimumOrderAmount.setOnClickListener(v -> {
                try {
                    EnterVoucherAmountDialogFragment dialogFragment = getInstanceEnterVoucherAmountForVoucher("minimum_order_voucher_amount", "Minimum Order amount", "Please enter minimum order amount",Validators.isNullOrEmpty(minimum_amount) ? 0F:Float.parseFloat(minimum_amount), Float.parseFloat(voucher_amount));
                    dialogFragment.show(getChildFragmentManager(), "voucher_amount");
                    dialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            minimum_amount = (String) o;
                            if (!Validators.isNullOrEmpty(minimum_amount)){
                                etMinimumOrderAmount.setText(myApp.currencySymbol + minimum_amount);
                            }
                        }
                    });
                    dialogFragment.setCancelable(false);
                } catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            });
            etVoucherAmount.setOnClickListener(v -> {
                try {
                    EnterVoucherAmountDialogFragment dialogFragment = getInstanceEnterVoucherAmount("voucher_amount", "Voucher amount", "Please enter voucher amount", Float.parseFloat(voucher_amount));
                    dialogFragment.show(getChildFragmentManager(), "voucher_amount");
                    dialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            voucher_amount = (String) o;
                            if (!Validators.isNullOrEmpty(voucher_amount)){
                                minimum_amount ="";
                                etMinimumOrderAmount.setText(minimum_amount);
                                etVoucherAmount.setText(myApp.currencySymbol + voucher_amount);
                                if(Float.parseFloat(voucher_amount)>0){
                                    txtMinimumOrderAmount.setVisibility(View.VISIBLE);
                                    etMinimumOrderAmount.setVisibility(View.VISIBLE);
                                }
                            }
                        }
                    });
                    dialogFragment.setCancelable(false);
                } catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            });
            etSearchCustomer.setOnItemClickListener((adapterView, view, i, l) -> {
                try {
                    int indext = customers.indexOf(adapterView.getItemAtPosition(i));
                    if (indext != -1) {
                        selectedCustomer = customers.get(indext);
                        etName.setText(selectedCustomer.name);
                        etContectNumber.setText(selectedCustomer.mobile);
                        etEmailAddress.setText(selectedCustomer.email);
                        new Thread(() -> {
                            if (selectedCustomer._id == 0 && !Validators.isNullOrEmpty(selectedCustomer.id)) {
                                selectedCustomer._id = (int) appDatabase.customerDao().insert(selectedCustomer);
                            }
                        }).start();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });

            DatePickerDialog.OnDateSetListener datePicker = new DatePickerDialog.OnDateSetListener() {
                @Override
                public void onDateSet(DatePickerDialog view, int year, int month, int dayOfMonth) {
                    myCalendar.set(Calendar.YEAR, year);
                    myCalendar.set(Calendar.MONTH, month);
                    myCalendar.set(Calendar.DAY_OF_MONTH, dayOfMonth);

                    if (fromPicker) {
                        myCalendar.set(Calendar.HOUR_OF_DAY, 0);
                        myCalendar.set(Calendar.MINUTE, 0);
                        fromDate = myCalendar.getTime();
                        etValidFrom.setText(CommonFunctions.convertMsToDesiredFormat(fromDate.getTime(), "dd-MM-yyyy"));
                    } else {
                        myCalendar.set(Calendar.HOUR_OF_DAY, 23);
                        myCalendar.set(Calendar.MINUTE, 59);
                        toDate = myCalendar.getTime();
                        tvValidUntil.setText(CommonFunctions.convertMsToDesiredFormat(toDate.getTime(), "dd-MM-yyyy"));
                    }
                }

            };

            etValidFrom.setOnClickListener(v -> {
                try {
                    fromPicker = true;
                    if (fromDate != null)
                        myCalendar.setTime(fromDate);
                    DatePickerDialog datePickerDialog = DatePickerDialog.newInstance(datePicker, myCalendar
                                    .get(Calendar.YEAR), myCalendar.get(Calendar.MONTH),
                            myCalendar.get(Calendar.DAY_OF_MONTH));
                    datePickerDialog.setThemeDark(false);
                    datePickerDialog.showYearPickerFirst(false);
                    datePickerDialog.show(getActivity().getFragmentManager(), "FromDatePickerDialog");
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });

            tvValidUntil.setOnClickListener(v -> {
                try {
                    fromPicker = false;
                    DatePickerDialog datePickerDialog = DatePickerDialog.newInstance(datePicker, myCalendar
                                    .get(Calendar.YEAR), myCalendar.get(Calendar.MONTH),
                            myCalendar.get(Calendar.DAY_OF_MONTH));
                    datePickerDialog.setThemeDark(false);
                    datePickerDialog.showYearPickerFirst(false);
                    datePickerDialog.show(getActivity().getFragmentManager(), "UntilDatePickerDialog");
                    if (fromDate != null) {
                        datePickerDialog.setMinDate(myCalendar);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });

            chkNoExpiry.setOnCheckedChangeListener((buttonView, isChecked) -> {
                if (isChecked) {
                    tvValidUntil.setText("");
                    tvValidUntil.setHint("No Expiry");
                    tvValidUntil.setEnabled(false);
                } else {
                    tvValidUntil.setHint("Valid Until*");
                    tvValidUntil.setEnabled(true);
                }
            });

            tvVoucherHistory.setOnClickListener(view -> {
                goBack();
            });

            btnUpdate.setOnClickListener(v -> {
                if (isValid())
                    if (myApp.isConnected(getActivity()))
                        addVoucher();
                    else {
                        ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("No internet", "Please check your internet connection", 2, "OKAY", null);
                        confirmationDialogFragment.show(getChildFragmentManager(), "no_net");
                    }
            });

            btnCancel.setOnClickListener(v -> goBack());
            tvVoucherCode.setOnClickListener(v -> {
                try {
                    ClipboardManager clipboard = (ClipboardManager) getActivity().getSystemService(Context.CLIPBOARD_SERVICE);
                    ClipData clip = ClipData.newPlainText("voucher_code", tvVoucherCode.getText().toString());
                    clipboard.setPrimaryClip(clip);
                    ToastUtils.makeToast(requireContext(), "Text copied to clipboard");
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateView() {
        if (voucher != null) {
            selectedCustomer = voucher.customer;
            etName.setText(voucher.customer_name);
            etContectNumber.setText(voucher.customer_mobile);
            etEmailAddress.setText(voucher.customer_email);
            voucher_amount = String.valueOf(voucher.voucher_amount);
            minimum_amount = String.valueOf(voucher.minimum_order_value);
            etVoucherAmount.setText(myApp.currencySymbol + MyApp.df.format(voucher.voucher_amount));
            if(voucher.voucher_amount>0){
                txtMinimumOrderAmount.setVisibility(View.VISIBLE);
                etMinimumOrderAmount.setVisibility(View.VISIBLE);
            }
            tvVoucherCode.setText(voucher.voucher_code);
            etValidFrom.setText(CommonFunctions.formatUnknownDateTime(voucher.start_date, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy"));
            fromDate = CommonFunctions.convertToDate(voucher.start_date, Constants.PHP_DATE_TIME_FORMAT);
            if (!Validators.isNullOrEmpty(voucher.end_date)) {
                if (voucher.end_date.contains("203")) {
                    chkNoExpiry.setChecked(true);
//                    toDate= fromDate;
                } else {
                    toDate = CommonFunctions.convertToDate(voucher.end_date, Constants.PHP_DATE_TIME_FORMAT);
                    tvValidUntil.setText(CommonFunctions.formatUnknownDateTime(voucher.end_date, Constants.PHP_DATE_TIME_FORMAT, "dd-MM-yyyy"));
                }
            } else {
//                toDate= fromDate;
                chkNoExpiry.setChecked(true);
            }

            for (ExclusionModel exclusionModel : daysList) {
                if (!Validators.isNullOrEmpty(voucher.week_day) && voucher.week_day.contains(exclusionModel.id)) {
                    exclusionModel.isChecked = true;
                }
            }
            dateAdapter.notifyDataSetChanged();

            for (OrderType orderType : orderTypeList) {
                if (!Validators.isNullOrEmpty(voucher.order_type_id) && voucher.order_type_id.contains(orderType.id)) {
                    orderType.isChecked = true;
                    orderTypeList.set(orderTypeList.indexOf(orderType), orderType);
                }
            }
            voucherOrderType.notifyDataSetChanged();
            etMinimumOrderAmount.setText(myApp.currencySymbol + voucher.minimum_order_value);
            boolean isCustom = true;
            /*for (ExclusionModel exclusionModel : minimumOrderList) {

                if (exclusionModel.name.equalsIgnoreCase("none")) {
                    if (voucher.minimum_order_value == 0) {
                        exclusionModel.isChecked = true;
                        minimumOrderAdapter.lastCheckedPosition = Integer.parseInt(exclusionModel.id);
                        isCustom = false;
                        minimumOrder = exclusionModel;
                    }
                } else {
                    if ((!exclusionModel.name.equalsIgnoreCase("none") && !exclusionModel.name.equalsIgnoreCase("custom")) && voucher.minimum_order_value == Float.parseFloat(exclusionModel.name.replace(MyApp.currencySymbol, ""))) {
                        exclusionModel.isChecked = true;
                        minimumOrderAdapter.lastCheckedPosition = Integer.parseInt(exclusionModel.id);
                        minimumOrder = exclusionModel;
                        isCustom = false;
                    }
                }

            }
            if (isCustom) {
                minimum_amount = MyApp.df.format(voucher.minimum_order_value);
                tvMinimumAmount.setText("Minimum Order: " + myApp.currencySymbol + voucher.minimum_order_value);
                llCustomMinimumAmount.setVisibility(View.VISIBLE);
                minimumOrderAdapter.lastCheckedPosition = 7;
                minimumOrder = new ExclusionModel();
                minimumOrder.name = "Custom";
                minimumOrder.id = "7";
            }
            minimumOrderAdapter.notifyDataSetChanged();*/

        }
    }

    private void setUpDate() {
        daysList.clear();

        ExclusionModel exclusionModel = new ExclusionModel();
        exclusionModel.id = "0";
        exclusionModel.name = "Sunday";
        daysList.add(exclusionModel);

        exclusionModel = new ExclusionModel();
        exclusionModel.id = "1";
        exclusionModel.name = "Monday";
        daysList.add(exclusionModel);

        exclusionModel = new ExclusionModel();
        exclusionModel.id = "2";
        exclusionModel.name = "Tuesday";
        daysList.add(exclusionModel);

        exclusionModel = new ExclusionModel();
        exclusionModel.id = "3";
        exclusionModel.name = "Wednesday";
        daysList.add(exclusionModel);

        exclusionModel = new ExclusionModel();
        exclusionModel.id = "4";
        exclusionModel.name = "Thursday";
        daysList.add(exclusionModel);

        exclusionModel = new ExclusionModel();
        exclusionModel.id = "5";
        exclusionModel.name = "Friday";
        daysList.add(exclusionModel);

        exclusionModel = new ExclusionModel();
        exclusionModel.id = "6";
        exclusionModel.name = "Saturday";
        daysList.add(exclusionModel);


    }

    private void setUpMinimumOrder() {
        minimumOrderList.clear();
        ExclusionModel exclusionModel = new ExclusionModel();
        exclusionModel.id = "0";
        exclusionModel.name = "None";
        minimumOrderList.add(exclusionModel);

        exclusionModel = new ExclusionModel();
        exclusionModel.id = "1";
        exclusionModel.name = "5";
        minimumOrderList.add(exclusionModel);

        exclusionModel = new ExclusionModel();
        exclusionModel.id = "2";
        exclusionModel.name = "10";
        minimumOrderList.add(exclusionModel);

        exclusionModel = new ExclusionModel();
        exclusionModel.id = "3";
        exclusionModel.name = "15";
        minimumOrderList.add(exclusionModel);

        exclusionModel = new ExclusionModel();
        exclusionModel.id = "4";
        exclusionModel.name = "20";
        minimumOrderList.add(exclusionModel);

        exclusionModel = new ExclusionModel();
        exclusionModel.id = "5";
        exclusionModel.name = "25";
        minimumOrderList.add(exclusionModel);

        exclusionModel = new ExclusionModel();
        exclusionModel.id = "6";
        exclusionModel.name = "30";
        minimumOrderList.add(exclusionModel);

        exclusionModel = new ExclusionModel();
        exclusionModel.id = "7";
        exclusionModel.name = "Custom";
        minimumOrderList.add(exclusionModel);

    }

    private boolean isValid() {
        etVoucherAmount.setError(null);
        etValidFrom.setError(null);
        tvValidUntil.setError(null);
        /*if (Validators.isNullOrEmpty(etName.getText().toString())) {
            etName.setError("Please enter customer name");
            etName.requestFocus();
            return false;
        }*/

        if (fromDate == null) {
            ToastUtils.makeToast(getActivity(), "Please select start date");
            return false;
        }

        if (!chkNoExpiry.isChecked() && toDate == null) {
            ToastUtils.makeToast(getActivity(), "Please select expire date");
            return false;
        }

        if (Validators.isNullOrEmpty(etVoucherAmount.getText().toString())) {
            etVoucherAmount.setError("Please enter voucher amount");
            etVoucherAmount.requestFocus();
            return false;
        }

        if (Validators.isNullOrEmpty(etMinimumOrderAmount.getText().toString())){
            ToastUtils.makeToast(getActivity(), "Please enter minimum value");
            return false;
        }

        /*if (minimumOrder.name.equalsIgnoreCase("custom") && Validators.isNullOrEmpty(tvMinimumAmount.getText().toString().replace(",", ""))) {
            ToastUtils.makeToast(getActivity(), "Please enter minimum value");
            return false;
        }*/

        return true;
    }

    protected String getSaltString() {
        String SALTCHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        StringBuilder salt = new StringBuilder();
        Random rnd = new Random();
        while (salt.length() < 8) { // length of the random string.
            int index = (int) (rnd.nextFloat() * SALTCHARS.length());
            salt.append(SALTCHARS.charAt(index));
        }
        String saltStr = salt.toString();
        return saltStr;

    }

    private void fetchVoucher() {
        new OfflineFetchAsync(() -> {
            updateView();
            return null;
        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
    }

    private class OfflineFetchAsync extends AsyncTask<String, String, String> {
        private Callable<Void> nextMethod;

        public OfflineFetchAsync(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected String doInBackground(String... strings) {
            LogUtils.e("_VOUHCER_ID:", String.valueOf(_voucher_id));
            voucher = appDatabase.voucherDao().view(_voucher_id);
            if (voucher != null) {
                voucher.customer = appDatabase.customerDao().view(voucher._customer_id);
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void fetchOrderType() {
        try {
            AndroidNetworking.get(ApiEndPoints.order_types)
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(OrderType.class, new ParsedRequestListener<List<OrderType>>() {

                        @Override
                        public void onResponse(List<OrderType> response) {
                            try {
                                orderTypeList.clear();
                                orderTypeList.addAll(response);
                                voucherOrderType.notifyDataSetChanged();
                                fetchVoucher();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                }
                                fetchVoucher();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addVoucher() {
        try {
            float amount = Float.parseFloat(voucher_amount);
            if (voucher == null) {
                voucher = new Voucher();
                voucher.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
            }
            if (selectedCustomer == null) {
                selectedCustomer = new Customer();
            }
            selectedCustomer.name = etName.getText().toString();

            if (!Validators.isNullOrEmpty(etEmailAddress.getText().toString()))
                selectedCustomer.email = etEmailAddress.getText().toString();

            if (!Validators.isNullOrEmpty(etContectNumber.getText().toString()))
                selectedCustomer.mobile = etContectNumber.getText().toString();

            voucher.customer = selectedCustomer;
            voucher.customer_id = selectedCustomer.id;
            voucher._customer_id = selectedCustomer._id;

            voucher.customer_name = selectedCustomer.name;
            voucher.customer_email = selectedCustomer.email;
            voucher.customer_mobile = selectedCustomer.mobile;

            voucher.voucher_amount = amount;
            voucher.voucher_code = tvVoucherCode.getText().toString();
            voucher.start_date = CommonFunctions.convertMsToDesiredFormat(fromDate.getTime(), Constants.PHP_DATE_TIME_FORMAT);

            if (chkNoExpiry.isChecked())
                voucher.end_date = null;
            else
                voucher.end_date = CommonFunctions.convertMsToDesiredFormat(toDate.getTime(), Constants.PHP_DATE_TIME_FORMAT);

            voucher.minimum_order_value = Float.parseFloat(minimum_amount);
            /*if (minimumOrder == null) {
                voucher.minimum_order_value = 0;
            } else {
                if (minimumOrder.name.equalsIgnoreCase("None")) {
                    voucher.minimum_order_value = 0;
                } else if (minimumOrder.name.equalsIgnoreCase("custom")) {
                    if (minimum_amount.contains(",")) {
                        voucher.minimum_order_value = Float.parseFloat(MyApp.df.format(Float.parseFloat(minimum_amount.replace(",", ""))));
                    } else {
                        voucher.minimum_order_value = Float.parseFloat(MyApp.df.format(Float.parseFloat(minimum_amount)));
                    }
                } else {
                    voucher.minimum_order_value = Float.parseFloat(MyApp.df.format(Float.parseFloat(minimumOrder.name.replace(MyApp.currencySymbol, ""))));
                }
            }*/

            StringBuilder builder = new StringBuilder();
            for (ExclusionModel exclusionModel : daysList) {
                if (exclusionModel.isChecked) {
                    if (builder.length() > 0) {
                        builder.append(",");
                    }
                    builder.append(exclusionModel.id);
                }
            }
            voucher.week_day = builder.toString();

            builder = new StringBuilder();
            for (OrderType orderType : orderTypeList) {
                if (orderType.isChecked) {
                    if (builder.length() > 0) {
                        builder.append(",");
                    }
                    builder.append(orderType.id);
                }
            }
            voucher.order_type_id = builder.toString();

            new SaveVoucherAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
//        new Thread(() -> {
//            if (selectedCustomer._id == 0) {
//                selectedCustomer._id = (int) appDatabase.customerDao().insert(selectedCustomer);
//            } else {
//                appDatabase.customerDao().insert(selectedCustomer);
//            }
//            voucher._customer_id = selectedCustomer._id;
//            if (voucher._id == 0)
//                voucher._id = (int) appDatabase.voucherDao().insert(voucher);
//            else appDatabase.voucherDao().insert(voucher);
//
//            getActivity().runOnUiThread(() -> {
//                if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
//                    if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
//                        zoneRichPrinter.connectPrinter(defaultPrinter.ip);
//                        zoneRichPrinter.printVoucher(myApp.businessLogo, "Voucher", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, voucher, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "");
//                    } else if (defaultPrinter.printer_model_name.toLowerCase().contains("sunmi") || defaultPrinter.printer_model_name.toLowerCase().contains("t2")) {
//                        sunmiPrinter.printVoucher(myApp.businessLogo, "Voucher", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, voucher, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "");
//                    } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
//                        wifiPrinter.connect(defaultPrinter.ip);
//                        wifiPrinter.printVoucher(myApp.businessLogo, "Voucher", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, voucher, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "");
//                    }
//                } else {
//                    ToastUtils.makeLongToast(getActivity(), "No printer model found");
//                }
//                goBack();
//            });
//        }).start();


    }

    private class SaveVoucherAsync extends AsyncTask<String, String, String> {

        @Override
        protected String doInBackground(String... strings) {
            try {
                if (selectedCustomer._id == 0) {
                    selectedCustomer._id = (int) appDatabase.customerDao().insert(selectedCustomer);
                } else {
                    appDatabase.customerDao().insert(selectedCustomer);
                }
                voucher._customer_id = selectedCustomer._id;
                if (voucher._id == 0)
                    voucher._id = (int) appDatabase.voucherDao().insert(voucher);
                else appDatabase.voucherDao().insert(voucher);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                getActivity().runOnUiThread(() -> {
                    if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                        if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                            zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                            zoneRichPrinter.printVoucher(myApp.businessLogo, "Voucher", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, voucher, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                        } else if (defaultPrinter.printer_model_name.toLowerCase().contains("sunmi") || defaultPrinter.printer_model_name.toLowerCase().contains("t2")) {
                            if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                                sunmiPrinterV3Mix.printVoucher(myApp.businessLogo, "Voucher", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, voucher, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                            }else {
                                sunmiPrinter.printVoucher(myApp.businessLogo, "Voucher", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, voucher, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                            }
                        } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                            if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                                wifiPrinter.connect(defaultPrinter.ip);
                                wifiPrinter.printVoucher(myApp.businessLogo, "Voucher", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, voucher, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                            } else {
                                try {
                                    if (bluetoothPrinter != null) {
                                        BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                        if (device != null) {
                                            bluetoothPrinter.printVoucher(myApp.businessLogo, "Voucher", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, voucher, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "");
                                        } else {
                                            ToastUtils.makeLongToast(getActivity(), "No bluetooth device found.");
                                        }
                                    }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    } else {
                        ToastUtils.makeLongToast(getActivity(), "No printer model found");
                    }
                    goBack();
                });
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void goBack() {
        if (voucher != null && voucher._id > 0) {
            uploadVoucher();
        }
        if (getActivity() != null)
            getActivity().onBackPressed();
    }

    private void uploadVoucher() {
        try {
            Intent intent = new Intent(getActivity(), SingleVoucherUploadService.class);
            intent.putExtra("_voucher_id", voucher._id);
            intent.putExtra("forcefully", true);
            getActivity().startService(intent);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchCustomers() {
        try {
            new CustomersAsyc().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, customers);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class CustomersAsyc extends AsyncTask<ArrayList<Customer>, Void, String> {

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected String doInBackground(ArrayList<Customer>... lists) {
            try {
                if (getActivity() != null)
                    getActivity().runOnUiThread(() -> {
                        customers.clear();
                        customers.addAll(appDatabase.customerDao().listNoNull());
                    });
            } catch (Exception e) {
                e.printStackTrace();
            }

            return "Executed";
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        progressBarDialog.dismiss();
                        customerAutoSuggestAdapter.updateData(customers);
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadSettings() {
        try {
            SiteSetting ticketHeaderTypeSetting = myApp.findSetting("ticket_header_type");
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("right")) {
                headerAlignment = 2;
            }
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("center")) {
                headerAlignment = 1;
            }
            ticketHeaderSetting = myApp.findSetting("ticket_header");

            footerASetting = myApp.findSetting("footer_a");
            footerBSetting = myApp.findSetting("footer_b");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    BroadcastReceiver voucherUploadUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("result", false)) {
                    int arg_voucher_id = intent.getIntExtra("_voucher_id", -1);
                    if (voucher != null && arg_voucher_id == voucher._id) {
                        fetchVoucher();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };


    @Override
    public void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance(getActivity()).registerReceiver(voucherUploadUpdateReceiver, new IntentFilter(Constants.VOUCHER_UPLOAD_UPDATE));
    }

    @Override
    public void onPause() {
        super.onPause();
        try {
            if (voucherUploadUpdateReceiver != null) {
                LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(voucherUploadUpdateReceiver);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EnterVoucherAmountDialogFragment getInstanceEnterVoucherAmount(String for_what, String title, String info, float value) {
        EnterVoucherAmountDialogFragment rejectReasonDialog = new EnterVoucherAmountDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("for_what", for_what);
        bundle.putString("title", title);
        bundle.putString("info", info);
        bundle.putFloat("value", value);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    public EnterVoucherAmountDialogFragment getInstanceEnterVoucherAmountForVoucher(String for_what, String title, String info, float value,float voucherAmount) {
        EnterVoucherAmountDialogFragment rejectReasonDialog = new EnterVoucherAmountDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("for_what", for_what);
        bundle.putString("title", title);
        bundle.putString("info", info);
        bundle.putFloat("value", value);
        bundle.putFloat("voucherAmount", voucherAmount);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }
}