package com.ubsidi.epos_2021.fragment;

import static android.content.Context.CLIPBOARD_SERVICE;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.VoucherHistoryAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinterV3Mix;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.Voucher;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;

public class VoucherHistoryFragment extends BaseFragment {
    private AlertDialog progressBarDialog;
    private SwipeRefreshLayout swipeRefreshLayout;
    private TextView tvDate, tvTotalCustomer;
    private RecyclerView rvVoucher;
    private VoucherHistoryAdapter voucherHistoryAdapter;
    private ArrayList<Voucher> voucherList = new ArrayList<Voucher>();

    private SunmiPrinter sunmiPrinter;
    private SunmiPrinterV3Mix sunmiPrinterV3Mix;
    private ZoneRichPrinter zoneRichPrinter;
    private WifiPrinter wifiPrinter;
    public BluetoothPrinter bluetoothPrinter;
    private Printer defaultPrinter;
    private SiteSetting headerAlignmentSetting;
    private int headerAlignment = 0;
    private SiteSetting ticketHeaderSetting, ticketHeaderTypeSetting, footerASetting, footerBSetting;
    private MaterialCardView btnNew;
    private int selectedButton = 0;
    private String fromDateString = "0", toDateString = "0";
    private Date startDate, endDate;
    Calendar c = Calendar.getInstance();
    int year = c.get(Calendar.YEAR);
    int month = c.get(Calendar.MONTH);
    int day = 1;
    private Chip chipBack;

    private LinearLayout llToday, llThisWeek, llThisMonth, llCustom;
    private TextView tvToday, tvThisWeek, tvThisMonth, tvCustom;
    private View vToday, vThisWeek, vThisMonth, vCustom;
    private boolean alreadyOnCreated = false;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_voucher_history, container, false);
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public void onViewCreated(@NonNull @NotNull View view, @Nullable @org.jetbrains.annotations.Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            setListeners();
            if (!alreadyOnCreated) {
                alreadyOnCreated = true;
                llToday.performClick();
            } else {
                LogUtils.e("VOUCHERS", "Already on created");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            loadSettings();
            progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
            zoneRichPrinter = new ZoneRichPrinter(getActivity());
            defaultPrinter = myPreferences.getDefaultPrinter();
            zoneRichPrinter = myApp.connectZonerich(zoneRichPrinter, defaultPrinter);
            wifiPrinter = WifiPrinter.getInstance();
            bluetoothPrinter = new BluetoothPrinter(getActivity());
            sunmiPrinter = new SunmiPrinter(getActivity());
            if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                sunmiPrinterV3Mix = new SunmiPrinterV3Mix(requireActivity());
            }
            chipBack = view.findViewById(R.id.chipBack);
            swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
            tvTotalCustomer = view.findViewById(R.id.tvTotalCustomer);
            tvDate = view.findViewById(R.id.tvDate);

            llToday = view.findViewById(R.id.llToday);
            llThisWeek = view.findViewById(R.id.llThisWeek);
            llThisMonth = view.findViewById(R.id.llThisMonth);
            llCustom = view.findViewById(R.id.llCustom);

            tvToday = view.findViewById(R.id.tvToday);
            tvThisWeek = view.findViewById(R.id.tvThisWeek);
            tvThisMonth = view.findViewById(R.id.tvThisMonth);
            tvCustom = view.findViewById(R.id.tvCustom);

            vToday = view.findViewById(R.id.vToday);
            vThisWeek = view.findViewById(R.id.vThisWeek);
            vThisMonth = view.findViewById(R.id.vThisMonth);
            vCustom = view.findViewById(R.id.vCustom);


            btnNew = view.findViewById(R.id.btnNew);
            rvVoucher = view.findViewById(R.id.rvVoucher);

            tvCustom.setText("Show All");
            voucherHistoryAdapter = new VoucherHistoryAdapter(voucherList, (position, tag, data) -> {
                Voucher voucher = (Voucher) data;
                switch (tag) {
                    case "copy":{
                        ClipboardManager clipboard = (ClipboardManager) getActivity().getSystemService(Context.CLIPBOARD_SERVICE);
                        ClipData clip = ClipData.newPlainText("voucher_code", voucher.voucher_code);
                        clipboard.setPrimaryClip(clip);
                        ToastUtils.makeToast(requireContext(), "Text copied to clipboard");
                        break;
                    }
                    case "view":
                        try {
                            FragmentManager manager = getActivity().getSupportFragmentManager();
                            FragmentTransaction transaction = manager.beginTransaction();
                            transaction.replace(R.id.nav_host_fragment, getInstanceVoucher(voucher));
                            transaction.addToBackStack("can_go_back");
                            transaction.commit();
                            getActivity().invalidateOptionsMenu();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;

                    case "print":
                        try {
                            getActivity().runOnUiThread(() -> {
                                if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                                    if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                                        zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                                        zoneRichPrinter.printVoucher(myApp.businessLogo, "Voucher", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, voucher, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                    } else if (defaultPrinter.printer_model_name.toLowerCase().contains("sunmi") || defaultPrinter.printer_model_name.toLowerCase().contains("t2")) {
                                        if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                                            sunmiPrinterV3Mix.printVoucher(myApp.businessLogo, "Voucher", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, voucher, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                        }else {
                                            sunmiPrinter.printVoucher(myApp.businessLogo, "Voucher", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, voucher, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                        }
                                    } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                                            wifiPrinter.connect(defaultPrinter.ip);
                                            wifiPrinter.printVoucher(myApp.businessLogo, "Voucher", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, voucher, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                        } else {
                                            try {
                                                if (bluetoothPrinter != null) {
                                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                                    if (device != null) {
                                                        bluetoothPrinter.printVoucher(myApp.businessLogo, "Voucher", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, voucher, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "");
                                                    } else {
                                                        ToastUtils.makeLongToast(getActivity(), "No bluetooth device found.");
                                                    }
                                                }
                                            } catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    }
                                } else {
                                    ToastUtils.makeLongToast(getActivity(), "No printer model found");
                                }
                            });
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;

                    case "cancel":
                        try {
                            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Delete Voucher", "Are you sure you want to delete this voucher?", 2, "Confirm", "Cancel");
                            confirmationDialogFragment.show(getChildFragmentManager(), "vouchers");
                            confirmationDialogFragment.setDialogDismissListener(o -> {
                                try {
                                    if (o instanceof String) {
                                        String action = (String) o;
                                        if (action.equalsIgnoreCase("confirm")) {
                                            deleteVoucher(voucher);
                                        }
                                    }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }

                            });
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                        break;
                }
            });

            rvVoucher.setLayoutManager(new LinearLayoutManager(getActivity(), LinearLayoutManager.VERTICAL, false));
            rvVoucher.setAdapter(voucherHistoryAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void deleteVoucher(Voucher voucher) {
        try {
            if (voucher._id > 0) {
                new Thread(() -> {
                    appDatabase.voucherDao().delete(voucher._id);
                }).start();
            }
            if (Validators.isNullOrEmpty(voucher.id)) {
                fetchVoucherHistory();
                return;
            }
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressBarDialog.show());
            }
            AndroidNetworking.delete(ApiEndPoints.voucher_add + voucher.id)
                    .build()
                    .getAsObject(Voucher.class, new ParsedRequestListener() {
                        @Override
                        public void onResponse(Object response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> progressBarDialog.dismiss());
                                }
                                fetchVoucherHistory();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> progressBarDialog.dismiss());
                                }
                                if (anError.getErrorCode() == 400) {
                                    ToastUtils.makeSnackToast(getActivity(), anError.getErrorAsObject(ApiError.class).getMessage());
                                }
                                fetchVoucherHistory();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {

        try {
            swipeRefreshLayout.setOnRefreshListener(this::fetchVoucherHistory);
            llToday.setOnClickListener(v -> {
                selectedButton = llToday.getId();
                chekedBtn(llToday);
                tvDate.setVisibility(View.VISIBLE);
                getToday();
            });
            llThisWeek.setOnClickListener(v -> {
                selectedButton = llThisWeek.getId();
                chekedBtn(llThisWeek);
                tvDate.setVisibility(View.VISIBLE);
                getWeek();
            });
            llThisMonth.setOnClickListener(v -> {
                selectedButton = llThisMonth.getId();
                chekedBtn(llThisMonth);
                tvDate.setVisibility(View.VISIBLE);
                getCurrentMonth();
            });
            llCustom.setOnClickListener(v -> {
                selectedButton = llCustom.getId();
                chekedBtn(llCustom);
                fromDateString = null;
                toDateString = null;
                tvDate.setVisibility(View.INVISIBLE);
                fetchVoucherHistory();
            });
            chipBack.setOnClickListener(view -> {
                if (getActivity() != null) {
                    getActivity().onBackPressed();
                }
            });
            btnNew.setOnClickListener(v -> {
                FragmentManager manager = getActivity().getSupportFragmentManager();
                FragmentTransaction transaction = manager.beginTransaction();
                transaction.replace(R.id.nav_host_fragment, new VoucherFragment());
                transaction.addToBackStack("can_go_back");
                transaction.commitAllowingStateLoss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void chekedBtn(View v) {
        vToday.setBackgroundResource(R.color.light_gray);
        tvToday.setAlpha(0.5f);

        vThisWeek.setBackgroundResource(R.color.light_gray);
        tvThisWeek.setAlpha(0.5f);

        vThisMonth.setBackgroundResource(R.color.light_gray);
        tvThisMonth.setAlpha(0.5f);

        vCustom.setBackgroundResource(R.color.light_gray);
        tvCustom.setAlpha(0.5f);

        if (v == llToday) {
            vToday.setBackgroundResource(R.color.persian_green);
            tvToday.setAlpha(1f);
        }
        if (v == llThisWeek) {
            vThisWeek.setBackgroundResource(R.color.persian_green);
            tvThisWeek.setAlpha(1f);
        }
        if (v == llThisMonth) {
            vThisMonth.setBackgroundResource(R.color.persian_green);
            tvThisMonth.setAlpha(1f);
        }
        if (v == llCustom) {
            vCustom.setBackgroundResource(R.color.persian_green);
            tvCustom.setAlpha(1f);
        }
    }

    private void getToday() {
        fromDateString = CommonFunctions.formatMiliToDesireFormat(System.currentTimeMillis(), "yyyy-MM-dd");
        toDateString = CommonFunctions.formatMiliToDesireFormat(System.currentTimeMillis(), "yyyy-MM-dd");

        setDateText();
        fetchVoucherHistory();
    }

    private void getWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(Calendar.MONDAY);
        cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
        startDate = cal.getTime();

        cal.add(Calendar.DATE, 6);
        endDate = cal.getTime();

        fromDateString = CommonFunctions.formatMiliToDesireFormat(startDate.getTime(), "yyyy-MM-dd");
        toDateString = CommonFunctions.formatMiliToDesireFormat(endDate.getTime(), "yyyy-MM-dd");

        setDateText();
        fetchVoucherHistory();
    }

    private void getCurrentMonth() {
        c.set(year, month, day);
        startDate = c.getTime();


        int numOfDaysInMonth = c.getActualMaximum(Calendar.DAY_OF_MONTH);
        c.add(Calendar.DAY_OF_MONTH, numOfDaysInMonth - 1);

        endDate = c.getTime();

        fromDateString = CommonFunctions.formatMiliToDesireFormat(startDate.getTime(), "yyyy-MM-dd");
        toDateString = CommonFunctions.formatMiliToDesireFormat(endDate.getTime(), "yyyy-MM-dd");

        setDateText();
        fetchVoucherHistory();
    }

    private void setDateText() {
        if (fromDateString.equalsIgnoreCase(toDateString)) {
            tvDate.setText(CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd MMM yyyy"));
        } else {
            tvDate.setText(CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd MMM yyyy") + " - " + CommonFunctions.formatUnknownDateTime(toDateString, "yyyy-MM-dd", "dd MMM yyyy"));
        }
    }

    private void fetchVoucherHistory() {
        try {
            if (("manual".equalsIgnoreCase(myPreferences.getOrderSyncMode()) && Validators.isNullOrEmpty(fromDateString)) || !MyApp.getInstance().isConnected(getActivity())) {
                new VouchersHistoryAsync(() -> {
                    voucherHistoryAdapter.notifyDataSetChanged();
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new ArrayList<>());
                return;
            }
            swipeRefreshLayout.setRefreshing(true);
            ANRequest.GetRequestBuilder getRequestBuilder = AndroidNetworking.get(ApiEndPoints.voucher_add)
                    .addQueryParameter("nopaginate", "1");
            if (!Validators.isNullOrEmpty(fromDateString)) {
                getRequestBuilder.addQueryParameter("from_date", fromDateString);
            }
            if (!Validators.isNullOrEmpty(toDateString)) {
                getRequestBuilder.addQueryParameter("to_date", toDateString);
            }
            getRequestBuilder.build()
                    .getAsObjectList(Voucher.class, new ParsedRequestListener<List<Voucher>>() {
                        @Override
                        public void onResponse(List<Voucher> response) {
                            try {
                                swipeRefreshLayout.setRefreshing(false);

                                new VouchersHistoryAsync(() -> {
                                    voucherHistoryAdapter.notifyDataSetChanged();
                                    return null;
                                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, response);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                swipeRefreshLayout.setRefreshing(false);
                                anError.printStackTrace();
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    voucherList.clear();
                                    voucherHistoryAdapter.notifyDataSetChanged();
                                    ToastUtils.makeToast(getActivity(), apiError.getMessage());
                                }

                                new VouchersHistoryAsync(() -> {
                                    voucherHistoryAdapter.notifyDataSetChanged();
                                    return null;
                                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new ArrayList<>());
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class VouchersHistoryAsync extends AsyncTask<List<Voucher>, String, String> {
        private Callable<Void> nextMethod;
        ArrayList<Voucher> localVouchers = new ArrayList<>();

        public VouchersHistoryAsync(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            swipeRefreshLayout.setRefreshing(true);
        }

        @Override
        protected String doInBackground(List<Voucher>... lists) {
            try {
                if (lists.length > 0) {
                    ArrayList<Voucher> voucherArrayList = (ArrayList<Voucher>) lists[0];
                    for (Voucher v : voucherArrayList) {
                        Voucher dbVoucher = appDatabase.voucherDao().view(v.id);
                        if (dbVoucher != null) {
                            v._id = dbVoucher._id;
                        }

                        Customer dbCustomer = appDatabase.customerDao().view(v.customer_id);
                        if (dbCustomer != null) {
                            v._customer_id = dbCustomer._id;
                            v.customer._id = dbCustomer._id;
                        } else {
                            if (v.customer == null) {
                                dbCustomer = new Customer();
                                dbCustomer.id = v.customer_id;
                                dbCustomer.name = v.customer_name;
                                dbCustomer.mobile = v.customer_mobile;
                                dbCustomer.email = v.customer_email;
                                v.customer = dbCustomer;
                            }
                            v.customer._id = (int) appDatabase.customerDao().insert(v.customer);
                            v._customer_id = v.customer._id;
                        }
                        appDatabase.voucherDao().insert(v);
                    }
                }

                if (!Validators.isNullOrEmpty(fromDateString) && !Validators.isNullOrEmpty(toDateString)) {
                    localVouchers = (ArrayList<Voucher>) appDatabase.voucherDao().listWithDate(fromDateString, toDateString);
                } else if (!Validators.isNullOrEmpty(fromDateString)) {
                    localVouchers = (ArrayList<Voucher>) appDatabase.voucherDao().list(fromDateString, toDateString);
                } else {
                    localVouchers = (ArrayList<Voucher>) appDatabase.voucherDao().list();
                }
                for (Voucher voucher : localVouchers) {
                    voucher.customer = appDatabase.customerDao().view(voucher._customer_id);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                voucherList.clear();
                voucherList.addAll(localVouchers);
                swipeRefreshLayout.setRefreshing(false);
                if (nextMethod != null) {
                    try {
                        nextMethod.call();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadSettings() {
        try {
            ticketHeaderTypeSetting = myApp.findSetting("ticket_header_type");
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("right")) {
                headerAlignment = 2;
            }
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("center")) {
                headerAlignment = 1;
            }
            ticketHeaderSetting = myApp.findSetting("ticket_header");

            footerASetting = myApp.findSetting("footer_a");
            footerBSetting = myApp.findSetting("footer_b");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    BroadcastReceiver voucherUploadUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("result", false)) {
                    LogUtils.e("VOUCHERS", "After uploading result received");
                    int arg_voucher_id = intent.getIntExtra("_voucher_id", -1);
                    if (!swipeRefreshLayout.isRefreshing()) {
                        fetchVoucherHistory();
                        if (alreadyOnCreated) {
                            if (selectedButton == R.id.llToday) {
                                llToday.performClick();
                            } else if (selectedButton == R.id.llThisWeek) {
                                llThisWeek.performClick();
                            } else if (selectedButton == R.id.llThisMonth) {
                                llThisMonth.performClick();
                            } else if (selectedButton == R.id.llCustom) {
                                llCustom.performClick();
                            } else {
                                llToday.performClick();
                            }
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    public void onResume() {
        super.onResume();
        try {
            LogUtils.e("VOUCHERS", "OnResume");
            LocalBroadcastManager.getInstance(getActivity()).registerReceiver(voucherUploadUpdateReceiver, new IntentFilter(Constants.VOUCHER_UPLOAD_UPDATE));
            if (alreadyOnCreated) {
                if (selectedButton == R.id.llToday) {
                    chekedBtn(llToday);
                } else if (selectedButton == R.id.llThisWeek) {
                    chekedBtn(llThisWeek);
                } else if (selectedButton == R.id.llThisMonth) {
                    chekedBtn(llThisMonth);
                } else if (selectedButton == R.id.llCustom) {
                    chekedBtn(llCustom);
                } else {
                    chekedBtn(llToday);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        try {
            LogUtils.e("VOUCHERS", "OnPause");
            if (voucherUploadUpdateReceiver != null) {
                LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(voucherUploadUpdateReceiver);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public VoucherFragment getInstanceVoucher(Voucher voucher) {
        VoucherFragment fragment = new VoucherFragment();
        Bundle bundle = new Bundle();
        bundle.putString("voucher", new Gson().toJson(voucher));
        fragment.setArguments(bundle);
        return fragment;
    }
}