package com.ubsidi.epos_2021.merchant.adapters;

import android.content.Context;
import android.graphics.Paint;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListenerWithTag;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.OrderSplit;

import java.util.ArrayList;

public class EposOrderedProductItemsAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private ArrayList<Object> eposOrderItem;
    private boolean showPrice = false;
    private RecyclerviewItemClickListenerWithTag itemClickListener;

    public EposOrderedProductItemsAdapter(ArrayList<Object> eposOrderItem, boolean showPrice, RecyclerviewItemClickListenerWithTag itemClickListener) {
        this.eposOrderItem = eposOrderItem;
        this.showPrice = showPrice;
        this.itemClickListener = itemClickListener;
    }


    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == R.layout.item_online_ordered_product_item) {
            return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
        } else if (viewType == R.layout.item_cart_split) {
            return new SplitViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
        } else
            return new EmptyViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
    }


    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {
        try {
            if (getItemViewType(position) == R.layout.item_online_ordered_product_item) {
                ViewHolder holder = (ViewHolder) viewHolder;
                OrderItem cart = (OrderItem) eposOrderItem.get(position);
                holder.tvName.setText(cart.product_name);
                holder.tvCount.setText(cart.quantity + "x");
                holder.tvSubAddon.setVisibility(View.GONE);
                StringBuilder selectedProductAddons = new StringBuilder();
                if(cart.is_delete){
                    holder.tvName.setPaintFlags(holder.tvName.getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
                    holder.tvCount.setPaintFlags(holder.tvCount.getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
                    holder.tvPrice.setPaintFlags(holder.tvPrice.getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
                }else {
                    holder.tvName.setPaintFlags(0);
                    holder.tvCount.setPaintFlags(0);
                    holder.tvPrice.setPaintFlags(0);
                }
                if (cart.order_item_addons != null && cart.order_item_addons.size() > 0) {
                    for (OrderItemAddon orderItemAddon : cart.order_item_addons) {
                        if (selectedProductAddons.length() > 0) {
                            selectedProductAddons.append("\n");
                        }
                        selectedProductAddons.append(orderItemAddon.addon_name).append(": ").append(MyApp.currencySymbol).append(MyApp.df.format(orderItemAddon.price));
                    }
                }

                if (cart.order_item_ingredients != null && cart.order_item_ingredients.size() > 0) {
                    for (OrderItemIngredient orderItemIngredient : cart.order_item_ingredients) {
                        if (selectedProductAddons.length() > 0) {
                            selectedProductAddons.append("\n");
                        }
                        if (orderItemIngredient.with) {
                            selectedProductAddons.append("Extra ");
                            selectedProductAddons.append(orderItemIngredient.quantity).append(" ");
                        }
                        if (orderItemIngredient.without) {
                            selectedProductAddons.append("No ");
                        }
                        selectedProductAddons.append(orderItemIngredient.ingredient_name).append(": ").append(MyApp.currencySymbol).append(MyApp.df.format(orderItemIngredient.total));
                    }
                }

                holder.tvSubAddon.setText(selectedProductAddons.toString());
                if (selectedProductAddons.length() > 0) {
                    holder.tvSubAddon.setVisibility(View.VISIBLE);
                } else {
                    holder.tvSubAddon.setVisibility(View.GONE);
                }
                if (showPrice) {
                    holder.tvPrice.setVisibility(View.VISIBLE);
                } else {
                    holder.tvPrice.setVisibility(View.GONE);
                }
                holder.tvPrice.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(cart.total)));

            } else if (getItemViewType(position) == R.layout.item_cart_split) {
                SplitViewHolder splitViewHolder = (SplitViewHolder) viewHolder;
                OrderSplit orderSplit = (OrderSplit) eposOrderItem.get(position);
                splitViewHolder.tvName.setText(orderSplit.group_name + " (" + MyApp.currencySymbol + MyApp.df.format(orderSplit.paid_amount) + "/" + MyApp.currencySymbol + MyApp.df.format(orderSplit.total) + ")");

                splitViewHolder.cvSplit.setEnabled(true);
                Context context = splitViewHolder.itemView.getContext();
                if (orderSplit.selected) {
                    splitViewHolder.cvSplit.setCardBackgroundColor(ContextCompat.getColor(context, R.color.persian_green));
                    splitViewHolder.tvName.setTextColor(ContextCompat.getColor(context, R.color.white));
                } else {
                    splitViewHolder.cvSplit.setCardBackgroundColor(ContextCompat.getColor(context, R.color.white));
                    splitViewHolder.tvName.setTextColor(ContextCompat.getColor(context, R.color.persian_green));
                }
                splitViewHolder.cvSplit.setOnClickListener(v -> {
                    orderSplit.selected = !orderSplit.selected;
                    if (itemClickListener != null)
                        itemClickListener.onItemClick(position, "split_click", orderSplit);
                });

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @Override
    public int getItemViewType(int position) {
        Object object = eposOrderItem.get(position);
        if (object instanceof OrderItem) {
            return R.layout.item_online_ordered_product_item;
        } else if (object instanceof OrderSplit) {
            return R.layout.item_cart_split;
        } else {
            return R.layout.item_cart_product_empty;
        }
    }

    @Override
    public int getItemCount() {
        return eposOrderItem.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private TextView tvCount, tvName, tvPrice, tvSubAddon;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tvCount = itemView.findViewById(R.id.tvCount);
            tvName = itemView.findViewById(R.id.tvName);
            tvPrice = itemView.findViewById(R.id.tvPrice);
            tvSubAddon = itemView.findViewById(R.id.tvSubAddon);
        }
    }

    public class SplitViewHolder extends RecyclerView.ViewHolder {
        private TextView tvName;
        private MaterialCardView cvSplit;

        public SplitViewHolder(@NonNull View itemView) {
            super(itemView);
            tvName = itemView.findViewById(R.id.tvName);
            cvSplit = itemView.findViewById(R.id.cvSplit);
        }
    }

    public static class EmptyViewHolder extends RecyclerView.ViewHolder {

        public EmptyViewHolder(@NonNull View itemView) {
            super(itemView);
        }
    }
}
