package com.ubsidi.epos_2021.merchant.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.merchant.models.Header;
import com.ubsidi.epos_2021.merchant.models.MerchantOrderTransaction;
import com.ubsidi.epos_2021.merchant.models.MerchantPaypalTransaction;
import com.ubsidi.epos_2021.merchant.models.MerchantTransaction;
import com.ubsidi.epos_2021.merchant.models.PaymentLink;
import com.ubsidi.epos_2021.utils.Constants;

import java.util.ArrayList;

/**
 * Created by Amrish on 09-06-2021.
 */
public class MerchantTransactionsAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private ArrayList<Object> data;
    public boolean showCheck = false;
    public RecyclerviewItemClickListener clickListener, refundClickListener, printClickListener;
    private boolean canRefund = false;
    private boolean canReprint = true;

    public MerchantTransactionsAdapter(ArrayList<Object> data, boolean canRefund, RecyclerviewItemClickListener clickListener, RecyclerviewItemClickListener refundClickListener, RecyclerviewItemClickListener printClickListener) {
        this.data = data;
        this.clickListener = clickListener;
        this.canRefund = canRefund;
        this.refundClickListener = refundClickListener;
        this.printClickListener = printClickListener;
    }

    public MerchantTransactionsAdapter(ArrayList<Object> data, boolean canRefund, boolean canReprint, RecyclerviewItemClickListener clickListener, RecyclerviewItemClickListener refundClickListener, RecyclerviewItemClickListener printClickListener) {
        this.data = data;
        this.clickListener = clickListener;
        this.canRefund = canRefund;
        this.canReprint = canReprint;
        this.refundClickListener = refundClickListener;
        this.printClickListener = printClickListener;
    }

    @Override
    public int getItemViewType(int position) {
        if (data.get(position) instanceof MerchantTransaction) {
            return R.layout.item_merchant_transaction;
        } else if (data.get(position) instanceof MerchantPaypalTransaction) {
            return R.layout.item_paypal_transaction;
        } else if (data.get(position) instanceof MerchantOrderTransaction) {
            return R.layout.item_order_transaction;
        } else if (data.get(position) instanceof PaymentLink) {
            return R.layout.item_transaction_paymentlink;
        } else if (data.get(position) instanceof Header) {
            return R.layout.item_header;
        }
        return super.getItemViewType(position);
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false);
        if (viewType == R.layout.item_merchant_transaction) {
            return new TransactionViewHolder(view);
        } else if (viewType == R.layout.item_paypal_transaction) {
            return new TransactionViewHolder(view);
        } else if (viewType == R.layout.item_order_transaction) {
            return new OrderTransactionViewHolder(view);
        } else if (viewType == R.layout.item_transaction_paymentlink) {
            return new PaymentLinksViewHolder(view);
        } else return new HeaderViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        try {
            if (getItemViewType(position) == R.layout.item_merchant_transaction) {
                TransactionViewHolder transactionHolder = (TransactionViewHolder) holder;
                MerchantTransaction transaction = (MerchantTransaction) data.get(position);
                transactionHolder.tvAmount.setText(MyApp.currencySymbol + MyApp.df.format(transaction.amount / 100));
                transactionHolder.tvType.setText(transaction.service);
                if (!Validators.isNullOrEmpty(transaction.transaction_date_time))
                    transactionHolder.tvDate.setText(CommonFunctions.formatUnknownDateTime(transaction.transaction_date_time, Constants.PHP_DATE_TIME_FORMAT, "dd MMM, hh:mm a"));
                else {
                    transactionHolder.tvDate.setText(CommonFunctions.formatMiliToDesireFormat(Long.parseLong(transaction.created + "000"), "dd MMM, hh:mm a"));
                }
                if (transaction.reporting_category.equalsIgnoreCase("refund")) {
                    transactionHolder.tvBrand.setText("Refund");
                    transactionHolder.ivEntry.setImageResource(R.drawable.ic_baseline_entry_remove_24);
                } else {
                    transactionHolder.tvBrand.setText(transaction.card_brand);
                    transactionHolder.ivEntry.setImageResource(R.drawable.ic_baseline_entry_add_24);
                }
                if (showCheck) {
                    transactionHolder.rbChecked.setVisibility(View.VISIBLE);
                    transactionHolder.rbChecked.setChecked(transaction.checked);
                    transactionHolder.rbChecked.setEnabled(true);

                    transactionHolder.llMain.setOnClickListener(v -> {
                        if (showCheck) {
                            transaction.checked = !transaction.checked;
                            transactionHolder.rbChecked.setChecked(transaction.checked);
                            if (clickListener != null) {
                                clickListener.onItemClick(position, transaction);
                            }
                        }
                    });
                } else {
                    transactionHolder.rbChecked.setVisibility(View.GONE);
                    transactionHolder.rbChecked.setEnabled(false);
                }
                if (canRefund && !transaction.refunded && transaction.reporting_category.equalsIgnoreCase("charge")) {
                    transactionHolder.btnRefund.setVisibility(View.VISIBLE);
                } else {
                    transactionHolder.btnRefund.setVisibility(View.GONE);
                }
                if (canReprint) {
                    transactionHolder.btnPrint.setVisibility(View.VISIBLE);
                } else {
                    transactionHolder.btnPrint.setVisibility(View.GONE);
                }
                transactionHolder.btnPrint.setOnClickListener(view -> {
                    if (printClickListener != null) {
                        printClickListener.onItemClick(position, transaction);
                    }
                });
                transactionHolder.btnRefund.setOnClickListener(view -> {
                    if (refundClickListener != null) {
                        refundClickListener.onItemClick(position, transaction);
                    }
                });
            }
            if (getItemViewType(position) == R.layout.item_paypal_transaction) {
                TransactionViewHolder transactionHolder = (TransactionViewHolder) holder;
                MerchantPaypalTransaction transaction = (MerchantPaypalTransaction) data.get(position);
                transactionHolder.tvBrand.setVisibility(View.GONE);
                transactionHolder.btnPrint.setVisibility(View.GONE);

                transactionHolder.tvAmount.setText(MyApp.currencySymbol + MyApp.df.format(transaction.transaction_amount));
                transactionHolder.tvType.setText(transaction.sale_state);
                transactionHolder.tvDate.setText(CommonFunctions.formatUnknownDateTime(transaction.sale_created_at, "yyyy-MM-dd'T'HH:mm:ss'Z'", "dd MMM, hh:mm a"));
                if (transaction.sale_state.equalsIgnoreCase("refunded")) {
                    transactionHolder.ivEntry.setImageResource(R.drawable.ic_baseline_entry_remove_24);
                } else {
                    if (transaction.sale_state.equalsIgnoreCase("partially_refunded")) {
                        if (canRefund) transactionHolder.btnRefund.setVisibility(View.VISIBLE);
                        else transactionHolder.btnRefund.setVisibility(View.GONE);
                        transactionHolder.tvBrand.setText(MyApp.getInstance().currencySymbol + MyApp.df.format(transaction.refunded_amount) + " refunded");
                    } else {
                        transactionHolder.btnRefund.setVisibility(View.GONE);
                    }
                    transactionHolder.ivEntry.setImageResource(R.drawable.ic_baseline_entry_add_24);
                }
                if (showCheck) {
                    transactionHolder.rbChecked.setVisibility(View.VISIBLE);
                    transactionHolder.rbChecked.setChecked(transaction.checked);
                    transactionHolder.rbChecked.setEnabled(true);

                    transactionHolder.llMain.setOnClickListener(v -> {
                        if (showCheck) {
                            transaction.checked = !transaction.checked;
                            transactionHolder.rbChecked.setChecked(transaction.checked);
                            if (clickListener != null) {
                                clickListener.onItemClick(position, transaction);
                            }
                        }
                    });
                } else {
                    transactionHolder.rbChecked.setVisibility(View.GONE);
                    transactionHolder.rbChecked.setEnabled(false);
                }
                if (canRefund && transaction.sale_state.equalsIgnoreCase("completed")) {
                    transactionHolder.btnRefund.setVisibility(View.VISIBLE);
                } else {
                    transactionHolder.btnRefund.setVisibility(View.GONE);
                }

                transactionHolder.btnPrint.setOnClickListener(view -> {
                    if (printClickListener != null) {
                        printClickListener.onItemClick(position, transaction);
                    }
                });
                transactionHolder.btnRefund.setOnClickListener(view -> {
                    if (refundClickListener != null) {
                        refundClickListener.onItemClick(position, transaction);
                    }
                });
            }
            if (getItemViewType(position) == R.layout.item_order_transaction) {
                OrderTransactionViewHolder transactionHolder = (OrderTransactionViewHolder) holder;
                MerchantOrderTransaction transaction = (MerchantOrderTransaction) data.get(position);
                transactionHolder.tvOrderId.setText("#ODR" + transaction.order_id);
                transactionHolder.tvPaymentMethod.setText("COD");

                if (transaction.calculated_fees != null) {
                    transactionHolder.tvAmount.setText(MyApp.currencySymbol + MyApp.df.format(transaction.calculated_fees.total_fee));
                } else {
                    transactionHolder.tvAmount.setText(MyApp.currencySymbol + MyApp.df.format(transaction.grand_total));
                }
                transactionHolder.tvType.setText(transaction.order_status);
                transactionHolder.tvBrand.setText(transaction.order_type);
                transactionHolder.tvDate.setText(CommonFunctions.formatUnknownDateTime(transaction.order_date, "yyyy-MM-dd HH:mm:ss", "dd MMM, hh:mm a"));

                transactionHolder.ivEntry.setImageResource(R.drawable.ic_baseline_entry_remove_24);
                if (showCheck) {
                    transactionHolder.rbChecked.setVisibility(View.VISIBLE);
                    transactionHolder.rbChecked.setChecked(transaction.checked);
                    transactionHolder.rbChecked.setEnabled(true);

                    transactionHolder.llMain.setOnClickListener(v -> {
                        if (showCheck) {
                            transaction.checked = !transaction.checked;
                            transactionHolder.rbChecked.setChecked(transaction.checked);
                            if (clickListener != null) {
                                clickListener.onItemClick(position, transaction);
                            }
                        }
                    });
                } else {
                    transactionHolder.rbChecked.setVisibility(View.GONE);
                    transactionHolder.rbChecked.setEnabled(false);
                }


            }
            if (getItemViewType(position) == R.layout.item_transaction_paymentlink) {
                PaymentLink paymentLink = (PaymentLink) data.get(position);
                PaymentLinksViewHolder viewHolder = (PaymentLinksViewHolder) holder;
                viewHolder.tvAmount.setText(MyApp.currencySymbol + MyApp.df.format(paymentLink.amount));
                viewHolder.tvDate.setText(CommonFunctions.formatUnknownDateTime(paymentLink.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd MMM hh:mm a"));
                viewHolder.tvStatus.setText(paymentLink.status);
                viewHolder.tvPhone.setText(paymentLink.phone);
                viewHolder.btnResend.setVisibility(View.GONE);
                Context activity = viewHolder.itemView.getContext();
                if (paymentLink.status.equalsIgnoreCase("failed")) {
                    viewHolder.ivEntry.setImageResource(R.drawable.ic_baseline_entry_remove_24);
                    viewHolder.ivEntry.setColorFilter(ContextCompat.getColor(activity, R.color.red));
                } else if (paymentLink.status.equalsIgnoreCase("pending")) {
                    viewHolder.ivEntry.setImageResource(R.drawable.ic_baseline_access_time_24);
                    viewHolder.ivEntry.setColorFilter(ContextCompat.getColor(activity, R.color.orders_card_bg_orange));
                    viewHolder.btnResend.setVisibility(View.VISIBLE);
                } else {
                    viewHolder.ivEntry.setColorFilter(ContextCompat.getColor(activity, R.color.persian_green));
                    viewHolder.ivEntry.setImageResource(R.drawable.ic_baseline_green_done_24);
                }
                viewHolder.btnResend.setOnClickListener(view -> {
                    if (clickListener != null) {
                        clickListener.onItemClick(position, paymentLink);
                    }
                });
            }
            if (getItemViewType(position) == R.layout.item_header) {
                Header header = (Header) data.get(position);
                HeaderViewHolder viewHolder = (HeaderViewHolder) holder;
                viewHolder.tvTitle.setText(header.title);
                if (!Validators.isNullOrEmpty(header.total)) {
                    viewHolder.tvTotal.setText(header.total);
                    viewHolder.tvTotal.setVisibility(View.VISIBLE);
                } else {
                    viewHolder.tvTotal.setVisibility(View.GONE);
                }
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return data.size();
    }

    protected static class TransactionViewHolder extends RecyclerView.ViewHolder {
        TextView tvBrand, tvDate, tvAmount, tvType;
        ImageView ivEntry;
        LinearLayout llMain;
        RadioButton rbChecked;
        MaterialButton btnRefund, btnPrint;

        public TransactionViewHolder(@NonNull View itemView) {
            super(itemView);
            btnRefund = itemView.findViewById(R.id.btnRefund);
            btnPrint = itemView.findViewById(R.id.btnPrint);
            tvBrand = itemView.findViewById(R.id.tvBrand);
            tvDate = itemView.findViewById(R.id.tvDate);
            tvAmount = itemView.findViewById(R.id.tvAmount);
            tvType = itemView.findViewById(R.id.tvType);
            ivEntry = itemView.findViewById(R.id.ivEntry);
            llMain = itemView.findViewById(R.id.llMainLayout);
            rbChecked = itemView.findViewById(R.id.rbChecked);

        }
    }

    protected static class OrderTransactionViewHolder extends RecyclerView.ViewHolder {
        TextView tvBrand, tvDate, tvAmount, tvType, tvOrderId, tvPaymentMethod;
        ImageView ivEntry;
        LinearLayout llMain;
        RadioButton rbChecked;

        public OrderTransactionViewHolder(@NonNull View itemView) {
            super(itemView);
            tvBrand = itemView.findViewById(R.id.tvBrand);
            tvDate = itemView.findViewById(R.id.tvDate);
            tvAmount = itemView.findViewById(R.id.tvAmount);
            tvOrderId = itemView.findViewById(R.id.tvOrderId);
            tvPaymentMethod = itemView.findViewById(R.id.tvPaymentMethod);
            tvType = itemView.findViewById(R.id.tvType);
            ivEntry = itemView.findViewById(R.id.ivEntry);
            llMain = itemView.findViewById(R.id.llMainLayout);
            rbChecked = itemView.findViewById(R.id.rbChecked);

        }
    }


    protected static class PaymentLinksViewHolder extends RecyclerView.ViewHolder {
        private TextView tvStatus, tvDate, tvAmount, tvPhone;
        private MaterialButton btnResend;
        private ImageView ivEntry;
        private LinearLayout llMain;

        public PaymentLinksViewHolder(@NonNull View itemView) {
            super(itemView);
            ivEntry = itemView.findViewById(R.id.ivEntry);
            tvStatus = itemView.findViewById(R.id.tvStatus);
            tvDate = itemView.findViewById(R.id.tvDate);
            tvAmount = itemView.findViewById(R.id.tvAmount);
            llMain = itemView.findViewById(R.id.llMainLayout);
            btnResend = itemView.findViewById(R.id.btnResend);
            tvPhone = itemView.findViewById(R.id.tvPhone);

        }
    }

    protected static class HeaderViewHolder extends RecyclerView.ViewHolder {
        private TextView tvTitle, tvTotal;

        public HeaderViewHolder(@NonNull View itemView) {
            super(itemView);
            tvTitle = itemView.findViewById(R.id.tvTitleMain);
            tvTotal = itemView.findViewById(R.id.tvTotal);

        }
    }
}
