package com.ubsidi.epos_2021.merchant.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;

import java.util.List;

public class OpeningTimeSlotAdapter extends RecyclerView.Adapter<OpeningTimeSlotAdapter.ViewHolder> {
    private List<String> timeSlots;
    private RecyclerviewItemClickListener clickListener;

    public OpeningTimeSlotAdapter(List<String> timeSlots, RecyclerviewItemClickListener clickListener) {
        this.timeSlots = timeSlots;
        this.clickListener = clickListener;
    }

    @NonNull
    @Override
    public OpeningTimeSlotAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_opening_time_slots, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull OpeningTimeSlotAdapter.ViewHolder holder, int position) {
        try {
            String time = timeSlots.get(position);
            holder.tvTime.setText(time);

            holder.rlTime.setOnClickListener(v -> {
                if (clickListener != null) {
                    clickListener.onItemClick(position, time);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return timeSlots.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        RelativeLayout rlTime;
        TextView tvTime;
        ImageView ivSelectedTime;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            rlTime = itemView.findViewById(R.id.rlTime);
            tvTime = itemView.findViewById(R.id.tvTime);
            ivSelectedTime = itemView.findViewById(R.id.ivSelectedTime);
        }
    }
}
