package com.ubsidi.epos_2021.merchant.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.chauthai.swipereveallayout.SwipeRevealLayout;
import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.merchant.models.Voucher;
import com.ubsidi.epos_2021.online.interfaces.RecyclerViewItemClickListener;

import java.util.ArrayList;

public class VouchersAdapter extends RecyclerView.Adapter<VouchersAdapter.VoucherViewHolder> {

    private ArrayList<Voucher> vouchers;
    private RecyclerViewItemClickListener editClickListener, removeClickListener;

    public VouchersAdapter(ArrayList<Voucher> vouchers, RecyclerViewItemClickListener editClickListener, RecyclerViewItemClickListener removeClickListener) {
        this.vouchers = vouchers;
        this.editClickListener = editClickListener;
        this.removeClickListener = removeClickListener;
    }

    @NonNull
    @Override
    public VouchersAdapter.VoucherViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new VoucherViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_voucher_list, parent, false));

    }

    @Override
    public void onBindViewHolder(@NonNull VouchersAdapter.VoucherViewHolder holder, int position) {
        try {
            Voucher voucher = vouchers.get(position);

            holder.tvVoucherNumber.setText("Offer " + (position + 1));
            holder.tvToDate.setText("To: " + voucher.voucher_to);
            holder.tvFromDate.setText("From: " + voucher.voucher_from);

            holder.cbDelivery.setChecked(voucher.delivery_type);
            holder.cbCollection.setChecked(voucher.pickup_type);
            holder.cbDinein.setChecked(voucher.dinein_type);
            holder.tvVoucher.setText("Code: " + voucher.voucher_code);
            if (voucher.offer_mode != null) {
                if (voucher.offer_mode.equalsIgnoreCase("price")) {
                    holder.tvVoucherValue.setText("-" + MyApp.getInstance().currencySymbol + voucher.offer_value);
                } else if (voucher.offer_mode.equalsIgnoreCase("percentage")) {
                    holder.tvVoucherValue.setText(voucher.offer_value + "% off");
                } else if (voucher.offer_mode.equalsIgnoreCase("free_delivery")) {
                    holder.tvVoucherValue.setText("Free Delivery");
                }
            }

            holder.cvVoucherValue.setOnClickListener(view -> {
                if (editClickListener != null) {
                    editClickListener.onItemClick(position, voucher);
                }
            });

            holder.llDelete.setOnClickListener(view -> {
                voucher.status = true;
                if (removeClickListener != null) {
                    removeClickListener.onItemClick(position, voucher);
                }
                vouchers.remove(position);
                notifyDataSetChanged();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return vouchers.size();
    }

    public class VoucherViewHolder extends RecyclerView.ViewHolder {
        TextView tvVoucherNumber, tvVoucher, tvEditVoucher, tvVoucherValue, tvEditOrderValue;
        MaterialCardView cvVoucherValue;
        LinearLayout llDelete;
        CheckBox cbDelivery, cbDinein, cbCollection;
        SwipeRevealLayout swipeRevealLayout;
        private TextView tvToDate, tvFromDate;
        private RelativeLayout llFromDate, llToDate;
        int fromYear, fromMonth, fromDay, toYear, toMonth, toDay;
        private String fromDate = "2019-06-01", toDate = "2020-12-31";

        public VoucherViewHolder(@NonNull View itemView) {
            super(itemView);
            tvVoucherNumber = itemView.findViewById(R.id.tvOfferNumber);
            swipeRevealLayout = itemView.findViewById(R.id.swipeRevealLayout);
            llDelete = itemView.findViewById(R.id.llDelete);
            tvVoucher = itemView.findViewById(R.id.tvVoucherCode);
            tvVoucherValue = itemView.findViewById(R.id.tvVoucherValue);

            cbCollection = itemView.findViewById(R.id.cbCollection);
            cbDelivery = itemView.findViewById(R.id.cbDelivery);
            cbDinein = itemView.findViewById(R.id.cbDinein);

            cvVoucherValue = itemView.findViewById(R.id.cvVoucherValue);

            tvToDate = itemView.findViewById(R.id.tvToDate);
            tvFromDate = itemView.findViewById(R.id.tvFromDate);
            llToDate = itemView.findViewById(R.id.llToDate);
            llFromDate = itemView.findViewById(R.id.llFromDate);
        }
    }
}
