package com.ubsidi.epos_2021.merchant.fragments;

import android.content.res.Resources;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Restaurant;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.online.base.BaseDialog;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.json.JSONObject;

public class EditRestaurantDescriptionBottomsheet extends BaseDialog {
    private AppCompatEditText etDecription;
    private TextView tvWordCounter;
    private MaterialButton btnCancel, btnUpdate;
    private Restaurant loggedInRestaurant = MyApp.getInstance().myPreferences.getRestaurant();
    private MyPreferences myPreferences = myApp.myPreferences;

    private String description;
    private DialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_edit_description_bottomsheet, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        WindowManager.LayoutParams params = getDialog().getWindow().getAttributes();
        params.width = ViewGroup.LayoutParams.WRAP_CONTENT;
        params.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        getDialog().getWindow().setAttributes(params);
        updateViews();
    }


    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (intentExtrasData.containsKey("res_description")) {
            description = String.valueOf(intentExtrasData.get("res_description"));
        }
    }

    @Override
    protected void setListeners() {
        super.setListeners();
        etDecription.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                tvWordCounter.setText(etDecription.length() + "/300");
                if (etDecription.length() > 300) {
                    tvWordCounter.setTextColor(getResources().getColor(R.color.red));
                } else {
                    tvWordCounter.setTextColor(getResources().getColor(R.color.black));
                }
            }
        });
        btnCancel.setOnClickListener(v -> dismiss());
        btnUpdate.setOnClickListener(view -> {
            if (etDecription.length() > 300) {
                ToastUtils.makeToast(getActivity(), "Description length should not more than 300 characters");
            } else {
                updateRestaurantDescription();
            }
        });
    }

    private void updateRestaurantDescription() {
        try {
            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                progressDialog.show();
            });
            AndroidNetworking.post(ApiEndPoints.restaurant_details + loggedInRestaurant.id)
                    .addBodyParameter("restaurant_about", etDecription.getText().toString())
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                    progressDialog.dismiss();
                                });
                                ToastUtils.makeToast(getActivity(), "Restaurant description updated!");
                                loggedInRestaurant.restaurant_about = etDecription.getText().toString();
                                myPreferences.saveRestaurant((loggedInRestaurant));
                                if (dialogDismissListener != null) {
                                    dialogDismissListener.onDialogDismiss(null);
                                }
                                dismiss();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                    progressDialog.dismiss();
                                });
                                if (anError.getErrorCode() == 400) {
                                    ToastUtils.makeToast(getActivity(), anError.getErrorAsObject(ApiError.class).getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateViews() {
        try {
            etDecription.setText(description);
            etDecription.setSelection(etDecription.getText().length());
            tvWordCounter.setText(etDecription.length() + "/300");
            tvWordCounter.setTextColor(getResources().getColor(R.color.black));
            if (etDecription.length() > 300) {
                tvWordCounter.setTextColor(getResources().getColor(R.color.red));
            } else {
                tvWordCounter.setTextColor(getResources().getColor(R.color.black));
            }
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
    }


    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            ivClose = view.findViewById(R.id.ivClose);
            etDecription = view.findViewById(R.id.etDecription);
            tvWordCounter = view.findViewById(R.id.tvWordCounter);
            btnCancel = view.findViewById(R.id.btnCancel);
            btnUpdate = view.findViewById(R.id.btnUpdate);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
