package com.ubsidi.epos_2021.merchant.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.fragment.app.DialogFragment;

import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.comman.MoneyTextWatcher;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;

/**
 * Created by Amrish on 11-11-2020.
 */
public class EnterAmountDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private MaterialButton btnConfirm, btnCancel;
    private AppCompatEditText etAmount;
    private DialogDismissListener dialogDismissListener;
    private String amount, title;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_enter_amount, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (getArguments() != null) {
                amount = getArguments().getString("amount");
                title = getArguments().getString("title");
            }
            initViews(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            TextView tvTitle = view.findViewById(R.id.tvTitle);
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnCancel = view.findViewById(R.id.btnCancel);
            etAmount = view.findViewById(R.id.etAmount);
            etAmount.setText(amount);
            etAmount.setSelection(etAmount.getText().toString().length());
            if (!Validators.isNullOrEmpty(title)) {
                tvTitle.setText(title);
                etAmount.setHint(title);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));
            btnConfirm.setOnClickListener(view -> {
                etAmount.setError(null);
                if (Validators.isNullOrEmpty(etAmount.getText().toString())) {
                    if (!Validators.isNullOrEmpty(title)) {
                        etAmount.setError("Please " + title.toLowerCase());
                    } else {
                        etAmount.setError("Please enter amount");
                    }
                } else {
                    if (dialogDismissListener != null)
                        dialogDismissListener.onDialogDismiss(etAmount.getText().toString().replace(",", ""));
                    dismiss();
                }
            });
            btnCancel.setOnClickListener(view -> {
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss(null);
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void changeStatus() {

    }
}
