package com.ubsidi.epos_2021.merchant.fragments;

import android.graphics.Paint;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.ViewPager;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.github.mikephil.charting.charts.BarChart;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarDataSet;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.formatter.IndexAxisValueFormatter;
import com.github.mikephil.charting.formatter.ValueFormatter;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.button.MaterialButtonToggleGroup;
import com.google.android.material.card.MaterialCardView;
import com.lwj.widget.viewpagerindicator.ViewPagerIndicator;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.interfaces.FragmentChangeListener;
import com.ubsidi.epos_2021.merchant.adapters.MerchantTransactionsAdapter;
import com.ubsidi.epos_2021.merchant.adapters.ScheduledPaymentViewPagerAdapter;
import com.ubsidi.epos_2021.merchant.models.MerchantTransaction;
import com.ubsidi.epos_2021.merchant.models.PaymentModel;
import com.ubsidi.epos_2021.merchant.models.SchedulePayments;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.MerchantStatement;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MerchantDashboardFragment extends BaseFragment {

    private LinearLayout llLoading, llData, llViewTransactions, llViewStatements;
    BarChart barMerchantPayments;
    private ArrayList<MerchantStatement> statements = new ArrayList<>();
    private MaterialButtonToggleGroup btnRangeToggle;
    private MerchantTransactionsAdapter transactionsAdapter;
    private String toDateString, fromDateString;
    private ArrayList<Object> transactions = new ArrayList<>();
    private ArrayList<SchedulePayments> schedulePayments = new ArrayList<>();
    public FragmentChangeListener changeListener;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_merchant_dashboard, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            setListeners();
            fetchPaymentOverview();
            fetchStatements();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void initViews(View view) {
        try {
            llLoading = view.findViewById(R.id.llLoading);
            llData = view.findViewById(R.id.llData);
            RecyclerView rvTransactions = view.findViewById(R.id.rvTransactions);
            llViewTransactions = view.findViewById(R.id.llMerchantTransactionsViewAll);
            TextView tvViewTransactions = view.findViewById(R.id.tvViewTransactions);
            llViewStatements = view.findViewById(R.id.llViewStatements);
            TextView tvViewStatements = view.findViewById(R.id.tvViewStatements);

            btnRangeToggle = view.findViewById(R.id.btnRangeGroup);
            ViewPager vpSchedule = view.findViewById(R.id.vpPayment);
            ViewPagerIndicator vpIndicator = view.findViewById(R.id.circleIndicator);

            tvViewTransactions.setPaintFlags(Paint.UNDERLINE_TEXT_FLAG);
            tvViewStatements.setPaintFlags(Paint.UNDERLINE_TEXT_FLAG);
            barMerchantPayments = view.findViewById(R.id.barMerchantPayments);
            ScheduledPaymentViewPagerAdapter vpAdapter = new ScheduledPaymentViewPagerAdapter(getActivity(), schedulePayments);
            vpSchedule.setAdapter(vpAdapter);
            vpIndicator.setViewPager(vpSchedule);

            transactionsAdapter = new MerchantTransactionsAdapter(transactions, false, false,
                    (position, data) -> {

                    }, (position, data) -> {

            }, (position, data) -> {

            });

            rvTransactions.setLayoutManager(new LinearLayoutManager(getActivity(), LinearLayoutManager.VERTICAL, false));
            rvTransactions.setAdapter(transactionsAdapter);
            initBarChart();

            Calendar calendar = Calendar.getInstance();
            calendar.set(Calendar.DAY_OF_MONTH, 1);
            fromDateString = CommonFunctions.formatMiliToDesireFormat(calendar.getTimeInMillis(), "yyyy-MM-dd");

            calendar = Calendar.getInstance();
            calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
            toDateString = CommonFunctions.formatMiliToDesireFormat(calendar.getTimeInMillis(), "yyyy-MM-dd");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            llViewTransactions.setOnClickListener(v -> {
                if (changeListener != null) {
                    changeListener.onFragmentChange("transactions");
                }
            });

            llViewStatements.setOnClickListener(v -> {
                if (changeListener != null) {
                    changeListener.onFragmentChange("statements");
                }
            });
            btnRangeToggle.addOnButtonCheckedListener((group, checkedId, isChecked) -> {
                try {
                    if (isChecked) {

                        if (checkedId == R.id.btnThisMonth) {
                            Calendar calendar = Calendar.getInstance();
                            calendar.set(Calendar.DAY_OF_MONTH, 1);
                            fromDateString = CommonFunctions.formatMiliToDesireFormat(calendar.getTimeInMillis(), "yyyy-MM-dd");

                            calendar = Calendar.getInstance();
                            calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
                            toDateString = CommonFunctions.formatMiliToDesireFormat(calendar.getTimeInMillis(), "yyyy-MM-dd");
                            fetchStatements();

                        } else if (checkedId == R.id.btnLastMonth) {
                            Calendar calendar = Calendar.getInstance();
                            calendar.set(Calendar.DAY_OF_MONTH, 1);
                            calendar.add(Calendar.MONTH, -1);
                            fromDateString = CommonFunctions.formatMiliToDesireFormat(calendar.getTimeInMillis(), "yyyy-MM-dd");

                            calendar = Calendar.getInstance();
                            calendar.add(Calendar.MONTH, -1);
                            calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
                            toDateString = CommonFunctions.formatMiliToDesireFormat(calendar.getTimeInMillis(), "yyyy-MM-dd");
                            fetchStatements();
                        } else if (checkedId == R.id.btnThisYear) {
                            Calendar calendar = Calendar.getInstance();
                            calendar.set(Calendar.DAY_OF_MONTH, 1);
                            calendar.set(Calendar.MONTH, 0);
                            fromDateString = CommonFunctions.formatMiliToDesireFormat(calendar.getTimeInMillis(), "yyyy-MM-dd");

                            calendar = Calendar.getInstance();
                            calendar.set(Calendar.DAY_OF_YEAR, calendar.getActualMaximum(Calendar.DAY_OF_YEAR));
                            toDateString = CommonFunctions.formatMiliToDesireFormat(calendar.getTimeInMillis(), "yyyy-MM-dd");
                            fetchStatements();
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchPaymentOverview() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    llLoading.setVisibility(View.VISIBLE);
                    llData.setVisibility(View.GONE);
                });
            }

            ANRequest.GetRequestBuilder anBuilder = AndroidNetworking.get(ApiEndPoints.merchant_transactions);
            anBuilder.addPathParameter("business_id", myPreferences.getBusinessId());
            anBuilder.addQueryParameter("nopaginate", "1");
            anBuilder.build()
                    .getAsObjectList(MerchantTransaction.class, new ParsedRequestListener<List<MerchantTransaction>>() {
                        @Override
                        public void onResponse(List<MerchantTransaction> response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llLoading.setVisibility(View.GONE);
                                        llData.setVisibility(View.VISIBLE);
                                    });
                                }

                                transactions.clear();
                                transactions.addAll(response);
                                transactionsAdapter.notifyDataSetChanged();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llLoading.setVisibility(View.GONE);
                                        llData.setVisibility(View.GONE);
                                    });
                                }

                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void initBarChart() {
        barMerchantPayments.setDrawValueAboveBar(true);
        barMerchantPayments.setFitBars(false);
        barMerchantPayments.setDescription(null);
        barMerchantPayments.getLegend().setEnabled(false);

        barMerchantPayments.getAxisLeft().setDrawLabels(false);
        barMerchantPayments.getAxisLeft().setDrawGridLines(false);
        barMerchantPayments.getAxisLeft().setDrawAxisLine(false);

        barMerchantPayments.getAxisRight().setDrawLabels(false);
        barMerchantPayments.getAxisRight().setDrawGridLines(false);
        barMerchantPayments.getAxisRight().setDrawAxisLine(false);

        barMerchantPayments.getXAxis().setDrawAxisLine(false);
        barMerchantPayments.getXAxis().setDrawGridLines(false);
        barMerchantPayments.getXAxis().setGranularity(1);
        barMerchantPayments.getXAxis().setPosition(XAxis.XAxisPosition.BOTTOM);
        barMerchantPayments.setDoubleTapToZoomEnabled(false);
        barMerchantPayments.setDoubleTapToZoomEnabled(false);
        barMerchantPayments.setPinchZoom(false);
        barMerchantPayments.setScaleEnabled(false);
        barMerchantPayments.getLegend().setTextSize(18);
    }

    private void fetchStatements() {
        try {
            AndroidNetworking.get(ApiEndPoints.merchant_statements)
                    .addQueryParameter("from_date", fromDateString)
                    .addQueryParameter("to_date", toDateString)
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(MerchantStatement.class, new ParsedRequestListener<List<MerchantStatement>>() {
                        @Override
                        public void onResponse(List<MerchantStatement> response) {
                            try {
                                statements.clear();
                                statements.addAll(response);
                                updateChart();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (anError.getErrorCode() == 400) {
                                    statements.clear();
                                    updateChart();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateChart() {
        try {
            float total = 0;

            LinkedHashMap<String, ArrayList<MerchantStatement>> listLinkedHashMap = new LinkedHashMap<>();
            for (MerchantStatement statement : statements) {
                total = total + statement.net_total;
                ArrayList<MerchantStatement> merchantStatements = new ArrayList<>();
                if (!listLinkedHashMap.containsKey(statement.to_date)) {
                    for (MerchantStatement sub_statement : statements) {
                        if (statement.to_date.equalsIgnoreCase(sub_statement.to_date)) {
                            merchantStatements.add(sub_statement);
                        }
                    }
                    listLinkedHashMap.put(statement.to_date, merchantStatements);
                }
            }
            ArrayList<MerchantStatement> merchantStatementsModified = new ArrayList<>();
            for (Map.Entry<String, ArrayList<MerchantStatement>> entry : listLinkedHashMap.entrySet()) {
                MerchantStatement merchantStatement = new MerchantStatement();
                merchantStatement.to_date = entry.getKey();
                for (MerchantStatement statement : entry.getValue()) {
                    merchantStatement.net_total = statement.net_total + merchantStatement.net_total;
                }
                merchantStatementsModified.add(merchantStatement);
            }

            List<BarEntry> barEntries = new ArrayList<>();
            int count = 0;
            ArrayList<String> xValues = new ArrayList<String>();
            Collections.reverse(merchantStatementsModified);
            for (MerchantStatement merchantStatement : merchantStatementsModified) {
                barEntries.add(new BarEntry(count, merchantStatement.net_total));
                xValues.add(CommonFunctions.formatUnknownDateTime(merchantStatement.to_date, "yyyy-MM-dd", "dd/MM/yy"));
                count++;
            }

            BarDataSet barDataSet = new BarDataSet(barEntries, "Dates");
            if (getActivity() != null)
                barDataSet.setColor(ContextCompat.getColor(getActivity(), R.color.persian_green));
            barDataSet.setValueFormatter(new ValueFormatter() {
                @Override
                public String getFormattedValue(float value) {
                    return (value == 0) ? "" : MyApp.currencySymbol + MyApp.df.format(value);
                }
            });
            barDataSet.setValueTextSize(16);
            BarData barData = new BarData(barDataSet);
            barData.setBarWidth(0.9f);
            barMerchantPayments.setData(barData);
            barMerchantPayments.getLegend().setTextSize(18f);
            barMerchantPayments.setExtraBottomOffset(5);
            XAxis xAxis = barMerchantPayments.getXAxis();
            xAxis.setTextSize(14f);
            xAxis.setValueFormatter(new IndexAxisValueFormatter(xValues));
            barMerchantPayments.invalidate();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
