package com.ubsidi.epos_2021.merchant.fragments;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.chip.Chip;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.MenuAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.fragment.ReservationsSetting;
import com.ubsidi.epos_2021.fragment.SettingsUserManaementFragment;
import com.ubsidi.epos_2021.models.ExclusionModel;
import com.ubsidi.epos_2021.models.Restaurant;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

public class MerchantSettingsFragment extends BaseFragment {

    private LinearLayout llProgress, llData;
    private ArrayList<ExclusionModel> settingList = new ArrayList<>();
    private MenuAdapter menuAdapter;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_merchant_settings, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        setUpSettings();
        if (!Validators.isNullOrEmpty(myApp.restaurant_id)) {
            fetchRestaurantDetails();
        }
    }


    private void fetchRestaurantDetails() {
        try {
            if (Validators.isNullOrEmpty(myApp.restaurant_id)) {
                return;
            }
            AndroidNetworking.get(ApiEndPoints.restaurant_details + myApp.restaurant_id)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            myPreferences.saveRestaurant(response);
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setUpSettings() {
        try {
            settingList.clear();
            ExclusionModel model = new ExclusionModel();
            if (!Validators.isNullOrEmpty(myApp.restaurant_id)) {

                model = new ExclusionModel();
                model.id = "restaurant_details";
                model.name = "Restaurant Details";
                model.isCheckable = true;
                settingList.add(model);

                model = new ExclusionModel();
                model.id = "restaurant_management";
                model.name = "Restaurant Management";
                model.isCheckable = true;
                settingList.add(model);

                model = new ExclusionModel();
                model.id = "profile";
                model.name = "Profile";
                model.isCheckable = true;
                settingList.add(model);

                model = new ExclusionModel();
                model.id = "bank_details";
                model.name = "Bank Account Details";
                model.isCheckable = true;
                settingList.add(model);

                model = new ExclusionModel();
                model.id = "feedback";
                model.name = "Feedback";
                model.isCheckable = true;
                settingList.add(model);

                model = new ExclusionModel();
                model.id = "contact_tiffintom";
                model.name = "Contact TiffinTom";
                model.isCheckable = false;
                settingList.add(model);
            }

            if (MyApp.userPermission != null && MyApp.userPermission.clear_database.actions.list) {
                model = new ExclusionModel();
                model.id = "data_management";
                model.name = "Data Management";
                model.isCheckable = true;
                settingList.add(model);
            }
            if (false) {
                model = new ExclusionModel();
                model.id = "user_management";
                model.name = "User Management";
                model.isCheckable = true;
                settingList.add(model);
            }
            model = new ExclusionModel();
            model.id = "reservations_setting";
            model.name = "Reservations Setting";
            model.isCheckable = true;
            settingList.add(model);

            model = new ExclusionModel();
            model.id = "db_file";
            model.name = "Send db file";
            model.isCheckable = true;
            settingList.add(model);

            model = new ExclusionModel();
            model.id = "clear_cache";
            model.name = "Clear Cache";
            model.isCheckable = true;
            settingList.add(model);
            selectDefault();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void selectDefault() {
        try {
            if (settingList.size() > 0) {
                settingList.get(0).isChecked = true;
                menuAdapter.checkedId = settingList.get(0).id;
                handleMenuClick(settingList.get(0));
            }
            menuAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    int Year, Month, Day;

    private void initViews(View view) {
        try {
            RecyclerView rvSettings = view.findViewById(R.id.rvSettings);
            llProgress = view.findViewById(R.id.llProgress);
            llData = view.findViewById(R.id.llData);
            Chip chipBack = view.findViewById(R.id.chipBack);

            menuAdapter = new MenuAdapter(settingList, true, true, (position, data) -> {
                ExclusionModel model = (ExclusionModel) data;
                handleMenuClick(model);

            });
            rvSettings.setLayoutManager(new LinearLayoutManager(getActivity(), LinearLayoutManager.VERTICAL, false));
            rvSettings.setAdapter(menuAdapter);

            chipBack.setOnClickListener(v -> getActivity().onBackPressed());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleMenuClick(ExclusionModel model) {
        try {
            if (model.id.equalsIgnoreCase("restaurant_details")) {
                changeFragment(new SettingsRestaurantDetailsFragment());
            } else if (model.id.equalsIgnoreCase("restaurant_management")) {
                changeFragment(new SettingsRestaurantManagementFragment());
            } else if (model.id.equalsIgnoreCase("profile")) {
                changeFragment(new SettingsProfileFragment());
            } else if (model.id.equalsIgnoreCase("bank_details")) {
                changeFragment(new SettingsBankDetailsFragment());
            } else if (model.id.equalsIgnoreCase("feedback")) {
                changeFragment(new SettingsFeedbackFragment());
            } else if (model.id.equalsIgnoreCase("contact_tiffintom")) {
                openContactDialog();
            } else if (model.id.equalsIgnoreCase("data_management")) {
                changeFragment(new SettingsDataManagementFragment());
            } else if (model.id.equalsIgnoreCase("user_management")) {
                changeFragment(new SettingsUserManaementFragment());
            } else if (model.id.equalsIgnoreCase("reservations_setting")) {
                changeFragment(new ReservationsSetting());
            } else if (model.id.equalsIgnoreCase("db_file")) {
                uploadDbFile();
            } else if (model.id.equalsIgnoreCase("clear_cache")) {
                myApp.clearCache();
                ToastUtils.makeToast(requireActivity(), "Cache Cleared Successfully");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void uploadDbFile() {
        try {
            getActivity().runOnUiThread(() ->
                    llProgress.setVisibility(View.VISIBLE));
            ANRequest.MultiPartBuilder androidNetworking = AndroidNetworking.upload(ApiEndPoints.database_file);
            //.addMultipartParameter(params);
            androidNetworking.addMultipartFile("log_file", requireActivity().getDatabasePath("epos_2021-database"));
            androidNetworking
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                getActivity().runOnUiThread(() ->
                                        llProgress.setVisibility(View.GONE));
                                getActivity().runOnUiThread(() ->
                                        ToastUtils.showSnackBar(requireContext(), llData, "File send successfully", "success"));
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (anError.getErrorBody() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        JSONObject jsonObject;
                                        try {
                                            jsonObject = new JSONObject(anError.getErrorBody());
                                            if (jsonObject.has("message")) {
                                                ToastUtils.showSnackBar(requireContext(), llData, jsonObject.getString("message"), "reject");
                                            } else if (!Validators.isNullOrEmpty(anError.getErrorDetail())) {
                                                ToastUtils.makeToast(requireContext(), anError.getErrorDetail());
                                            }
                                        } catch (JSONException e) {
                                            e.printStackTrace();
                                        }
                                    });
                                } else if (!Validators.isNullOrEmpty(anError.getErrorDetail())) {
                                    ToastUtils.makeToast(requireContext(), anError.getErrorDetail());
                                }
                                anError.printStackTrace();
                                if (getActivity() != null)
                                    getActivity().runOnUiThread(() ->
                                            llProgress.setVisibility(View.GONE));
                                if (!CommonFunctions.isConnected(getActivity()))
                                    myApp.noInternet(getActivity());
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openContactDialog() {
        try {
            Restaurant restaurant = myPreferences.getRestaurant();
            SettingsContactTiffintomDialogFragment contactDialogFragment = new SettingsContactTiffintomDialogFragment();
            contactDialogFragment.show(getChildFragmentManager(), "contact_us");
            contactDialogFragment.setDialogDismissListener(o -> {
                Intent intent;
                if (((String) o).equalsIgnoreCase("call")) {
                    intent = new Intent();
                    intent.setAction(Intent.ACTION_DIAL);
                    intent.setData(Uri.parse("tel: " + restaurant.contact_phone));
                } else {
                    //Do Email
                    intent = new Intent(Intent.ACTION_SENDTO);
                    intent.setData(Uri.parse("mailto:")); // only email apps should handle this
                    intent.putExtra(Intent.EXTRA_EMAIL, new String[]{restaurant.contact_email});
                }
                startActivity(intent);
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeFragment(Fragment fragment) {
        try {
            FragmentManager manager = getChildFragmentManager();
            FragmentTransaction transaction = manager.beginTransaction();
            transaction.replace(R.id.nav_setting_fragment, fragment);
            transaction.addToBackStack("can_go_back");
            transaction.commitAllowingStateLoss();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}