package com.ubsidi.epos_2021.merchant.fragments;

import static com.ubsidi.epos_2021.utils.Constants.DAY_BEFORE_YESTERDAY_CLICKED;
import static com.ubsidi.epos_2021.utils.Constants.TODAY_CLICKED;
import static com.ubsidi.epos_2021.utils.Constants.YESTERDAY_CLICKED;
import static com.ubsidi.epos_2021.utils.Constants._2_DAY_BEFORE_YESTERDAY_CLICKED;

import android.bluetooth.BluetoothDevice;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.androidnetworking.interfaces.StringRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.gson.Gson;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinterV3Mix;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.fragment.ConfirmationDialogFragment;
import com.ubsidi.epos_2021.merchant.adapters.MerchantTransactionsAdapter;
import com.ubsidi.epos_2021.merchant.models.Header;
import com.ubsidi.epos_2021.merchant.models.MerchantBusinessesAllTransaction;
import com.ubsidi.epos_2021.merchant.models.MerchantOrderTransaction;
import com.ubsidi.epos_2021.merchant.models.MerchantPaypalTransaction;
import com.ubsidi.epos_2021.merchant.models.MerchantTransaction;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.models.MerchantUserPermission;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.online.fragments.EnterPasswordDialogFragment;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

/**
 * Created by Amrish on 09-06-2021.
 */
public class MerchantTransactionsFragment extends BaseFragment {
    private TextView tvSelectTransactions, tvErrorMessage;
    private boolean isLoading = false;
    private ArrayList<Object> transactions = new ArrayList<>();
    private ArrayList<String> checkedStripeIds = new ArrayList<>();
    private ArrayList<String> checkedPaypalIds = new ArrayList<>();
    private ArrayList<String> checkedOrderIds = new ArrayList<>();

    private SwipeRefreshLayout swipeRefreshLayout;
    private LinearLayout llArchiveActions;
    private TextView tvSelectedTransactions;
    private MaterialButton btnCancel, btnArchive, btnDayBeforeYesterday, btnYesterday, btnToday,btn2DayBeforeYesterday;
    private TextView tvMonth;
    private TextView tvTotal;
    private boolean archivedTransactions = false, refundedTransactions = false;
    private ImageView ivBack;
    private ZoneRichPrinter zoneRichPrinter;
    public BluetoothPrinter bluetoothPrinter;
    public WifiPrinter wifiPrinter;
    private SunmiPrinter sunmiPrinter;
    private SunmiPrinterV3Mix sunmiPrinterV3Mix;
    private Printer defaultPrinter;
    private MerchantTransactionsAdapter merchantTransactionsAdapter;
    private AlertDialog progressDialog;
    private String fromDateString = "2019-06-01", toDateString = "2020-12-31";
    private Business selectedBusiness = myPreferences.getLoggedInAdmin().selected_business;
    private SiteSetting ticketHeaderSetting;
    private SiteSetting footerASetting;
    private SiteSetting footerBSetting;
    private int headerAlignment = 0;
    private MerchantUserPermission permission;
    private Calendar fromCalendar = Calendar.getInstance();
    private Calendar toCalendar = Calendar.getInstance();
    private int currentPage = 1;

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getArguments() != null) {
            String type = getArguments().getString("type");
            if (!Validators.isNullOrEmpty(type)) {
                refundedTransactions = type.equalsIgnoreCase("refunded");
                archivedTransactions = type.equalsIgnoreCase("archived");

            }
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_merchant_transactions, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            loadSettings();
            setBtnDate();
            setListeners();
            //fetchTransactions();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadSettings() {
        try {
            SiteSetting ticketHeaderTypeSetting = myApp.findSetting("ticket_header_type");
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("right")) {
                headerAlignment = 2;
            }
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("center")) {
                headerAlignment = 1;
            }
            ticketHeaderSetting = myApp.findSetting("ticket_header");

            footerASetting = myApp.findSetting("footer_a");
            footerBSetting = myApp.findSetting("footer_b");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            int merchantRole = myPreferences.getMerchantRole();
            if (merchantRole == 2) {
                permission = selectedBusiness.admin_permissions;
            } else if (merchantRole == 1) {
                permission = selectedBusiness.supervisor_permissions;
            } else {
                permission = null;
            }
            progressDialog = CommonFunctions.customProgressDialog(getActivity());
            defaultPrinter = myPreferences.getDefaultPrinter();
            zoneRichPrinter = new ZoneRichPrinter(getActivity());
            bluetoothPrinter = new BluetoothPrinter(getActivity());
            zoneRichPrinter = myApp.connectZonerich(zoneRichPrinter, defaultPrinter);

            try {
                wifiPrinter = WifiPrinter.getInstance();

                if (defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    wifiPrinter.connect(defaultPrinter.ip);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

            sunmiPrinter = new SunmiPrinter(getActivity());
            if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                sunmiPrinterV3Mix = new SunmiPrinterV3Mix(requireActivity());
            }
            tvErrorMessage = view.findViewById(R.id.tvErrorMessage);
            TextView tvTitle = view.findViewById(R.id.tvTitle);
            tvTotal = view.findViewById(R.id.tvTotal);
            tvMonth = view.findViewById(R.id.tvTitleMain);
            tvSelectTransactions = view.findViewById(R.id.tvSelectTransactions);
            tvSelectedTransactions = view.findViewById(R.id.tvSelectedTransactions);
            TextView tvSubTitle = view.findViewById(R.id.tvSubTitle);
            llArchiveActions = view.findViewById(R.id.llArchiveAction);
            btnArchive = view.findViewById(R.id.btnArchive);
            btnCancel = view.findViewById(R.id.btnCancel);
            btnDayBeforeYesterday = view.findViewById(R.id.btnDayBeforeYesterday);
            btn2DayBeforeYesterday = view.findViewById(R.id.btn2DayBeforeYesterday);
            btnYesterday = view.findViewById(R.id.btnYesterday);
            btnToday = view.findViewById(R.id.btnToday11);
            ivBack = view.findViewById(R.id.ivBack);
            RecyclerView rvTransactions = view.findViewById(R.id.rvTransactions);
            swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);


            tvSubTitle.setVisibility(View.GONE);
            if (refundedTransactions) {
                tvSelectTransactions.setVisibility(View.GONE);
            }
            if (archivedTransactions) {
                tvTitle.setText("Archived Transactions");
                btnArchive.setText("Unarchive");
            }
            if (refundedTransactions) {
                tvTitle.setText("Refunded Transactions");
            }
            merchantTransactionsAdapter = new MerchantTransactionsAdapter(transactions, !refundedTransactions && (permission != null && permission.refund), (position, data) -> {
                if (data instanceof MerchantTransaction) {
                    MerchantTransaction transaction = (MerchantTransaction) data;
                    if (transaction.checked) {
                        if (!checkedStripeIds.contains(transaction.id)) {
                            checkedStripeIds.add(transaction.id);
                        }
                    } else {
                        checkedStripeIds.remove(transaction.id);
                    }
                }
                if (data instanceof MerchantPaypalTransaction) {
                    MerchantPaypalTransaction transaction = (MerchantPaypalTransaction) data;
                    if (transaction.checked) {
                        if (!checkedPaypalIds.contains(transaction.id)) {
                            checkedPaypalIds.add(transaction.id);
                        }
                    } else {
                        checkedPaypalIds.remove(transaction.id);
                    }
                }
                if (data instanceof MerchantOrderTransaction) {
                    MerchantOrderTransaction transaction = (MerchantOrderTransaction) data;
                    if (transaction.checked) {
                        if (!checkedOrderIds.contains(transaction.id)) {
                            checkedOrderIds.add(transaction.id);
                        }
                    } else {
                        checkedOrderIds.remove(transaction.id);
                    }
                }
                if ((checkedStripeIds.size() + checkedPaypalIds.size() + checkedOrderIds.size()) > 0) {
                    tvSelectedTransactions.setText((checkedStripeIds.size() + checkedPaypalIds.size() + checkedOrderIds.size()) + " transactions selected");
                    llArchiveActions.setVisibility(View.VISIBLE);
                } else {
                    llArchiveActions.setVisibility(View.GONE);
                }
                merchantTransactionsAdapter.notifyDataSetChanged();
            }, (position, data) -> {
                if (data instanceof MerchantTransaction)
                    refundTransaction((MerchantTransaction) data);
            }, (position, data) -> {
                if (data instanceof MerchantTransaction)
                    printTransaction("Merchant copy", (MerchantTransaction) data, getString(R.string.re_print));
            });
            rvTransactions.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            rvTransactions.addOnScrollListener(new RecyclerView.OnScrollListener() {
                @Override
                public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                    super.onScrollStateChanged(recyclerView, newState);
                }

                @Override
                public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                    super.onScrolled(recyclerView, dx, dy);

                    LinearLayoutManager linearLayoutManager = (LinearLayoutManager) recyclerView.getLayoutManager();
                    if (!isLoading) {
                        if (linearLayoutManager != null && linearLayoutManager.findLastCompletelyVisibleItemPosition() == transactions.size() - 1) {
                            //bottom of list!
                            currentPage++;
                            fetchTransactions();
                            isLoading = true;
                        }
                    }
                }
            });
            rvTransactions.setAdapter(merchantTransactionsAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void setListeners() {
        try {
            swipeRefreshLayout.setOnRefreshListener(this::fetchTransactions);

            tvSelectTransactions.setOnClickListener(view -> {
                merchantTransactionsAdapter.showCheck = !merchantTransactionsAdapter.showCheck;
                merchantTransactionsAdapter.notifyDataSetChanged();
                if (merchantTransactionsAdapter.showCheck) {
                    tvSelectTransactions.setText("Cancel");
                } else {
                    tvSelectTransactions.setText("Select");
                    unSelectAll();
                }
            });
            btnCancel.setOnClickListener(view -> {
                tvSelectTransactions.performClick();
            });

            btnArchive.setOnClickListener(view -> {
                {
                    archiveUnArchiveTransactions();
                }
            });
            ivBack.setOnClickListener(v -> getActivity().onBackPressed());
            btnToday.setOnClickListener(view -> setButtonTintForButton(TODAY_CLICKED));
            btnYesterday.setOnClickListener(view -> setButtonTintForButton(YESTERDAY_CLICKED));
            btnDayBeforeYesterday.setOnClickListener(view -> setButtonTintForButton(DAY_BEFORE_YESTERDAY_CLICKED));
            btn2DayBeforeYesterday.setOnClickListener(view -> setButtonTintForButton(_2_DAY_BEFORE_YESTERDAY_CLICKED));
            btnToday.performClick();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setBtnDate() {
        try {
            String fromDate;
            Calendar cal = Calendar.getInstance(Locale.getDefault());
            fromDate = CommonFunctions.formatMiliToDesireFormat(cal.getTimeInMillis(), "dd/MM/yy");
            btnToday.setText(fromDate);

            cal = Calendar.getInstance(Locale.getDefault());
            cal.add(Calendar.DAY_OF_MONTH, -1);
            fromDate = CommonFunctions.formatMiliToDesireFormat(cal.getTimeInMillis(), "dd/MM/yy");
            btnYesterday.setText(fromDate);

            cal = Calendar.getInstance(Locale.getDefault());
            cal.add(Calendar.DAY_OF_MONTH, -2);
            fromDate = CommonFunctions.formatMiliToDesireFormat(cal.getTimeInMillis(), "dd/MM/yy");
            btnDayBeforeYesterday.setText(fromDate);

            cal = Calendar.getInstance();
            cal.add(Calendar.DAY_OF_MONTH, -3);
            fromDate = CommonFunctions.formatMiliToDesireFormat(cal.getTimeInMillis(), "dd/MM/yy");
            btn2DayBeforeYesterday.setText(fromDate);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setButtonTintForButton(String isFromButton) {
        if (Objects.equals(isFromButton, TODAY_CLICKED)) {
            btnToday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.persian_green));
            btnYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            btnDayBeforeYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            btn2DayBeforeYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            toCalendar = Calendar.getInstance();
            fromCalendar = Calendar.getInstance();
        } else if (Objects.equals(isFromButton, YESTERDAY_CLICKED)) {
            btnToday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            btnYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.persian_green));
            btnDayBeforeYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            btn2DayBeforeYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            toCalendar = Calendar.getInstance();
            fromCalendar = Calendar.getInstance();
            fromCalendar.add(Calendar.DAY_OF_MONTH, -1);
            toCalendar.add(Calendar.DAY_OF_MONTH, -1);
        }else if (Objects.equals(isFromButton, _2_DAY_BEFORE_YESTERDAY_CLICKED)) {
            btnToday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            btnDayBeforeYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            btn2DayBeforeYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.persian_green));
            btnYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            toCalendar = Calendar.getInstance();
            fromCalendar = Calendar.getInstance();
            fromCalendar.add(Calendar.DAY_OF_MONTH, -3);
            toCalendar.add(Calendar.DAY_OF_MONTH, -3);
        } else {
            btnToday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            btnDayBeforeYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.persian_green));
            btnYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            btn2DayBeforeYesterday.setBackgroundTintList(ContextCompat.getColorStateList(requireContext(), R.color.dark_grey_color));
            toCalendar = Calendar.getInstance();
            fromCalendar = Calendar.getInstance();
            fromCalendar.add(Calendar.DAY_OF_MONTH, -2);
            toCalendar.add(Calendar.DAY_OF_MONTH, -2);
        }
        transactions.clear();
        merchantTransactionsAdapter.notifyDataSetChanged();
        updateViews();
        currentPage =1;
        tvMonth.setVisibility(View.GONE);
        tvTotal.setVisibility(View.GONE);
        fetchTransactions();
    }

    private void updateViews() {
        try {
            fromDateString = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
            toDateString = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HashMap<String, String> generateTransactionParams() {
        HashMap<String, String> params = new HashMap<>();
        params.put("from_date", fromDateString);
        params.put("to_date", toDateString);
        //params.put("nopaginate", "1");
        params.put("page", String.valueOf(currentPage));
        int limit = 100;
        params.put("per_page", String.valueOf(limit));
        if (archivedTransactions) {
            params.put("filter", "archived");
        }
        if (refundedTransactions) {
            params.put("filter", "refunded");
        }
        Log.e("paramsparamsparams","params "+params);
        return params;
    }

    private void fetchTransactions() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    swipeRefreshLayout.setRefreshing(true);
                    tvErrorMessage.setVisibility(View.GONE);
                });
            }

            ANRequest.GetRequestBuilder anBuilder = AndroidNetworking.get(ApiEndPoints.MERCHANT_BUSINESSES_ALL_TRANSACTIONS);
            anBuilder.addPathParameter("business_id", myApp.myPreferences.getBusinessId());
            anBuilder.addQueryParameter(generateTransactionParams());
            anBuilder.build()
                    .getAsObject(MerchantBusinessesAllTransaction.class, new ParsedRequestListener() {
                        @Override
                        public void onResponse(Object response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    swipeRefreshLayout.setRefreshing(false);
                                });
                            }

                            MerchantBusinessesAllTransaction allTransaction = (MerchantBusinessesAllTransaction) response;
                            ArrayList<Object> objectArrayList = new ArrayList<>();
                            objectArrayList.addAll(allTransaction.card_transactions.card_transactions);
                            //objectArrayList.addAll(allTransaction.paypal_transactions.paypal_transactions);
                            objectArrayList.addAll(allTransaction.order_transactions.order_transactions);
                            Collections.sort(objectArrayList, new Comparator<Object>() {
                                public int compare(Object o1, Object o2) {
                                    Long d1 = 0L;
                                    Long d2 = 0L;
                                    if (o1 instanceof MerchantTransaction) {
                                        d1 = CommonFunctions.convertStringDateToDate(((MerchantTransaction) o1).transaction_date_time, "yyyy-MM-dd HH:mm:ss").getTime();
                                    }
                                    if (o2 instanceof MerchantTransaction) {
                                        d2 = CommonFunctions.convertStringDateToDate(((MerchantTransaction) o2).transaction_date_time, "yyyy-MM-dd HH:mm:ss").getTime();
                                    }

                                    if (o1 instanceof MerchantOrderTransaction) {
                                        d1 = CommonFunctions.convertStringDateToDate(((MerchantOrderTransaction) o1).order_date, "yyyy-MM-dd HH:mm:ss").getTime();
                                    }
                                    if (o2 instanceof MerchantOrderTransaction) {
                                        d2 = CommonFunctions.convertStringDateToDate(((MerchantOrderTransaction) o2).order_date, "yyyy-MM-dd HH:mm:ss").getTime();
                                    }

                                    if (o1 instanceof MerchantPaypalTransaction) {
                                        d1 = CommonFunctions.convertStringDateToDate(((MerchantPaypalTransaction) o1).sale_created_at, "yyyy-MM-dd'T'HH:mm:ss'Z'").getTime();
                                    }
                                    if (o2 instanceof MerchantPaypalTransaction) {
                                        d2 = CommonFunctions.convertStringDateToDate(((MerchantPaypalTransaction) o2).sale_created_at, "yyyy-MM-dd'T'HH:mm:ss'Z'").getTime();
                                    }
                                    return d2.compareTo(d1);
                                    //                                return d1.compareTo(d2);
                                }
                            });

                            if (currentPage == 1) {
                                transactions.clear();
                                checkedStripeIds.clear();
                            }
                            LinkedHashMap<String, ArrayList<Object>> datesHeader = new LinkedHashMap<>();
                            for (Object transaction : objectArrayList) {
                                String dateKey = "";
                                if (transaction instanceof MerchantTransaction) {
                                    MerchantTransaction txn = (MerchantTransaction) transaction;
                                    dateKey = CommonFunctions.formatMiliToDesireFormat(Long.parseLong(txn.created + "000"), "dd MMM yyyy");
                                    if (!Validators.isNullOrEmpty(txn.transaction_date_time))
                                        dateKey = CommonFunctions.formatUnknownDateTime(txn.transaction_date_time, "yyyy-MM-dd HH:mm:ss", "dd MMM yyyy");
                                }
                                if (transaction instanceof MerchantPaypalTransaction) {
                                    MerchantPaypalTransaction txn = (MerchantPaypalTransaction) transaction;
                                    dateKey = CommonFunctions.formatUnknownDateTime(txn.sale_created_at, "yyyy-MM-dd'T'HH:mm:ss'Z'", "dd MMM yyyy");
                                }
                                if (transaction instanceof MerchantOrderTransaction) {
                                    MerchantOrderTransaction txn = (MerchantOrderTransaction) transaction;
                                    dateKey = CommonFunctions.formatUnknownDateTime(txn.order_date, "yyyy-MM-dd HH:mm:ss", "dd MMM yyyy");
                                }

                                ArrayList<Object> datedTransactions = new ArrayList<>();
                                if (!datesHeader.containsKey(dateKey)) {
                                    for (Object sub_transaction : objectArrayList) {
                                        if (sub_transaction instanceof MerchantTransaction) {
                                            MerchantTransaction businessesTransaction = (MerchantTransaction) sub_transaction;
                                            String subDateKey = CommonFunctions.formatMiliToDesireFormat(Long.parseLong(businessesTransaction.created + "000"), "dd MMM yyyy");
                                            if (!Validators.isNullOrEmpty(businessesTransaction.transaction_date_time))
                                                subDateKey = CommonFunctions.formatUnknownDateTime(businessesTransaction.transaction_date_time, "yyyy-MM-dd HH:mm:ss", "dd MMM yyyy");
                                            if (dateKey.equalsIgnoreCase(subDateKey)) {
                                                datedTransactions.add(businessesTransaction);
                                            }

                                        }
                                        if (sub_transaction instanceof MerchantPaypalTransaction) {
                                            MerchantPaypalTransaction paypalTransaction = (MerchantPaypalTransaction) sub_transaction;
                                            String subDateKey = CommonFunctions.formatUnknownDateTime(paypalTransaction.sale_created_at, "yyyy-MM-dd'T'HH:mm:ss'Z'", "dd MMM yyyy");
                                            if (dateKey.equalsIgnoreCase(subDateKey)) {
                                                datedTransactions.add(paypalTransaction);
                                            }
                                        }
                                        if (sub_transaction instanceof MerchantOrderTransaction) {
                                            MerchantOrderTransaction orderTransaction = (MerchantOrderTransaction) sub_transaction;
                                            String subDateKey = CommonFunctions.formatUnknownDateTime(orderTransaction.order_date, "yyyy-MM-dd HH:mm:ss", "dd MMM yyyy");
                                            if (dateKey.equalsIgnoreCase(subDateKey)) {
                                                datedTransactions.add(orderTransaction);
                                            }
                                        }
                                    }
                                    datesHeader.put(dateKey, datedTransactions);
                                }
                            }
                            for (Map.Entry<String, ArrayList<Object>> entry : datesHeader.entrySet()) {

                                float total = 0;
                                /*for (Object tran : entry.getValue()) {
                                    if (tran instanceof MerchantTransaction) {
                                        MerchantTransaction txn = (MerchantTransaction) tran;
                                        if (refundedTransactions) {
                                            total = (txn.amount * -1) / 100 + total;
                                        } else {
                                            total = txn.amount / 100 + total;
                                        }
                                    }
                                    if (tran instanceof MerchantPaypalTransaction) {
                                        MerchantPaypalTransaction txn = (MerchantPaypalTransaction) tran;
                                        total = txn.transaction_amount + total;
                                    }
                                    if (tran instanceof MerchantOrderTransaction) {
                                        MerchantOrderTransaction txn = (MerchantOrderTransaction) tran;
                                        if (txn.calculated_fees != null) {
                                            total = (-1 * txn.calculated_fees.total_fee) + total;
                                        } else {
                                            total = txn.grand_total + total;
                                        }
                                    }
                                }*/
                                /*Header header = new Header(entry.getKey(), MyApp.currencySymbol + MyApp.df.format(total));
                                transactions.add(header);*/
                                tvMonth.setText(entry.getKey());
                                tvTotal.setText(MyApp.currencySymbol +allTransaction.total_amount);
                                transactions.addAll(entry.getValue());
                            }

                            tvSelectTransactions.setEnabled(true);
                            llArchiveActions.setVisibility(View.GONE);

                            if (permission != null && permission.archive && transactions.size() > 0)
                                tvSelectTransactions.setVisibility(View.VISIBLE);
                            else tvSelectTransactions.setVisibility(View.GONE);

                            if(transactions.size()!=0){
                                tvMonth.setVisibility(View.VISIBLE);
                                tvTotal.setVisibility(View.VISIBLE);
                            }else {
                                tvMonth.setVisibility(View.GONE);
                                tvTotal.setVisibility(View.GONE);
                            }
                            if (refundedTransactions) {
                                isLoading = (!Validators.isNullOrEmpty(allTransaction.card_transactions.total) && (transactions.size()==(Integer.parseInt(allTransaction.card_transactions.total))));
                            }else {
                                isLoading = (!Validators.isNullOrEmpty(allTransaction.card_transactions.total) && !Validators.isNullOrEmpty(allTransaction.order_transactions.total)
                                        && (transactions.size()==(Integer.parseInt(allTransaction.card_transactions.total) + Integer.parseInt(allTransaction.order_transactions.total))));
                            }
                            merchantTransactionsAdapter.notifyDataSetChanged();
                        }


                        @Override
                        public void onError(ANError anError) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    if(currentPage==1){
                                        transactions.clear();
                                        merchantTransactionsAdapter.notifyDataSetChanged();
                                    }
                                    swipeRefreshLayout.setRefreshing(false);
                                });
                            }

                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void archiveUnArchiveTransactions() {
        try {
            String url = ApiEndPoints.MERCHANT_BUSINESS_ALL_TRANSACTIONS_ARCHIVE;
            if (archivedTransactions) {
                url = ApiEndPoints.MERCHANT_BUSINESS_ALL_TRANSACTIONS_UNARCHIVE;
            }
            progressDialog.show();
            AndroidNetworking.post(url)
                    .addPathParameter("business_id", myApp.myPreferences.getBusinessId())
                    .addBodyParameter("stripe_ids", new Gson().toJson(checkedStripeIds))
                    .addBodyParameter("paypal_ids", new Gson().toJson(checkedPaypalIds))
                    .addBodyParameter("order_ids", new Gson().toJson(checkedOrderIds))
                    .build()
                    .getAsString(new StringRequestListener() {
                        @Override
                        public void onResponse(String response) {
                            progressDialog.dismiss();
                            unSelectAll();
                            fetchTransactions();
                            ToastUtils.makeSnackToast(getActivity(), archivedTransactions ? "Transactions unarchived" : "Transactions archived");
                        }

                        @Override
                        public void onError(ANError anError) {
                            progressDialog.dismiss();
                            anError.printStackTrace();
                            if (anError.getErrorCode() == 400) {
                                ToastUtils.makeSnackToast(getActivity(), anError.getErrorAsObject(ApiError.class).getMessage());
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void refundTransaction(MerchantTransaction data) {
        try {
            EnterAmountDialogFragment enterAmountDialogFragment = getInstanceEnterAmount(MyApp.df.format(data.amount / 100), "Enter amount you want to refund");
            enterAmountDialogFragment.show(getActivity().getSupportFragmentManager(), "enter_amout");
            enterAmountDialogFragment.setDialogDismissListener(o -> {
                try {
                    if (o instanceof String) {
                        String amount = (String) o;
                        EnterPasswordDialogFragment enterPasswordDialogFragment = myApp.getInstanceEnterPassword(null, "Please enter password", "Please enter password to refund transaction");
                        enterPasswordDialogFragment.show(getChildFragmentManager(), "password");
                        enterPasswordDialogFragment.setDialogDismissListener(o1 -> {
                            if (o1 instanceof String) {
                                String password = (String) o1;
                                refundTransaction(data, amount, password);
                            }
                        });
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void refundTransaction(MerchantTransaction transaction, String amount, String password) {
        try {
            progressDialog.show();
            AndroidNetworking.post(ApiEndPoints.merchant_refund_transaction)
                    .addBodyParameter("amount", amount)
                    .addBodyParameter("password", password)
                    .addPathParameter("business_id", myPreferences.getBusinessId())
                    .addPathParameter("id", transaction.id)
                    .build()
                    .getAsObject(MerchantTransaction.class, new ParsedRequestListener() {
                        @Override
                        public void onResponse(Object response) {
                            if (getActivity() != null)
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            transaction.reporting_category = "refund";
                            transaction.amount = Float.parseFloat(amount) * 100;
                            ToastUtils.makeLongToast(getActivity(), "Transaction refunded successfully");

                            printTransaction("Merchant Copy", transaction, "");
                            fetchTransactions();
                        }

                        @Override
                        public void onError(ANError anError) {
                            progressDialog.dismiss();
                            if (anError.getErrorCode() == 400) {
                                ToastUtils.makeLongToast(getActivity(), anError.getErrorAsObject(ApiError.class).getMessage());
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void unSelectAll() {
        try {
            for (Object object : transactions) {
                if (object instanceof MerchantTransaction) {
                    ((MerchantTransaction) object).checked = false;
                }
                if (object instanceof MerchantOrderTransaction) {
                    ((MerchantOrderTransaction) object).checked = false;
                }
                if (object instanceof MerchantPaypalTransaction) {
                    ((MerchantPaypalTransaction) object).checked = false;
                }
            }
            checkedStripeIds.clear();
            checkedOrderIds.clear();
            checkedPaypalIds.clear();
            tvSelectedTransactions.setText("0 transactions selected");
            merchantTransactionsAdapter.notifyDataSetChanged();
            llArchiveActions.setVisibility(View.GONE);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printTransaction(String title, MerchantTransaction merchantTransaction, String rePrintTitle) {

        try {
            String actualAmount = "£" + MyApp.df.format(merchantTransaction.amount / 100);

            String card = "Card                 " + merchantTransaction.card_brand;
            String account = "Account      " + merchantTransaction.card_number;
            String stripe_id = "TID  " + merchantTransaction.txn_id;
            String status = "Status            " + (merchantTransaction.reporting_category.equalsIgnoreCase("charge") ? "Approved" : "Refund");
            String date_final = (CommonFunctions.formatMiliToDesireFormat(Long.parseLong(merchantTransaction.created + "000"), "dd/MM/yyyy hh:mm a"));

            String main_content = card + "\n" + account + "\n" + stripe_id + "\n" + status + "\n";
            String please = "Please Retain Receipt\nFor Your Record";

            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h") || defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                        zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                        //zoneRichPrinter.printCardReaderReceipt(myApp.businessLogo,rePrintTitle, title, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, actualAmount, null, actualAmount, main_content, please, date_final, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "",myPreferences);
                        zoneRichPrinter.printCardReaderReceipt(myApp.businessLogo, rePrintTitle, title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, null, actualAmount, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myPreferences);

                        if (title.toLowerCase().contains("merchant")) {
                            ConfirmationDialogFragment confirmationDialogFragment =myApp.getInstanceConfirmationDialog("Print", "Is Customer Copy required?", 0, "Confirm", "Cancel");
                            confirmationDialogFragment.show(getChildFragmentManager(), "action");
                            confirmationDialogFragment.setDialogDismissListener(o -> {
                                if (o instanceof String) {
                                    if (((String) o).equalsIgnoreCase("confirm") && getActivity() != null) {
                                        getActivity().runOnUiThread(() -> {
                                            printTransaction("Customer Copy", merchantTransaction, rePrintTitle);
                                        });
                                    }
                                }
                            });
                        }
                    } else {
                        try {
                            // TODO for zonerich
                            if (bluetoothPrinter != null) {
                                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                if (device != null) {
                                    bluetoothPrinter.printCardReaderReceiptZoneRich(myApp.businessLogo, rePrintTitle, title, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, actualAmount, null, actualAmount, main_content, please, date_final, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "");
                                    if (title.toLowerCase().contains("merchant")) {
                                        ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Print", "Is Customer Copy required?", 0, "Confirm", "Cancel");
                                        confirmationDialogFragment.show(getChildFragmentManager(), "action");
                                        confirmationDialogFragment.setDialogDismissListener(o -> {
                                            if (o instanceof String) {
                                                if (((String) o).equalsIgnoreCase("confirm") && getActivity() != null) {
                                                    getActivity().runOnUiThread(() -> {
                                                        printTransaction("Customer Copy", merchantTransaction, rePrintTitle);
                                                    });
                                                }
                                            }
                                        });
                                    }
                                } else {
                                    ToastUtils.makeLongToast(getActivity(), "No bluetooth device found.");
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {

                    //sunmiPrinter.printCardReaderReceipt(myApp.businessLogo, rePrintTitle, title, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, actualAmount, null, actualAmount, main_content, please, date_final, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                    if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                        sunmiPrinterV3Mix.printCardReaderReceipt(myApp.businessLogo, rePrintTitle, title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, null, actualAmount, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myPreferences);
                    }else {
                        sunmiPrinter.printCardReaderReceipt(myApp.businessLogo, rePrintTitle, title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, null, actualAmount, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myPreferences);
                    }
                    if (title.toLowerCase().contains("merchant")) {
                        ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Print", "Is Customer Copy required?", 0, "Confirm", "Cancel");
                        confirmationDialogFragment.show(getChildFragmentManager(), "action");
                        confirmationDialogFragment.setDialogDismissListener(o -> {
                            if (o instanceof String) {
                                if (((String) o).equalsIgnoreCase("confirm") && getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        printTransaction("Customer Copy", merchantTransaction, rePrintTitle);
                                    });
                                }
                            }
                        });
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                    myApp.iMinPrinterUtils.printCardReaderReceipt(myApp.tiffintomLogoSmall, rePrintTitle, title, selectedBusiness.header_a, selectedBusiness.header_b, "", actualAmount, null, actualAmount, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b);
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80)) {
                    if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                        CommonFunctions.functionThatDelay(200);
                        //wifiPrinter.printCardReaderReceipt(myApp.businessLogo, rePrintTitle, title, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, actualAmount, null, actualAmount, main_content, please, date_final, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", false, myPreferences);
                        wifiPrinter.printCardReaderReceipt(myApp.businessLogo, rePrintTitle, title, selectedBusiness.header_a, headerAlignment, selectedBusiness.header_b, actualAmount, null, actualAmount, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, false, myPreferences);
                        if (title.toLowerCase().contains("merchant")) {
                            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Print", "Is Customer Copy required?", 0, "Confirm", "Cancel");
                            confirmationDialogFragment.show(getChildFragmentManager(), "action");
                            confirmationDialogFragment.setDialogDismissListener(o -> {
                                if (o instanceof String) {
                                    if (((String) o).equalsIgnoreCase("confirm") && getActivity() != null) {
                                        getActivity().runOnUiThread(() -> {
                                            printTransaction("Customer Copy", merchantTransaction, rePrintTitle);
                                        });
                                    }
                                }
                            });
                        }
                    } else {
                        try {
                            if (bluetoothPrinter != null) {
                                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                if (device != null) {
                                    CommonFunctions.functionThatDelay(200);
                                    //bluetoothPrinter.printCardReaderReceipt(myApp.businessLogo, title, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, actualAmount, null, actualAmount, main_content, please, date_final, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", false);
                                    bluetoothPrinter.printCardReaderReceipt(myApp.businessLogo, title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, null, actualAmount, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, false);
                                    if (title.toLowerCase().contains("merchant")) {
                                        ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Print", "Is Customer Copy required?", 0, "Confirm", "Cancel");
                                        confirmationDialogFragment.show(getChildFragmentManager(), "action");
                                        confirmationDialogFragment.setDialogDismissListener(o -> {
                                            if (o instanceof String) {
                                                if (((String) o).equalsIgnoreCase("confirm") && getActivity() != null) {
                                                    getActivity().runOnUiThread(() -> {
                                                        printTransaction("Customer Copy", merchantTransaction, rePrintTitle);
                                                    });
                                                }
                                            }
                                        });
                                    }
                                } else {
                                    ToastUtils.makeLongToast(getActivity(), "No bluetooth device found.");
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }

    }

    public EnterAmountDialogFragment getInstanceEnterAmount(String amount, String title) {
        EnterAmountDialogFragment rejectReasonDialog = new EnterAmountDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("amount", amount);
        bundle.putString("title", title);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }
}
