package com.ubsidi.epos_2021.merchant.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.merchant.adapters.OpeningTimeSlotAdapter;
import com.ubsidi.epos_2021.online.base.BaseBottomSheet;

import java.util.Arrays;
import java.util.List;

public class OpeningHoursTimeSlotBottomSheetFragment extends BaseBottomSheet {

    private AppCompatImageView ivClose;
    private OpeningTimeSlotAdapter slotAdapter;
    private RecyclerView rvTime;
    private String[] morningTimes = {"05:00 AM", "05:15 AM", "05:30 AM", "05:45 AM", "06:00 AM", "06:15 AM", "06:30 AM", "06:45 AM", "07:00 AM", "07:15 AM", "07:30 AM", "07:45 AM", "08:00 AM", "08:15 AM", "08:30 AM", "08:45 AM", "09:00 AM", "09:15 AM", "09:30 AM", "09:45 AM", "10:00 AM", "10:15 AM", "10:30 AM", "10:45 AM", "11:00 AM", "11:15 AM", "11:30 AM", "11:45 AM", "12:00 AM"};

//    private String[] eveningTimes = {"01:00 PM", "01:15 PM", "01:30 PM", "01:45 PM", "02:00 PM", "02:15 PM", "02:30 PM", "02:45 PM", "03:00 PM", "03:15 PM", "03:30 PM", "03:45 PM", "04:00 PM", "04:15 PM", "04:30 PM", "04:45 PM", "05:00 PM", "05:15 PM", "05:30 PM", "05:45 PM", "06:00 PM", "06:15 PM", "06:30 PM", "06:45 PM", "07:00 PM", "07:15 PM", "07:30 PM", "07:45 PM", "08:00 PM", "08:15 PM", "08:30 PM", "08:45 PM", "09:00 PM", "09:15 PM", "09:30 PM", "09:45 PM", "10:00 PM", "10:15 PM", "10:30 PM", "10:45 PM", "11:00 PM", "11:15 PM", "11:30 PM", "11:45 PM", "12:00 PM", "12:15 PM", "12:30 PM", "12:45 PM"
//    };

    private String[] eveningTimes = {"05:00 PM", "05:15 PM", "05:30 PM", "05:45 PM", "06:00 PM", "06:15 PM", "06:30 PM", "06:45 PM", "07:00 PM", "07:15 PM", "07:30 PM", "07:45 PM", "08:00 PM"};

    private String dayTime;
    private List<String> timeSlots;
    private DialogDismissListener dialogDismissListener;

    public static OpeningHoursTimeSlotBottomSheetFragment getInstance(String dayTime) {
        OpeningHoursTimeSlotBottomSheetFragment bottomSheetFragment = new OpeningHoursTimeSlotBottomSheetFragment();
        Bundle bundle = new Bundle();
        bundle.putString("day_time", dayTime);
        bottomSheetFragment.setArguments(bundle);
        return bottomSheetFragment;
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (intentExtrasData.containsKey("day_time")) {
            dayTime = String.valueOf(intentExtrasData.get("day_time"));
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_time_slot_bottom_sheet, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

    }

    @Override
    protected void setListeners() {
        super.setListeners();
    }

    @Override
    protected void initViews(View view) {
        super.initViews(view);
        try {
            rvTime = view.findViewById(R.id.rvTime);
            ivClose = view.findViewById(R.id.ivClose);

            if (dayTime.equalsIgnoreCase("morning")) {
                timeSlots = Arrays.asList(morningTimes);
            } else {
                timeSlots = Arrays.asList(eveningTimes);
            }

            slotAdapter = new OpeningTimeSlotAdapter(timeSlots, (position, data) -> {
                String selectedTime = (String) data;
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss(selectedTime);
                }
                dismiss();
            });
            rvTime.setLayoutManager(new LinearLayoutManager(getActivity(), LinearLayoutManager.VERTICAL, false));
        } catch (Exception e) {
            e.printStackTrace();
        }
        rvTime.setAdapter(slotAdapter);
    }
}
