package com.ubsidi.epos_2021.merchant.fragments;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ubsidi.BuildConfig;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.MoneyTextWatcher;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.merchant.adapters.MerchantTransactionsAdapter;
import com.ubsidi.epos_2021.merchant.models.Header;
import com.ubsidi.epos_2021.merchant.models.PaymentLink;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.MerchantUserPermission;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.Restaurant;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.json.JSONObject;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class PaymentLinkFragment extends BaseFragment {

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    private Chip chipBack;
    private EditText etAmount, etPhone, etTip;
    private MaterialButton btnSend, btnCancel, btnSendLink;
    private TextView tvViewAll, tvTransactionTitle, tvTip;
    private String fromDate = "2019-06-01", toDate = "2020-12-31";
    private RecyclerView rvPaymentLinks;
    private ArrayList<Object> paymentLinks = new ArrayList<>();
    private MerchantTransactionsAdapter transactionsAndStatementsAdapter;
    private LinearLayout llPaymentBtns;
    int merchantRole = myPreferences.getMerchantRole();
    private LinearLayout llMainLayout;
    private Business loggedInBusiness;
    String stripe_private_key, stripe_public_key, stripe_mode;
    private AlertDialog progressDialog;
    private MerchantUserPermission permission;
    private ImageView ivBack;
    private final Calendar fromCalendar = Calendar.getInstance();
    private final Calendar toCalendar = Calendar.getInstance();
    private Float orderTotal;
    String order_id = "", order_split_id,unique_id="";
    int _order_id, _order_split_id;

    protected void initViews(View view) {
        try {
            progressDialog = CommonFunctions.customProgressDialog(getActivity());
            loggedInBusiness = myPreferences.getLoggedInAdmin().selected_business;
            llMainLayout = view.findViewById(R.id.llMainLayout);
            merchantRole = myPreferences.getMerchantRole();
            if (merchantRole == 1) {
                permission = loggedInBusiness.supervisor_permissions;
            } else if (merchantRole == 2) {
                permission = loggedInBusiness.admin_permissions;
            }
            stripe_mode = loggedInBusiness.stripe_mode;
            if (!Validators.isNullOrEmpty(loggedInBusiness.s_account_id) && !Validators.isNullOrEmpty(BuildConfig.connect_stripe_public_key)) {
                stripe_private_key = BuildConfig.connect_stripe_private_key;
                stripe_public_key = BuildConfig.connect_stripe_public_key;
            } else {
                if (stripe_mode.equalsIgnoreCase("live")) {
                    stripe_private_key = loggedInBusiness.stripe_private_key_live;
                    stripe_public_key = loggedInBusiness.stripe_public_key_live;
                } else {
                    stripe_private_key = loggedInBusiness.stripe_private_key_test;
                    stripe_public_key = loggedInBusiness.stripe_public_key_test;
                }
            }
            ivBack = view.findViewById(R.id.ivBack);
            etAmount = view.findViewById(R.id.etAmount);
            etPhone = view.findViewById(R.id.etPhone);
            etTip = view.findViewById(R.id.etTip);
            btnCancel = view.findViewById(R.id.btnCancel);
            btnSendLink = view.findViewById(R.id.btnSendLink);
            btnSend = view.findViewById(R.id.btnSend);
            rvPaymentLinks = view.findViewById(R.id.rvPaymentLinks);
            tvViewAll = view.findViewById(R.id.tvViewAll);
            tvTransactionTitle = view.findViewById(R.id.tvRecentTransactions);
            llPaymentBtns = view.findViewById(R.id.llPaymentBtns);
            chipBack = view.findViewById(R.id.chipBack);
            tvTip = view.findViewById(R.id.tvTip);
            rvPaymentLinks.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));

            transactionsAndStatementsAdapter = new MerchantTransactionsAdapter(transactions, false, (position, data) -> {
                resendPaymentLink((PaymentLink) data);
            }, (position, data) -> {
            }, ((position, data) -> {
            }));
            rvPaymentLinks.setAdapter(transactionsAndStatementsAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        try {
            if (getArguments() != null) {
                order_id = getArguments().getString("order_id");
                unique_id = getArguments().getString("unique_id","");
                order_split_id = getArguments().getString("order_split_id");
                _order_id = getArguments().getInt("_order_id");
                _order_split_id = getArguments().getInt("_order_split_id");
                orderTotal = getArguments().getFloat("order_total");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return inflater.inflate(R.layout.fragment_payment_link, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            initCalender();

            if ((merchantRole > 0 || MyApp.userPermission.payment_link_history.actions.list) && getArguments() == null) {
                getRecentPaymentLinks();
                startTimer();
            } else {
                rvPaymentLinks.setVisibility(View.GONE);
                tvViewAll.setVisibility(View.GONE);
            }

            final Handler handler = new Handler(Looper.getMainLooper());
            handler.postDelayed(() -> {
                if (getArguments() != null) {
                    chipBack.setVisibility(View.VISIBLE);
                    etAmount.setText(MyApp.df.format(orderTotal));
                    llPaymentBtns.setVisibility(View.GONE);
                    btnSendLink.setVisibility(View.VISIBLE);
                    etTip.setVisibility(View.GONE);
                    tvTip.setVisibility(View.GONE);
                } else {
                    chipBack.setVisibility(View.GONE);
                    llPaymentBtns.setVisibility(View.VISIBLE);
                    btnSendLink.setVisibility(View.GONE);
                }
                setMobileNo();
            }, 300);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setMobileNo() {
        if (getArguments() != null) {
            try {
                new Thread(() -> {
                    try {
                        Order dbOrder;
                        if (order_id != null) {
                            dbOrder = appDatabase.orderDao().view(order_id);
                            if (dbOrder != null && dbOrder.customer_id != null) {
                                Customer customer = appDatabase.customerDao().view(dbOrder.customer_id);
                                if (customer != null && customer.mobile != null) {
                                    if (getActivity() != null) {
                                        getActivity().runOnUiThread(() -> etPhone.setText(customer.mobile));
                                    }
                                }
                            } else {
                                dbOrder = appDatabase.orderDao().view(_order_id);
                                if (dbOrder != null && dbOrder._customer_id != 0) {
                                    Customer customer = appDatabase.customerDao().view(dbOrder._customer_id);
                                    if (customer != null && customer.mobile != null) {
                                        if (getActivity() != null) {
                                            getActivity().runOnUiThread(() -> etPhone.setText(customer.mobile));
                                        }
                                    }
                                }
                            }
                        } else {
                            dbOrder = appDatabase.orderDao().view(_order_id);
                            if (dbOrder != null && dbOrder._customer_id != 0) {
                                Customer customer = appDatabase.customerDao().view(dbOrder._customer_id);
                                if (customer != null && customer.mobile != null) {
                                    if (getActivity() != null) {
                                        getActivity().runOnUiThread(() -> etPhone.setText(customer.mobile));
                                    }
                                }
                            }
                        }

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }).start();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initCalender() {
        fromCalendar.add(Calendar.DAY_OF_MONTH, -1);

        fromDate = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
        toDate = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd");

    }

    private void setListeners() {
        try {
            ivBack.setOnClickListener(view -> {
                if (getActivity() != null) {
                    getActivity().onBackPressed();
                }
            });
            etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));
            etTip.addTextChangedListener(new MoneyTextWatcher(etTip));
            btnSend.setOnClickListener(view -> {
                if (Validators.isNullOrEmpty(etPhone.getText().toString())) {
                    etPhone.setError("Please enter phone");
                    etPhone.requestFocus();
                } else if (Validators.isNullOrEmpty(etAmount.getText().toString())) {
                    etAmount.setError("Please enter amount");
                    etAmount.requestFocus();
                } else if (Float.parseFloat(etAmount.getText().toString().replace(",", "")) == 0) {
                    etAmount.setError("Amount should be greater than zero");
                    etAmount.requestFocus();
                } else {
                    new Thread(() -> {
                        generatePaymentLink("");
                    }).start();
                }
            });
            btnCancel.setOnClickListener(view -> {
                CommonFunctions.hideKeyboard(getActivity(), etAmount);
                CommonFunctions.hideKeyboard(getActivity(), etPhone);
                getActivity().onBackPressed();
            });
            tvViewAll.setOnClickListener(view -> {
                CommonFunctions.hideKeyboard(getActivity(), etAmount);
                CommonFunctions.hideKeyboard(getActivity(), etPhone);
                FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
                ft.replace(R.id.nav_payment_fragment, new PaymentLinksTransactionFragment(), "Payment link transactions");
                ft.addToBackStack("can_go_back");
                ft.commit();
            });
            chipBack.setOnClickListener(v -> {
                getActivity().onBackPressed();
            });
            btnSendLink.setOnClickListener(view -> {
                if (Validators.isNullOrEmpty(etPhone.getText().toString())) {
                    etPhone.setError("Please enter phone");
                    etPhone.requestFocus();
                } else if (Validators.isNullOrEmpty(etAmount.getText().toString())) {
                    etAmount.setError("Please enter amount");
                    etAmount.requestFocus();
                } else if (Float.parseFloat(etAmount.getText().toString().replace(",", "")) == 0) {
                    etAmount.setError("Amount should be greater than zero");
                    etAmount.requestFocus();
                } else {
                    new Thread(() -> {
                        generatePaymentLink("order");
                    }).start();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void resendPaymentLink(PaymentLink data) {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            AndroidNetworking.post(ApiEndPoints.online_payment_links_resend)
                    .addPathParameter("id", data.id)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        progressDialog.dismiss();
                                    });
                                }
                                ToastUtils.showSnackBar(getActivity(), llMainLayout, "Payment link resent!");
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                }
                                anError.printStackTrace();
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                } else {
                                    ToastUtils.showSnackBar(getActivity(), llMainLayout, "Something went wrong!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generatePaymentLink(String from) {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            float total_amount = Float.parseFloat(etAmount.getText().toString().replace(",", ""));
            if (!Validators.isNullOrEmpty(etTip.getText().toString()) && Float.parseFloat(etTip.getText().toString().replace(",", "")) >= 0) {
                total_amount = total_amount + Float.parseFloat(etTip.getText().toString().replace(",", ""));
            }
            String id = "";
            if (order_id != null) {
                id = order_id;
            } else {
                id = String.valueOf(_order_id);
            }
            AndroidNetworking.post(ApiEndPoints.online_payment_links)
                    .addBodyParameter("phone", etPhone.getText().toString())
                    .addBodyParameter("secretkey", stripe_private_key)
                    .addBodyParameter("publishkey", stripe_public_key)
                    .addBodyParameter("amount", String.valueOf(total_amount))
                    .addBodyParameter("name", loggedInBusiness.name)
                    .addBodyParameter("business_id", loggedInBusiness.id)
                    .addBodyParameter("order_id", unique_id)
                    .addBodyParameter("device_id", Validators.isNullOrEmpty(myPreferences.getUserFCMToken())?"":myPreferences.getUserFCMToken())
                    .addBodyParameter("description", Validators.isNullOrEmpty(loggedInBusiness.statement_description)?"":loggedInBusiness.statement_description)
                    .addBodyParameter("descriptor",Validators.isNullOrEmpty(loggedInBusiness.statement_descriptor)?"":loggedInBusiness.statement_descriptor)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        progressDialog.dismiss();
                                        etAmount.setText(null);
                                        etTip.setText(null);
                                        etPhone.setText(null);
                                        CommonFunctions.hideKeyboard(getActivity(), etAmount);
                                        CommonFunctions.hideKeyboard(getActivity(), etPhone);
                                        CommonFunctions.hideKeyboard(getActivity(), etTip);
                                    });
                                }
                                ToastUtils.showSnackBar(getActivity(), llMainLayout, "Payment link sent successfully");
                                if (from.equalsIgnoreCase("order")) {
                                    myApp.isPaymentLinkSent = true;
                                    getActivity().finish();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            anError.printStackTrace();
                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                            } else {
                                ToastUtils.showSnackBar(getActivity(), llMainLayout, "Something went wrong!");
                            }
                        }
                    });
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private void getRecentPaymentLinks() {

        AndroidNetworking.get(ApiEndPoints.online_payment_links)
                .addQueryParameter("business_id", loggedInBusiness.id)
                .addQueryParameter("from_date", fromDate)
                .addQueryParameter("to_date", toDate)
                .build()
                .getAsJSONObject(new JSONObjectRequestListener() {
                    @Override
                    public void onResponse(JSONObject response) {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> {

                            });
                        }
                        try {
                            Type type = new TypeToken<List<PaymentLink>>() {
                            }.getType();
                            paymentLinks.clear();
                            paymentLinks.addAll(new Gson().fromJson(response.getJSONArray("data").toString(), type));
                            setUpAdapter();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void onError(ANError anError) {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> progressDialog.dismiss());
                        }
                        if (paymentLinks.size() > 0) {
                            tvTransactionTitle.setVisibility(View.VISIBLE);
                        } else {
                            tvTransactionTitle.setVisibility(View.GONE);
                        }
                        if (anError.getErrorCode() == 400) {
                            ApiError apiError = anError.getErrorAsObject(ApiError.class);
                            LogUtils.e(apiError.getMessage());
                        }
                        anError.printStackTrace();
                    }
                });
    }

    TimerTask timerTask;
    Timer timer;
    private final ArrayList<String> dayMonth = new ArrayList<>();
    private final ArrayList<Object> transactions = new ArrayList<>();

    // Setup adapter for today's transactions
    private void setUpAdapter() {
        try {
            dayMonth.clear();
            Calendar fromCalendarTemp = Calendar.getInstance();
            Calendar toCalendarTemp = Calendar.getInstance();

            fromCalendarTemp.setTime(fromCalendar.getTime());
            toCalendarTemp.setTime(toCalendar.getTime());

            fromCalendarTemp.add(Calendar.DAY_OF_MONTH, -1);
            while (toCalendarTemp.after(fromCalendarTemp)) {
                String dMonth = CommonFunctions.formatMiliToDesireFormat(toCalendarTemp.getTimeInMillis(), "dd MMMM");
                dayMonth.add(dMonth);
                break;
                //  toCalendarTemp.add(Calendar.DAY_OF_MONTH, -1);
            }

            transactions.clear();

            for (String ddMMM : dayMonth) {
                ArrayList<PaymentLink> dailyTransactions = new ArrayList<>();
                for (Object obj : paymentLinks) {
                    PaymentLink transactionModel = (PaymentLink) obj;
                    String transactionDateMonth = CommonFunctions.formatUnknownDateTime(transactionModel.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd MMMM");
                    if (transactionDateMonth.equals(ddMMM)) {
                        dailyTransactions.add(transactionModel);
                    }
                }
                if (dailyTransactions.size() > 0) {
                    transactions.add(new Header(CommonFunctions.formatUnknownDateTime(ddMMM, "dd MMMM", "EEE dd MMM")));
                    transactions.addAll(dailyTransactions);
                }
            }

            transactionsAndStatementsAdapter.notifyDataSetChanged();

            if (paymentLinks.size() > 0) {
                tvTransactionTitle.setVisibility(View.VISIBLE);
            } else {
                tvTransactionTitle.setVisibility(View.GONE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startTimer() {
        //set a new Timer
        timer = new Timer();
        initTimerTask();
        //schedule the timer, to wake up every 2 second
        try {
            if (timerTask != null) timer.schedule(timerTask, 1000, 15000); //
        } catch (Exception e) {
        }
    }

    private void initTimerTask() {
        timerTask = new TimerTask() {
            public void run() {
                try {
                    getRecentPaymentLinks();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    @Override
    public void onResume() {
        super.onResume();
        setListeners();
    }

    @Override
    public void onStop() {
        CommonFunctions.hideKeyboard(getActivity(), etAmount);
        super.onStop();
    }

    @Override
    public void onDestroy() {
        if (timerTask != null) timerTask.cancel();
        super.onDestroy();
    }
}