package com.ubsidi.epos_2021.merchant.fragments;


import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ubsidi.R;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.merchant.adapters.MerchantTransactionsAdapter;
import com.ubsidi.epos_2021.merchant.models.Header;
import com.ubsidi.epos_2021.merchant.models.PaymentLink;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.models.Restaurant;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.ToastUtils;
import com.wdullaer.materialdatetimepicker.date.DatePickerDialog;

import org.json.JSONObject;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class PaymentLinksTransactionFragment extends BaseFragment {

    private final ArrayList<Object> transactions = new ArrayList<>();
    private RecyclerView rvTransactions;
    private MerchantTransactionsAdapter transactionsAndStatementsAdapter;
    private SwipeRefreshLayout swipeRefreshLayout;
    private String fromDate = "2019-06-01", toDate = "2020-12-31";
    private final Calendar today = Calendar.getInstance();
    private final Calendar fromCalendar = Calendar.getInstance();
    private final Calendar toCalendar = Calendar.getInstance();
    private final ArrayList<PaymentLink> paymentLinks = new ArrayList<>();
    private TextView tvToDate;
    private TextView tvFromDate;
    private LinearLayout llFromDate, llToDate;
    int fromYear, fromMonth, fromDay, toYear, toMonth, toDay;
    private TextView tvTitle;
    private boolean isLoading = false;
    private int currentPage = 1, limit = 10;
    private Chip chipBack;
    private LinearLayout llMainLayout;
    private AlertDialog progressDialog;
    private Business loggedInBusiness;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragement_paymentlink_transaction, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            updateViews();
            setListeners();
            getData();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    protected void initViews(View view) {
        try {
            loggedInBusiness = myPreferences.getLoggedInAdmin().selected_business;
            progressDialog = CommonFunctions.customProgressDialog(getActivity());
            llMainLayout = view.findViewById(R.id.llMainLayout);
            TextView tvSelectTransactions = view.findViewById(R.id.tvSelectTransactions);
            tvTitle = view.findViewById(R.id.tvTitle);
            tvSelectTransactions.setVisibility(View.GONE);

            tvToDate = view.findViewById(R.id.tvToDate);
            tvFromDate = view.findViewById(R.id.tvFromDate);
            llToDate = view.findViewById(R.id.llToDate);
            llFromDate = view.findViewById(R.id.llFromDate);
            chipBack = view.findViewById(R.id.chipBack);

            rvTransactions = view.findViewById(R.id.rvTransactions);
            swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
            transactionsAndStatementsAdapter = new MerchantTransactionsAdapter(transactions, false, (position, data) -> resendPaymentLink((PaymentLink) data), (position, data) -> {
            }, (position, data) -> {
            });
            rvTransactions.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            rvTransactions.setNestedScrollingEnabled(false);
            rvTransactions.setAdapter(transactionsAndStatementsAdapter);

            tvTitle.setText("Payment link transactions");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateViews() {
        try {
            fromCalendar.add(Calendar.DAY_OF_MONTH, -1);

            fromDate = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
            toDate = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd");

            tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
            tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            chipBack.setOnClickListener(v -> getActivity().onBackPressed());
            rvTransactions.addOnScrollListener(new RecyclerView.OnScrollListener() {
                @Override
                public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                    super.onScrollStateChanged(recyclerView, newState);
                }

                @Override
                public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                    super.onScrolled(recyclerView, dx, dy);

                    LinearLayoutManager linearLayoutManager = (LinearLayoutManager) recyclerView.getLayoutManager();
                    if (!isLoading) {
                        if (linearLayoutManager != null && linearLayoutManager.findLastCompletelyVisibleItemPosition() == transactions.size() - 1) {
                            //bottom of list!
                            currentPage++;
                            fetchTransactions();
                            isLoading = true;
                        }
                    }
                }
            });

            swipeRefreshLayout.setOnRefreshListener(() -> {
                currentPage = 1;
                getData();
            });
            llFromDate.setOnClickListener(view -> {
                DatePickerDialog datePickerDialog = DatePickerDialog.newInstance((view1, y, m, d) -> {
                    fromDay = d;
                    fromMonth = m;
                    fromYear = y;
                    fromDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                    fromCalendar.set(y, m, d);
                    tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                    currentPage = 1;
                    fetchTransactions();
                }, fromCalendar.get(Calendar.YEAR), fromCalendar.get(Calendar.MONTH), fromCalendar.get(Calendar.DAY_OF_MONTH));
                datePickerDialog.setThemeDark(false);
                datePickerDialog.showYearPickerFirst(false);
                datePickerDialog.show(getActivity().getFragmentManager(), "FromPickerDialog");

                if (!Validators.isNullOrEmpty(toDate)) {
                    datePickerDialog.setMaxDate(toCalendar);
                }

            });
            llToDate.setOnClickListener(view -> {
                DatePickerDialog datePickerDialog = DatePickerDialog.newInstance(new DatePickerDialog.OnDateSetListener() {
                    @Override
                    public void onDateSet(DatePickerDialog view, int y, int m, int d) {
                        toDay = d;
                        toMonth = m;
                        toYear = y;
                        toDate = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                        toCalendar.set(y, m, d);
                        tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                        currentPage = 1;
                        fetchTransactions();
                    }
                }, toCalendar.get(Calendar.YEAR), toCalendar.get(Calendar.MONTH), toCalendar.get(Calendar.DAY_OF_MONTH));
                datePickerDialog.setThemeDark(false);
                datePickerDialog.showYearPickerFirst(false);
                datePickerDialog.show(getActivity().getFragmentManager(), "ToPickerDialog");
                if (!Validators.isNullOrEmpty(fromDate)) {
                    datePickerDialog.setMinDate(fromCalendar);
                }

            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    private void getData() {
        new Thread(this::fetchTransactions).start();
    }

    Type paymentLinkTypeToken = new TypeToken<List<PaymentLink>>() {
    }.getType();

    private void fetchTransactions() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    swipeRefreshLayout.setRefreshing(true);
                });
            }
            AndroidNetworking.get(ApiEndPoints.online_payment_links)
                    // .addQueryParameter("name", loggedInBusiness.name)
                    .addQueryParameter("business_id", loggedInBusiness.id)
                    .addQueryParameter("from_date", fromDate)
                    .addQueryParameter("to_date", toDate)
                    .addQueryParameter("page", String.valueOf(currentPage))
                    .addQueryParameter("per_page", String.valueOf(limit))
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                isLoading = false;
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        swipeRefreshLayout.setRefreshing(false);
                                    });
                                }
                                try {
                                    if (currentPage == 1)
                                        paymentLinks.clear();
                                    paymentLinks.addAll(new Gson().fromJson(response.getJSONArray("data").toString(), paymentLinkTypeToken));
                                    setupAdapter();

                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                isLoading = false;
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        swipeRefreshLayout.setRefreshing(false);
                                    });
                                }
                                if (currentPage == 1) {
                                    if (anError.getErrorCode() == 400) {
                                        ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                        ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                    } else {
                                        ToastUtils.showSnackBar(getActivity(), llMainLayout, "Something went wrong!");
                                    }
                                } else {
                                    currentPage--;
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void resendPaymentLink(PaymentLink data) {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            AndroidNetworking.post(ApiEndPoints.online_payment_links_resend)
                    .addPathParameter("id", data.id)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        progressDialog.dismiss();
                                    });
                                }
                                ToastUtils.showSnackBar(getActivity(), llMainLayout, "Payment link resent!");
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                }
                                anError.printStackTrace();
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                } else {
                                    ToastUtils.showSnackBar(getActivity(), llMainLayout, "Something went wrong!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private final ArrayList<String> dayMonth = new ArrayList<>();

    private void setupAdapter() {
        try {
            dayMonth.clear();
            Calendar fromCalendarTemp = Calendar.getInstance();
            Calendar toCalendarTemp = Calendar.getInstance();

            fromCalendarTemp.setTime(fromCalendar.getTime());
            toCalendarTemp.setTime(toCalendar.getTime());

            fromCalendarTemp.add(Calendar.DAY_OF_MONTH, -1);
            while (toCalendarTemp.after(fromCalendarTemp)) {
                String dMonth = CommonFunctions.formatMiliToDesireFormat(toCalendarTemp.getTimeInMillis(), "dd MMMM");
                dayMonth.add(dMonth);
                toCalendarTemp.add(Calendar.DAY_OF_MONTH, -1);
            }

            transactions.clear();

            for (String ddMMM : dayMonth) {
                ArrayList<PaymentLink> dailyTransactions = new ArrayList<>();
                for (PaymentLink transactionModel : paymentLinks) {
                    String transactionDateMonth = CommonFunctions.formatUnknownDateTime(transactionModel.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd MMMM");
                    if (transactionDateMonth.equals(ddMMM)) {
                        dailyTransactions.add(transactionModel);
                    }
                }
                if (dailyTransactions.size() > 0) {
                    transactions.add(new Header(CommonFunctions.formatUnknownDateTime(ddMMM, "dd MMMM", "EEE dd MMM")));
                    transactions.addAll(dailyTransactions);
                }
            }
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    transactionsAndStatementsAdapter.notifyDataSetChanged();
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
