package com.ubsidi.epos_2021.merchant.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONArrayRequestListener;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.ubsidi.R;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.merchant.adapters.AutoDiscountAdapter;
import com.ubsidi.epos_2021.merchant.models.Offer;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class SettingsAutoDiscountFragment extends BaseFragment {

    private RecyclerView rvAutoDiscounts;
    private AutoDiscountAdapter autoDiscountAdapter;
    private ArrayList<Offer> offers = new ArrayList<>();
    private ArrayList<Offer> removedOffers = new ArrayList<>();
    private MaterialCardView cvAdd;
    private LinearLayout llMainLayout;
    private MaterialButton btnUpdate;
    private Chip chipBack;
    private LinearLayout llLoading;
    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_autodiscounts, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            getOffers();
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            chipBack.setOnClickListener(v -> getActivity().onBackPressed());
            cvAdd.setOnClickListener(view -> {
                Offer offer = new Offer();
                offer.status = true;
                offers.add(offer);
                autoDiscountAdapter.notifyDataSetChanged();
                if (offers.size() > 0) {
                    btnUpdate.setVisibility(View.VISIBLE);
                    btnUpdate.setEnabled(true);
                }
            });
            btnUpdate.setOnClickListener(view -> {
                boolean isValid = true;
                for (Offer offer : offers) {
                    if ((offer.normal_percentage) == 0 || (offer.normal_price) == 0) {
                        ToastUtils.showSnackBar(getActivity(), llMainLayout, "Invalid offer details");
                        isValid = false;
                        break;
                    }
                    if ((!offer.delivery_type && !offer.pickup_type && !offer.dinein_type)) {
                        ToastUtils.showSnackBar(getActivity(), llMainLayout, "Please select order type");
                        isValid = false;
                        break;
                    }
                    offer.resid = myApp.restaurant_id;
                }
                if (isValid) {
                    updateOffers();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateOffers() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> llLoading.setVisibility(View.VISIBLE));
            }
            ArrayList<Offer> allOffers = new ArrayList<>();
            allOffers.addAll(offers);
            allOffers.addAll(removedOffers);

            AndroidNetworking.post(ApiEndPoints.online_auto_discounts + "bulk")
                    .addBodyParameter("offers", new Gson().toJson(allOffers))
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> llLoading.setVisibility(View.GONE));
                                }
                                try {
                                    ToastUtils.showSnackBar(getActivity(), llMainLayout, response.getString("message"));
                                    getOffers();
                                } catch (JSONException e) {
                                    e.printStackTrace();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> llLoading.setVisibility(View.GONE));
                                }
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.showSnackBar(getActivity(), llMainLayout, apiError.getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getOffers() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> llLoading.setVisibility(View.VISIBLE));
            }

            AndroidNetworking.get(ApiEndPoints.online_auto_discounts)
                    .addQueryParameter("restaurant_id", myApp.restaurant_id)
                    .addQueryParameter("status", "1")
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsJSONArray(new JSONArrayRequestListener() {
                        @Override
                        public void onResponse(JSONArray response) {
                            try {
                                Type type = new TypeToken<List<Offer>>() {
                                }.getType();
                                offers.clear();
                                removedOffers.clear();
                                offers.addAll(new Gson().fromJson(response.toString(), type));
                                autoDiscountAdapter.notifyDataSetChanged();

                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> llLoading.setVisibility(View.GONE));
                                    cvAdd.setVisibility(View.VISIBLE);
                                    if (offers.size() > 0) {
                                        btnUpdate.setVisibility(View.VISIBLE);
                                    }
                                }
                            } catch (JsonSyntaxException e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llLoading.setVisibility(View.GONE);
                                        cvAdd.setVisibility(View.VISIBLE);
                                    });
                                }
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.showSnackBar(getActivity(), llMainLayout, apiError.getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            llMainLayout = view.findViewById(R.id.llMainLayout);
            rvAutoDiscounts = view.findViewById(R.id.rvAutoDiscounts);
            cvAdd = view.findViewById(R.id.cvAdd);
            btnUpdate = view.findViewById(R.id.btnUpdate);
            chipBack = view.findViewById(R.id.chipBack);
            llLoading = view.findViewById(R.id.llLoading);

            autoDiscountAdapter = new AutoDiscountAdapter(getActivity(), offers, (position, data) -> {
                Offer offer = (Offer) data;
                EnterAmountDialogFragment enterAmountDialogFragment = getInstanceEnterAmount(String.valueOf(offer.normal_percentage), "Enter discount percentage");
                enterAmountDialogFragment.show(getChildFragmentManager(), "enter_discount");
                enterAmountDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        offer.normal_percentage = Float.parseFloat((String) o);
                        offers.set(position, offer);
                        autoDiscountAdapter.notifyDataSetChanged();
                    }
                });
            }, (position, data) -> {
                Offer offer = (Offer) data;
                EnterAmountDialogFragment enterAmountDialogFragment = getInstanceEnterAmount(String.valueOf(offer.normal_price), "Enter order value");
                enterAmountDialogFragment.show(getChildFragmentManager(), "order_value");
                enterAmountDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        offer.normal_price = Float.parseFloat((String) o);
                        offers.set(position, offer);
                        autoDiscountAdapter.notifyDataSetChanged();
                    }
                });
            }, (position, data) -> {
                Offer offer = (Offer) data;
                removedOffers.add((Offer) data);
            });
            rvAutoDiscounts.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            rvAutoDiscounts.setAdapter(autoDiscountAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EnterAmountDialogFragment getInstanceEnterAmount(String amount, String title) {
        EnterAmountDialogFragment rejectReasonDialog = new EnterAmountDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("amount", amount);
        bundle.putString("title", title);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }
}
