package com.ubsidi.epos_2021.merchant.fragments;

import android.app.TimePickerDialog;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.SwitchCompat;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.merchant.models.RestaurantTiming;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Restaurant;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.json.JSONObject;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class SettingsCollectionHoursFragment extends BaseFragment {


    private LinearLayout llMondaym, llTuesdaym, llWednesdaym, llThursdaym, llFridaym, llSaturdaym, llSundaym;
    private LinearLayout llMondayClosedm, llTuesdayClosedm, llWednesdayClosedm, llThursdayClosedm, llFridayClosedm, llSaturdayClosedm, llSundayClosedm;
    private SwitchCompat swMondaym, swTuesdaym, swWednesdaym, swThursdaym, swFridaym, swSaturdaym, swSundaym;

    private TextView tvMondayFromM, tvTuesdayFromM, tvWednesdayFromM, tvThursdayFromM, tvFridayFromM, tvSaturdayFromM, tvSundayFromM;
    private TextView tvMondayToM, tvTuesdayToM, tvWednesdayToM, tvThursdayToM, tvFridayToM, tvSaturdayToM, tvSundayToM;

    private LinearLayout llMondayE, llTuesdayE, llWednesdayE, llThursdayE, llFridayE, llSaturdayE, llSundayE;
    private LinearLayout llMondayClosedE, llTuesdayClosedE, llWednesdayClosedE, llThursdayClosedE, llFridayClosedE, llSaturdayClosedE, llSundayClosedE;
    private SwitchCompat swMondayE, swTuesdayE, swWednesdayE, swThursdayE, swFridayE, swSaturdayE, swSundayE;


    private TextView tvMondayFromE, tvTuesdayFromE, tvWednesdayFromE, tvThursdayFromE, tvFridayFromE, tvSaturdayFromE, tvSundayFromE;
    private TextView tvMondayToE, tvTuesdayToE, tvWednesdayToE, tvThursdayToE, tvFridayToE, tvSaturdayToE, tvSundayToE;

    private View vMorning, vEvening;
    private LinearLayout llMorningTab, llEveningTab, llMorning, llEvening;

    private Chip chipBack;
    private MaterialButton btnUpdate;
    Date fromDate, toDate;
    Calendar fromCalendar, toCalendar;
    private String fromSelectedDay;
    private Restaurant loggedInRestaurant;
    private RestaurantTiming pickupTiming;
    private LinearLayout llLoading;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_delivery_hours, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        loggedInRestaurant = MyApp.getInstance().myPreferences.getRestaurant();
        pickupTiming = loggedInRestaurant.restaurant_timing;
        fromDate = new Date();
        toDate = new Date();

        fromCalendar = Calendar.getInstance();
        toCalendar = Calendar.getInstance();
        initViews(view);
        setListeners();
        updateViews();
    }

    private void updateViews() {
        if (loggedInRestaurant != null) {
            swMondaym.setChecked(!pickupTiming.pick_monday_status.equalsIgnoreCase("close"));
            swTuesdaym.setChecked(!pickupTiming.pick_tuesday_status.equalsIgnoreCase("close"));
            swWednesdaym.setChecked(!pickupTiming.pick_wednesday_status.equalsIgnoreCase("close"));
            swThursdaym.setChecked(!pickupTiming.pick_thursday_status.equalsIgnoreCase("close"));
            swFridaym.setChecked(!pickupTiming.pick_friday_status.equalsIgnoreCase("close"));
            swSaturdaym.setChecked(!pickupTiming.pick_saturday_status.equalsIgnoreCase("close"));
            swSundaym.setChecked(!pickupTiming.pick_sunday_status.equalsIgnoreCase("close"));

            swMondayE.setChecked(!pickupTiming.pick_monday_status.equalsIgnoreCase("close"));
            swTuesdayE.setChecked(!pickupTiming.pick_tuesday_status.equalsIgnoreCase("close"));
            swWednesdayE.setChecked(!pickupTiming.pick_wednesday_status.equalsIgnoreCase("close"));
            swThursdayE.setChecked(!pickupTiming.pick_thursday_status.equalsIgnoreCase("close"));
            swFridayE.setChecked(!pickupTiming.pick_friday_status.equalsIgnoreCase("close"));
            swSaturdayE.setChecked(!pickupTiming.pick_saturday_status.equalsIgnoreCase("close"));
            swSundayE.setChecked(!pickupTiming.pick_sunday_status.equalsIgnoreCase("close"));

            tvMondayFromM.setText(pickupTiming.pick_monday_first_opentime);
            tvMondayToM.setText(pickupTiming.pick_monday_first_closetime);

            tvTuesdayFromM.setText(pickupTiming.pick_tuesday_first_opentime);
            tvTuesdayToM.setText(pickupTiming.pick_tuesday_first_closetime);

            tvWednesdayFromM.setText(pickupTiming.pick_wednesday_first_opentime);
            tvWednesdayToM.setText(pickupTiming.pick_wednesday_first_closetime);

            tvThursdayFromM.setText(pickupTiming.pick_thursday_first_opentime);
            tvThursdayToM.setText(pickupTiming.pick_thursday_first_closetime);

            tvFridayFromM.setText(pickupTiming.pick_friday_first_opentime);
            tvFridayToM.setText(pickupTiming.pick_friday_first_closetime);

            tvSaturdayFromM.setText(pickupTiming.pick_saturday_first_opentime);
            tvSaturdayToM.setText(pickupTiming.pick_saturday_first_closetime);

            tvSundayFromM.setText(pickupTiming.pick_sunday_first_opentime);
            tvSundayToM.setText(pickupTiming.pick_sunday_first_closetime);

            //Evening
            tvMondayFromE.setText(pickupTiming.pick_monday_second_opentime);
            tvMondayToE.setText(pickupTiming.pick_monday_second_closetime);

            tvTuesdayFromE.setText(pickupTiming.pick_tuesday_second_opentime);
            tvTuesdayToE.setText(pickupTiming.pick_tuesday_second_closetime);

            tvWednesdayFromE.setText(pickupTiming.pick_wednesday_second_opentime);
            tvWednesdayToE.setText(pickupTiming.pick_wednesday_second_closetime);

            tvThursdayFromE.setText(pickupTiming.pick_thursday_second_opentime);
            tvThursdayToE.setText(pickupTiming.pick_thursday_second_closetime);

            tvFridayFromE.setText(pickupTiming.pick_friday_second_opentime);
            tvFridayToE.setText(pickupTiming.pick_friday_second_closetime);

            tvSaturdayFromE.setText(pickupTiming.pick_saturday_second_opentime);
            tvSaturdayToE.setText(pickupTiming.pick_saturday_second_closetime);

            tvSundayFromE.setText(pickupTiming.pick_sunday_second_opentime);
            tvSundayToE.setText(pickupTiming.pick_sunday_second_closetime);

//            if(pickupTiming.pick_working_time.equalsIgnoreCase("both")){
//                llEveningTab.setVisibility(View.VISIBLE);
//                llMorningTab.setVisibility(View.VISIBLE);
//            }else if (pickupTiming.pick_working_time.equalsIgnoreCase("evening")){
//                llEveningTab.setVisibility(View.VISIBLE);
//                llMorningTab.setVisibility(View.GONE);
//            }else if (pickupTiming.pick_working_time.equalsIgnoreCase("morning")){
//                llEveningTab.setVisibility(View.VISIBLE);
//                llMorningTab.setVisibility(View.GONE);
//            }
        }
    }

    private void setListeners() {
        chipBack.setOnClickListener(v -> getActivity().onBackPressed());
        swMondaym.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                swMondaym.setText("Open");
                llMondaym.setVisibility(View.VISIBLE);
                llMondayClosedm.setVisibility(View.GONE);
                pickupTiming.pick_monday_status = "";
            } else {
                swMondaym.setText("Closed");
                llMondaym.setVisibility(View.GONE);
                llMondayClosedm.setVisibility(View.VISIBLE);
                pickupTiming.pick_monday_status = "Close";
            }
        });

        swTuesdaym.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                swTuesdaym.setText("Open");
                llTuesdaym.setVisibility(View.VISIBLE);
                llTuesdayClosedm.setVisibility(View.GONE);
                pickupTiming.pick_tuesday_status = "";
            } else {
                swTuesdaym.setText("Closed");
                llTuesdaym.setVisibility(View.GONE);
                llTuesdayClosedm.setVisibility(View.VISIBLE);
                pickupTiming.pick_tuesday_status = "Close";
            }
        });

        swWednesdaym.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                swWednesdaym.setText("Open");
                llWednesdaym.setVisibility(View.VISIBLE);
                llWednesdayClosedm.setVisibility(View.GONE);
                pickupTiming.pick_wednesday_status = "";
            } else {
                swWednesdaym.setText("Closed");
                llWednesdaym.setVisibility(View.GONE);
                llWednesdayClosedm.setVisibility(View.VISIBLE);
                pickupTiming.pick_wednesday_status = "Close";
            }
        });

        swThursdaym.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                swThursdaym.setText("Open");
                llThursdaym.setVisibility(View.VISIBLE);
                llThursdayClosedm.setVisibility(View.GONE);
                pickupTiming.pick_thursday_status = "";
            } else {
                swThursdaym.setText("Closed");
                llThursdaym.setVisibility(View.GONE);
                llThursdayClosedm.setVisibility(View.VISIBLE);
                pickupTiming.pick_thursday_status = "Close";
            }
        });

        swFridaym.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                swFridaym.setText("Open");
                llFridaym.setVisibility(View.VISIBLE);
                llFridayClosedm.setVisibility(View.GONE);
                pickupTiming.pick_friday_status = "";
            } else {
                swFridaym.setText("Closed");
                llFridaym.setVisibility(View.GONE);
                llFridayClosedm.setVisibility(View.VISIBLE);
                pickupTiming.pick_friday_status = "Close";
            }
        });

        swSaturdaym.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                swSaturdaym.setText("Open");
                llSaturdaym.setVisibility(View.VISIBLE);
                llSaturdayClosedm.setVisibility(View.GONE);
                pickupTiming.pick_saturday_status = "";
            } else {
                swSaturdaym.setText("Closed");
                llSaturdaym.setVisibility(View.GONE);
                llSaturdayClosedm.setVisibility(View.VISIBLE);
                pickupTiming.pick_saturday_status = "Close";
            }
        });

        swSundaym.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                swSundaym.setText("Open");
                llSundaym.setVisibility(View.VISIBLE);
                llSundayClosedm.setVisibility(View.GONE);
                pickupTiming.pick_sunday_status = "Close";
            } else {
                swSundaym.setText("Closed");
                llSundaym.setVisibility(View.GONE);
                llSundayClosedm.setVisibility(View.VISIBLE);
                pickupTiming.pick_sunday_status = "Close";
            }
        });

        //Evening time
        swMondayE.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                swMondayE.setText("Open");
                llMondayE.setVisibility(View.VISIBLE);
                llMondayClosedE.setVisibility(View.GONE);
                pickupTiming.pick_monday_status = "";
            } else {
                swMondayE.setText("Closed");
                llMondayE.setVisibility(View.GONE);
                llMondayClosedE.setVisibility(View.VISIBLE);
                pickupTiming.pick_monday_status = "Close";
            }
        });

        swTuesdayE.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                swTuesdayE.setText("Open");
                llTuesdayE.setVisibility(View.VISIBLE);
                llTuesdayClosedE.setVisibility(View.GONE);
                pickupTiming.pick_tuesday_status = "";
            } else {
                swTuesdayE.setText("Closed");
                llTuesdayE.setVisibility(View.GONE);
                llTuesdayClosedE.setVisibility(View.VISIBLE);
                pickupTiming.pick_tuesday_status = "Close";
            }
        });

        swWednesdayE.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                swWednesdayE.setText("Open");
                llWednesdayE.setVisibility(View.VISIBLE);
                llWednesdayClosedE.setVisibility(View.GONE);
                pickupTiming.pick_wednesday_status = "";
            } else {
                swWednesdayE.setText("Closed");
                llWednesdayE.setVisibility(View.GONE);
                llWednesdayClosedE.setVisibility(View.VISIBLE);
                pickupTiming.pick_wednesday_status = "Close";
            }
        });

        swThursdayE.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                swThursdayE.setText("Open");
                llThursdayE.setVisibility(View.VISIBLE);
                llThursdayClosedE.setVisibility(View.GONE);
                pickupTiming.pick_thursday_status = "";
            } else {
                swThursdayE.setText("Closed");
                llThursdayE.setVisibility(View.GONE);
                llThursdayClosedE.setVisibility(View.VISIBLE);
                pickupTiming.pick_thursday_status = "Close";
            }
        });

        swFridayE.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                swFridayE.setText("Open");
                llFridayE.setVisibility(View.VISIBLE);
                llFridayClosedE.setVisibility(View.GONE);
                pickupTiming.pick_friday_status = "";
            } else {
                swFridayE.setText("Closed");
                llFridayE.setVisibility(View.GONE);
                llFridayClosedE.setVisibility(View.VISIBLE);
                pickupTiming.pick_friday_status = "Close";
            }
        });

        swSaturdayE.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                swSaturdayE.setText("Open");
                llSaturdayE.setVisibility(View.VISIBLE);
                llSaturdayClosedE.setVisibility(View.GONE);
                pickupTiming.pick_saturday_status = "";
            } else {
                swSaturdayE.setText("Closed");
                llSaturdayE.setVisibility(View.GONE);
                llSaturdayClosedE.setVisibility(View.VISIBLE);
                pickupTiming.pick_saturday_status = "Close";
            }
        });

        swSundayE.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                swSundayE.setText("Open");
                llSundayE.setVisibility(View.VISIBLE);
                llSundayClosedE.setVisibility(View.GONE);
                pickupTiming.pick_sunday_status = "Close";
            } else {
                swSundayE.setText("Closed");
                llSundayE.setVisibility(View.GONE);
                llSundayClosedE.setVisibility(View.VISIBLE);
                pickupTiming.pick_sunday_status = "Close";
            }
        });

        tvMondayFromM.setOnClickListener(v -> {
            //    fromPickerDialog(1);
            openTimeSlotBottomSheet("morning", true, 1);
        });
        tvTuesdayFromM.setOnClickListener(v -> {
            openTimeSlotBottomSheet("morning", true, 2);
        });
        tvWednesdayFromM.setOnClickListener(v -> {
            openTimeSlotBottomSheet("morning", true, 3);
        });
        tvThursdayFromM.setOnClickListener(v -> {
            openTimeSlotBottomSheet("morning", true, 4);
        });
        tvFridayFromM.setOnClickListener(v -> {
            openTimeSlotBottomSheet("morning", true, 5);
        });
        tvSaturdayFromM.setOnClickListener(v -> {
            openTimeSlotBottomSheet("morning", true, 6);
        });
        tvSundayFromM.setOnClickListener(v -> {
            openTimeSlotBottomSheet("morning", true, 7);
        });
        tvMondayToM.setOnClickListener(v -> {
            openTimeSlotBottomSheet("morning", false, 1);
        });
        tvTuesdayToM.setOnClickListener(v -> {
            openTimeSlotBottomSheet("morning", false, 2);
        });
        tvWednesdayToM.setOnClickListener(v -> {
            openTimeSlotBottomSheet("morning", false, 3);
        });
        tvThursdayToM.setOnClickListener(v -> {
            openTimeSlotBottomSheet("morning", false, 4);
        });
        tvFridayToM.setOnClickListener(v -> {
            openTimeSlotBottomSheet("morning", false, 5);
        });
        tvSaturdayToM.setOnClickListener(v -> {
            openTimeSlotBottomSheet("morning", false, 6);
        });
        tvSundayToM.setOnClickListener(v -> {
            openTimeSlotBottomSheet("morning", false, 7);
        });

        //Evening time
        tvMondayFromE.setOnClickListener(v -> {
            //    fromPickerDialog(1);
            openTimeSlotBottomSheet("evening", true, 1);
        });
        tvTuesdayFromE.setOnClickListener(v -> {
            openTimeSlotBottomSheet("evening", true, 2);
        });
        tvWednesdayFromE.setOnClickListener(v -> {
            openTimeSlotBottomSheet("evening", true, 3);
        });
        tvThursdayFromE.setOnClickListener(v -> {
            openTimeSlotBottomSheet("evening", true, 4);
        });
        tvFridayFromE.setOnClickListener(v -> {
            openTimeSlotBottomSheet("evening", true, 5);
        });
        tvSaturdayFromE.setOnClickListener(v -> {
            openTimeSlotBottomSheet("evening", true, 6);
        });
        tvSundayFromE.setOnClickListener(v -> {
            openTimeSlotBottomSheet("evening", true, 7);
        });

        tvMondayToE.setOnClickListener(v -> {
            openTimeSlotBottomSheet("evening", false, 1);
        });
        tvTuesdayToE.setOnClickListener(v -> {
            openTimeSlotBottomSheet("evening", false, 2);
        });
        tvWednesdayToE.setOnClickListener(v -> {
            openTimeSlotBottomSheet("evening", false, 3);
        });
        tvThursdayToE.setOnClickListener(v -> {
            openTimeSlotBottomSheet("evening", false, 4);
        });
        tvFridayToE.setOnClickListener(v -> {
            openTimeSlotBottomSheet("evening", false, 5);
        });
        tvSaturdayToE.setOnClickListener(v -> {
            openTimeSlotBottomSheet("evening", false, 6);
        });
        tvSundayToE.setOnClickListener(v -> {
            openTimeSlotBottomSheet("evening", false, 7);
        });

        llEveningTab.setOnClickListener(view1 -> {
            llEvening.setVisibility(View.VISIBLE);
            llMorning.setVisibility(View.GONE);
            vEvening.setVisibility(View.VISIBLE);
            vMorning.setVisibility(View.INVISIBLE);
        });
        llMorningTab.setOnClickListener(view1 -> {
            llMorning.setVisibility(View.VISIBLE);
            llEvening.setVisibility(View.GONE);
            vMorning.setVisibility(View.VISIBLE);
            vEvening.setVisibility(View.INVISIBLE);
        });

        btnUpdate.setOnClickListener(view1 -> {
            saveDetails();
        });

    }

    private void saveDetails() {
        if (getActivity() != null) {
            getActivity().runOnUiThread(() -> {
                llLoading.setVisibility(View.VISIBLE);
            });
        }

        loggedInRestaurant.restaurant_timing = pickupTiming;
        AndroidNetworking.post(ApiEndPoints.restaurant_details + loggedInRestaurant.id)
                .addApplicationJsonBody(loggedInRestaurant)
                .build()
                .getAsObject(Restaurant.class, new ParsedRequestListener<Restaurant>() {
                    @Override
                    public void onResponse(Restaurant response) {
                        fetchProfile();
                        ToastUtils.makeLongToast(getActivity(), "Collection hours updated");
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                llLoading.setVisibility(View.GONE);
                            });
                        }
                    }

                    @Override
                    public void onError(ANError anError) {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                llLoading.setVisibility(View.GONE);
                            });
                        }
                        if (anError.getErrorCode() == 400) {
                            ToastUtils.makeToast(getActivity(), anError.getErrorAsObject(ApiError.class).getMessage());
                        }
                    }
                });
    }

    private void fetchProfile() {
        if (getActivity() != null) {
            getActivity().runOnUiThread(() -> llLoading.setVisibility(View.VISIBLE));
        }
        AndroidNetworking.get(ApiEndPoints.restaurant_details + loggedInRestaurant.id)
                .build()
                .getAsJSONObject(new JSONObjectRequestListener() {
                    @Override
                    public void onResponse(JSONObject response) {
                        myPreferences.saveRestaurant(response);
                        loggedInRestaurant = MyApp.getInstance().myPreferences.getRestaurant();
                        pickupTiming = loggedInRestaurant.restaurant_timing;
                        updateViews();
                    }

                    @Override
                    public void onError(ANError anError) {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> llLoading.setVisibility(View.GONE));
                        }
                        if (anError.getErrorCode() == 400) {
                            ToastUtils.makeToast(getActivity(), anError.getErrorAsObject(ApiError.class).getMessage());
                        }
                    }
                });
    }

    private void openTimeSlotBottomSheet(String daysTime, boolean fromSelected, int selectedDay) {
        OpeningHoursTimeSlotBottomSheetFragment slotBottomSheetFragment = OpeningHoursTimeSlotBottomSheetFragment.getInstance(daysTime);
        slotBottomSheetFragment.show(getChildFragmentManager(), "time_slots");
        slotBottomSheetFragment.setDialogDismissListener(o -> {
            String selectedTime = (String) o;

            setSelectedTime(daysTime, fromSelected, selectedDay, selectedTime);
        });
    }

    private void setSelectedTime(String dayTime, boolean fromSelected, int selectedDay, String selectedTime) {
        if (dayTime.equalsIgnoreCase("morning")) {
            if (fromSelected) {
                if (selectedDay == 1) {
                    if (findTimeRange(selectedTime, tvMondayToM.getText().toString())) {
                        tvMondayFromM.setText(selectedTime);
                        pickupTiming.pick_monday_first_opentime = selectedTime;
                    }
                } else if (selectedDay == 2) {
                    if (findTimeRange(selectedTime, tvTuesdayToM.getText().toString())) {
                        tvTuesdayFromM.setText(selectedTime);
                        pickupTiming.pick_tuesday_first_opentime = selectedTime;
                    }
                } else if (selectedDay == 3) {
                    if (findTimeRange(selectedTime, tvWednesdayToM.getText().toString())) {
                        tvWednesdayFromM.setText(selectedTime);
                        pickupTiming.pick_wednesday_first_opentime = selectedTime;
                    }
                } else if (selectedDay == 4) {
                    if (findTimeRange(selectedTime, tvThursdayToM.getText().toString())) {
                        tvThursdayFromM.setText(selectedTime);
                        pickupTiming.pick_thursday_first_opentime = selectedTime;
                    }
                } else if (selectedDay == 5) {
                    if (findTimeRange(selectedTime, tvFridayToM.getText().toString())) {
                        tvFridayFromM.setText(selectedTime);
                        pickupTiming.pick_friday_first_opentime = selectedTime;
                    }
                } else if (selectedDay == 6) {
                    if (findTimeRange(selectedTime, tvSaturdayToM.getText().toString())) {
                        tvSaturdayFromM.setText(selectedTime);
                        pickupTiming.pick_saturday_first_opentime = selectedTime;
                    }
                } else if (selectedDay == 7) {
                    if (findTimeRange(selectedTime, tvSundayToM.getText().toString())) {
                        tvSundayFromM.setText(selectedTime);
                        pickupTiming.pick_sunday_first_opentime = selectedTime;
                    }
                }
            } else {
                if (selectedDay == 1) {
                    if (findTimeRange(tvMondayFromM.getText().toString(), selectedTime)) {
                        tvMondayToM.setText(selectedTime);
                        pickupTiming.pick_monday_first_closetime = selectedTime;
                    }
                } else if (selectedDay == 2) {
                    if (findTimeRange(tvTuesdayFromM.getText().toString(), selectedTime)) {
                        tvTuesdayToM.setText(selectedTime);
                        pickupTiming.pick_tuesday_first_closetime = selectedTime;
                    }
                } else if (selectedDay == 3) {
                    if (findTimeRange(tvWednesdayFromM.getText().toString(), selectedTime)) {
                        tvWednesdayToM.setText(selectedTime);
                        pickupTiming.pick_wednesday_first_closetime = selectedTime;
                    }
                } else if (selectedDay == 4) {
                    if (findTimeRange(tvThursdayFromM.getText().toString(), selectedTime)) {
                        tvThursdayToM.setText(selectedTime);
                        pickupTiming.pick_thursday_first_closetime = selectedTime;
                    }
                } else if (selectedDay == 5) {
                    if (findTimeRange(tvFridayFromM.getText().toString(), selectedTime)) {
                        tvFridayToM.setText(selectedTime);
                        pickupTiming.pick_friday_first_closetime = selectedTime;
                    }
                } else if (selectedDay == 6) {
                    if (findTimeRange(tvSaturdayFromM.getText().toString(), selectedTime)) {
                        tvSaturdayToM.setText(selectedTime);
                        pickupTiming.pick_saturday_first_closetime = selectedTime;
                    }
                } else if (selectedDay == 7) {
                    if (findTimeRange(tvSundayFromM.getText().toString(), selectedTime)) {
                        tvSundayToM.setText(selectedTime);
                        pickupTiming.pick_sunday_first_closetime = selectedTime;
                    }
                }
            }
        } else if (dayTime.equalsIgnoreCase("evening")) {
            if (fromSelected) {
                if (selectedDay == 1) {
                    if (findTimeRange(selectedTime, tvMondayToE.getText().toString())) {
                        tvMondayFromE.setText(selectedTime);
                        pickupTiming.pick_monday_second_opentime = selectedTime;
                    }
                } else if (selectedDay == 2) {
                    if (findTimeRange(selectedTime, tvTuesdayToE.getText().toString())) {
                        tvTuesdayFromE.setText(selectedTime);
                        pickupTiming.pick_tuesday_second_opentime = selectedTime;
                    }
                } else if (selectedDay == 3) {
                    if (findTimeRange(selectedTime, tvWednesdayToE.getText().toString())) {
                        tvWednesdayFromE.setText(selectedTime);
                        pickupTiming.pick_wednesday_second_opentime = selectedTime;
                    }
                } else if (selectedDay == 4) {
                    if (findTimeRange(selectedTime, tvThursdayToE.getText().toString())) {
                        tvThursdayFromE.setText(selectedTime);
                        pickupTiming.pick_thursday_second_opentime = selectedTime;
                    }
                } else if (selectedDay == 5) {
                    if (findTimeRange(selectedTime, tvFridayToE.getText().toString())) {
                        tvFridayFromE.setText(selectedTime);
                        pickupTiming.pick_friday_second_opentime = selectedTime;
                    }
                } else if (selectedDay == 6) {
                    if (findTimeRange(selectedTime, tvSaturdayToE.getText().toString())) {
                        tvSaturdayFromE.setText(selectedTime);
                        pickupTiming.pick_saturday_second_opentime = selectedTime;
                    }
                } else if (selectedDay == 7) {
                    if (findTimeRange(selectedTime, tvSundayToE.getText().toString())) {
                        tvSundayFromE.setText(selectedTime);
                        pickupTiming.pick_sunday_second_opentime = selectedTime;
                    }
                }
            } else {
                if (selectedDay == 1) {
                    if (findTimeRange(tvMondayFromE.getText().toString(), selectedTime)) {
                        tvMondayToE.setText(selectedTime);
                        pickupTiming.pick_monday_second_closetime = selectedTime;
                    }
                } else if (selectedDay == 2) {
                    if (findTimeRange(tvTuesdayFromE.getText().toString(), selectedTime)) {
                        tvTuesdayToE.setText(selectedTime);
                        pickupTiming.pick_tuesday_second_closetime = selectedTime;
                    }
                } else if (selectedDay == 3) {
                    if (findTimeRange(tvWednesdayFromE.getText().toString(), selectedTime)) {
                        tvWednesdayToE.setText(selectedTime);
                        pickupTiming.pick_wednesday_second_closetime = selectedTime;
                    }
                } else if (selectedDay == 4) {
                    if (findTimeRange(tvThursdayFromE.getText().toString(), selectedTime)) {
                        tvThursdayToE.setText(selectedTime);
                        pickupTiming.pick_thursday_second_closetime = selectedTime;
                    }
                } else if (selectedDay == 5) {
                    if (findTimeRange(tvFridayFromE.getText().toString(), selectedTime)) {
                        tvFridayToE.setText(selectedTime);
                        pickupTiming.pick_friday_second_closetime = selectedTime;
                    }
                } else if (selectedDay == 6) {
                    if (findTimeRange(tvSaturdayFromE.getText().toString(), selectedTime)) {
                        tvSaturdayToE.setText(selectedTime);
                        pickupTiming.pick_saturday_second_closetime = selectedTime;
                    }
                } else if (selectedDay == 7) {
                    if (findTimeRange(tvSundayFromE.getText().toString(), selectedTime)) {
                        tvSundayToE.setText(selectedTime);
                        pickupTiming.pick_sunday_second_closetime = selectedTime;
                    }
                }
            }
        }
        updateViews();
    }

    private boolean findTimeRange(String from_time, String to_time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm a");
        try {
            fromDate = dateFormat.parse(from_time);
            toDate = dateFormat.parse(to_time);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        if (fromDate.getTime() > toDate.getTime()) {
            ToastUtils.makeToast(getActivity(), "Invalid time range");
            return false;
        }

        return true;
    }

    private void fromPickerDialog(int selectedDay) {
        TimePickerDialog timePickerDialog = new TimePickerDialog(getActivity(), (view, hour, minute) -> {
            fromCalendar.set(Calendar.HOUR_OF_DAY, hour);
            fromCalendar.set(Calendar.MINUTE, minute);

            fromDate = fromCalendar.getTime();
            fromSelectedDay = CommonFunctions.formatMiliToDesireFormat(fromDate.getTime(), "hh:mm a");
            if (selectedDay == 1) {
                tvMondayFromM.setText(fromSelectedDay);
            } else if (selectedDay == 2) {
                tvTuesdayFromM.setText(fromSelectedDay);
            } else if (selectedDay == 3) {
                tvWednesdayFromM.setText(fromSelectedDay);
            } else if (selectedDay == 4) {
                tvThursdayFromM.setText(fromSelectedDay);
            } else if (selectedDay == 5) {
                tvFridayFromM.setText(fromSelectedDay);
            } else if (selectedDay == 6) {
                tvSaturdayFromM.setText(fromSelectedDay);
            } else if (selectedDay == 7) {
                tvSundayFromM.setText(fromSelectedDay);
            }
        }, fromCalendar.get(Calendar.HOUR_OF_DAY), fromCalendar.get(Calendar.MINUTE), false);
        timePickerDialog.show();
        timePickerDialog.setOnCancelListener(dialogInterface -> {

        });
    }

    private void toPickerDialog(int selectedDay) {
        TimePickerDialog timePickerDialog = new TimePickerDialog(getActivity(), (view, hour, minute) -> {
            toCalendar.set(Calendar.HOUR_OF_DAY, hour);
            toCalendar.set(Calendar.MINUTE, minute);

            toDate = toCalendar.getTime();
            if (selectedDay == 1) {
                tvMondayToM.setText(fromSelectedDay);
            } else if (selectedDay == 2) {
                tvTuesdayToM.setText(fromSelectedDay);
            } else if (selectedDay == 3) {
                tvWednesdayToM.setText(fromSelectedDay);
            } else if (selectedDay == 4) {
                tvThursdayToM.setText(fromSelectedDay);
            } else if (selectedDay == 5) {
                tvFridayToM.setText(fromSelectedDay);
            } else if (selectedDay == 6) {
                tvSaturdayToM.setText(fromSelectedDay);
            } else if (selectedDay == 7) {
                tvSundayToM.setText(fromSelectedDay);
            }
        }, toCalendar.get(Calendar.HOUR_OF_DAY), toCalendar.get(Calendar.MINUTE), false);
        timePickerDialog.show();
        timePickerDialog.setOnCancelListener(dialogInterface -> {

        });

    }

    private void initViews(View view) {
        llMondaym = view.findViewById(R.id.MorningllMonday);
        llTuesdaym = view.findViewById(R.id.MorningllTuesday);
        llWednesdaym = view.findViewById(R.id.MorningllWednesday);
        llThursdaym = view.findViewById(R.id.MorningllThursday);
        llFridaym = view.findViewById(R.id.MorningllFriday);
        llSaturdaym = view.findViewById(R.id.MorningllSaturday);
        llSundaym = view.findViewById(R.id.MorningllSunday);


        llMondayE = view.findViewById(R.id.EveningllMonday);
        llTuesdayE = view.findViewById(R.id.EveningllTuesday);
        llWednesdayE = view.findViewById(R.id.EveningllWednesday);
        llThursdayE = view.findViewById(R.id.EveningllThursday);
        llFridayE = view.findViewById(R.id.EveningllFriday);
        llSaturdayE = view.findViewById(R.id.EveningllSaturday);
        llSundayE = view.findViewById(R.id.EveningllSunday);

        llMondayClosedm = view.findViewById(R.id.MorningllMClosed);
        llTuesdayClosedm = view.findViewById(R.id.MorningllTueClosed);
        llWednesdayClosedm = view.findViewById(R.id.MorningllWedClosed);
        llThursdayClosedm = view.findViewById(R.id.MorningllThClosed);
        llFridayClosedm = view.findViewById(R.id.MorningllFriClosed);
        llSaturdayClosedm = view.findViewById(R.id.MorningllSatClosed);
        llSundayClosedm = view.findViewById(R.id.MorningllSunClosed);

        llMondayClosedE = view.findViewById(R.id.EveningllMClosed);
        llTuesdayClosedE = view.findViewById(R.id.EveningllTueClosed);
        llWednesdayClosedE = view.findViewById(R.id.EveningllWedClosed);
        llThursdayClosedE = view.findViewById(R.id.EveningllThClosed);
        llFridayClosedE = view.findViewById(R.id.EveningllFriClosed);
        llSaturdayClosedE = view.findViewById(R.id.EveningllSatClosed);
        llSundayClosedE = view.findViewById(R.id.EveningllSunClosed);

        swMondaym = view.findViewById(R.id.MorningswMonday);
        swTuesdaym = view.findViewById(R.id.MorningswTuesday);
        swWednesdaym = view.findViewById(R.id.MorningswWednesday);
        swThursdaym = view.findViewById(R.id.MorningswThursday);
        swFridaym = view.findViewById(R.id.MorningswFriday);
        swSaturdaym = view.findViewById(R.id.MorningswSaturday);
        swSundaym = view.findViewById(R.id.MorningswSunday);

        swMondayE = view.findViewById(R.id.EveningswMonday);
        swTuesdayE = view.findViewById(R.id.EveningswTuesday);
        swWednesdayE = view.findViewById(R.id.EveningswWednesday);
        swThursdayE = view.findViewById(R.id.EveningswThursday);
        swFridayE = view.findViewById(R.id.EveningswFriday);
        swSaturdayE = view.findViewById(R.id.EveningswSaturday);
        swSundayE = view.findViewById(R.id.EveningswSunday);

        tvMondayFromM = view.findViewById(R.id.MorningtvMonFrom);
        tvTuesdayFromM = view.findViewById(R.id.MorningtvTueFrom);
        tvWednesdayFromM = view.findViewById(R.id.MorningtvWedFrom);
        tvThursdayFromM = view.findViewById(R.id.MorningtvThuFrom);
        tvFridayFromM = view.findViewById(R.id.MorningtvFriFrom);
        tvSaturdayFromM = view.findViewById(R.id.MorningtvSatFrom);
        tvSundayFromM = view.findViewById(R.id.MorningtvSunFrom);

        tvMondayToM = view.findViewById(R.id.MorningtvMonTo);
        tvTuesdayToM = view.findViewById(R.id.MorningtvTueTo);
        tvWednesdayToM = view.findViewById(R.id.MorningtvWedTo);
        tvThursdayToM = view.findViewById(R.id.MorningtvThuTo);
        tvFridayToM = view.findViewById(R.id.MorningtvFriTo);
        tvSaturdayToM = view.findViewById(R.id.MorningtvSatTo);
        tvSundayToM = view.findViewById(R.id.MorningtvSunTo);


        tvMondayFromE = view.findViewById(R.id.EveningtvMonFrom);
        tvTuesdayFromE = view.findViewById(R.id.EveningtvTueFrom);
        tvWednesdayFromE = view.findViewById(R.id.EveningtvWedFrom);
        tvThursdayFromE = view.findViewById(R.id.EveningtvThuFrom);
        tvFridayFromE = view.findViewById(R.id.EveningtvFriFrom);
        tvSaturdayFromE = view.findViewById(R.id.EveningtvSatFrom);
        tvSundayFromE = view.findViewById(R.id.EveningtvSunFrom);

        tvMondayToE = view.findViewById(R.id.EveningtvMonTo);
        tvTuesdayToE = view.findViewById(R.id.EveningtvTueTo);
        tvWednesdayToE = view.findViewById(R.id.EveningtvWedTo);
        tvThursdayToE = view.findViewById(R.id.EveningtvThuTo);
        tvFridayToE = view.findViewById(R.id.EveningtvFriTo);
        tvSaturdayToE = view.findViewById(R.id.EveningtvSatTo);
        tvSundayToE = view.findViewById(R.id.EveningtvSunTo);

        btnUpdate = view.findViewById(R.id.btnUpdate);
        llMorningTab = view.findViewById(R.id.llMorningTab);
        llEveningTab = view.findViewById(R.id.llEveningTab);

        llMorning = view.findViewById(R.id.MorningllMorning);
        llEvening = view.findViewById(R.id.EveningllEvening);

        vMorning = view.findViewById(R.id.vMorning);
        vEvening = view.findViewById(R.id.vEvening);
        TextView tvHeading = view.findViewById(R.id.tvHeading);
        chipBack = view.findViewById(R.id.chipBack);
        llLoading = view.findViewById(R.id.llLoading);

        tvHeading.setText("Collection Hours");
    }
}
