package com.ubsidi.epos_2021.merchant.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;

import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;

public class SettingsContactTiffintomDialogFragment extends DialogFragment {

    private MaterialButton btnEmail, btnCall;
    private ImageView ivClose;

    private DialogDismissListener dialogDismissListener;

    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);

    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_contact_tiffintom, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        setListeners();
    }

    private void initViews(View view) {
        btnEmail = view.findViewById(R.id.btnEmail);
        btnCall = view.findViewById(R.id.btnCall);
        ivClose = view.findViewById(R.id.ivClose);

    }

    private void setListeners() {
        ivClose.setOnClickListener(view -> {
            dismiss();
        });
        btnEmail.setOnClickListener(view -> {
            if (dialogDismissListener != null)
                dialogDismissListener.onDialogDismiss("email");
            dismiss();
        });
        btnCall.setOnClickListener(view -> {
            if (dialogDismissListener != null)
                dialogDismissListener.onDialogDismiss("call");
            dismiss();
        });
    }
}
