package com.ubsidi.epos_2021.merchant.fragments;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.StringRequestListener;
import com.ubsidi.R;
import com.ubsidi.epos_2021.activities.HomeActivity;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.fragment.ConfirmationDialogFragment;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.User;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.online.fragments.EnterPasswordDialogFragment;
import com.ubsidi.epos_2021.utils.ToastUtils;

public class SettingsDataManagementFragment extends BaseFragment {

    private LinearLayout llFactoryData, llEraseOrders, llEraseReservation, llEraseCashDrawer, llEraseCallerID;
    private User loggedInUser = myPreferences.getLoggedInUser();

    AlertDialog progressDialog;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_data_management, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        setListeners();
    }

    private void setListeners() {
        llFactoryData.setOnClickListener(view -> {
            confirmBeforeErase("factory_reset");
        });
        llEraseOrders.setOnClickListener(view -> {
            confirmBeforeErase("orders");
        });
        llEraseCallerID.setOnClickListener(view -> {
            confirmBeforeErase("calllogs");
        });
        llEraseReservation.setOnClickListener(view -> {
            confirmBeforeErase("reservations");
        });
        llEraseCashDrawer.setOnClickListener(view -> {
            confirmBeforeErase("cashdraw");
        });
    }

    private void initViews(View view) {
        progressDialog = CommonFunctions.customProgressDialog(getActivity());
        llFactoryData = view.findViewById(R.id.llFactoryReset);
        llEraseOrders = view.findViewById(R.id.llAllOrder);
        llEraseReservation = view.findViewById(R.id.llAllReservation);
        llEraseCashDrawer = view.findViewById(R.id.llCashDrawer);
        llEraseCallerID = view.findViewById(R.id.llCallerId);
    }

    private void confirmBeforeErase(String type) {
        String message = "All data will be wiped from the system.\nAre you sure you want to complete a factory data reset?";
        String title = "Confirmation";
        if (type.equalsIgnoreCase("orders")) {
            message = "All orders will be wiped from the system.\nAre you sure you want to erase\nall orders?";
        }
        if (type.equalsIgnoreCase("reservations")) {
            message = "All reservations will be wiped from the system.\nAre you sure you want to erase\nall reservations?";
        }
        if (type.equalsIgnoreCase("cashdraw")) {
            message = "The cash drawer log will be wiped from the system.\nAre you sure you want to erase it?";
        }
        if (type.equalsIgnoreCase("calllogs")) {
            message = "The caller ID log will be wiped from the system.\nAre you sure you want to erase it?";
        }
        ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog(title, message, 0, "Confirm", "Cancel");
        confirmationDialogFragment.show(getChildFragmentManager(), "ask");
        confirmationDialogFragment.setDialogDismissListener(o -> {
            if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                askPassword(type);
            }
        });
    }

    private void askPassword(String type) {
        String message = "Please enter password to complete factory data reset";
        String title = "Please enter password";
        if (type.equalsIgnoreCase("orders")) {
            message = "Please enter password to erase all orders";
        }
        if (type.equalsIgnoreCase("reservations")) {
            message = "Please enter password to erase all reservations";
        }
        if (type.equalsIgnoreCase("cashdraw")) {
            message = "Please enter password to erase cash drawer log";
        }
        if (type.equalsIgnoreCase("calllogs")) {
            message = "Please enter password to erase caller ID log";
        }
        EnterPasswordDialogFragment enterPasswordDialogFragment = myApp.getInstanceEnterPassword(type, title, message);
        enterPasswordDialogFragment.show(getChildFragmentManager(), "password");
        enterPasswordDialogFragment.setDialogDismissListener(o -> {
            if (o instanceof String) {
                String password = (String) o;
                if (loggedInUser.password.equalsIgnoreCase(password)) {
                    eraseData(type);
                } else
                    ToastUtils.makeLongToast(getActivity(), "Invalid password");
            }
        });
    }

    private void eraseData(String type) {
        try {
            String url = ApiEndPoints.factory_reset;
            if (type.equalsIgnoreCase("orders")) {
                url = ApiEndPoints.delete_orders;
            }
            if (type.equalsIgnoreCase("reservations")) {
                url = ApiEndPoints.delete_reservations;
            }
            if (type.equalsIgnoreCase("cashdraw")) {
                url = ApiEndPoints.delete_cash_draw_logs;
            }
            if (type.equalsIgnoreCase("calllogs")) {
                url = ApiEndPoints.delete_calllogs;
            }
            progressDialog.show();
            AndroidNetworking.delete(url)
                    .addQueryParameter("device_id", myApp.myPreferences.getRegisteredDevice().device_id)
                    .build()
                    .getAsString(new StringRequestListener() {
                        @Override
                        public void onResponse(String response) {
                            String message = "Factory Reset settings done";
                            if (type.equalsIgnoreCase("orders")) {
                                message = "Orders deleted successfully";
                            }
                            if (type.equalsIgnoreCase("reservations")) {
                                new Thread(() -> {
                                    appDatabase.emptyPulledDao().nukeReservations();
                                    appDatabase.reservationDao().resetReservationPrimaryKey();
                                }).start();
                                message = "Reservations deleted successfully";
                            }
                            if (type.equalsIgnoreCase("cashdraw")) {
                                message = "Cash draw logs deleted successfully";
                            }
                            if (type.equalsIgnoreCase("calllogs")) {
                                message = "Call logs deleted successfully";
                            }
                            if (type.equalsIgnoreCase("orders") || type.equalsIgnoreCase("factory_reset")) {
                                String finalMessage = message;
                                new Thread(() -> {
                                    if (type.equalsIgnoreCase("factory_reset") || type.equalsIgnoreCase("orders")) {
                                        appDatabase.customerDao().deleteBlankNameAndMobileNumber("", null);
                                    }
                                    appDatabase.emptyPulledDao().nukeOrderItemIngredient();
                                    appDatabase.emptyPulledDao().nukeOrderItemAddon();
                                    appDatabase.emptyPulledDao().nukeOrderPayment();
                                    appDatabase.emptyPulledDao().nukeOrderSplit();
                                    appDatabase.emptyPulledDao().nukeOrder();
                                    appDatabase.emptyPulledDao().nukeReservations();
                                    appDatabase.emptyPulledDao().externalCCPayment();
                                    appDatabase.orderDao().resetOrderRelatedPrimaryKey();
                                    appDatabase.tableDao().freeAllTables();
                                    appDatabase.reservationDao().resetReservationPrimaryKey();
                                    progressDialog.dismiss();
                                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Message", finalMessage, 0, "Okay", null);
                                    confirmationDialogFragment.show(getChildFragmentManager(), "message");
                                    confirmationDialogFragment.setDialogDismissListener(o -> {

                                        if (getActivity() != null) {
                                            Intent mIntent = new Intent(getActivity(), HomeActivity.class);
                                            getActivity().finishAffinity();
                                            startActivity(mIntent);
                                        }
                                    });
                                }).start();
                            } else {
                                progressDialog.dismiss();
                                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Message", message, 0, "Okay", null);
                                confirmationDialogFragment.show(getChildFragmentManager(), "message");
                                confirmationDialogFragment.setDialogDismissListener(o -> {

                                    if (getActivity() != null) {
                                        Intent mIntent = new Intent(getActivity(), HomeActivity.class);
                                        getActivity().finishAffinity();
                                        startActivity(mIntent);
                                    }
                                });
                            }

                        }

                        @Override
                        public void onError(ANError anError) {
                            progressDialog.dismiss();
                            if (anError.getErrorCode() == 400) {
                                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Message", anError.getErrorAsObject(ApiError.class).getMessage(), 2, "Okay", null);
                                confirmationDialogFragment.show(getChildFragmentManager(), "message");
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

}
