package com.ubsidi.epos_2021.merchant.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SwitchCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.chip.Chip;
import com.ubsidi.R;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.merchant.adapters.DeliveryFeesAdapter;
import com.ubsidi.epos_2021.merchant.models.DeliveryFee;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Restaurant;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.json.JSONObject;

import java.util.ArrayList;

public class SettingsDeliveryFeesFragment extends BaseFragment {


    private RecyclerView rvDeliveryFees;
    private DeliveryFeesAdapter deliveryFeesAdapter;
    private ArrayList<DeliveryFee> deliveryFees = new ArrayList<>();
    private MaterialCardView cvAdd;
    private MaterialButton btnUpdate;
    private MaterialCardView cvFreeDel;
    private SwitchCompat switchFreeDel;
    private LinearLayout llFreeDel, llMainLayout;
    private TextView tvFreeDelMiles;
    DeliveryFee freeDelivery;
    private Chip chipBack;
    private Restaurant loggedInRestaurant = myPreferences.getRestaurant();
    private LinearLayout llLoading;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_delivery_fees, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        setListeners();
        fetchProfile();
    }

    private void initViews(View view) {
        try {
            llMainLayout = view.findViewById(R.id.llMainLayout);
            tvFreeDelMiles = view.findViewById(R.id.tvFreeDelMiles);
            llFreeDel = view.findViewById(R.id.llFreeDelivery);
            switchFreeDel = view.findViewById(R.id.switchFreeDel);
            cvFreeDel = view.findViewById(R.id.cvFreeDel);
            rvDeliveryFees = view.findViewById(R.id.rvDeliveryFees);
            cvAdd = view.findViewById(R.id.cvAdd);
            btnUpdate = view.findViewById(R.id.btnUpdate);
            chipBack = view.findViewById(R.id.chipBack);
            llLoading = view.findViewById(R.id.llLoading);

            deliveryFeesAdapter = new DeliveryFeesAdapter(deliveryFees, (position, data) -> {
                DeliveryFee deliveryFee = (DeliveryFee) data;
                EnterAmountDialogFragment enterAmountDialogFragment = getInstanceEnterAmount(deliveryFee.delivery_miles, "Enter delivery miles");
                enterAmountDialogFragment.show(getChildFragmentManager(), "enter_miles");
                enterAmountDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        deliveryFee.delivery_miles = (String) o;
                        deliveryFees.set(position, deliveryFee);
                        deliveryFeesAdapter.notifyDataSetChanged();
                    }
                });
            }, (position, data) -> {
                DeliveryFee deliveryFee = (DeliveryFee) data;
                EnterAmountDialogFragment enterAmountDialogFragment = getInstanceEnterAmount(deliveryFee.delivery_charge, "Enter delivery fee");
                enterAmountDialogFragment.show(getChildFragmentManager(), "enter_amount");
                enterAmountDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        deliveryFee.delivery_charge = (String) o;
                        deliveryFees.set(position, deliveryFee);
                        deliveryFeesAdapter.notifyDataSetChanged();
                    }
                });
            });
            rvDeliveryFees.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            rvDeliveryFees.setAdapter(deliveryFeesAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public EnterAmountDialogFragment getInstanceEnterAmount(String amount, String title) {
        EnterAmountDialogFragment rejectReasonDialog = new EnterAmountDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("amount", amount);
        bundle.putString("title", title);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    private void updateViews() {
        try {
            deliveryFees.clear();
            if (loggedInRestaurant.delivery_setting != null && loggedInRestaurant.delivery_setting.size() > 0 && loggedInRestaurant.delivery_setting.get(0).getDelivery_charge() == 0) {
                freeDelivery = loggedInRestaurant.delivery_setting.get(0);
                loggedInRestaurant.delivery_setting.remove(0);
                switchFreeDel.setOnCheckedChangeListener(null);
                switchFreeDel.setChecked(true);
                freeDeliverySwitchListener();
                tvFreeDelMiles.setText(freeDelivery.delivery_miles + " miles");
            }
            if (loggedInRestaurant.delivery_setting != null)
                deliveryFees.addAll(loggedInRestaurant.delivery_setting);
            deliveryFeesAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void freeDeliverySwitchListener() {
        try {
            switchFreeDel.setOnCheckedChangeListener((compoundButton, b) -> {
                try {
                    if (b) {
                        if (freeDelivery == null)
                            freeDelivery = new DeliveryFee();
                        EnterAmountDialogFragment enterAmountDialogFragment = getInstanceEnterAmount(!Validators.isNullOrEmpty(freeDelivery.delivery_miles) ? freeDelivery.delivery_miles : "0", "Enter delivery miles");
                        enterAmountDialogFragment.show(getChildFragmentManager(), "enter_miles");
                        enterAmountDialogFragment.setDialogDismissListener(o -> {
                            if (o instanceof String) {
                                freeDelivery.delivery_miles = (String) o;
                                tvFreeDelMiles.setText(freeDelivery.delivery_miles + " miles");
                            } else {
                                if (Validators.isNullOrEmpty(freeDelivery.delivery_miles)) {
                                    freeDelivery = null;
                                    switchFreeDel.setChecked(false);
                                }
                            }
                        });
                    } else {
                        freeDelivery = null;
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void setListeners() {
        try {
            chipBack.setOnClickListener(v -> getActivity().onBackPressed());
            cvAdd.setOnClickListener(view -> {
                DeliveryFee deliveryFee = new DeliveryFee();
                deliveryFee.delivery_charge = "0";
                deliveryFee.delivery_miles = "0";
                deliveryFees.add(deliveryFee);
                deliveryFeesAdapter.notifyDataSetChanged();
            });
            btnUpdate.setOnClickListener(view -> {
                try {
                    boolean isValid = true;
                    for (DeliveryFee deliveryFee : deliveryFees) {
                        if (Float.parseFloat(deliveryFee.delivery_charge) == 0 || Float.parseFloat(deliveryFee.delivery_miles) == 0) {
                            ToastUtils.showSnackBar(getActivity(), llMainLayout, "Invalid delivery fees details");
                            isValid = false;
                            break;
                        }
                    }
                    if (isValid) {
                        updateDeliveryFees();
                    }
                } catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            });
            freeDeliverySwitchListener();
            cvFreeDel.setOnClickListener(view -> {
                try {
                    if (!switchFreeDel.isChecked()) {
                        switchFreeDel.setChecked(true);
                    } else {
                        EnterAmountDialogFragment enterAmountDialogFragment = getInstanceEnterAmount(!Validators.isNullOrEmpty(freeDelivery.delivery_miles) ? freeDelivery.delivery_miles : "0", "Enter delivery miles");
                        enterAmountDialogFragment.show(getChildFragmentManager(), "enter_miles");
                        enterAmountDialogFragment.setDialogDismissListener(o -> {
                            if (o instanceof String) {
                                freeDelivery.delivery_miles = (String) o;
                                tvFreeDelMiles.setText(freeDelivery.delivery_miles + " miles");
                            } else {
                                if (Validators.isNullOrEmpty(freeDelivery.delivery_miles)) {
                                    freeDelivery = null;
                                    switchFreeDel.setChecked(false);
                                }
                            }
                        });
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateDeliveryFees() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> llLoading.setVisibility(View.VISIBLE));
            }
            if (freeDelivery != null) {
                freeDelivery.delivery_charge = "0";
                deliveryFees.add(0, freeDelivery);
            }
            loggedInRestaurant.delivery_setting = deliveryFees;
            AndroidNetworking.post(ApiEndPoints.restaurant_details + loggedInRestaurant.id)
                    .addApplicationJsonBody(loggedInRestaurant)
                    .build()
                    .getAsObject(Restaurant.class, new ParsedRequestListener<Restaurant>() {
                        @Override
                        public void onResponse(Restaurant response) {
                            try {
                                fetchProfile();
                                ToastUtils.makeLongToast(getActivity(), "Delivery fees updated!");
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llLoading.setVisibility(View.GONE);
                                    });
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        llLoading.setVisibility(View.GONE);
                                    });
                                }
                                if (anError.getErrorCode() == 400) {
                                    ToastUtils.makeToast(getActivity(), anError.getErrorAsObject(ApiError.class).getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchProfile() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> llLoading.setVisibility(View.VISIBLE));
            }
            AndroidNetworking.get(ApiEndPoints.restaurant_details + loggedInRestaurant.id)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> llLoading.setVisibility(View.GONE));
                                }
                                myPreferences.saveRestaurant(response);
                                loggedInRestaurant = myPreferences.getRestaurant();
                                updateViews();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> llLoading.setVisibility(View.GONE));
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
