package com.ubsidi.epos_2021.merchant.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.SwitchCompat;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.ubsidi.R;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.merchant.models.RestaurantPaymentMethod;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Restaurant;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.json.JSONObject;

import java.util.HashMap;

public class SettingsDineinOptionsFragment extends BaseFragment {


    private SwitchCompat switchOrders, switchTips, switchCod;
    private MaterialButton btnUpdate;
    private LinearLayout llMainLayout;
    private Chip chipBack;
    private Restaurant loggedInRestaurant = myPreferences.getRestaurant();
    private LinearLayout llLoading;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_dinein_options, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        updateViews();
        setListeners();
    }

    private void setListeners() {
        switchOrders.setOnCheckedChangeListener((compoundButton, b) -> {
            loggedInRestaurant.dine_in = b;
        });
        switchTips.setOnCheckedChangeListener((compoundButton, b) -> {
            loggedInRestaurant.gratuity = b;
        });
        btnUpdate.setOnClickListener(view -> {
            HashMap<String, String> params = new HashMap<>();
            params.put("action", "EditStoreAllDetail");
            params.put("user_id", myApp.restaurant_id);
            params.put("gratuity", loggedInRestaurant.gratuity ? "1" : "0");
            params.put("dine_in", loggedInRestaurant.dine_in ? "1" : "0");
            updateDetails(params);
        });
        chipBack.setOnClickListener(v -> getActivity().onBackPressed());
    }

    private void updateDetails(HashMap<String, String> params) {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> llLoading.setVisibility(View.VISIBLE));
            }
            AndroidNetworking.post(ApiEndPoints.restaurant_details + loggedInRestaurant.id)
                    .addBodyParameter(params)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> llLoading.setVisibility(View.GONE));
                            }
                            ToastUtils.showSnackBar(getActivity(), llMainLayout, "Details updated");
                            myPreferences.saveRestaurant(loggedInRestaurant);
                        }

                        @Override
                        public void onError(ANError anError) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> llLoading.setVisibility(View.GONE));
                            }
                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                            } else {
                                ToastUtils.showSnackBar(getActivity(), llMainLayout, "Something went wrong!");
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateViews() {
        switchTips.setChecked(loggedInRestaurant.gratuity);
        switchOrders.setChecked(loggedInRestaurant.dine_in);
        boolean isCodOn = false;
        for (RestaurantPaymentMethod paymentMethod : loggedInRestaurant.payment_methods) {
            if (paymentMethod.payment_method_name.equalsIgnoreCase("cod")) {
                if (paymentMethod.dinein_android_status.equalsIgnoreCase("y")) isCodOn = true;
            }
        }
        switchCod.setChecked(isCodOn);
    }

    private void initViews(View view) {
        llMainLayout = view.findViewById(R.id.llMainLayout);
        switchCod = view.findViewById(R.id.switchCod);
        switchOrders = view.findViewById(R.id.switchOrders);
        switchTips = view.findViewById(R.id.switchTips);
        btnUpdate = view.findViewById(R.id.btnUpdate);
        chipBack = view.findViewById(R.id.chipBack);
        llLoading = view.findViewById(R.id.llLoading);
    }
}
