package com.ubsidi.epos_2021.merchant.fragments;

import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Restaurant;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.json.JSONObject;

public class SettingsFeedbackFragment extends BaseFragment {

    private EditText etSubject, etDescription;
    private TextView tvSubject, tvWordCounter;
    private MaterialButton btnSend;
    private LinearLayout llSubject, llMainLayout;
    private String subjectData;
    private ImageView ivBack;
    private AlertDialog progressDialog;
    private Restaurant restaurant = myPreferences.getRestaurant();

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_feedback, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        setListeners();
    }

    public SettingsFeedbackSubjectBottomSheetFragment getInstance(String subjectData) {
        SettingsFeedbackSubjectBottomSheetFragment feedbackSubjectBottomSheetFragment = new SettingsFeedbackSubjectBottomSheetFragment();
        Bundle bundle = new Bundle();
        bundle.putString("selected_subject", subjectData);
        feedbackSubjectBottomSheetFragment.setArguments(bundle);
        return feedbackSubjectBottomSheetFragment;
    }

    private void setListeners() {
        ivBack.setOnClickListener(v -> getActivity().onBackPressed());
        tvSubject.setOnClickListener(v -> {
            CommonFunctions.hideKeyboard(getActivity(), etDescription);
            SettingsFeedbackSubjectBottomSheetFragment feedbackSubjectBottomSheetFragment = getInstance(subjectData);
            feedbackSubjectBottomSheetFragment.show(getChildFragmentManager(), "feedback subject");
            feedbackSubjectBottomSheetFragment.setDialogDismissListener(o -> getSubject(o));
        });


        etDescription.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @Override
            public void afterTextChanged(Editable editable) {

                int length = etDescription.length();
                tvWordCounter.setText(length + "/300");
                if (length > 300) {
                    tvWordCounter.setTextColor(getResources().getColor(R.color.red));
                } else {
                    tvWordCounter.setTextColor(getResources().getColor(R.color.black));
                }
            }
        });

        btnSend.setOnClickListener(v -> {
            if (isValid()) {
                if (restaurant != null) {
                    new Thread(this::sendFeedback).start();
                }
            }
        });

    }

    private void getSubject(Object o) {
        subjectData = (String) o;
        if (subjectData.equalsIgnoreCase("other")) {
            tvSubject.setText(subjectData);
            llSubject.setVisibility(View.VISIBLE);
            etSubject.setText("");
            etSubject.requestFocus();
        } else {
            llSubject.setVisibility(View.GONE);
            etSubject.setText(subjectData);
            tvSubject.setText(subjectData);
        }
    }

    private void sendFeedback() {
        try {
            if (getActivity() != null)
                getActivity().runOnUiThread(() -> progressDialog.show());
            AndroidNetworking.post(ApiEndPoints.online_app_feedback)
                    .addBodyParameter("action", "AppFeedback")
                    .addBodyParameter("customer_id", restaurant.user_id)
                    .addBodyParameter("subject", etSubject.getText().toString())
                    .addBodyParameter("message", etDescription.getText().toString())
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            if (getActivity() != null)
                                getActivity().runOnUiThread(() -> {
                                    progressDialog.dismiss();
                                });

                            ToastUtils.showSnackBar(getActivity(), llMainLayout, "Feedback sent!");
                            etSubject.setText("");
                            tvSubject.setText("");
                            etDescription.setText("");

                        }

                        @Override
                        public void onError(ANError anError) {
                            if (getActivity() != null)
                                progressDialog.dismiss();
                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                            } else {
                                ToastUtils.showSnackBar(getActivity(), llMainLayout, "Something went wrong!");
                            }
                            if (!CommonFunctions.isConnected(getActivity()))
                                myApp.noInternet(getActivity());
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isValid() {
        etSubject.setError(null);
        etDescription.setError(null);
        if (Validators.isNullOrEmpty(tvSubject.getText().toString())) {
            ToastUtils.showSnackBar(getActivity(), llMainLayout, "Please select feedback subject");
            return false;
        }
        if (!Validators.isNullOrEmpty(subjectData) && subjectData.equalsIgnoreCase("other") && Validators.isNullOrEmpty(etSubject.getText().toString())) {
            etSubject.setError("Please enter feedback subject");
            etSubject.requestFocus();
            return false;
        }
        if (Validators.isNullOrEmpty(etDescription.getText().toString())) {
            etDescription.setError("Please enter your feedback");
            etDescription.requestFocus();
            return false;
        }
        if (etDescription.getText().toString().length() > 300) {
            etDescription.setError("Character should be less then 300.");
            return false;
        }
        return true;
    }

    private void initViews(View view) {
        progressDialog = CommonFunctions.customProgressDialog(getActivity());
        llMainLayout = view.findViewById(R.id.llMainLayout);
        btnSend = view.findViewById(R.id.btnSend);
        etDescription = view.findViewById(R.id.etFeedbackProblem);
        etSubject = view.findViewById(R.id.etFeedbackSubject);
        tvSubject = view.findViewById(R.id.tvFeedbackSubject);
        tvWordCounter = view.findViewById(R.id.tvWordCounter);
        llSubject = view.findViewById(R.id.llFeedbackSubject);
        ivBack = view.findViewById(R.id.ivBack);
    }

    @Override
    public void onStop() {
        CommonFunctions.hideKeyboard(getActivity(), etDescription);
        super.onStop();
    }
}
