package com.ubsidi.epos_2021.merchant.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentTransaction;

import com.google.android.material.chip.Chip;
import com.ubsidi.R;
import com.ubsidi.epos_2021.base.BaseFragment;

public class SettingsOfferFragment extends BaseFragment {

    private LinearLayout llDiscountCodes, llAutoDiscount;
    private Chip chipBack;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_restaurant_offers, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        setListeners();
    }

    private void setListeners() {
        llAutoDiscount.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(), new SettingsAutoDiscountFragment(), "Offers");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        llDiscountCodes.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(), new SettingsVoucherCodesFragment(), "Offers");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });
        chipBack.setOnClickListener(v -> getActivity().onBackPressed());
    }


    private void initViews(View view) {
        llDiscountCodes = view.findViewById(R.id.llDiscountCode);
        llAutoDiscount = view.findViewById(R.id.llAutoDiscount);
        chipBack = view.findViewById(R.id.chipBack);
    }
}
