package com.ubsidi.epos_2021.merchant.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentTransaction;

import com.google.android.material.chip.Chip;
import com.ubsidi.R;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.models.Restaurant;

public class SettingsOpeningHoursFragment extends BaseFragment {

    private LinearLayout llDeliveryHours, llCollectionHours;
    private Chip chipBack;
    private Restaurant loggedInRestaurant = myPreferences.getRestaurant();

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_openinghours, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        setLinteners();
    }

    private void setLinteners() {
        chipBack.setOnClickListener(v -> getActivity().onBackPressed());
        if (loggedInRestaurant.restaurant_delivery.equalsIgnoreCase("yes")) {
            llDeliveryHours.setVisibility(View.VISIBLE);
        } else {
            llDeliveryHours.setVisibility(View.GONE);
        }
        if (loggedInRestaurant.restaurant_pickup.equalsIgnoreCase("yes")) {
            llCollectionHours.setVisibility(View.VISIBLE);
        } else {
            llCollectionHours.setVisibility(View.GONE);
        }

        llDeliveryHours.setOnClickListener(view1 -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(),new SettingsDeliveryHoursFragment(), "DeliveryHours");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });

        llCollectionHours.setOnClickListener(view1 -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(), new SettingsCollectionHoursFragment(), "CollectionHours");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });

    }

    private void initViews(View view) {
        llDeliveryHours = view.findViewById(R.id.llDeliveryHours);
        llCollectionHours = view.findViewById(R.id.llCollectionHours);
        chipBack = view.findViewById(R.id.chipBack);
    }
}
