package com.ubsidi.epos_2021.merchant.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SwitchCompat;
import androidx.fragment.app.FragmentTransaction;

import com.google.android.material.chip.Chip;
import com.ubsidi.R;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.online.fragments.EnterPasswordDialogFragment;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;

public class SettingsOrderOptionsFragment extends BaseFragment {
    private LinearLayout llDeliveryFee, llOrderRequirements;
    private Chip chipBack;
    private SwitchCompat switchCompat;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_order_options, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        setListeners();

    }

    private void setListeners() {
        chipBack.setOnClickListener(v -> getActivity().onBackPressed());
        llOrderRequirements.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(), new SettingsOrderRequirementFragment(), "Order requirements");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });

        llDeliveryFee.setOnClickListener(view -> {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(), new SettingsDeliveryFeesFragment(), "Order requirements");
            ft.addToBackStack("can_go_back");
            ft.commit();
        });

        switchCompat.setOnCheckedChangeListener(checkedChangeListener);
    }

    CompoundButton.OnCheckedChangeListener checkedChangeListener = new CompoundButton.OnCheckedChangeListener() {
        @Override
        public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
            EnterPasswordDialogFragment enterPasswordDialogFragment = getInstanceDialogFragment("online_order", b ? "Yes" : "No");
            enterPasswordDialogFragment.show(getChildFragmentManager(), "enter_password");
            enterPasswordDialogFragment.setCancelable(false);
            enterPasswordDialogFragment.setDialogDismissListener(changeOrderAcceptingStatusDialogListener);
        }
    };

    DialogDismissListener changeOrderAcceptingStatusDialogListener = new DialogDismissListener() {
        @Override
        public void onDialogDismiss(Object o) {
            switchCompat.setOnCheckedChangeListener(null);
            updateOrderTakingStatus();
            switchCompat.setOnCheckedChangeListener(checkedChangeListener);
        }
    };

    private void updateOrderTakingStatus() {
        switchCompat.setChecked(myPreferences.getRestaurant().online_order.equalsIgnoreCase("Yes"));
    }

    private void initViews(View view) {
        llDeliveryFee = view.findViewById(R.id.llDeliveryFee);
        llOrderRequirements = view.findViewById(R.id.llOrderRequirements);
        chipBack = view.findViewById(R.id.chipBack);
        switchCompat = view.findViewById(R.id.switchOrders);

        updateOrderTakingStatus();
    }

    public EnterPasswordDialogFragment getInstanceDialogFragment(String for_what, String yes_no) {
        EnterPasswordDialogFragment rejectReasonDialog = new EnterPasswordDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("for_what", for_what);
        bundle.putString("yes_no", yes_no);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }
}
