package com.ubsidi.epos_2021.merchant.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.chip.Chip;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Restaurant;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.json.JSONObject;

import java.util.HashMap;

public class SettingsOrderRequirementFragment extends BaseFragment {

    private MaterialCardView cvOrderValue;
    private TextView tvOrderValue;
    private Chip chipBack;
    private LinearLayout llMainLayout;
    private Restaurant loggedInRestaurant = myPreferences.getRestaurant();

    private AlertDialog progressDialog;
    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_order_requirements, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        setListeners();
    }


    private void setListeners() {
        chipBack.setOnClickListener(v -> getActivity().onBackPressed());
        cvOrderValue.setOnClickListener(view -> {
            EnterAmountDialogFragment enterAmountDialogFragment = getInstanceEnterAmount(MyApp.df.format(loggedInRestaurant.minimum_order));
            enterAmountDialogFragment.show(getChildFragmentManager(), "Enter amount");
            enterAmountDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String) {
                    loggedInRestaurant.minimum_order = Float.parseFloat(String.valueOf(o));
                    tvOrderValue.setText(myApp.currencySymbol + (loggedInRestaurant.minimum_order));
                    HashMap<String, String> params = new HashMap<>();
                    params.put("minimum_order", MyApp.df.format(loggedInRestaurant.minimum_order));
                    updateDetails(params);
                }
            });
        });

    }

    public EnterAmountDialogFragment getInstanceEnterAmount(String amount) {
        EnterAmountDialogFragment rejectReasonDialog = new EnterAmountDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("amount", amount);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    private void updateDetails(HashMap<String, String> params) {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            AndroidNetworking.post(ApiEndPoints.restaurant_details + loggedInRestaurant.id)
                    .addBodyParameter(params)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            ToastUtils.showSnackBar(getActivity(), llMainLayout, "Details updated");
                            myPreferences.saveRestaurant(loggedInRestaurant);
                        }

                        @Override
                        public void onError(ANError anError) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            anError.printStackTrace();
                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                            } else {
                                ToastUtils.showSnackBar(getActivity(), llMainLayout, "Something went wrong!");
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        progressDialog = CommonFunctions.customProgressDialog(getActivity());
        llMainLayout = view.findViewById(R.id.llMainLayout);
        cvOrderValue = view.findViewById(R.id.cvOrderValue);
        tvOrderValue = view.findViewById(R.id.tvOrderValue);
        chipBack = view.findViewById(R.id.chipBack);

        if (loggedInRestaurant != null) {
            tvOrderValue.setText(myApp.currencySymbol + MyApp.df.format(loggedInRestaurant.minimum_order));
        }
    }

}
