package com.ubsidi.epos_2021.merchant.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.models.Restaurant;

public class SettingsProfileFragment extends BaseFragment {

    private TextView tvContactName, tvPhone, tvEmail;
    private Restaurant restaurant = MyApp.getInstance().myPreferences.getRestaurant();

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_profile, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        updateViews();
        setListeners();
    }


    private void setListeners() {

    }

    private void initViews(View view) {
        tvContactName = view.findViewById(R.id.tvContactName);
        tvEmail = view.findViewById(R.id.tvContactEmail);
        tvPhone = view.findViewById(R.id.tvContactNumber);
    }

    private void updateViews() {
        if (restaurant != null) {
            tvContactName.setText(restaurant.contact_name);
            tvPhone.setText(restaurant.contact_phone);
            tvEmail.setText(restaurant.contact_email);
        }
    }

}
