package com.ubsidi.epos_2021.merchant.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SwitchCompat;

import com.google.android.material.chip.Chip;
import com.ubsidi.R;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.online.fragments.EnterPasswordDialogFragment;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;

public class SettingsReservationOptionsFragment extends BaseFragment {

    private Chip chipBack;
    private SwitchCompat switchCompat;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_reservation_options, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        initViews(view);
        setListeners();
    }


    private void initViews(View view) {
        chipBack = view.findViewById(R.id.chipBack);
        switchCompat = view.findViewById(R.id.switchReservations);

        updateReservationStatus();
    }

    private void setListeners() {
        chipBack.setOnClickListener(v -> getActivity().onBackPressed());

        switchCompat.setOnCheckedChangeListener(checkedChangeListener);
    }

    CompoundButton.OnCheckedChangeListener checkedChangeListener = new CompoundButton.OnCheckedChangeListener() {
        @Override
        public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
            EnterPasswordDialogFragment enterPasswordDialogFragment = getInstanceDialogFragment("booking_status", b ? "Yes" : "No");
            enterPasswordDialogFragment.show(getChildFragmentManager(), "enter_password");
            enterPasswordDialogFragment.setCancelable(false);
            enterPasswordDialogFragment.setDialogDismissListener(changeOrderAcceptingStatusDialogListener);
        }
    };
    DialogDismissListener changeOrderAcceptingStatusDialogListener = new DialogDismissListener() {
        @Override
        public void onDialogDismiss(Object o) {
            switchCompat.setOnCheckedChangeListener(null);
            updateReservationStatus();
            switchCompat.setOnCheckedChangeListener(checkedChangeListener);
        }
    };

    private void updateReservationStatus() {
        switchCompat.setChecked(myPreferences.getRestaurant().booking_status.equalsIgnoreCase("Yes"));
    }

    public EnterPasswordDialogFragment getInstanceDialogFragment(String for_what, String yes_no) {
        EnterPasswordDialogFragment rejectReasonDialog = new EnterPasswordDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("for_what", for_what);
        bundle.putString("yes_no", yes_no);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }
}
