package com.ubsidi.epos_2021.merchant.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.models.Restaurant;

public class SettingsRestaurantDetailsFragment extends BaseFragment {

    private TextView tvDescription;
    private ImageView ivEdit;
    private ImageView ivBack;
    private TextView tvCompanyName, tvRestaurantName, tvPhone, tvEmail;
    private Restaurant loggedInRestaurant = MyApp.getInstance().myPreferences.getRestaurant();

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {

    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_settings_restaurant_details, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        setListeners();
        updateViews();
    }

    private void setListeners() {
        ivBack.setOnClickListener(v -> getActivity().onBackPressed());
        ivEdit.setOnClickListener(v -> {
            EditRestaurantDescriptionBottomsheet descriptionBottomsheet = getInstanceEditRestaurantDescription(tvDescription.getText().toString());
            descriptionBottomsheet.show(getChildFragmentManager(), "edit_description");
            descriptionBottomsheet.setDialogDismissListener(o -> updateViews());
        });

    }

    private void updateViews() {
        loggedInRestaurant = MyApp.getInstance().myPreferences.getRestaurant();
        if (loggedInRestaurant != null) {
            tvRestaurantName.setText(loggedInRestaurant.restaurant_name);
            tvPhone.setText(loggedInRestaurant.restaurant_phone);
            tvEmail.setText(loggedInRestaurant.username);
            tvDescription.setText(loggedInRestaurant.restaurant_about);
        }
    }

    private void initViews(View view) {
        ivEdit = view.findViewById(R.id.ivEdit);
        tvDescription = view.findViewById(R.id.tvDecription);
        tvCompanyName = view.findViewById(R.id.tvCompanyName);
        tvEmail = view.findViewById(R.id.tvRestaurantEmail);
        tvPhone = view.findViewById(R.id.tvRestaurantPhone);
        tvRestaurantName = view.findViewById(R.id.tvRestaurantName);
        ivBack = view.findViewById(R.id.ivBack);

        if (loggedInRestaurant != null) {
            tvCompanyName.setText(loggedInRestaurant.restaurant_name);
            tvRestaurantName.setText(loggedInRestaurant.restaurant_name);
            tvPhone.setText(loggedInRestaurant.restaurant_phone);
            tvEmail.setText(loggedInRestaurant.username);
            tvDescription.setText(loggedInRestaurant.restaurant_about);
        }
    }

    public EditRestaurantDescriptionBottomsheet getInstanceEditRestaurantDescription(String description) {
        EditRestaurantDescriptionBottomsheet descriptionBottomsheet = new EditRestaurantDescriptionBottomsheet();
        Bundle bundle = new Bundle();
        bundle.putString("res_description", description);
        descriptionBottomsheet.setArguments(bundle);
        return descriptionBottomsheet;
    }
}
